/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module;

import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.classroom.client.messaging.MessageListener;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.activity.ActivityDebug;
import com.elluminate.groupware.activity.module.ActivityMessage;
import com.elluminate.groupware.activity.module.ActivityPublisher;
import com.elluminate.groupware.activity.module.CJEditorPane;
import com.elluminate.groupware.activity.module.StringsProperties;
import com.elluminate.groupware.activity.module.listener.ActivityDataListener;
import com.elluminate.groupware.activity.module.model.ActivityDisplayStateModel;
import com.elluminate.groupware.activity.module.model.ActivityTypeConfig;
import com.elluminate.groupware.imps.AccessibilityCLIAPI;
import com.elluminate.groupware.imps.AccessibilityCLIException;
import com.elluminate.groupware.imps.SessionTimeAPI;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CMenuButton;
import com.elluminate.gui.component.CToolBarToggleButton;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

@Singleton
public class ActivityBean
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String FONT_SIZE_DELTA_PREF = ".fontSizeDelta";
    private static final String EVENT_NOTICE = "/activity/notice/event";
    private static final String ALL_ALERTS_PATH = "/activity/notice/enableAllEvents";
    private static final String BASIC_ALERTS_PATH = "/activity/notice/enableBasicEvents";
    private static final String ENABLED_ALERT_SET = "/activity/enabledAlertSet";
    private static final int CUSTOM_ENABLED = 0;
    private static final int BASIC_ENABLED = 1;
    private static final int ALL_ENABLED = 2;
    private ActivityDisplayStateModel model;
    private Logger log;
    private SwingRunner swRunner;
    private ActivityPublisher publisher;
    private int lastSplitLocation;
    private long lastSound;
    private boolean commandFieldShownPermanently;
    private DateFormat timestampFormat = DateFormat.getTimeInstance(3);
    private volatile long sessionTimeBase = 0L;
    private volatile Date lastTimestamp = null;
    private volatile int baseFontSize;
    private volatile int fontSizeDelta = 0;
    private FeatureBroker broker;
    private EnumeratedFeature<Integer> enabledAlerts;
    private I18n i18n = I18n.create((Object)this);
    private CToolBarToggleButton commandButton;
    private CCheckBoxMenuItem allAlertsItem;
    private CCheckBoxMenuItem standardAlertsItem;
    private CCheckBoxMenuItem customAlertsItem;
    private CMenuButton filterButton;
    private CMenuButton audioAlertsButton;
    private CMenuButton optionButton;
    private CMenuItem notificationsItem;
    private CMenuItem myMessagesItem;
    private CCheckBoxMenuItem allMessagesItem;
    private CCheckBoxMenuItem normalMessagesItem;
    private CCheckBoxMenuItem importantMessagesItem;
    private CMenuItem timesItem;
    private JSplitPane split;
    private JEditorPane messageField;
    private JPopupMenu popupMenu;
    private JTextArea commandField;
    private Provider<ActivityTypeConfig> configProvider;
    private int oldCaretPosition = -1;
    private int currentCaretPosition = -1;
    private boolean rightArrowLast = false;
    private Imps impls;
    private ClientProvider clientProvider;
    public static final KeyStroke showActivityAccelerator = KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());

    @Inject
    public ActivityBean(ActivityDisplayStateModel model, FeatureBroker broker, SwingRunner sr) {
        this.model = model;
        this.broker = broker;
        this.swRunner = sr;
        this.initializeUI();
        this.registerAgainstModel();
    }

    @Inject
    public void initLogger(Logger logger) {
        this.log = logger;
    }

    @Inject
    public void initActivityPublisher(ActivityPublisher pub) {
        this.publisher = pub;
    }

    @Inject
    public void initClientProvider(ClientProvider prov) {
        this.clientProvider = prov;
    }

    @Inject
    public void initTypeConfigAndMessageRouter(Provider<ActivityTypeConfig> cp, MessageRouter router) {
        this.configProvider = cp;
        router.registerListener(new MessageListener(){

            public void receiveMessage(Message msg) {
            }

            public void newPublisherAvailable(MessagePublisherMetadata publisherInfo) {
                ActivityBean.this.handleNewPublisherInfo(publisherInfo);
            }
        });
    }

    @Inject
    public void initImpls(Imps i) {
        this.impls = i;
    }

    private void handleNewPublisherInfo(final MessagePublisherMetadata publisherInfo) {
        this.swRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                String modName = publisherInfo.getModuleName();
                ModuleItem mi = new ModuleItem(publisherInfo.getModuleDisplayName(), modName, publisherInfo.getPublisherIcon());
                ActivityTypeConfig config = (ActivityTypeConfig)ActivityBean.this.configProvider.get();
                mi.setSelected(config.isModuleEnabled(modName));
                Component[] comps = ActivityBean.this.filterButton.getMenuComponents();
                for (int i = 0; i < comps.length; ++i) {
                    ModuleItem mit = (ModuleItem)((Object)comps[i]);
                    if (mit.getText().compareTo(mi.getText()) <= 0) continue;
                    ActivityBean.this.filterButton.add((JMenuItem)((Object)mi), i);
                    return;
                }
                ActivityBean.this.filterButton.add((JMenuItem)((Object)mi));
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ActivityTypeConfig config = (ActivityTypeConfig)this.configProvider.get();
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ActivityBean.this.configurationChanged(e);
            }
        });
        if (config.isNotificationsEnabled()) {
            this.notificationsItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDENOTIFICATIONSITEM));
        } else {
            this.notificationsItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWNOTIFICATIONSITEM));
        }
        if (config.isMyMessagesEnabled()) {
            this.myMessagesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDEMYEVENTSITEM));
        } else {
            this.myMessagesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWMYEVENTSITEM));
        }
        int vol = config.getMinimumVolume();
        if (vol < 4) {
            this.allMessagesItem.setSelected(true);
        } else if (vol < 7) {
            this.normalMessagesItem.setSelected(true);
        } else {
            this.importantMessagesItem.setSelected(true);
        }
        if (config.isTimestampsDisplayed()) {
            this.timesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDETIMESITEM));
        } else {
            this.timesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWTIMESITEM));
        }
    }

    private void configurationChanged(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "minimumVolume") {
            int vol = (Integer)e.getNewValue();
            if (vol < 4) {
                this.allMessagesItem.setSelected(true);
            } else if (vol < 7) {
                this.normalMessagesItem.setSelected(true);
            } else {
                this.importantMessagesItem.setSelected(true);
            }
        } else if (prop == "disabledModules") {
            String enabledModule;
            String disabledModule = (String)e.getNewValue();
            if (disabledModule != null) {
                for (Component comp : this.filterButton.getMenuComponents()) {
                    if (!(comp instanceof ModuleItem) || !((ModuleItem)((Object)comp)).moduleName.equals(disabledModule)) continue;
                    ((ModuleItem)((Object)comp)).setSelected(false);
                }
            }
            if ((enabledModule = (String)e.getOldValue()) != null) {
                for (Component comp : this.filterButton.getMenuComponents()) {
                    if (!(comp instanceof ModuleItem) || !((ModuleItem)((Object)comp)).moduleName.equals(enabledModule)) continue;
                    ((ModuleItem)((Object)comp)).setSelected(true);
                }
            }
        } else if (prop == "myMessagesEnabled") {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.myMessagesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDEMYEVENTSITEM));
            } else {
                this.myMessagesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWMYEVENTSITEM));
            }
        } else if (prop == "notificationsEnabled") {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.notificationsItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDENOTIFICATIONSITEM));
            } else {
                this.notificationsItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWNOTIFICATIONSITEM));
            }
        } else if (prop == "timestampsDisplayed") {
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.timesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_HIDETIMESITEM));
            } else {
                this.timesItem.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWTIMESITEM));
            }
        }
    }

    private void initializeUI() {
        this.registerHideAction();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 350));
        AccessibleToolBar tb = new AccessibleToolBar();
        this.mapCommandKey((JComponent)tb);
        tb.setFloatable(false);
        tb.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), tb.getBorder()));
        this.add((Component)tb, "North");
        this.commandButton = new CToolBarToggleButton((Icon)this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYBEAN_COMMANDICON));
        this.commandButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_COMMANDTIP));
        this.commandButton.setSelected(true);
        this.commandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.setCommandFieldVisible(ActivityBean.this.commandButton.isSelected());
            }
        });
        tb.add((Component)this.commandButton);
        tb.add(Box.createHorizontalGlue());
        this.audioAlertsButton = new CMenuButton((Icon)this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYBEAN_AUDIOALERTSICON));
        this.audioAlertsButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_AUDIOALERTSTIP));
        tb.add((Component)this.audioAlertsButton);
        ButtonGroup grp = new ButtonGroup();
        this.allAlertsItem = new CCheckBoxMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_ALLAUDIOALERTSITEM));
        this.allAlertsItem.setSelected(true);
        this.allAlertsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.applyAlertSet();
                ActivityBean.this.broker.sendNotification((Object)this, ActivityBean.ALL_ALERTS_PATH, "", ActivityBean.this.clientProvider.get().getSessionTime());
            }
        });
        grp.add((AbstractButton)this.allAlertsItem);
        this.audioAlertsButton.add((JMenuItem)this.allAlertsItem);
        this.standardAlertsItem = new CCheckBoxMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_STANDARDAUDIOALERTSITEM));
        this.standardAlertsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.applyAlertSet();
                ActivityBean.this.broker.sendNotification((Object)this, ActivityBean.BASIC_ALERTS_PATH, "", ActivityBean.this.clientProvider.get().getSessionTime());
            }
        });
        grp.add((AbstractButton)this.standardAlertsItem);
        this.audioAlertsButton.add((JMenuItem)this.standardAlertsItem);
        this.customAlertsItem = new CCheckBoxMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_CUSTOMAUDIOALERTSITEM));
        this.customAlertsItem.setEnabled(false);
        grp.add((AbstractButton)this.customAlertsItem);
        this.audioAlertsButton.add((JMenuItem)this.customAlertsItem);
        this.enabledAlerts = this.broker.createEnumeratedFeature((Object)this, ENABLED_ALERT_SET, Integer.class, true, (Object)2, (Object[])new Integer[]{0, 1, 2}, "EnabledAlerts", null);
        this.enabledAlerts.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent e) {
                ActivityBean.this.applyAlertSet();
            }
        });
        this.broker.addFeature(this.enabledAlerts);
        this.filterButton = new CMenuButton((Icon)this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYBEAN_FILTERICON));
        this.filterButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_FILTERTIP));
        tb.add((Component)this.filterButton);
        this.optionButton = new CMenuButton((Icon)this.i18n.getIcon((PropertiesEnum)StringsProperties.ACTIVITYBEAN_OPTIONSICON));
        this.optionButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_OPTIONSTIP));
        tb.add((Component)this.optionButton);
        this.notificationsItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWNOTIFICATIONSITEM));
        this.notificationsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityTypeConfig config;
                config.setNotificationsEnabled(!(config = (ActivityTypeConfig)ActivityBean.this.configProvider.get()).isNotificationsEnabled());
            }
        });
        this.optionButton.add((JMenuItem)this.notificationsItem);
        this.myMessagesItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWMYEVENTSITEM));
        this.myMessagesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityTypeConfig config;
                config.setMyMessagesEnabled(!(config = (ActivityTypeConfig)ActivityBean.this.configProvider.get()).isMyMessagesEnabled());
            }
        });
        this.optionButton.add((JMenuItem)this.myMessagesItem);
        this.optionButton.addSeparator();
        grp = new ButtonGroup();
        this.allMessagesItem = new VolumeItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_ALLEVENTSITEM), 1);
        grp.add((AbstractButton)this.allMessagesItem);
        this.optionButton.add((JMenuItem)this.allMessagesItem);
        this.normalMessagesItem = new VolumeItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_NORMALEVENTSITEM), 4);
        grp.add((AbstractButton)this.normalMessagesItem);
        this.optionButton.add((JMenuItem)this.normalMessagesItem);
        this.importantMessagesItem = new VolumeItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_IMPORTANTEVENTSITEM), 7);
        grp.add((AbstractButton)this.importantMessagesItem);
        this.optionButton.add((JMenuItem)this.importantMessagesItem);
        this.optionButton.addSeparator();
        this.timesItem = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_SHOWTIMESITEM));
        this.timesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityTypeConfig config;
                config.setTimestampsDisplayed(!(config = (ActivityTypeConfig)ActivityBean.this.configProvider.get()).isTimestampsDisplayed());
            }
        });
        this.optionButton.add((JMenuItem)this.timesItem);
        this.split = new JSplitPane(0, true){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setUI(new SplitterUI());
            }
        };
        this.split.setBorder(BorderFactory.createEmptyBorder());
        this.split.setDividerSize(6);
        this.split.setResizeWeight(1.0);
        this.add((Component)this.split, "Center");
        this.messageField = new CJEditorPane("text/html", null);
        this.messageField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handlePopup(e);
            }

            private void handlePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ActivityBean.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.mapCommandKey(this.messageField);
        this.popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_MAKETEXTBIGGERITEM));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.fontSizeDelta++;
                ActivityBean.this.applyFontSizeDelta();
            }
        });
        this.popupMenu.add(mi);
        mi = new JMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_MAKETEXTSMALLERITEM));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.fontSizeDelta--;
                ActivityBean.this.applyFontSizeDelta();
            }
        });
        this.popupMenu.add(mi);
        mi = new JMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_DEFAULTSIZEITEM));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.fontSizeDelta = 0;
                ActivityBean.this.applyFontSizeDelta();
            }
        });
        this.popupMenu.add(mi);
        this.messageField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ActivityBean.this.handleCaretUpdate(e);
            }
        });
        this.messageField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                ActivityBean.this.rightArrowLast = e.getKeyCode() == 39 || e.getKeyCode() == 227;
            }
        });
        this.messageField.setMargin(new Insets(0, 0, 0, 0));
        this.messageField.setEditable(false);
        this.messageField.getInputMap().put(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        JScrollPane sp = new JScrollPane(this.messageField, 20, 30);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.split.setTopComponent(sp);
        this.commandField = new JTextArea(){
            private static final long serialVersionUID = 1L;
            private Image icon;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont(UIManager.getFont("EditorPane.font"));
                Keymap kmap = JTextComponent.addKeymap(null, this.getKeymap());
                kmap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new TextAction("process-command-action"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String cmd = this.getText();
                        if (cmd.startsWith("/")) {
                            ActivityBean.this.handleCommand(cmd);
                            this.setText("");
                            if (!ActivityBean.this.commandFieldShownPermanently) {
                                ActivityBean.this.setCommandFieldVisible(false);
                            }
                        }
                    }
                });
                kmap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new TextAction("cancel-command-action"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ActivityBean.this.setCommandFieldVisible(false);
                    }
                });
                this.setKeymap(kmap);
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.icon == null) {
                    this.icon = new BufferedImage(13, 13, 2);
                    Graphics2D g2 = (Graphics2D)this.icon.getGraphics();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int size = 13;
                    g2.setColor(new Color(219, 219, 219));
                    g2.fillOval(0, 0, size, size);
                    g2.setColor(Color.WHITE);
                    g2.setFont(new Font("Helvetica", 1, 13));
                    FontMetrics fm = g2.getFontMetrics();
                    String text = ">";
                    g2.drawString(text, (size - fm.stringWidth(text) + 1) / 2, size - (size - fm.getAscent() - fm.getDescent() + 1) / 2 - fm.getDescent());
                    g2.dispose();
                }
                g.drawImage(this.icon, 6, 2, this);
            }
        };
        this.commandField.setLineWrap(true);
        this.commandField.setWrapStyleWord(true);
        this.commandField.setMargin(new Insets(0, 24, 0, 4));
        this.commandField.setPreferredSize(new Dimension(1, 36));
        this.commandField.setMinimumSize(new Dimension(1, 36));
        this.commandField.setFocusTraversalKeys(0, null);
        this.commandField.setFocusTraversalKeys(1, null);
        this.split.setBottomComponent(this.commandField);
        try {
            this.loadStyleSheet(this.getClass().getResource("css/default.css"));
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.setCommandFieldVisible(false);
        this.broker.announceNotification((Object)this, EVENT_NOTICE);
    }

    private void applyAlertSet() {
        switch ((Integer)this.enabledAlerts.getValue()) {
            case 0: {
                this.customAlertsItem.setSelected(true);
                break;
            }
            case 1: {
                this.standardAlertsItem.setSelected(true);
                break;
            }
            case 2: {
                this.allAlertsItem.setSelected(true);
            }
        }
    }

    private void mapCommandKey(JComponent comp) {
        String actionKey = "enter-command-action";
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(47, 0), actionKey);
        comp.getActionMap().put(actionKey, new TextAction(actionKey){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.setCommandFieldVisible(true, false, "/");
            }
        });
    }

    private void registerHideAction() {
        String hideWindowAction = "hide-activity-window";
        this.getInputMap(2).put(showActivityAccelerator, hideWindowAction);
        this.getActionMap().put(hideWindowAction, new AbstractAction(hideWindowAction){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivityBean.this.model.setVisible(false);
            }
        });
    }

    private void handleCaretUpdate(CaretEvent event) {
        final Document doc = this.messageField.getDocument();
        this.oldCaretPosition = this.currentCaretPosition;
        this.currentCaretPosition = event.getMark();
        try {
            String text = doc.getText(this.currentCaretPosition, 1);
            if (text.equals("\n")) {
                final int newCaretPosition = this.rightArrowLast ? this.currentCaretPosition + 1 : this.currentCaretPosition - 1;
                this.swRunner.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        block7: {
                            int newPos = newCaretPosition;
                            if (newPos >= doc.getLength()) {
                                newPos = doc.getLength() - 1;
                            }
                            if (newPos < 0) {
                                newPos = 0;
                            }
                            try {
                                ActivityBean.this.messageField.moveCaretPosition(newPos);
                            }
                            catch (IllegalArgumentException e) {
                                if (ActivityDebug.ERROR.show()) {
                                    ActivityBean.this.log.error((Object)this, "handleCaretUpdate", "Problems moving caret position: " + e.getMessage());
                                }
                                ActivityBean.this.currentCaretPosition = ActivityBean.this.oldCaretPosition;
                                if (ActivityBean.this.oldCaretPosition < 0 || ActivityBean.this.oldCaretPosition >= doc.getLength()) break block7;
                                try {
                                    ActivityBean.this.messageField.moveCaretPosition(ActivityBean.this.oldCaretPosition);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (BadLocationException e) {
            this.log.message("unable to determine character at cursor position.");
        }
    }

    private void registerAgainstModel() {
        this.model.addDataListener(new ActivityDataListener(){

            @Override
            public void newMessageAvailable(int idx) {
                ActivityBean.this.handleNewMessage(idx);
            }

            @Override
            public void clearMessages() {
                ActivityBean.this.clear();
            }
        });
    }

    public void savePreferences(String prefix, Preferences preferences) {
        if (this.fontSizeDelta != 0) {
            preferences.setSetting(prefix + FONT_SIZE_DELTA_PREF, this.fontSizeDelta);
        } else {
            preferences.clearSetting(prefix + FONT_SIZE_DELTA_PREF);
        }
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        this.fontSizeDelta = preferences.getIntegerSetting(prefix + FONT_SIZE_DELTA_PREF, 0);
        this.applyFontSizeDelta();
    }

    public void setCommandFieldVisible(boolean visible) {
        this.setCommandFieldVisible(visible, true, null);
    }

    private void setCommandFieldVisible(boolean visible, boolean permanently, String input) {
        this.commandFieldShownPermanently = permanently;
        if (visible) {
            if (!this.commandButton.isSelected()) {
                this.commandButton.setSelected(true);
            }
            if (!this.commandField.isVisible()) {
                if (this.lastSplitLocation < 20) {
                    this.lastSplitLocation = this.commandField.getMinimumSize().height + 6;
                }
                this.split.setDividerLocation(this.split.getHeight() - this.lastSplitLocation);
                this.split.setDividerSize(6);
                this.commandField.setVisible(true);
            }
            this.commandField.requestFocus();
            if (input != null && !this.commandField.getText().endsWith(input)) {
                this.commandField.setText(input);
            }
        } else {
            if (this.commandButton.isSelected()) {
                this.commandButton.setSelected(false);
            }
            if (this.commandField.isVisible()) {
                this.lastSplitLocation = this.split.getHeight() - this.split.getDividerLocation();
                this.commandField.setVisible(false);
                this.split.setDividerSize(0);
                this.split.setDividerLocation(1.0);
            }
            this.commandField.setText("");
        }
    }

    public void loadStyleSheet(URL cssURL) throws IOException {
        Object size;
        Color c;
        int charsRead;
        String base = cssURL.toString();
        int pos = base.lastIndexOf("/");
        if (pos != -1) {
            base = base.substring(0, pos + 1);
        }
        String css = "";
        StringBuilder b = new StringBuilder();
        Reader r = new InputStreamReader(cssURL.openStream());
        char[] buf = new char[1024];
        while ((charsRead = r.read(buf)) != -1) {
            b.append(buf, 0, charsRead);
        }
        r.close();
        css = b.toString();
        css = css.replaceAll("url\\((.*)\\)", "url\\(" + base + "$1\\)");
        Font f = UIManager.getFont("EditorPane.font");
        StyleSheet ss = ((HTMLDocument)this.messageField.getDocument()).getStyleSheet();
        ss.addRule("body { font: " + f.getSize() * 11 / 12 + "pt \"" + f.getFamily() + "\"; }");
        r = new StringReader(css);
        ss.loadRules(r, null);
        r.close();
        Pattern p = Pattern.compile("body[ \\t\\r\\n]*\\{[ \\t\\r\\n]*background-color:[ \\t]*((#[0-9A-Fa-f]{6})|(aqua)|(black)|(blue)|(fuchsia)|(navy)|(olive)|(purple)|(red)|(gray)|(green)|(lime)|(maroon)|(silver)|(teal)|(white)|(yellow))\\b");
        Matcher m = p.matcher(css);
        if (m.find() && (c = ss.stringToColor(m.group(1))) != null) {
            this.messageField.setBackground(c);
        }
        this.baseFontSize = f.getSize() * 11 / 12;
        Style s = ss.getRule("body");
        if (s != null && (size = s.getAttribute(StyleConstants.FontSize)) instanceof Integer) {
            this.baseFontSize = (Integer)size;
        }
    }

    private void applyFontSizeDelta() {
        StyleSheet ss = ((HTMLDocument)this.messageField.getDocument()).getStyleSheet();
        ss.addRule("body { font-size: " + (this.baseFontSize + this.fontSizeDelta) + "pt; }");
    }

    private void handleNewMessage(int index) {
        this.appendMessage(this.model.getMessageAtIndex(index));
    }

    private void clear() {
        this.sessionTimeBase = 0L;
        this.lastTimestamp = null;
        this.lastSound = 0L;
        try {
            Document doc = this.messageField.getDocument();
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void appendMessage(ActivityMessage message) {
        if (ActivityDebug.NOTIFY.show()) {
            this.log.log("New message: [" + message.getDisplayName() + "] " + message.getTextDescription() + "\n");
        }
        if (this.sessionTimeBase == 0L) {
            SessionTimeAPI sessionTime = (SessionTimeAPI)this.impls.findBest(SessionTimeAPI.class);
            if (sessionTime != null) {
                if (sessionTime.isSessionTimeValid()) {
                    this.sessionTimeBase = sessionTime.getSessionTimeBase();
                }
            } else {
                this.sessionTimeBase = Long.MIN_VALUE;
            }
        }
        Calendar ts = null;
        if (((ActivityTypeConfig)this.configProvider.get()).isTimestampsDisplayed() && this.sessionTimeBase != 0L) {
            ts = Calendar.getInstance();
            if (this.sessionTimeBase < 0L) {
                ts.setTime(new Date(message.getSystemTimeOfMessageMillis()));
            } else {
                long when = this.sessionTimeBase + message.getSessionTimeOfMessageMillis();
                Date stamp = new Date(when);
                ts.setTime(stamp);
            }
            if (this.lastTimestamp != null) {
                Calendar next = Calendar.getInstance();
                next.setTime(this.lastTimestamp);
                next.add(12, 5);
                if (ts.after(next)) {
                    int min = ts.get(12);
                    min = min / 5 * 5;
                    ts.set(12, min);
                    ts.set(13, 0);
                    this.lastTimestamp = ts.getTime();
                } else {
                    ts = null;
                }
            } else {
                int min = ts.get(12);
                min = min / 5 * 5;
                ts.set(12, min);
                ts.set(13, 0);
                this.lastTimestamp = ts.getTime();
            }
        }
        try {
            String text;
            HTMLDocument doc = (HTMLDocument)this.messageField.getDocument();
            if (ts != null) {
                String html = "<div class=\"timestamp\">" + this.timestampFormat.format(ts.getTime()) + "</div>";
                int pos = doc.getLength();
                Element e = doc.getParagraphElement(pos);
                doc.insertAfterEnd(e, html);
            }
            StringBuilder html = new StringBuilder();
            boolean notification = message.getVolume() == 11;
            html.append("<div class=\"event");
            if (notification) {
                html.append("-notification");
            } else if (message.getHeader() != null) {
                html.append("-message");
            }
            html.append("\">");
            html.append("<div class=\"");
            String clss = message.getOrigModuleName();
            if (clss != null) {
                html.append(ActivityBean.normalizeCSSName(clss.toLowerCase(Locale.ENGLISH)));
            } else {
                html.append("generic");
            }
            html.append("\">");
            String hdr = StringUtils.htmlEscape((String)message.getHeader());
            if (hdr != null) {
                html.append("<p class=\"header\">");
                html.append(hdr);
                html.append("</p>");
            }
            if ((text = StringUtils.htmlEscape((String)message.getTextDescription())) != null) {
                html.append("<p class=\"text");
                if (notification) {
                    html.append("-notification");
                } else if (message.isFromMe()) {
                    html.append("-me");
                }
                html.append("\">");
                html.append(text);
                html.append("</p>");
            }
            html.append("</div></div>");
            int pos = doc.getLength();
            Element e = doc.getParagraphElement(pos);
            doc.insertAfterEnd(e, html.toString());
            if (ActivityDebug.HTML.show()) {
                StringWriter w = new StringWriter();
                this.messageField.getEditorKit().write(w, (Document)doc, 0, doc.getLength());
                this.log.log(w.toString());
            }
            if (this.model.isVisible()) {
                long now = System.currentTimeMillis();
                if (now - this.lastSound > 500L) {
                    this.broker.sendNotification((Object)this, EVENT_NOTICE, message.getTextDescription(), message.getSessionTimeOfMessageMillis());
                }
                this.lastSound = now;
            }
        }
        catch (BadLocationException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String normalizeCSSName(String name) {
        return name.replace(' ', '-').replaceAll("&", "");
    }

    private void handleCommand(String commandLine) {
        AccessibilityCLIAPI api = (AccessibilityCLIAPI)this.impls.findBest(AccessibilityCLIAPI.class);
        if (api == null) {
            LogSupport.message((String)"Accessibility CLI API not Available");
            return;
        }
        try {
            if (!api.processCLICommand(commandLine)) {
                this.publisher.sendCommandErrorMessage(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_COMMANDUNRECOGNIZED, new Object[]{commandLine}));
            }
        }
        catch (AccessibilityCLIException ex) {
            String dmsg = ex.getDisplayMessage();
            if (dmsg == null) {
                dmsg = this.i18n.getString((PropertiesEnum)StringsProperties.ACTIVITYBEAN_COMMANDERROR, new Object[]{commandLine});
            }
            this.publisher.sendCommandErrorMessage(dmsg);
        }
    }

    private class ModuleItem
    extends CCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        String moduleName;

        public ModuleItem(String moduleDisplayName, String moduleName, Icon moduleIcon) {
            super(moduleDisplayName, moduleIcon);
            this.moduleName = moduleName;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivityTypeConfig config = (ActivityTypeConfig)ActivityBean.this.configProvider.get();
            config.setModuleEnabled(this.moduleName, this.isSelected());
        }
    }

    private static class SplitterUI
    extends BasicSplitPaneUI {
        private SplitterUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Dimension s = this.getSize();
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 1, s.width, s.height - 1);
                    g.setColor(Color.GRAY);
                    g.drawLine(0, 0, s.width, 0);
                }
            };
        }
    }

    private class VolumeItem
    extends CCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private int volume;

        public VolumeItem(String text, int volume) {
            super(text);
            this.volume = volume;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActivityTypeConfig config = (ActivityTypeConfig)ActivityBean.this.configProvider.get();
            config.setMinimumVolume(this.volume);
        }
    }
}

