/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.XmlElement;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlParser
implements ContentHandler {
    LinkedList<XmlElement> stack = new LinkedList();
    Map<String, XmlElement> known = new HashMap<String, XmlElement>();
    private Locator locator = null;

    public void addElementType(XmlElement e) {
        this.known.put(e.getName(), e);
    }

    public void parse(Reader input) throws SAXException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            InputSource source = new InputSource(input);
            reader.setContentHandler(this);
            reader.parse(source);
        }
        catch (IOException iox) {
            throw new SAXParseException("While reading hint definitions - " + iox, this.locator);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        throw new SAXParseException("Prefix mapping '" + prefix + "'->" + uri + " is not supported.", this.locator);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        throw new SAXParseException("Prefix mapping '" + prefix + "' is not supported.", this.locator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        XmlElement child = this.known.get(localName);
        if (child == null) {
            throw new SAXException("Unknown element '" + localName + "'");
        }
        XmlElement parent = this.stack.peek();
        if (parent == null) {
            if (!child.isRoot()) {
                throw new SAXParseException("'" + localName + "' may not be used as a root element", this.locator);
            }
        } else {
            parent.validateChild(child);
        }
        if (child.isActive()) {
            throw new SAXParseException("Recursive use of <" + localName + "> element.", this.locator);
        }
        child.reset();
        child.enter(parent, atts);
        this.stack.addFirst(child);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            XmlElement top = this.stack.removeFirst();
            if (!localName.equals(top.getName())) {
                throw new SAXParseException("End element '" + localName + "' while '" + top.getName() + "' is being processed.", this.locator);
            }
            top.leave();
        }
        catch (NoSuchElementException nsx) {
            throw new SAXParseException("End element '" + localName + "' while processing stack is empty.", this.locator);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        XmlElement current = this.stack.peek();
        if (current == null && new String(ch, start, length).trim().length() > 0) {
            throw new SAXParseException("Text found outside of the document. '" + new String(ch, start, length) + "'", this.locator);
        }
        try {
            current.processText(ch, start, length);
        }
        catch (SAXException sx) {
            throw new SAXParseException(sx.getMessage(), this.locator);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new SAXParseException("Processing instruction " + target + "->" + data + " is not supported.", this.locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

