/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class XmlElement {
    private String name;
    private boolean isRoot;
    private boolean inUse;

    protected XmlElement(String name, boolean root) {
        this.name = name;
        this.isRoot = root;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public final boolean isActive() {
        return this.inUse;
    }

    public final void doEnter(XmlElement outer, Attributes attrs) throws SAXException {
        this.inUse = true;
        this.enter(outer, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doLeave() throws SAXException {
        try {
            this.leave();
        }
        finally {
            this.inUse = false;
        }
    }

    protected abstract void enter(XmlElement var1, Attributes var2) throws SAXException;

    protected abstract void leave() throws SAXException;

    public abstract void reset();

    public void validateChild(XmlElement child) throws SAXException {
        throw new SAXException("The " + this.getName() + " element may not have child elements.");
    }

    public void processText(char[] chars, int off, int len) throws SAXException {
        String txt = new String(chars, off, len);
        if ((txt = txt.trim()).length() > 0) {
            throw new SAXException("Text is not supported in this context. '" + txt + "'");
        }
    }
}

