/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.Hint;
import com.elluminate.framework.feature.hints.Hintable;
import java.util.HashMap;
import java.util.Map;

public class Hints {
    private Map<String, Hint> hints = new HashMap<String, Hint>();

    public void apply(Hintable h) {
        for (Hint hint : this.hints.values()) {
            hint.apply(h);
        }
    }

    public Hint get(String name) {
        return this.hints.get(name);
    }

    public void add(Hint hint) {
        this.hints.put(hint.getName(), hint);
    }

    public void add(Hints other) {
        this.hints.putAll(other.hints);
    }

    public void addIfMissing(Hints other) {
        for (String name : other.hints.keySet()) {
            if (this.hints.containsKey(name)) continue;
            this.hints.put(name, other.hints.get(name));
        }
    }

    public boolean isEmpty() {
        return this.hints.isEmpty();
    }

    public String toString() {
        StringBuilder msg = new StringBuilder("Hints (");
        msg.append(this.hints.size());
        msg.append(")\n");
        for (Hint h : this.hints.values()) {
            msg.append("  ");
            msg.append(h);
            msg.append("\n");
        }
        return msg.toString();
    }
}

