/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.ValueChangeRequestListener;

public class ValueFeature<T>
extends AbstractFeature {
    public static final String VALUE = "ValueFeature.value";
    public static final String VALUE_MUTABLE = "ValueFeature.valueMutable";
    private Class<T> type;
    private boolean allowSetMutable = false;
    private ValueChangeRequestListener<T> changeRequestListener = null;

    protected ValueFeature() {
        this.initMetaDatumType(VALUE_MUTABLE, Boolean.class);
    }

    public void initType(Class<T> type) {
        if (this.type != null) {
            throw new IllegalStateException("type is already initialized");
        }
        this.type = type;
        this.initMetaDatumType(VALUE, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initMutable(boolean mutable) {
        if (super.getMetaDatum(VALUE_MUTABLE) != null) {
            throw new IllegalStateException("ValueFeature.valueMutable is already initialized");
        }
        try {
            this.allowSetMutable = true;
            super.setMetaDatum(VALUE_MUTABLE, mutable);
        }
        finally {
            this.allowSetMutable = false;
        }
    }

    public Class<T> getValueType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChangeRequestSupported() {
        boolean crOk;
        Object object = this.lock;
        synchronized (object) {
            crOk = this.changeRequestListener != null;
        }
        return crOk;
    }

    public T getValue() {
        return this.getMetaDatumAs(this.type, VALUE);
    }

    public void setValue(T value) {
        this.setMetaDatum(VALUE, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestValue(T value) {
        ValueChangeRequestListener<T> listener;
        Object object = this.lock;
        synchronized (object) {
            listener = this.changeRequestListener;
        }
        if (listener == null) {
            throw new IllegalStateException(this.getPath() + ": requestValue called when not supported.");
        }
        listener.requestValueChange(this, value);
    }

    public void addValueChangeListener(MetaDataListener l) {
        this.addMetaDataListener(VALUE, l);
    }

    public void removeValueChangeListener(MetaDataListener l) {
        this.removeMetaDataListener(VALUE, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueChangeRequestListener(ValueChangeRequestListener<T> lst) {
        Object object = this.lock;
        synchronized (object) {
            this.changeRequestListener = lst;
        }
    }

    public boolean isMutable() {
        Boolean mutable = this.getMetaDatumAs(Boolean.class, VALUE_MUTABLE);
        if (mutable != null) {
            return mutable;
        }
        return true;
    }

    @Override
    protected void validateMetaDatumAssignment(String key, Object value) {
        super.validateMetaDatumAssignment(key, value);
        if (VALUE_MUTABLE.equals(key) && !this.allowSetMutable) {
            throw new UnsupportedOperationException("Cannot set 'ValueFeature.valueMutable' as a meta-datum");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        if (this.type != null) {
            result.append("[" + this.type.getName() + "]");
        }
        result.append("=" + this.getValue());
        return result.toString();
    }
}

