/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.ValueFeature;
import java.awt.Image;

public class StringFeature
extends ValueFeature<String> {
    public static final String SECURE_TEXT = "secureText";
    public static final String ICON = "icon";
    private Validator validator = null;

    public StringFeature() {
        this.initType(String.class);
        this.initMetaDatumType(SECURE_TEXT, Boolean.class);
        this.initMetaDatumType(ICON, Image.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidator(Validator validator) {
        Object object = this.lock;
        synchronized (object) {
            if (validator != null && !validator.isValid((String)this.getValue())) {
                throw new IllegalStateException("Current value failed to validate: " + (String)this.getValue());
            }
            this.validator = validator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidator(Validator validator, String value) {
        Object object = this.lock;
        synchronized (object) {
            if (validator != null && !validator.isValid(value)) {
                throw new IllegalStateException("Given value failed to validate: " + value);
            }
            boolean assignedOK = false;
            Validator oldValidator = this.validator;
            this.validator = validator;
            try {
                this.setMetaDatum("ValueFeature.value", value);
                assignedOK = true;
            }
            finally {
                if (!assignedOK) {
                    this.validator = oldValidator;
                }
            }
        }
    }

    public boolean isSecureText() {
        Boolean result = this.getMetaDatumAs(Boolean.class, SECURE_TEXT);
        if (result != null) {
            return result;
        }
        return false;
    }

    public void setSecureText(boolean secureText) {
        this.setMetaDatum(SECURE_TEXT, secureText);
    }

    public Image getIcon() {
        return this.getMetaDatumAs(Image.class, ICON);
    }

    public void setIcon(Image icon) {
        super.setMetaDatum(ICON, icon);
    }

    @Override
    protected void validateMetaDatumAssignment(String key, Object value) {
        super.validateMetaDatumAssignment(key, value);
        if ("ValueFeature.value".equals(key) && this.validator != null && !this.validator.isValid((String)value)) {
            throw new IllegalArgumentException("Value failed validation: " + value);
        }
    }

    public static interface Validator {
        public boolean isValid(String var1);
    }
}

