/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.util.ArraySet;
import java.awt.Image;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EnumeratedFeature<T>
extends ValueFeature<T> {
    public static final String VALUE_ICON_IMAGE = "EnumeratedFeature.valueIconImage";
    public static final String VALUE_TEXT = "EnumeratedFeature.valueText";
    public static final String VALUE_DESCRIPTION = "EnumeratedFeature.valueDescription";
    public static final String DEFAULT_ICON = "EnumeratedFeature.defaultIcon";
    private ArraySet<T> allowedValues;

    public EnumeratedFeature() {
        this.initMetaDatumType(VALUE_ICON_IMAGE, Map.class);
        this.initMetaDatumType(VALUE_TEXT, Map.class);
        this.initMetaDatumType(VALUE_DESCRIPTION, Map.class);
        this.initMetaDatumType(DEFAULT_ICON, Image.class);
    }

    public void initEnumeration(T[] allowedValues) {
        if (this.allowedValues != null) {
            throw new IllegalStateException("allowedValues already initialized");
        }
        if (allowedValues.length < 1) {
            throw new IllegalArgumentException("Empty set not allowed");
        }
        this.allowedValues = new ArraySet(allowedValues.length);
        for (T val : allowedValues) {
            if (this.allowedValues.contains(val)) {
                throw new IllegalArgumentException("Duplicate allowed value: " + val);
            }
            this.allowedValues.add(val);
        }
        if (!this.allowedValues.contains(this.getValue())) {
            this.setValue(allowedValues[0]);
        }
    }

    public void initEnumeration(Collection<T> allowedValues) {
        if (this.allowedValues != null) {
            throw new IllegalStateException("allowedValues already initialized");
        }
        if (allowedValues.isEmpty()) {
            throw new IllegalArgumentException("Empty set not allowed");
        }
        this.allowedValues = new ArraySet(allowedValues.size());
        for (T val : allowedValues) {
            if (this.allowedValues.contains(val)) {
                throw new IllegalArgumentException("Duplicate allowed value: " + val);
            }
            this.allowedValues.add(val);
        }
        if (!this.allowedValues.contains(this.getValue())) {
            this.setValue(allowedValues.iterator().next());
        }
    }

    public boolean isAllowedValue(T value) {
        return this.allowedValues.contains(value);
    }

    public T[] getAllowedValues() {
        Object[] result = (Object[])Array.newInstance(this.getValueType(), this.allowedValues.size());
        return this.allowedValues.toArray(result);
    }

    public Set<T> getEnumerationSet() {
        return Collections.unmodifiableSet(this.allowedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueText(T value) {
        Object object = this.lock;
        synchronized (object) {
            Map textMap = this.getMetaDatumAs(Map.class, VALUE_TEXT);
            if (textMap != null) {
                return (String)textMap.get(value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueText(T value, String text) {
        if (!this.isAllowedValue(value)) {
            throw new IllegalArgumentException("Value is not a member of the enumeration: " + value);
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Object, String> textMap = this.getMetaDatumAs(Map.class, VALUE_TEXT);
            textMap = textMap == null ? new HashMap<T, String>() : new HashMap(textMap);
            textMap.put(value, text);
            this.setMetaDatum(VALUE_TEXT, textMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueDescription(T value) {
        Object object = this.lock;
        synchronized (object) {
            Map textMap = this.getMetaDatumAs(Map.class, VALUE_DESCRIPTION);
            if (textMap != null) {
                return (String)textMap.get(value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueDescription(T value, String text) {
        if (!this.isAllowedValue(value)) {
            throw new IllegalArgumentException("Value is not a member of the enumeration: " + value);
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Object, String> textMap = this.getMetaDatumAs(Map.class, VALUE_DESCRIPTION);
            textMap = textMap == null ? new HashMap<T, String>() : new HashMap(textMap);
            textMap.put(value, text);
            this.setMetaDatum(VALUE_DESCRIPTION, textMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getValueIconImage(T value) {
        Object object = this.lock;
        synchronized (object) {
            Map iconMap = this.getMetaDatumAs(Map.class, VALUE_ICON_IMAGE);
            if (iconMap != null) {
                return (Image)iconMap.get(value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueIconImage(T value, Image image) {
        if (!this.isAllowedValue(value)) {
            throw new IllegalArgumentException("Value is not a member of the enumeration: " + value);
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Object, Image> iconMap = this.getMetaDatumAs(Map.class, VALUE_ICON_IMAGE);
            iconMap = iconMap == null ? new HashMap<T, Image>() : new HashMap(iconMap);
            iconMap.put(value, image);
            this.setMetaDatum(VALUE_ICON_IMAGE, iconMap);
        }
    }

    public void setDefaultIcon(Image icon) {
        this.setMetaDatum(DEFAULT_ICON, icon);
    }

    public Image getDefaultIcon() {
        return this.getMetaDatumAs(Image.class, DEFAULT_ICON);
    }

    @Override
    protected void validateMetaDatumAssignment(String key, Object value) {
        Object typedValue;
        super.validateMetaDatumAssignment(key, value);
        if ("ValueFeature.value".equals(key) && !this.isAllowedValue(typedValue = value)) {
            throw new IllegalArgumentException("Value is not an allowed value: " + value);
        }
    }
}

