/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.FeaturePublicationEvent;
import com.elluminate.framework.feature.FeaturePublicationListener;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.LocationWhitelist;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.feature.NotificationListener;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.feature.hints.Hintable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class BrokerAdapter
implements FeaturePublicationListener,
NotificationListener {
    private static final String DEFAULT_LOCATION_HINT = "location";
    private String locationHint = "location";
    private Object lock = new Object();
    private Map<String, List<LocationHandler>> handlerMap = new HashMap<String, List<LocationHandler>>();
    private List<LocationHandler> defaultInfo = new ArrayList<LocationHandler>();
    private FeatureBroker broker;
    private LocationWhitelist locationWhitelist;

    @Inject
    public BrokerAdapter(FeatureBroker broker, LocationWhitelist locationWhitelist) {
        this.broker = broker;
        broker.addFeaturePublicationListener(this);
        broker.addNotificationListener(this);
        this.locationWhitelist = locationWhitelist;
    }

    public void dispose() {
        this.broker.removeFeaturePublicationListener(this);
        this.broker.removeNotificationListener(this);
    }

    public void setLocationHintName(String name) {
        this.locationHint = name;
    }

    public void addLocationHandler(String location, LocationHandler handler) {
        this.mapInsert(location, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapInsert(String location, LocationHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.locationWhitelist.checkLocation(location)) {
                return;
            }
            List<LocationHandler> list = this.handlerMap.get(location);
            if (list == null) {
                list = new ArrayList<LocationHandler>();
                this.handlerMap.put(location, list);
            }
            list.add(handler);
        }
    }

    public void removeLocationHandler(String location, LocationHandler handler) {
        this.mapRemove(location, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapRemove(String location, LocationHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            List<LocationHandler> handlers = this.handlerMap.get(location);
            if (this.handlerMap != null) {
                handlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultLocationHandler(LocationHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            this.defaultInfo.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultLocationHandler(LocationHandler handler) {
        Object object = this.lock;
        synchronized (object) {
            this.defaultInfo.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocationHandler> getHandlers(Hintable hintable) {
        Set locations = (Set)((Object)hintable.getHintValue(this.locationHint, Set.class));
        List<LocationHandler> handlers = null;
        Object object = this.lock;
        synchronized (object) {
            if (locations != null) {
                for (HintEnum loc : locations) {
                    List<LocationHandler> list = this.handlerMap.get(loc.getName());
                    if (list == null) continue;
                    if (handlers == null) {
                        handlers = list;
                        continue;
                    }
                    handlers = new ArrayList<LocationHandler>(handlers);
                    handlers.addAll(list);
                }
            }
            if (handlers == null) {
                handlers = this.defaultInfo;
            }
        }
        return handlers;
    }

    @Override
    public void featureAdded(FeaturePublicationEvent event) {
        Feature feature = event.getSourceFeature();
        for (LocationHandler handler : this.getHandlers(feature)) {
            handler.addFeature(feature);
        }
    }

    @Override
    public void featureRemoved(FeaturePublicationEvent event) {
        Feature feature = event.getSourceFeature();
        for (LocationHandler handler : this.getHandlers(feature)) {
            handler.removeFeature(feature);
        }
    }

    @Override
    public void featureAnnounced(FeaturePublicationEvent event) {
        Feature feature = event.getSourceFeature();
        for (LocationHandler handler : this.getHandlers(feature)) {
            handler.announceFeature(feature);
        }
    }

    @Override
    public void deliverNotification(Notification notification) {
        for (LocationHandler handler : this.getHandlers(notification)) {
            handler.deliverNotification(notification);
        }
    }

    @Override
    public void abortNotification(Notification notification) {
        for (LocationHandler handler : this.getHandlers(notification)) {
            handler.abortNotification(notification);
        }
    }

    @Override
    public void announceNotification(Notification notification) {
        for (LocationHandler handler : this.getHandlers(notification)) {
            handler.announceNotification(notification);
        }
    }
}

