/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionFeatureStatus;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ActionFeature
extends AbstractFeature {
    public static final String DEFAULT_ICON = "Action.dftIcon";
    public static final String PRESSED_ICON = "Action.pressedIcon";
    public static final String DISABLED_ICON = "Action.disabledIcon";
    public static final String ROLLOVER_ICON = "Action.rolloverIcon";
    public static final String INTERACTIVE = "Action.interactive";
    public static final String KEYSTROKE = "Action.keystroke";
    private ListenerRegistry<ActionFeatureListener> actionListenerRegistry = new ListenerRegistry(this.throwableProxy);
    private final Map<String, ActionParameterDescriptor> parameterList = new TreeMap<String, ActionParameterDescriptor>();

    public ActionFeature() {
        this.initMetaDatumType(DEFAULT_ICON, Image.class);
        this.initMetaDatumType(PRESSED_ICON, Image.class);
        this.initMetaDatumType(DISABLED_ICON, Image.class);
        this.initMetaDatumType(ROLLOVER_ICON, Image.class);
        this.initMetaDatumType(INTERACTIVE, Boolean.class);
        this.initMetaDatumType(KEYSTROKE, String.class);
    }

    public void initParameterDescriptors(Collection<ActionParameterDescriptor> params) {
        if (!this.parameterList.isEmpty()) {
            throw new IllegalStateException("Parameter list already initialized");
        }
        if (params != null) {
            for (ActionParameterDescriptor desc : params) {
                this.addParameterDescriptor(desc);
            }
        }
    }

    public void initParameterDescriptors(ActionParameterDescriptor[] params) {
        if (!this.parameterList.isEmpty()) {
            throw new IllegalStateException("Parameter list already initialized");
        }
        if (params != null) {
            for (ActionParameterDescriptor desc : params) {
                this.addParameterDescriptor(desc);
            }
        }
    }

    private void addParameterDescriptor(ActionParameterDescriptor desc) {
        if (desc == null) {
            throw new IllegalArgumentException("Null parameter descriptor");
        }
        if (this.parameterList.containsKey(desc.getKey())) {
            throw new IllegalArgumentException("Duplicate parameter key: " + desc.getKey());
        }
        this.parameterList.put(desc.getKey(), desc);
    }

    public boolean hasParameters() {
        return this.getParameterCount() > 0;
    }

    public int getParameterCount() {
        return this.parameterList.size();
    }

    public Set<String> getParameterKeys() {
        if (this.parameterList.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.parameterList.keySet());
    }

    public boolean hasParameter(String key) {
        return this.parameterList.containsKey(key);
    }

    public ActionParameterDescriptor getParameterDescriptor(String key) {
        return this.parameterList.get(key);
    }

    public Collection<ActionParameterDescriptor> getParameterList() {
        if (this.parameterList.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.parameterList.values());
    }

    public boolean isParameterValueValid(String key, Object value) {
        ActionParameterDescriptor desc = this.getParameterDescriptor(key);
        if (desc == null) {
            throw new IllegalArgumentException("Unrecognized parameter: " + key);
        }
        return desc.isValid(value);
    }

    private void verifyParameterList(Map<String, Object> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                ActionParameterDescriptor desc = this.getParameterDescriptor(key);
                if (desc == null) {
                    throw new RuntimeException("Unexpected parameter: " + key);
                }
                Object val = params.get(key);
                if (desc.isValid(val)) continue;
                throw new RuntimeException("Invalid value for " + desc + ": " + val);
            }
        }
        for (ActionParameterDescriptor desc : this.getParameterList()) {
            if (desc.isOptional() || params != null && params.containsKey(desc.getKey())) continue;
            throw new RuntimeException("Missing required parameter: " + desc);
        }
    }

    public void setDefaultIcon(Image icon) {
        this.setMetaDatum(DEFAULT_ICON, icon);
    }

    public Image getDefaultIcon() {
        return this.getMetaDatumAs(Image.class, DEFAULT_ICON);
    }

    public void setPressedIcon(Image icon) {
        this.setMetaDatum(PRESSED_ICON, icon);
    }

    public Image getPressedIcon() {
        return this.getMetaDatumAs(Image.class, PRESSED_ICON);
    }

    public void setDisabledIcon(Image icon) {
        this.setMetaDatum(DISABLED_ICON, icon);
    }

    public Image getDisabledIcon() {
        return this.getMetaDatumAs(Image.class, DISABLED_ICON);
    }

    public void setRolloverIcon(Image icon) {
        this.setMetaDatum(ROLLOVER_ICON, icon);
    }

    public Image getRolloverIcon() {
        return this.getMetaDatumAs(Image.class, ROLLOVER_ICON);
    }

    public void setInteractive(boolean flag) {
        this.setMetaDatum(INTERACTIVE, flag);
    }

    public boolean isInteractive() {
        Boolean b = this.getMetaDatumAs(Boolean.class, INTERACTIVE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public String getKeyStroke() {
        return super.getMetaDatumAs(String.class, KEYSTROKE);
    }

    public void setKeyStroke(String keystroke) {
        super.setMetaDatum(KEYSTROKE, keystroke);
    }

    public void addActionFeatureListener(ActionFeatureListener l) {
        this.actionListenerRegistry.add((Object)l);
    }

    public void removeActionFeatureListener(ActionFeatureListener l) {
        this.actionListenerRegistry.remove((Object)l);
    }

    public ActionFeatureStatus fireActionFeatureListeners() {
        return this.fireActionFeatureListeners(null, null);
    }

    public ActionFeatureStatus fireActionFeatureListeners(Object userData) {
        return this.fireActionFeatureListeners(null, userData);
    }

    public ActionFeatureStatus fireActionFeatureListeners(Map<String, Object> params) {
        return this.fireActionFeatureListeners(params, null);
    }

    public ActionFeatureStatus fireActionFeatureListeners(Map<String, Object> params, Object userData) {
        ActionFeatureStatus status = null;
        this.verifyParameterList(params);
        if (this.isPublished() && this.isEnabled()) {
            FireActionFeatureFunctor firer = new FireActionFeatureFunctor(params, userData);
            this.actionListenerRegistry.fire((FiringFunctor)firer);
            status = firer.getStatus();
        }
        if (status == null) {
            return new ActionFeatureStatus();
        }
        return status;
    }

    private class FireActionFeatureFunctor
    implements FiringFunctor<ActionFeatureListener> {
        private Map<String, Object> parameters;
        private Object userData;
        private ActionFeatureEvent event = null;

        FireActionFeatureFunctor(Map<String, Object> parameters, Object userData) {
            this.parameters = parameters;
            this.userData = userData;
        }

        public void fire(ActionFeatureListener listener) {
            if (this.event == null) {
                this.event = new ActionFeatureEvent(ActionFeature.this, this.parameters, this.userData);
            }
            listener.actionPerformed(this.event);
        }

        public ActionFeatureStatus getStatus() {
            if (this.event == null) {
                return null;
            }
            return this.event.getStatus();
        }
    }
}

