/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.hints.AbstractHintable;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.google.inject.Inject;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractFeature
extends AbstractHintable
implements Feature {
    public static final String NAME = "Feature.name";
    public static final String LONG_NAME = "Feature.longName";
    public static final String SHORT_NAME = "Feature.shortName";
    public static final String AX_NAME = "Feature.accessibleName";
    public static final String DESCRIPTION = "Feature.description";
    public static final String AX_DESCRIPTION = "Feature.accessibileDescription";
    public static final String ENABLED = "Feature.enabled";
    private String path;
    private boolean isPublished = false;
    private final Map<String, Object> metaData;
    private final Map<String, Class<?>> metaTypes;
    private final ListenerRegistry<MetaDataListener> metaListeners;
    private final Map<String, ListenerRegistry<MetaDataListener>> keyedMetaListeners;
    private ThrowableListener throwableListener = null;
    protected final ThrowableListener throwableProxy = new ThrowableListenerProxy();
    protected FeaturePathSupport pathSupport;
    protected Object lock = new Object();

    protected AbstractFeature() {
        this.metaData = new TreeMap<String, Object>();
        this.metaTypes = new TreeMap();
        this.metaListeners = new ListenerRegistry(this.throwableProxy);
        this.keyedMetaListeners = new TreeMap<String, ListenerRegistry<MetaDataListener>>();
        this.initMetaDatumType(NAME, String.class);
        this.initMetaDatumType(LONG_NAME, String.class);
        this.initMetaDatumType(SHORT_NAME, String.class);
        this.initMetaDatumType(AX_NAME, String.class);
        this.initMetaDatumType(DESCRIPTION, String.class);
        this.initMetaDatumType(AX_DESCRIPTION, String.class);
        this.initMetaDatumType(ENABLED, Boolean.class);
    }

    @Inject
    public void initThrowableListener(ThrowableListener tl) {
        if (this.throwableListener != null) {
            throw new IllegalStateException("ThrowableListener already set");
        }
        if (tl == null) {
            throw new IllegalArgumentException("Null ThrowableListener not allowed");
        }
        this.throwableListener = tl;
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        if (this.pathSupport != null) {
            throw new IllegalStateException("PathSupport already set");
        }
        this.pathSupport = pathSupport;
    }

    void initPath(String path) {
        if (this.getPath() != null) {
            throw new IllegalStateException("Feature path already set");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null feature path");
        }
        this.pathSupport.validatePath(path);
        if (!this.pathSupport.isAbsolutePath(path)) {
            throw new IllegalArgumentException("Relative path not allowed: " + path);
        }
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMetaDatumType(String key, Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            this.metaTypes.put(key, type);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + ":" + this.path);
        String[] hintList = this.getHintList();
        if (hintList.length > 0) {
            result.append(" { ");
            boolean firstTrip = true;
            for (String hintName : hintList) {
                if (!firstTrip) {
                    result.append(", ");
                }
                result.append(hintName + "=" + this.getHintValue(hintName));
                firstTrip = false;
            }
            result.append(" }");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPublished() {
        boolean pub;
        Object object = this.lock;
        synchronized (object) {
            pub = this.isPublished;
        }
        return pub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPublished(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.isPublished = b;
        }
    }

    public String getName() {
        return this.getMetaDatumAs(String.class, NAME);
    }

    public void setName(String name) {
        this.setMetaDatum(NAME, name);
        if (this.getMetaDatumAs(String.class, AX_NAME) == null) {
            this.setAccessibleName(name);
        }
    }

    public String getLongName() {
        String result = this.getMetaDatumAs(String.class, LONG_NAME);
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public void setLongName(String name) {
        this.setMetaDatum(LONG_NAME, name);
    }

    public String getShortName() {
        String result = this.getMetaDatumAs(String.class, SHORT_NAME);
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public void setShortName(String name) {
        this.setMetaDatum(SHORT_NAME, name);
    }

    public String getAccessibleName() {
        String result = this.getMetaDatumAs(String.class, AX_NAME);
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public void setAccessibleName(String name) {
        name = this.cleanAXName(name);
        this.setMetaDatum(AX_NAME, name);
    }

    private String cleanAXName(String name) {
        if (name == null) {
            return name;
        }
        String cleaned = name;
        char[] chars = cleaned.toCharArray();
        int previous = 0;
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char current = chars[i];
            if (current != '&') continue;
            char c = next = i + 1 < chars.length ? chars[i + 1] : (char)'\u0000';
            if ((previous == 0 || previous == 32) && (next == '\u0000' || next == ' ')) continue;
            chars[i] = '\u0000';
        }
        cleaned = String.valueOf(chars);
        cleaned = cleaned.replace("\u0000", "");
        return cleaned;
    }

    public String getDescription() {
        return this.getMetaDatumAs(String.class, DESCRIPTION);
    }

    public void setDescription(String name) {
        this.setMetaDatum(DESCRIPTION, name);
    }

    public String getAccessibleDescription() {
        String result = this.getMetaDatumAs(String.class, AX_DESCRIPTION);
        if (result == null) {
            result = this.getDescription();
        }
        return result;
    }

    public void setAccessibleDescription(String name) {
        this.setMetaDatum(AX_DESCRIPTION, name);
    }

    public boolean isEnabled() {
        Boolean result = this.getMetaDatumAs(Boolean.class, ENABLED);
        if (result == null) {
            return true;
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.setMetaDatum(ENABLED, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getMetaDatumType(String key) {
        Class<Object> result;
        Object object = this.lock;
        synchronized (object) {
            result = this.metaTypes.get(key);
        }
        if (result == null) {
            result = Object.class;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getMetaDatum(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.metaData.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getMetaDatumAs(Class<T> type, String key) {
        Object value;
        Object object = this.lock;
        synchronized (object) {
            value = this.metaData.get(key);
        }
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            String msg = "Cannot coerce " + value.getClass().getName() + " meta-datum '" + key + "' of feature " + this.getPath() + " to " + type.getName();
            throw new IllegalArgumentException(msg);
        }
        Object result = value;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaDatum(String key, Object value) {
        Object oldValue = null;
        Object object = this.lock;
        synchronized (object) {
            this.validateMetaDatumAssignment(key, value);
            oldValue = this.metaData.get(key);
            if (value == oldValue) {
                return;
            }
            if (value != null && value.equals(oldValue)) {
                return;
            }
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
            this.metaData.put(key, value);
        }
        this.fireMetaDataChanged(key, oldValue, value);
    }

    protected void validateMetaDatumAssignment(String key, Object value) {
        Class<?> type;
        if (value != null && (type = this.metaTypes.get(key)) != null && !type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(this.getPath() + "." + key + " requires a " + type.getName() + ", not a " + value.getClass().getName());
        }
    }

    @Override
    public void addMetaDataListener(MetaDataListener l) {
        this.metaListeners.add((Object)l);
    }

    @Override
    public void removeMetaDataListener(MetaDataListener l) {
        this.metaListeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaDataListener(String key, MetaDataListener l) {
        ListenerRegistry reg;
        Map<String, ListenerRegistry<MetaDataListener>> map = this.keyedMetaListeners;
        synchronized (map) {
            reg = this.keyedMetaListeners.get(key);
            if (reg == null) {
                reg = new ListenerRegistry(this.throwableProxy);
                this.keyedMetaListeners.put(key, (ListenerRegistry<MetaDataListener>)reg);
            }
        }
        reg.add((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaDataListener(String key, MetaDataListener l) {
        ListenerRegistry<MetaDataListener> reg;
        Map<String, ListenerRegistry<MetaDataListener>> map = this.keyedMetaListeners;
        synchronized (map) {
            reg = this.keyedMetaListeners.get(key);
        }
        if (reg != null) {
            reg.remove((Object)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMetaDataChanged(final String key, final Object oldValue, final Object newValue) {
        ListenerRegistry<MetaDataListener> forKey;
        if (!this.isPublished()) {
            return;
        }
        FiringFunctor<MetaDataListener> ff = new FiringFunctor<MetaDataListener>(){
            private MetaDataEvent ev = null;

            public void fire(MetaDataListener l) {
                if (this.ev == null) {
                    this.ev = new MetaDataEvent(AbstractFeature.this, key, oldValue, newValue);
                }
                l.metaDataChanged(this.ev);
            }
        };
        Map<String, ListenerRegistry<MetaDataListener>> map = this.keyedMetaListeners;
        synchronized (map) {
            forKey = this.keyedMetaListeners.get(key);
        }
        if (forKey != null) {
            forKey.fire((FiringFunctor)ff);
        }
        this.metaListeners.fire((FiringFunctor)ff);
    }

    private class ThrowableListenerProxy
    implements ThrowableListener {
        private ThrowableListenerProxy() {
        }

        public void exceptionThrown(Exception ex) {
            ThrowableListener tl = AbstractFeature.this.throwableListener;
            if (tl != null) {
                tl.exceptionThrown(ex);
            } else {
                this.fallback(ex);
            }
        }

        public void errorThrown(Error err) {
            ThrowableListener tl = AbstractFeature.this.throwableListener;
            if (tl != null) {
                tl.errorThrown(err);
            } else {
                this.fallback(err);
            }
        }

        private void fallback(Throwable t) {
            System.err.println("Throwable encountered w/p handler:");
            t.printStackTrace();
        }
    }
}

