/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareHistoryCache;
import com.elluminate.groupware.appshare.AppShareTile;
import com.elluminate.groupware.appshare.AppShareTileDefn;
import com.elluminate.groupware.appshare.AppShareTileDesc;
import com.elluminate.util.log.LogSupport;

public final class AppShareTileDecoder {
    public static final int CUR_ENCODING_FORMAT = 2;
    protected AppShareHistoryCache history;
    protected int prevCol;
    protected short[] prevColors15;
    protected int[] prevColors32;
    protected int prevRow;
    protected short[] dftColors15;
    protected int[] dftColors32;
    protected int[] typeCount = new int[17];
    protected long[] typeBytes = new long[17];
    protected int[] clutLength = new int[256];
    protected int nDataBytes = 0;

    public AppShareTileDecoder(int hostID, int historyCnt, short bgColor) {
        this.history = new AppShareHistoryCache(hostID, historyCnt);
        this.prevCol = 0;
        this.prevRow = 0;
        this.dftColors15 = new short[]{bgColor};
        this.dftColors32 = new int[]{AppShareTileDecoder.expandColor(bgColor)};
        this.prevColors15 = this.dftColors15;
        this.prevColors32 = this.dftColors32;
    }

    public AppShareHistoryCache getHistory() {
        return this.history;
    }

    public void showHistogramData() {
        int maxColorCnt;
        byte ix;
        LogSupport.message((Object)this, (String)"showHistogramData", (String)"Encoding Type Histogram, w/byte counts");
        int countSum = 0;
        for (ix = 0; ix < this.typeCount.length; ix = (byte)((byte)(ix + 1))) {
            countSum += this.typeCount[ix];
        }
        for (ix = 0; ix < this.typeCount.length; ix = (byte)(ix + 1)) {
            String label = ix <= 15 ? AppShareTileDefn.typeName(ix) : "Dup";
            float countPct = countSum > 0 ? (float)((this.typeCount[ix] * 1000 + countSum / 2) / countSum) / 10.0f : 0.0f;
            float sizePct = this.nDataBytes > 0 ? (float)((this.typeBytes[ix] * 1000L + (long)(this.nDataBytes / 2)) / (long)this.nDataBytes) / 10.0f : 0.0f;
            float avgSize = this.typeCount[ix] > 0 ? (float)((this.typeBytes[ix] * 10L + (long)(this.typeCount[ix] / 2)) / (long)this.typeCount[ix]) / 10.0f : 0.0f;
            LogSupport.message((String)("  " + label + ":\t" + this.typeCount[ix] + "\t" + countPct + "%\t" + this.typeBytes[ix] + "\t" + sizePct + "%\t" + avgSize + " ea"));
        }
        LogSupport.message((Object)this, (String)"showHistogramData", (String)"Colour Map Histogram:");
        for (maxColorCnt = this.clutLength.length - 1; maxColorCnt > 0 && this.clutLength[maxColorCnt] <= 0; --maxColorCnt) {
        }
        for (int ix2 = 0; ix2 < maxColorCnt; ix2 += 8) {
            LogSupport.message((String)(ix2 + ":\t" + this.clutLength[ix2] + "\t" + this.clutLength[ix2 + 1] + "\t" + this.clutLength[ix2 + 2] + "\t" + this.clutLength[ix2 + 3] + "\t" + this.clutLength[ix2 + 4] + "\t" + this.clutLength[ix2 + 5] + "\t" + this.clutLength[ix2 + 6] + "\t" + this.clutLength[ix2 + 7]));
        }
    }

    public String getStats() {
        int maxColourCnt;
        int countSum = 0;
        for (int ix = 0; ix < this.typeCount.length; ix = (int)((byte)(ix + 1))) {
            countSum += this.typeCount[ix];
        }
        for (maxColourCnt = this.clutLength.length - 1; maxColourCnt > 0 && this.clutLength[maxColourCnt] <= 0; --maxColourCnt) {
        }
        float avgSize = countSum > 0 ? (float)((this.nDataBytes * 10 + countSum / 2) / countSum) / 10.0f : 0.0f;
        return "nBytes=" + this.nDataBytes + " nTiles=" + countSum + " maxColorDepth=" + maxColourCnt + " avgSize=" + avgSize;
    }

    public void purgeHistory() {
        this.history.purge();
        this.prevCol = 0;
        this.prevRow = 0;
        this.prevColors15 = this.dftColors15;
        this.prevColors32 = this.dftColors32;
    }

    public void setCacheSize(int newSize) {
        if (this.history != null) {
            this.history.setCapacity(newSize);
        }
    }

    public int getCacheSize() {
        if (this.history != null) {
            return this.history.capacity();
        }
        return 0;
    }

    private short demuxColour(short muxed) {
        int red = 0;
        int grn = 0;
        int blu = 0;
        int val = muxed;
        for (int pos = 0; pos < 5; ++pos) {
            red |= (val & 1) << pos;
            grn |= ((val >>= 1) & 1) << pos;
            blu |= ((val >>= 1) & 1) << pos;
            val >>= 1;
        }
        return (short)((red & 0x1F) << 10 | (grn & 0x1F) << 5 | blu & 0x1F);
    }

    public int decodeTileDefn(byte[] defnBuf, int defnOff, int defnLim, AppShareTileDesc desc, AppShareTile tile) {
        boolean debug = AppShareDebug.DECODE.show();
        int[] pixmap = null;
        if (tile != null && tile.pixels != null) {
            pixmap = tile.pixels;
        }
        if (defnOff >= defnLim) {
            if (debug) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)"Off >= Lim");
            }
            return 0;
        }
        int defnIdx = defnOff;
        byte header = defnBuf[defnIdx++];
        int type = header & 0xF;
        boolean usePrevColors = (header & 0x10) != 0;
        boolean isDup = false;
        if (type == 15) {
            isDup = usePrevColors;
            usePrevColors = false;
        }
        if (debug) {
            if (type == 15) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Type: " + header + "=" + (isDup ? "Duplicate" : "Raw")));
            } else {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Type: " + header + "=" + AppShareTileDefn.typeName((byte)type) + (usePrevColors ? " reusing previous CLUT" : "")));
            }
        }
        int curRow = 0;
        int curCol = 0;
        switch (header & 0x60) {
            case 96: {
                curCol = this.prevCol;
                curRow = this.prevRow + 1;
                if (!debug) break;
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Same col, next row: R=" + curRow + " C=" + curCol));
                break;
            }
            case 32: {
                curCol = this.prevCol + 1;
                curRow = this.prevRow;
                if (!debug) break;
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Same row, next col: R=" + curRow + " C=" + curCol));
                break;
            }
            case 64: {
                curCol = this.prevCol - 1;
                curRow = this.prevRow;
                if (!debug) break;
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Same row, next col: R=" + curRow + " C=" + curCol));
                break;
            }
            default: {
                if (defnIdx + 1 > defnLim) {
                    throw new RuntimeException("No column or row specified in header: " + Integer.toHexString(header) + " @ " + defnIdx + " in tile @ " + defnOff);
                }
                curCol = defnBuf[defnIdx++] & 0xFF;
                if (defnIdx + 1 > defnLim) {
                    throw new RuntimeException("No row specified in header: " + Integer.toHexString(header) + " @ " + defnIdx + " in tile @ " + defnOff);
                }
                curRow = defnBuf[defnIdx++] & 0xFF;
                if (!debug) break;
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("R=" + curRow + " C=" + curCol));
            }
        }
        if (tile != null) {
            tile.row = curRow;
            tile.col = curCol;
        }
        short[] colors15 = null;
        int[] colors32 = null;
        if (usePrevColors) {
            colors15 = this.prevColors15;
            colors32 = this.prevColors32;
            if (debug) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Reuse CLUT: " + colors15.length));
            }
        } else if (type != 15) {
            int colorIdx;
            int colorCnt;
            boolean compressed;
            if (defnIdx >= defnLim) {
                throw new RuntimeException("No CLUT: @ " + defnIdx + " in tile @ " + defnOff);
            }
            int colorStart = defnIdx;
            boolean bl = compressed = type != 0 && defnBuf[defnIdx] < 0;
            if (!compressed) {
                int maxColours = AppShareTileDefn.getMaxColors((byte)type);
                int defnIdx2 = defnIdx;
                do {
                    if ((defnIdx2 += 2) <= defnLim) continue;
                    throw new RuntimeException("CLUT incomplete @ " + defnIdx2 + " in tile @ " + defnOff);
                } while (defnBuf[defnIdx2 - 2] >= 0 && (defnIdx2 - defnIdx) / 2 < maxColours);
                colorCnt = (defnIdx2 - defnIdx) / 2;
                colors15 = new short[colorCnt];
                colors32 = new int[colorCnt];
                for (colorIdx = 0; colorIdx < colorCnt; ++colorIdx) {
                    short reducedColor;
                    colors15[colorIdx] = reducedColor = (short)((defnBuf[defnIdx] << 8 | defnBuf[defnIdx + 1] & 0xFF) & Short.MAX_VALUE);
                    colors32[colorIdx] = AppShareTileDecoder.expandColor(reducedColor);
                    defnIdx += 2;
                    if (!debug) continue;
                    LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("  CLUT " + Integer.toHexString(colorIdx) + ": " + Integer.toHexString(reducedColor)));
                }
            } else {
                short reducedColor;
                if (defnIdx + 3 > defnLim) {
                    throw new RuntimeException("Compressed CLUT malformed @ " + defnIdx + " in tile @ " + defnOff);
                }
                colorCnt = 1 + (defnBuf[defnIdx + 2] & 0xFF);
                if (colorCnt > 256) {
                    throw new RuntimeException("Invalid compressed CLUT length: " + colorCnt + " @ " + defnIdx + 2 + " in tile @ " + defnOff);
                }
                colors15 = new short[colorCnt];
                colors32 = new int[colorCnt];
                short reducedColorRaw = (short)((defnBuf[defnIdx] << 8 | defnBuf[defnIdx + 1] & 0xFF) & Short.MAX_VALUE);
                colors15[0] = reducedColor = this.demuxColour(reducedColorRaw);
                colors32[0] = AppShareTileDecoder.expandColor(reducedColor);
                defnIdx += 2;
                ++defnIdx;
                if (debug) {
                    LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("  Compressed CLUT 0: " + Integer.toHexString(reducedColor)));
                }
                for (colorIdx = 1; colorIdx < colorCnt; ++colorIdx) {
                    if (defnIdx + 1 > defnLim) {
                        throw new RuntimeException("Compressed CLUT-a incomplete @ " + defnIdx + " in tile @ " + defnOff);
                    }
                    if (defnBuf[defnIdx] < 0) {
                        int delta = (defnBuf[defnIdx] & 0x7F) + 1;
                        reducedColorRaw = (short)(reducedColorRaw + delta);
                        reducedColor = this.demuxColour(reducedColorRaw);
                        ++defnIdx;
                    } else {
                        if (defnIdx + 2 > defnLim) {
                            throw new RuntimeException("Compressed CLUT-b incomplete @ " + defnIdx + " in tile @ " + defnOff);
                        }
                        reducedColorRaw = (short)((defnBuf[defnIdx] << 8 | defnBuf[defnIdx + 1] & 0xFF) & Short.MAX_VALUE);
                        reducedColor = this.demuxColour(reducedColorRaw);
                        defnIdx += 2;
                    }
                    colors15[colorIdx] = reducedColor;
                    colors32[colorIdx] = AppShareTileDecoder.expandColor(reducedColor);
                    if (!debug) continue;
                    LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("  Compressed CLUT " + Integer.toHexString(colorIdx) + ": " + Integer.toHexString(reducedColor)));
                }
            }
            if (debug) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Read CLUT: " + colors15.length));
            }
        }
        AppShareTileDefn defn = null;
        int encodingLen = 0;
        byte[] pixelEnc = null;
        if (isDup) {
            AppShareTileDefn orig;
            encodingLen = 2;
            if (defnIdx + encodingLen > defnLim) {
                throw new RuntimeException("Original ID missing @ " + defnIdx + " in tile @ " + defnOff);
            }
            int dupIdx = (defnBuf[defnIdx] & 0xFF) << 8 | defnBuf[defnIdx + 1] & 0xFF;
            if (debug || AppShareDebug.DUPLICATES.show()) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Decoding duplicate of " + dupIdx));
            }
            if ((orig = this.history.lookupDuplicate(dupIdx)) == null) {
                throw new RuntimeException("Invalid duplicate ID: " + dupIdx + " @ " + curRow + "," + curCol + " @ " + defnIdx + " in tile @ " + defnOff);
            }
            if (pixmap != null) {
                int origLen;
                short[] dupColors15 = orig.colors;
                colors32 = null;
                if (dupColors15 != null) {
                    if (dupColors15 == this.prevColors15) {
                        colors32 = this.prevColors32;
                    } else {
                        colors32 = new int[dupColors15.length];
                        for (int i = 0; i < colors32.length; ++i) {
                            colors32[i] = AppShareTileDecoder.expandColor(dupColors15[i]);
                        }
                    }
                }
                if ((origLen = AppShareTileDecoder.decodePixelEncoding(orig.pixelEnc, 0, orig.pixelEnc.length, orig.type, colors32, pixmap)) < 0) {
                    throw new RuntimeException("Invalid original encoding: " + dupIdx + " @ " + defnIdx + " in tile @ " + defnOff);
                }
            }
            defn = new AppShareTileDefn((byte)type, null, null, orig);
        } else if (type == 0) {
            encodingLen = 0;
            defn = AppShareTileDefn.getUnicolorTileDefn(colors15[0]);
            if (pixmap != null) {
                AppShareTileDecoder.decodePixelEncoding(defnBuf, defnIdx, defnLim, (byte)type, colors32, pixmap);
            }
        } else {
            encodingLen = AppShareTileDecoder.decodePixelEncoding(defnBuf, defnIdx, defnLim, (byte)type, colors32, pixmap);
            if (encodingLen < 0) {
                throw new RuntimeException("Pixel encoding incomplete @ " + defnIdx + " in tile @ " + defnOff);
            }
            pixelEnc = new byte[encodingLen];
            defn = new AppShareTileDefn((byte)type, colors15, pixelEnc);
            if (encodingLen > 0) {
                System.arraycopy(defnBuf, defnIdx, pixelEnc, 0, encodingLen);
            }
            this.history.insert(defn);
        }
        defnIdx += encodingLen;
        if (desc != null) {
            desc.row = curRow;
            desc.col = curCol;
            desc.defn = defn;
        }
        this.prevCol = curCol;
        this.prevRow = curRow;
        if (colors15 != null) {
            this.prevColors15 = colors15;
            this.prevColors32 = colors32;
        }
        if (debug) {
            StringBuffer dump = new StringBuffer(encodingLen * 3 + 1);
            for (int jj = defnOff; jj < defnIdx; ++jj) {
                if ((defnBuf[jj] & 0xFF) < 16) {
                    dump.append(" 0" + Integer.toHexString(defnBuf[jj] & 0xF));
                    continue;
                }
                dump.append(" " + Integer.toHexString(defnBuf[jj] & 0xFF));
            }
            LogSupport.message((Object)this, (String)"decodeTileDefn", (String)("Decoded " + (defnIdx - defnOff) + " bytes @ " + curCol + "," + curRow + ": " + dump));
            if (pixmap != null) {
                LogSupport.message((Object)this, (String)"decodeTileDefn", (String)"Decoded pixmap:");
                for (int ii = 0; ii < 16; ++ii) {
                    dump.setLength(0);
                    if (ii == 0) {
                        dump.append("0");
                    }
                    dump.append(Integer.toHexString(ii * 16) + ":");
                    for (int jj = 0; jj < 16; ++jj) {
                        dump.append(" ");
                        int color32 = pixmap[ii * 16 + jj];
                        short color15 = (short)(color32 >> 19 & 0x1F | color32 >> 11 & 0x1F | color32 & 0x1F);
                        for (int kk = 3; kk >= 0; --kk) {
                            int nibble = color15 >> kk * 4 & 0xF;
                            dump.append(Integer.toHexString(nibble));
                        }
                    }
                    LogSupport.message((String)("  " + dump.toString()));
                }
            }
        }
        this.nDataBytes += defnIdx - defnOff;
        int typeIdx = type;
        if (isDup) {
            typeIdx = 16;
        }
        if (typeIdx >= 0 && typeIdx < this.typeCount.length) {
            int n = typeIdx;
            this.typeCount[n] = this.typeCount[n] + 1;
            int n2 = typeIdx;
            this.typeBytes[n2] = this.typeBytes[n2] + (long)(defnIdx - defnOff);
        }
        if (colors15 == null) {
            this.clutLength[0] = this.clutLength[0] + 1;
        } else if (colors15.length < this.clutLength.length) {
            int n = colors15.length;
            this.clutLength[n] = this.clutLength[n] + 1;
        }
        return defnIdx - defnOff;
    }

    protected static final int decode1Color(byte[] defnBuf, int defnOff, int defnLim, int[] colors, int[] pixels) {
        if (colors == null || colors.length < 1) {
            throw new IllegalArgumentException("Color table invalid @ " + defnOff);
        }
        if (pixels != null) {
            for (int pixelIdx = 0; pixelIdx < 256; ++pixelIdx) {
                pixels[pixelIdx] = colors[0];
            }
        }
        return 0;
    }

    protected static final int decodeBlockLists(byte[] defnBuf, int defnOff, int defnLim, int[] colors, int[] pixels) {
        if (colors == null || colors.length < 2) {
            throw new IllegalArgumentException("Color table invalid @ " + defnOff);
        }
        if (pixels != null) {
            int background = colors[0];
            for (int pixelIdx = 0; pixelIdx < 256; ++pixelIdx) {
                pixels[pixelIdx] = background;
            }
        }
        int defnIdx = defnOff;
        for (int colorIdx = 1; colorIdx < colors.length; ++colorIdx) {
            int pointCnt;
            int foreground = colors[colorIdx];
            if (defnIdx >= defnLim) {
                throw new RuntimeException("BlockList encoding incomplete -- no block count for colour " + colorIdx + " @ " + defnIdx);
            }
            int blockCnt = defnBuf[defnIdx] & 0xFF;
            if ((blockCnt & 0x80) != 0) {
                blockCnt = 0;
            } else {
                ++defnIdx;
            }
            if (defnIdx + 2 * blockCnt > defnLim) {
                throw new RuntimeException("BlockList encoding incomplete -- missing blocks of colour " + colorIdx + " @ " + defnIdx);
            }
            if (pixels == null) {
                defnIdx += 2 * blockCnt;
            } else {
                for (int blockIdx = 0; blockIdx < blockCnt; ++blockIdx) {
                    int col1 = defnBuf[defnIdx] & 0xF;
                    int row1 = defnBuf[defnIdx] >> 4 & 0xF;
                    int col2 = defnBuf[++defnIdx] & 0xF;
                    int row2 = defnBuf[defnIdx] >> 4 & 0xF;
                    ++defnIdx;
                    for (int row = row1; row <= row2; ++row) {
                        for (int col = col1; col <= col2; ++col) {
                            pixels[16 * row + col] = foreground;
                        }
                    }
                }
            }
            if (colorIdx == colors.length - 1 && defnIdx >= defnLim) {
                pointCnt = 0;
            } else {
                if (defnIdx >= defnLim) {
                    throw new RuntimeException("BlockList encoding incomplete -- missing point count for colour " + colorIdx + " @ " + defnIdx);
                }
                pointCnt = defnBuf[defnIdx] & 0xFF;
                if ((pointCnt & 0x80) != 0) {
                    pointCnt &= 0x7F;
                    ++defnIdx;
                } else {
                    pointCnt = 0;
                }
            }
            if (defnIdx + pointCnt > defnLim) {
                throw new RuntimeException("BlockList encoding incomplete -- missing point for colour " + colorIdx + " @ " + defnIdx);
            }
            if (pixels == null) {
                defnIdx += pointCnt;
                continue;
            }
            for (int pointIdx = 0; pointIdx < pointCnt; ++pointIdx) {
                pixels[defnBuf[defnIdx++] & 0xFF] = foreground;
            }
        }
        return defnIdx - defnOff;
    }

    protected static final int decodeMapping(int maxColorCnt, int mapCnt, byte[] defnBuf, int defnOff, int defnLim, int[] colors, int[] pixels) {
        if (colors == null || colors.length < 2) {
            throw new IllegalArgumentException("Color table invalid @ " + defnOff);
        }
        int map1ElemsPerByte = colors.length <= 2 ? 8 : (colors.length <= 4 ? 4 : (colors.length <= 16 ? 2 : 1));
        int map1Size = 256 / map1ElemsPerByte;
        int map2Size = 0;
        if (mapCnt > 1) {
            map2Size = (map1Size + 7) / 8;
        }
        int map3Size = 0;
        if (mapCnt > 2) {
            map3Size = (map2Size + 7) / 8;
        }
        int defnIdx = defnOff;
        byte[] map2 = null;
        int map2Off = 0;
        if (map3Size == 0) {
            map2 = defnBuf;
            map2Off = defnIdx;
            if ((defnIdx += map2Size) > defnLim) {
                throw new RuntimeException("Map Encoding incomplete -- secondary map truncated @ " + defnIdx);
            }
        } else {
            map2 = new byte[map2Size];
            byte[] map3 = defnBuf;
            int map3Off = defnIdx;
            if ((defnIdx += map3Size) > defnLim) {
                throw new RuntimeException("Map Encoding incomplete -- tertiary map truncated @ " + defnIdx);
            }
            for (int map2Idx = 0; map2Idx < map2Size; ++map2Idx) {
                if ((map3[map2Idx / 8 + map3Off] >> map2Idx % 8 & 1) == 0) {
                    map2[map2Idx] = 0;
                    continue;
                }
                if (defnIdx >= defnLim) {
                    throw new RuntimeException("Map Encoding incomplete -- secondary map truncated @ " + defnIdx);
                }
                map2[map2Idx] = defnBuf[defnIdx++];
            }
        }
        byte[] map1 = null;
        int map1Off = 0;
        if (map2Size == 0) {
            map1 = defnBuf;
            map1Off = defnIdx;
            if ((defnIdx += map1Size) > defnLim) {
                throw new RuntimeException("Map Encoding incomplete -- primary map truncated @ " + defnIdx);
            }
        } else {
            map1 = new byte[map1Size];
            for (int map1Idx = 0; map1Idx < map1Size; ++map1Idx) {
                if ((map2[map1Idx / 8 + map2Off] >> map1Idx % 8 & 1) == 0) {
                    map1[map1Idx] = 0;
                    continue;
                }
                if (defnIdx >= defnLim) {
                    throw new RuntimeException("Map Encoding incomplete -- primary map truncated @ " + defnIdx);
                }
                map1[map1Idx] = defnBuf[defnIdx++];
            }
        }
        if (pixels != null) {
            int map1BitsPerElem = 8 / map1ElemsPerByte;
            int map1ElemMask = (1 << map1BitsPerElem) - 1;
            for (int pixelIdx = 0; pixelIdx < 256; ++pixelIdx) {
                int map1Idx = pixelIdx / map1ElemsPerByte;
                int map1ElemShift = pixelIdx % map1ElemsPerByte * map1BitsPerElem;
                int colorIdx = map1[map1Idx + map1Off] >> map1ElemShift & map1ElemMask;
                if (colorIdx >= 0 && colorIdx < colors.length) {
                    pixels[pixelIdx] = colors[colorIdx];
                    continue;
                }
                pixels[pixelIdx] = 0;
                LogSupport.message(AppShareTileDecoder.class, (String)"decodeMapping", (String)("Invalid colour: " + colorIdx + " / " + colors.length));
            }
        }
        return defnIdx - defnOff;
    }

    protected static final int decodePixelEncoding(byte[] encodingBuf, int encodingOff, int encodingLim, byte type, int[] colors, int[] pixels) {
        switch (type) {
            case 0: {
                return AppShareTileDecoder.decode1Color(encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 1: {
                return AppShareTileDecoder.decodeMapping(2, 1, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 2: {
                return AppShareTileDecoder.decodeMapping(2, 2, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 3: {
                return AppShareTileDecoder.decodeMapping(2, 3, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 4: {
                return AppShareTileDecoder.decodeMapping(4, 1, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 5: {
                return AppShareTileDecoder.decodeMapping(4, 2, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 6: {
                return AppShareTileDecoder.decodeMapping(4, 3, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 7: {
                return AppShareTileDecoder.decodeMapping(16, 1, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 8: {
                return AppShareTileDecoder.decodeMapping(16, 2, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 9: {
                return AppShareTileDecoder.decodeMapping(16, 3, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 10: {
                return AppShareTileDecoder.decodeMapping(256, 1, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 11: {
                return AppShareTileDecoder.decodeMapping(256, 2, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 12: {
                return AppShareTileDecoder.decodeMapping(256, 3, encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 13: {
                return AppShareTileDecoder.decodeBlockLists(encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 14: {
                return AppShareTileDecoder.decodePointLists(encodingBuf, encodingOff, encodingLim, colors, pixels);
            }
            case 15: {
                return AppShareTileDecoder.decodeRawPixels(encodingBuf, encodingOff, encodingLim, pixels);
            }
        }
        throw new IllegalArgumentException("Invalid encoding type @ " + encodingOff + ": " + Integer.toHexString(type));
    }

    protected static final int decodePointLists(byte[] defnBuf, int defnOff, int defnLim, int[] colors, int[] pixels) {
        if (colors == null || colors.length < 2) {
            throw new IllegalArgumentException("Color table invalid @ " + defnOff);
        }
        if (pixels != null) {
            int background = colors[0];
            for (int pixelIdx = 0; pixelIdx < 256; ++pixelIdx) {
                pixels[pixelIdx] = background;
            }
        }
        int defnIdx = defnOff;
        for (int colorIdx = 1; colorIdx < colors.length; ++colorIdx) {
            int pointCnt;
            if (defnIdx >= defnLim) {
                throw new RuntimeException("PointList Encoding incomplete -- missing point count for colour " + colorIdx + " @ " + defnIdx);
            }
            if (defnIdx + (pointCnt = defnBuf[defnIdx++] & 0xFF) > defnLim) {
                throw new RuntimeException("PointList Encoding incomplete -- missing points for colour " + colorIdx + " @ " + defnIdx);
            }
            if (pixels == null) {
                defnIdx += pointCnt;
                continue;
            }
            int foreground = colors[colorIdx];
            for (int pointIdx = 0; pointIdx < pointCnt; ++pointIdx) {
                pixels[defnBuf[defnIdx++] & 0xFF] = foreground;
            }
        }
        return defnIdx - defnOff;
    }

    protected static final int decodeRawPixels(byte[] defnBuf, int defnOff, int defnLim, int[] pixels) {
        if (defnOff + 512 > defnLim) {
            throw new RuntimeException("Raw Encoding incomplete  @ " + defnOff);
        }
        int defnIdx = defnOff;
        if (pixels == null) {
            defnIdx += 512;
        } else {
            for (int pixelIdx = 0; pixelIdx < 256; ++pixelIdx) {
                pixels[pixelIdx] = AppShareTileDecoder.expandColor((short)(defnBuf[defnIdx] << 8 | defnBuf[defnIdx + 1] & 0xFF));
                defnIdx += 2;
            }
        }
        return defnIdx - defnOff;
    }

    public static final int expandColor(short rgb15) {
        int red5 = rgb15 >> 10 & 0x1F;
        int green5 = rgb15 >> 5 & 0x1F;
        int blue5 = rgb15 & 0x1F;
        int argb = 0xFF000000 | red5 << 19 | green5 << 11 | blue5 << 3;
        argb |= (argb & 0xE0E0E0) >> 5;
        return argb;
    }
}

