/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareMessage;
import com.elluminate.groupware.appshare.AppShareMessageHandler;
import com.elluminate.groupware.appshare.AppShareProtocol;
import com.elluminate.groupware.appshare.AppShareTile;
import com.elluminate.groupware.appshare.AppShareTileDecoder;
import com.elluminate.groupware.appshare.ProtocolWindow;
import com.elluminate.groupware.appshare.StringsProperties;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;

public final class AppShareResponder
extends DefaultProtocolResponder
implements ChannelDataListener,
AppShareMessageHandler {
    private ProtocolWindow recvWindow = new ProtocolWindow();
    private boolean online = false;
    private boolean flushing = false;
    private AppShareTileDecoder decoder = null;
    private AppShareTile decoderTile = null;
    private I18n i18n = I18n.create((Object)this);
    private I18nMessage modIcon = null;
    private I18nMessage startIdxType = null;
    private I18nMessage stopIdxType = null;
    private I18nMessage currentDetail = null;

    public AppShareResponder() {
        super((JinxProtocol)new AppShareProtocol());
        this.setChannelDataListener(this);
    }

    public void onChannelData(ChannelDataEvent e) {
        AppShareMessage msg = AppShareMessage.construct(e, this);
        this.recvWindow.receive(msg);
        msg.dispatch();
    }

    @Override
    public void handleStart(AppShareMessage.Start msg) {
        if (msg.getSender() != 0) {
            return;
        }
        this.recvWindow.reset(msg.getWindowSize());
        AppShareMessage.StartAck reply = new AppShareMessage.StartAck(msg.getCacheSize(), msg.getWindowSize());
        reply.send(msg.getSender(), this);
        this.online = true;
        this.flushing = false;
        this.decoder = new AppShareTileDecoder(-1, msg.getCacheSize(), msg.getBaseColour());
        this.decoderTile = new AppShareTile(0, 0, new int[256]);
        if (this.modIcon == null) {
            this.modIcon = this.i18n.getMessage((PropertiesEnum)StringsProperties.APPSHARERESPONDER_INDEXICON);
        }
        if (this.startIdxType == null) {
            this.startIdxType = this.i18n.getMessage((PropertiesEnum)StringsProperties.APPSHARERESPONDER_INDEXSTARTTYPE);
        }
        this.currentDetail = msg.getDetail();
        VCRFile.IndexEntry indexEntry = new VCRFile.IndexEntry(this.modIcon, this.startIdxType, this.currentDetail);
        this.fireNotableEventListeners("recording.index", indexEntry);
    }

    @Override
    public void handleStartAck(AppShareMessage.StartAck msg) {
        AppShareMessage.Stop stop = new AppShareMessage.Stop();
        stop.send((short)0, this);
    }

    @Override
    public void handleStop(AppShareMessage.Stop msg) {
        this.online = false;
        this.flushing = false;
        this.decoderTile = null;
        if (this.decoder != null) {
            this.decoder.purgeHistory();
            this.decoder = null;
        }
        if (this.modIcon == null) {
            this.modIcon = this.i18n.getMessage((PropertiesEnum)StringsProperties.APPSHARERESPONDER_INDEXICON);
        }
        if (this.stopIdxType == null) {
            this.stopIdxType = this.i18n.getMessage((PropertiesEnum)StringsProperties.APPSHARERESPONDER_INDEXSTOPTYPE);
        }
        VCRFile.IndexEntry indexEntry = new VCRFile.IndexEntry(this.modIcon, this.stopIdxType, this.currentDetail);
        this.currentDetail = null;
        this.fireNotableEventListeners("recording.index", indexEntry);
    }

    @Override
    public void handleFlush(AppShareMessage.Flush msg) {
        AppShareMessage.FlushAck reply = new AppShareMessage.FlushAck();
        reply.send(msg.getSender(), this);
    }

    @Override
    public void handleFlushAck(AppShareMessage.FlushAck msg) {
        if (!this.flushing) {
            return;
        }
        if (this.decoder != null) {
            this.decoder.purgeHistory();
        }
        this.flushing = false;
    }

    @Override
    public void handleScreenData(AppShareMessage.ScreenData msg) {
        if (!this.online || this.flushing) {
            return;
        }
        byte[] data = msg.getTileData();
        if (data == null) {
            return;
        }
        if (this.decoder == null) {
            return;
        }
        if (this.decoderTile == null) {
            return;
        }
        try {
            int nBytes;
            int start = 0;
            while ((nBytes = this.decoder.decodeTileDefn(data, start, data.length, null, this.decoderTile)) > 0) {
                start += nBytes;
            }
        }
        catch (Throwable t) {
            LogSupport.error((Object)this, (String)"handleScreenData", (String)("Exception processing message " + msg + "\n" + Debug.getStackTrace((Throwable)t) + "\nResetting decoder and resynchronizing."));
            AppShareMessage.Flush whine = new AppShareMessage.Flush();
            whine.send((short)0, this);
            this.flushing = true;
        }
    }

    @Override
    public void handleControl(AppShareMessage.Control msg) {
        if (msg.getUser() == this.connection.getAddress()) {
            AppShareMessage.Release reply = new AppShareMessage.Release();
            reply.send(msg.getSender(), this);
            if (msg.getSender() != 0) {
                reply.send((short)0, this);
            }
        }
    }

    @Override
    public void handleWindowChange(AppShareMessage.WindowChange msg) {
        if (msg.getSender() != 0) {
            return;
        }
        int newSize = msg.getWindowSize();
        this.recvWindow.sync(msg.getSender(), this, newSize);
        AppShareMessage.ChangeAck reply = new AppShareMessage.ChangeAck(msg.getCommand(), newSize);
        reply.send(msg.getSender(), this);
    }

    @Override
    public void handleCacheChange(AppShareMessage.CacheChange msg) {
        AppShareMessage.CacheChange reply = new AppShareMessage.CacheChange(msg.getCacheSize());
        reply.send((short)0, this);
    }

    @Override
    public void sendMessage(ChannelDataEvent msg, byte urgency, AppShareMessage appShareMessage, short to) {
        String cName = "AppSharing";
        Channel chnl = this.getChannel(cName);
        if (chnl == null) {
            throw new IllegalArgumentException("Channel not found: " + cName);
        }
        chnl.onChannelData(msg, urgency);
    }

    @Override
    public void handleFront(AppShareMessage.Front msg) {
    }

    @Override
    public void handleRefresh(AppShareMessage.Refresh msg) {
    }

    @Override
    public void handleAOIMove(AppShareMessage.AOIMove msg) {
    }

    @Override
    public void handleAOIRemove(AppShareMessage.AOIRemove msg) {
    }

    @Override
    public void handleAOIAdd(AppShareMessage.AOIAdd msg) {
    }

    @Override
    public void handleScreenDataAck(AppShareMessage.ScreenDataAck msg) {
    }

    @Override
    public void handleCursor(AppShareMessage.Cursor msg) {
    }

    @Override
    public void handleRelease(AppShareMessage.Release msg) {
    }

    @Override
    public void handleRevoke(AppShareMessage.Revoke msg) {
    }

    @Override
    public void handleMouseMove(AppShareMessage.MouseMove msg) {
    }

    @Override
    public void handleMouseDown(AppShareMessage.Mouse msg) {
    }

    @Override
    public void handleMouseUp(AppShareMessage.Mouse msg) {
    }

    @Override
    public void handleMouseDrag(AppShareMessage.Mouse msg) {
    }

    @Override
    public void handleMouseClick(AppShareMessage.Mouse msg) {
    }

    @Override
    public void handleKey(AppShareMessage.Key msg) {
    }

    @Override
    public void handleSubscribe(AppShareMessage.Subscribe msg) {
    }

    @Override
    public void handleStatus(AppShareMessage.Status msg) {
    }

    @Override
    public void handleChangeAck(AppShareMessage.ChangeAck msg) {
    }

    @Override
    public void handleRemoteStart(AppShareMessage.RemoteStart msg) {
    }

    @Override
    public void handleRemoteReply(AppShareMessage.RemoteReply msg) {
    }

    @Override
    public void handleScrollWheel(AppShareMessage.ScrollWheel msg) {
    }

    @Override
    public void handleResolutionChange(AppShareMessage.ResolutionChange msg) {
    }
}

