/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareTileDefn;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;

public final class AppShareHistoryCache {
    private static final double HASH_LOAD_FACTOR = 0.75;
    private int maxSize = 0;
    private int curSize = 0;
    private int head = 0;
    private int tileCount = 0;
    private int hitCount = 0;
    private int bytesCached = 0;
    private int userID = 0;
    private CacheEntry[] forward = null;
    private CacheEntry[] reverse = null;
    private Object lock = new Object();

    public AppShareHistoryCache(int uid, int cacheSize) {
        this.userID = uid;
        this.maxSize = cacheSize;
        this.bytesCached = 0;
        this.head = 0;
        this.forward = new CacheEntry[cacheSize];
        for (int ix = 0; ix < this.forward.length; ++ix) {
            this.forward[ix] = null;
        }
        int hashSize = AppShareHistoryCache.getHashSize(this.maxSize);
        this.reverse = new CacheEntry[hashSize];
        for (int ix = 0; ix < this.reverse.length; ++ix) {
            this.reverse[ix] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCapacity(int cap) {
        if (cap < 1 || cap > 65536) {
            throw new IllegalArgumentException("Invalid cache size: " + cap);
        }
        if (cap == this.maxSize) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"setCapacity", (String)"AppShare History Cache lock", (Object)this.lock);
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean isFull;
                boolean wasFull = this.curSize == this.maxSize;
                boolean bl = isFull = this.curSize >= cap;
                if (cap > this.forward.length) {
                    this.reallocCache(cap);
                }
                if (cap < this.maxSize) {
                    for (int ix = 0; ix <= this.head - cap; ++ix) {
                        if (this.forward[ix] == null) continue;
                        this.forgetItem(ix);
                        this.forward[ix].wipe();
                        this.forward[ix] = null;
                    }
                    int term = this.forward.length - (cap - this.head - 1);
                    if (term > this.forward.length) {
                        term = this.forward.length;
                    }
                    for (int ix = this.head + 1; ix < term; ++ix) {
                        if (this.forward[ix] == null) continue;
                        this.forgetItem(ix);
                        this.forward[ix].wipe();
                        this.forward[ix] = null;
                    }
                }
                this.maxSize = cap;
                if (isFull != wasFull && AppShareDebug.CACHE_FILL.show()) {
                    if (isFull) {
                        LogSupport.message((Object)this, (String)"setCapacity", (String)("Cache for " + this.userID + " is now full (" + this.maxSize + ")"));
                    } else {
                        LogSupport.message((Object)this, (String)"setCapacity", (String)("Cache for " + this.userID + " is no longer full (" + this.curSize + " of " + this.maxSize + ")"));
                    }
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"setCapacity", (String)"AppShare History Cache lock", (Object)this.lock);
        }
    }

    private static int getHashSize(int size) {
        int hashSize = (int)((double)size / 0.75 + 1.0);
        return hashSize |= 1;
    }

    private final void reallocCache(int cap) {
        int ix;
        if (cap <= this.maxSize) {
            return;
        }
        CacheEntry[] oldFwd = this.forward;
        CacheEntry[] oldRev = this.reverse;
        CacheEntry[] newFwd = new CacheEntry[cap];
        CacheEntry[] newRev = new CacheEntry[AppShareHistoryCache.getHashSize(cap)];
        for (ix = 0; ix < newRev.length; ++ix) {
            newRev[ix] = null;
        }
        block1: for (ix = 0; ix < newFwd.length; ++ix) {
            if (oldFwd == null || ix >= oldFwd.length || oldFwd[ix] == null || oldFwd[ix].item == null) {
                newFwd[ix] = null;
                continue;
            }
            CacheEntry ent = new CacheEntry();
            ent.item = oldFwd[ix].item;
            ent.ID = ix;
            ent.collide = null;
            int hc = ent.item.hashCode() % newRev.length;
            if (hc < 0) {
                hc += newRev.length;
            }
            ent.hash = hc;
            newFwd[ix] = ent;
            if (newRev[hc] == null) {
                newRev[hc] = newFwd[ix];
                continue;
            }
            CacheEntry cur = newRev[hc];
            while (cur != null && cur.item != ent.item) {
                if (cur.collide == null) {
                    cur.collide = ent;
                    continue block1;
                }
                cur = cur.collide;
            }
        }
        this.forward = newFwd;
        this.reverse = newRev;
        this.maxSize = this.forward.length;
        if (this.curSize < this.maxSize) {
            this.head = this.curSize;
        } else {
            this.head = 0;
            this.curSize = this.maxSize;
        }
        for (ix = 0; ix < oldFwd.length; ++ix) {
            if (oldFwd[ix] == null) continue;
            oldFwd[ix].wipe();
            oldFwd[ix] = null;
        }
        for (ix = 0; ix < oldRev.length; ++ix) {
            oldRev[ix] = null;
        }
    }

    public final int size() {
        return this.curSize;
    }

    public final int capacity() {
        return this.maxSize;
    }

    public final int getTiles() {
        return this.tileCount;
    }

    public final int getHits() {
        return this.hitCount;
    }

    public final int getBytesCached() {
        return this.bytesCached;
    }

    public final int getTotalBytes() {
        int result = this.bytesCached + this.curSize * 32;
        result += this.forward.length * 8 + 4;
        return result += this.reverse.length * 8 + 4;
    }

    public String toString() {
        long totalLen;
        long cachedLen;
        double hitRate = 0.0;
        String cachedSuffix = "";
        String totalSuffix = "";
        int denom = this.tileCount + this.hitCount;
        if (denom > 0) {
            hitRate = (double)((this.hitCount * 1000 + denom / 2) / denom) / 10.0;
        }
        if ((cachedLen = (long)(this.getBytesCached() * 100)) > 409600L) {
            cachedLen = (cachedLen + 512L) / 1024L;
            cachedSuffix = "K";
            if (cachedLen > 409600L) {
                cachedLen = (cachedLen + 512L) / 1024L;
                cachedSuffix = "M";
            }
        }
        if ((totalLen = (long)(this.getTotalBytes() * 100)) > 409600L) {
            totalLen = (totalLen + 512L) / 1024L;
            totalSuffix = "K";
            if (totalLen > 409600L) {
                totalLen = (totalLen + 512L) / 1024L;
                totalSuffix = "M";
            }
        }
        return "HistoryCache: Size=" + this.curSize + "/" + this.maxSize + " (" + this.forward.length + ") Tiles=" + this.tileCount + " CachedBytes=" + (double)cachedLen / 100.0 + cachedSuffix + " TotalBytes=" + (double)totalLen / 100.0 + totalSuffix + " Hits=" + this.hitCount + " Rate=" + hitRate + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(AppShareTileDefn obj) {
        if (obj == null) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"insert", (String)"AppShare History Cache lock", (Object)this.lock);
        try {
            Object object = this.lock;
            synchronized (object) {
                boolean isFull;
                boolean wasFull;
                CacheEntry discard = null;
                boolean bl = wasFull = this.curSize == this.maxSize;
                if (this.maxSize < this.forward.length) {
                    int pos = (this.head - this.maxSize + 1 + this.forward.length) % this.forward.length;
                    discard = this.forward[pos];
                    if (this.forward[pos] != null) {
                        this.forgetItem(pos);
                        this.forward[pos].wipe();
                        this.forward[pos] = null;
                    }
                }
                if (this.forward[this.head] == null) {
                    this.forward[this.head] = discard == null ? new CacheEntry() : discard;
                } else {
                    this.forgetItem(this.head);
                }
                this.forward[this.head].item = obj;
                this.forward[this.head].ID = this.head;
                this.forward[this.head].hash = obj.hashCode() % this.reverse.length;
                if (this.forward[this.head].hash < 0) {
                    this.forward[this.head].hash += this.reverse.length;
                }
                this.insertRev(this.forward[this.head]);
                ++this.curSize;
                ++this.tileCount;
                this.bytesCached += obj.getCachedLength();
                this.head = (this.head + 1) % this.forward.length;
                boolean bl2 = isFull = this.curSize == this.maxSize;
                if (AppShareDebug.CACHE_FILL.show()) {
                    if (!wasFull && isFull) {
                        LogSupport.message((Object)this, (String)"insert", (String)("Cache for " + this.userID + " is now full (" + this.maxSize + ")"));
                    }
                    if (this.head == 0) {
                        LogSupport.message((Object)this, (String)"insert", (String)("Cache for " + this.userID + " has rolled over."));
                    }
                }
                if (this.tileCount % 500 == 0 && AppShareDebug.CACHE.show()) {
                    LogSupport.message((String)this.toString());
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"insert", (String)"AppShare History Cache lock", (Object)this.lock);
        }
    }

    private final void forgetItem(int pos) {
        if (this.forward[pos].item != null) {
            this.bytesCached -= this.forward[pos].item.getCachedLength();
            this.removeRev(this.forward[pos]);
            --this.curSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AppShareTileDefn lookupDuplicate(int origID) {
        CacheEntry ent;
        block7: {
            AppShareTileDefn appShareTileDefn;
            if (origID < 0) return null;
            if (origID >= this.forward.length) {
                return null;
            }
            Debug.lockEnter((Object)this, (String)"lookupDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
            try {
                Object object = this.lock;
                // MONITORENTER : object
                ent = this.forward[origID];
                if (ent != null && ent.item != null) break block7;
                appShareTileDefn = null;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Debug.lockLeave((Object)this, (String)"lookupDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
                throw throwable;
            }
            Debug.lockLeave((Object)this, (String)"lookupDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
            return appShareTileDefn;
        }
        ++this.hitCount;
        AppShareTileDefn appShareTileDefn = ent.item;
        // MONITOREXIT : object
        Debug.lockLeave((Object)this, (String)"lookupDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
        return appShareTileDefn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int lookupDuplicate(AppShareTileDefn obj) {
        CacheEntry ent;
        block6: {
            int n;
            Debug.lockEnter((Object)this, (String)"lookupDuplicate-rev", (String)"AppShare History Cache lock", (Object)this.lock);
            try {
                Object object = this.lock;
                // MONITORENTER : object
                ent = this.findRev(obj);
                if (ent != null && ent.item != null) break block6;
                n = -1;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Debug.lockLeave((Object)this, (String)"lookupDuplicate-rev", (String)"AppShare History Cache lock", (Object)this.lock);
                throw throwable;
            }
            Debug.lockLeave((Object)this, (String)"lookupDuplicate-rev", (String)"AppShare History Cache lock", (Object)this.lock);
            return n;
        }
        ++this.hitCount;
        int n = ent.ID;
        // MONITOREXIT : object
        Debug.lockLeave((Object)this, (String)"lookupDuplicate-rev", (String)"AppShare History Cache lock", (Object)this.lock);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean isDuplicate(AppShareTileDefn obj) {
        CacheEntry ent;
        block6: {
            boolean bl;
            Debug.lockEnter((Object)this, (String)"isDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
            try {
                Object object = this.lock;
                // MONITORENTER : object
                ent = this.findRev(obj);
                if (ent != null && ent.item != null) break block6;
                bl = false;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Debug.lockLeave((Object)this, (String)"isDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
                throw throwable;
            }
            Debug.lockLeave((Object)this, (String)"isDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
            return bl;
        }
        boolean bl = ent.ID >= 0;
        // MONITOREXIT : object
        Debug.lockLeave((Object)this, (String)"isDuplicate", (String)"AppShare History Cache lock", (Object)this.lock);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        if (AppShareDebug.CACHE.show()) {
            LogSupport.message((Object)this, (String)"purge", (String)this.toString());
        }
        Debug.lockEnter((Object)this, (String)"purge", (String)"AppShare History Cache lock", (Object)this.lock);
        try {
            Object object = this.lock;
            synchronized (object) {
                int ix;
                this.head = 0;
                this.curSize = 0;
                this.bytesCached = 0;
                if (this.forward != null) {
                    for (ix = 0; ix < this.forward.length; ++ix) {
                        if (this.forward[ix] != null) {
                            this.forward[ix].wipe();
                        }
                        this.forward[ix] = null;
                    }
                }
                if (this.reverse != null) {
                    for (ix = 0; ix < this.reverse.length; ++ix) {
                        this.reverse[ix] = null;
                    }
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"purge", (String)"AppShare History Cache lock", (Object)this.lock);
        }
    }

    private final void insertRev(CacheEntry ent) {
        if (this.reverse == null) {
            return;
        }
        if (ent == null || ent.item == null) {
            return;
        }
        ent.collide = null;
        if (this.reverse[ent.hash] == null) {
            this.reverse[ent.hash] = ent;
            return;
        }
        CacheEntry cur = this.reverse[ent.hash];
        while (cur != null && cur.item != ent.item) {
            if (cur.collide == null) {
                cur.collide = ent;
                break;
            }
            cur = cur.collide;
        }
    }

    private final void removeRev(CacheEntry ent) {
        if (ent == null) {
            return;
        }
        if (this.reverse == null) {
            return;
        }
        if (this.reverse[ent.hash] == null) {
            return;
        }
        if (this.reverse[ent.hash].item == ent.item) {
            this.reverse[ent.hash] = this.reverse[ent.hash].collide;
            return;
        }
        CacheEntry cur = this.reverse[ent.hash];
        while (cur.collide != null) {
            CacheEntry next = cur.collide;
            if (next.item == ent.item) {
                cur.collide = next.collide;
                next.collide = null;
                break;
            }
            cur = cur.collide;
        }
    }

    private final CacheEntry findRev(AppShareTileDefn obj) {
        if (obj == null) {
            return null;
        }
        if (this.reverse == null) {
            return null;
        }
        int hash = obj.hashCode() % this.reverse.length;
        if (hash < 0) {
            hash += this.reverse.length;
        }
        CacheEntry cur = this.reverse[hash];
        while (cur != null && cur.item != obj) {
            cur = cur.collide;
        }
        return cur;
    }

    private static final class CacheEntry {
        public static final int OVERHEAD = 32;
        public int ID = -1;
        public int hash = 0;
        public CacheEntry collide = null;
        public AppShareTileDefn item = null;

        private CacheEntry() {
        }

        public final void wipe() {
            this.collide = null;
            this.item = null;
            this.ID = -1;
            this.hash = 0;
        }

        public final int getCachedLength() {
            return this.item == null ? 0 : this.item.getCachedLength();
        }

        public final String toString() {
            return "ID=" + this.ID + " " + (this.item == null ? "" : this.item.toString());
        }
    }
}

