/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.chair.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class ChairPublisher {
    public static final String MODERATOR_GRANTED = "moderator-granted";
    public static final String MODERATOR_REVOKED = "moderator-revoked";
    private final String UNIQUE_NAME = "ChairPublisher";
    private final String DISPLAY_NAME;
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();
    private String moduleName;
    private String moduleDisplayName;
    private Icon icon;

    @Inject
    public ChairPublisher(MessagePublisher pub, MessagePublisherMetadata meta, I18n localization, MessageRouter msgRouter, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.i18n = localization;
        this.metadata = meta;
        this.router = msgRouter;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.moduleName = mod.getNameOfModule();
        this.moduleDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void initMessageTypes() {
        this.msgTypes.put(MODERATOR_GRANTED, new MessageType(MODERATOR_GRANTED, this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRTYPE_PERMISSIONGRANTED), 11));
        this.msgTypes.put(MODERATOR_REVOKED, new MessageType(MODERATOR_REVOKED, this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRPUBLISHER_TYPE_PERMISSION_REVOKED), 11));
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("ChairPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.moduleName);
        this.metadata.setModuleDisplayName(this.moduleDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    public void sendModeratorGrantedMessage(String moderatorName) {
        this.publisher.sendTextMessage(this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_NOTIFYMSG, new Object[]{moderatorName}), this.msgTypes.get(MODERATOR_GRANTED));
    }

    public void sendModeratorRevokedMessage(String moderatorName) {
        this.publisher.sendTextMessage(this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRPUBLISHER_MODERATOR_REVOKE_MESSAGE, new Object[]{moderatorName}), this.msgTypes.get(MODERATOR_REVOKED));
    }
}

