/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair.module;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.chair.ChairDebug;
import com.elluminate.groupware.chair.module.BasicBean;
import com.elluminate.groupware.chair.module.ChairModule;
import com.elluminate.groupware.chair.module.ChairPermissionDelegate;
import com.elluminate.groupware.chair.module.ChairPublisher;
import com.elluminate.groupware.chair.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CList;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

@Singleton
public class ChairBean
extends BasicBean
implements PropertyChangeListener {
    private I18n i18n = I18n.create((Object)this);
    private ChairModule module;
    private String chairDesc = LabelProps.get(null, (String)"Label.moderator");
    private String chairDescTitle = LabelProps.get(null, (String)"Label.Moderator");
    private String participantDesc = LabelProps.get(null, (String)"Label.Participant");
    private String partPluralDesc = LabelProps.get(null, (String)"Label.participants");
    private String sessionDesc = LabelProps.get(null, (String)"Label.session");
    private ChairPublisher chairPub;
    private ChairProtocol chairProtocol;
    private CRSession session;
    private ChairPermissionDelegate chairPermissionDelegate;

    @Inject
    protected ChairBean(ChairModule module, Logger logger) {
        super(logger);
        this.module = module;
    }

    @Inject
    protected void initChairPublisher(ChairPublisher pub) {
        this.chairPub = pub;
    }

    @Inject
    protected void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initChairPermissionDelegate(ChairPermissionDelegate chairPermissionDelegate) {
        this.chairPermissionDelegate = chairPermissionDelegate;
    }

    public void registerProvider() {
        this.chairPermissionDelegate.setChairBean(this);
        this.chairPermissionDelegate.setChairProtocol(this.chairProtocol);
        this.chairPermissionDelegate.setClientProvider(this.clientProvider);
        this.chairPermissionDelegate.setSession(this.session);
        CRPermissionFactory permissionFactory = new CRPermissionFactory("ChairPermission", "ChairPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.chairPermissionDelegate);
        this.session.registerPermission(permissionFactory);
    }

    public void init() {
        super.setClient(this.clientProvider.get(), (JinxProtocol)this.chairProtocol, null, null, this);
        this.clients.addPropertyChangeListener("Label.moderator", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Moderator", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.participant", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.participants", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this.chairPermissionDelegate);
    }

    public void removeParticipant(ClientInfo who, boolean confirm) {
        Chair chair = this.chairProtocol.fetchChair((Connection)this.client);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "removeParticipant", "remove participant: who" + who + ", confirm: " + confirm);
        }
        if (chair.isMe()) {
            int reply;
            ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
            DataOutputStream str = msg.write();
            try {
                str.writeShort(who.getAddress());
                str.close();
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"removeParticipant", (Throwable)ex, (boolean)true);
                try {
                    str.close();
                }
                catch (IOException io) {
                    // empty catch block
                }
                msg.dispose();
                return;
            }
            if (confirm && (reply = ModalDialog.showConfirmDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVEQUERY, new Object[]{who.getDisplayName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVETITLE, new Object[]{this.participantDesc}), (int)0)) != 0) {
                msg.dispose();
                return;
            }
            this.fireChannelData(msg);
        }
    }

    public void removeParticipants(ClientInfo[] who, boolean confirm) {
        if (who == null) {
            return;
        }
        Chair chair = this.chairProtocol.fetchChair((Connection)this.client);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "removeParticipants", " remove participants: who[" + who.length + "], confirm: " + confirm);
        }
        if (chair.isMe()) {
            if (confirm) {
                int reply = 1;
                if (who.length == 1) {
                    reply = ModalDialog.showConfirmDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVEQUERY, new Object[]{who[0].getDisplayName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVETITLE, new Object[]{this.participantDesc}), (int)0);
                    if (reply != 0) {
                        return;
                    }
                } else {
                    ArrayList<String> names = new ArrayList<String>(who.length);
                    for (int ix = 0; ix < who.length; ++ix) {
                        names.add(who[ix].getDisplayName());
                    }
                    String msgText = this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVEMULTIPLEQUERY, new Object[]{this.partPluralDesc, this.sessionDesc});
                    MultilineLabel label = new MultilineLabel(msgText, 384);
                    CList list = new CList(names);
                    list.setSelectionModel((ListSelectionModel)new CList.NoSelectionModel());
                    JScrollPane scroller = new JScrollPane((Component)list);
                    scroller.setVerticalScrollBarPolicy(22);
                    Box scrollBox = Box.createHorizontalBox();
                    scrollBox.add(Box.createHorizontalStrut(16));
                    scrollBox.add(scroller);
                    scrollBox.add(Box.createHorizontalGlue());
                    Box content = Box.createVerticalBox();
                    content.add((Component)label);
                    content.add(Box.createVerticalStrut(16));
                    content.add(scrollBox);
                    content.add(Box.createVerticalGlue());
                    if (list.getVisibleRowCount() > names.size() + 1) {
                        list.setVisibleRowCount(names.size() + 1);
                    }
                    reply = ModalDialog.showConfirmDialog((Component)this.getAppFrame(), (Object)content, (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_REMOVETITLE, new Object[]{this.participantDesc}), (int)0);
                }
                if (reply != 0) {
                    return;
                }
            }
            for (int i = 0; i < who.length; ++i) {
                ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
                DataOutputStream str = msg.write();
                try {
                    str.writeShort(who[i].getAddress());
                    str.close();
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"removeParticipants", (Throwable)ex, (boolean)true);
                    try {
                        str.close();
                    }
                    catch (IOException io) {
                        // empty catch block
                    }
                    msg.dispose();
                    return;
                }
                this.fireChannelData(msg);
            }
        }
    }

    boolean giveChair(ClientInfo who, boolean confirm) {
        if (who == null) {
            return false;
        }
        Chair chair = this.chairProtocol.fetchChair((Connection)this.client);
        short addr = who.getAddress();
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "giveChair", "give chair: who: , confirm: " + confirm);
        }
        if (chair.isMe()) {
            int reply;
            if (confirm && (reply = ModalDialog.showConfirmDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_GIVECHAIRQUERY, new Object[]{this.chairDesc, who.getDisplayName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_GIVECHAIRTITLE, new Object[]{this.chairDescTitle}), (int)0)) != 0) {
                return false;
            }
            chair.add(addr);
            return true;
        }
        return false;
    }

    public void giveChair(ClientInfo[] who, boolean confirm) {
        if (who == null) {
            return;
        }
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "giveChair", "give chair: who[" + who.length + "], confirm: " + confirm);
        }
        if (!this.session.getMe().isChair()) {
            return;
        }
        ArrayList<CRParticipant> toGiveTo = new ArrayList<CRParticipant>(who.length);
        for (ClientInfo ci : who) {
            CRParticipant participant;
            if (ci == null || (participant = this.session.getParticipantById(ci.getAddress())) == null || participant.isChair()) continue;
            toGiveTo.add(participant);
        }
        if (toGiveTo.size() < 1) {
            return;
        }
        if (toGiveTo.size() == 1) {
            this.session.setPermissionValue("ChairPermission", ((CRParticipant)toGiveTo.get(0)).getID(), Boolean.TRUE.booleanValue());
            return;
        }
        if (confirm) {
            int reply;
            ArrayList<String> names = new ArrayList<String>(toGiveTo.size());
            for (CRParticipant p : toGiveTo) {
                names.add(p.getDisplayName());
            }
            String msgText = this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_GIVECHAIRMULTIPLEQUERY, new Object[]{this.chairDesc, this.partPluralDesc});
            MultilineLabel label = new MultilineLabel(msgText, 384);
            CList list = new CList(names);
            list.setSelectionModel((ListSelectionModel)new CList.NoSelectionModel());
            JScrollPane scroller = new JScrollPane((Component)list);
            scroller.setVerticalScrollBarPolicy(22);
            Box scrollBox = Box.createHorizontalBox();
            scrollBox.add(Box.createHorizontalStrut(16));
            scrollBox.add(scroller);
            scrollBox.add(Box.createHorizontalGlue());
            Box content = Box.createVerticalBox();
            content.add((Component)label);
            content.add(Box.createVerticalStrut(16));
            content.add(scrollBox);
            content.add(Box.createVerticalGlue());
            if (list.getVisibleRowCount() > names.size() + 1) {
                list.setVisibleRowCount(names.size() + 1);
            }
            if ((reply = ModalDialog.showConfirmDialog((Component)this.getAppFrame(), (Object)content, (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_GIVECHAIRTITLE, new Object[]{this.chairDescTitle}), (int)0)) != 0) {
                return;
            }
        }
        this.session.setPermissionValue("ChairPermission", toGiveTo, Boolean.TRUE.booleanValue());
    }

    boolean takeChair(ClientInfo who) {
        if (who == null) {
            return false;
        }
        boolean isChairOfRecord = who.getProperty("chair.ofRecord", false);
        Chair chair = this.chairProtocol.fetchChair((Connection)this.client);
        short addr = who.getAddress();
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "takeChair", "take chair: who: " + who);
        }
        if (chair.isMe() && !isChairOfRecord) {
            chair.remove(addr);
            return true;
        }
        return false;
    }

    public void takeChair(ClientInfo[] who) {
        if (who == null) {
            return;
        }
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "takeChair", "take chair: who[" + who.length + "]");
        }
        if (!this.session.getMe().isChair()) {
            return;
        }
        ArrayList<CRParticipant> toTakeFrom = new ArrayList<CRParticipant>(who.length);
        for (ClientInfo ci : who) {
            CRParticipant participant;
            if (ci == null || (participant = this.session.getParticipantById(ci.getAddress())) == null || !participant.isChair()) continue;
            toTakeFrom.add(participant);
        }
        this.session.setPermissionValue("ChairPermission", toTakeFrom, Boolean.FALSE.booleanValue());
        List permissionNames = this.session.getPermissionNames(CRPermissionScope.PARTICIPANT);
        for (ClientInfo ci : who) {
            CRParticipant participant = this.session.getParticipantById(ci.getAddress());
            if (participant == null) continue;
            for (String permissionName : permissionNames) {
                CRPermission permission = this.session.getPermission(permissionName, ci.getAddress());
                if (permission == null) continue;
                permission.setValue(permission.getDefault());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String nm = event.getPropertyName();
        if (nm.equals("chair")) {
            if (event.getNewValue() == null) {
                return;
            }
            Chair chair = this.chairProtocol.fetchChair((Connection)this.client);
            Chair oldChair = new Chair((Connection)this.client, event.getOldValue());
            if (ChairDebug.TRACE.show()) {
                this.logger.message((Object)this, "propertyChange", "property change: , chair: " + chair + ", oldChair: " + oldChair);
            }
            if (chair.isMe() && !oldChair.isMe()) {
                this.module.postModeratorGranted(this.i18n.getString((PropertiesEnum)StringsProperties.CHAIRBEAN_NOTIFYMSG, new Object[]{this.chairDesc}));
                this.chairPub.sendModeratorGrantedMessage(this.chairDescTitle);
            } else if (!chair.isMe() && oldChair.isMe()) {
                this.chairPub.sendModeratorRevokedMessage(this.chairDescTitle);
            }
        } else {
            this.chairDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator");
            this.chairDescTitle = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
            this.participantDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant");
            this.partPluralDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participants");
            this.sessionDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
        }
    }
}

