/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.swingsupport;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttributeMap;
import com.elluminate.groupware.whiteboard.attributes.AttributeSetEvent;
import com.elluminate.groupware.whiteboard.attributes.AttributeSetListener;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.attributes.ToolColorList;
import com.elluminate.groupware.whiteboard.attributes.ToolFontList;
import com.elluminate.groupware.whiteboard.attributes.ToolRectangle;
import com.elluminate.groupware.whiteboard.attributes.ToolStyleRunList;
import com.elluminate.groupware.whiteboard.attributes.ToolText;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleRunSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.ScreenChangeEvent;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneUIInterface;
import com.elluminate.groupware.whiteboard.interfaces.ToolActivationListener;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.TranslatedMouseEvent;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.ScaledFontEditorKit;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.ScaledFontStyledDocument;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBLineBorder;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBUIComponent;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.proxies.ProxyFactory;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.proxies.StyleProxy;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.TextEditorToolModel;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.textparser.CursorInfo;
import com.elluminate.gui.textparser.HyperlinkMouseHandler;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class WBTextPane
extends WBUIComponent
implements AdjustmentListener,
DocumentListener,
PropertyChangeListener,
CursorInfo {
    private TextEditorToolModel editorTool;
    private JTextPane textPane;
    private JScrollPane scroller;
    private MouseListener mListener;
    private MouseMotionListener mMotionListener;
    private LinkedList attributeSetListeners = new LinkedList();
    private ScaledFontStyledDocument document = null;
    private CopyScaledFontStyledDocument documentCopy = null;
    private ScaledFontEditorKit editorKit = null;
    public static final String SCALE_FACTOR = "SCALE_FACTOR";
    BufferedImage textImage = null;
    private int curAdjValue;
    private Timer updateTimer;
    private final int TIMER_DELAY = 250;

    public WBTextPane() {
    }

    public WBTextPane(AbstractToolModel tool) {
        super(tool);
        this.editorTool = (TextEditorToolModel)tool;
        this.getUI().setLayout(new GridLayout(1, 1));
        this.textPane = new JTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor((Color)WBTextPane.this.editorTool.getFillColor().getColor());
                g2d.setComposite(AlphaComposite.getInstance(3, (float)WBTextPane.this.editorTool.getFillColor().getAlpha() / 255.0f));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
                g2d.dispose();
            }

            @Override
            public void repaint(int x, int y, int width, int height) {
                super.repaint(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.textPane.setContentType("text/rtf");
        this.editorKit = new ScaledFontEditorKit();
        AccessibilityUtils.initComponent((JComponent)this.textPane);
        MutableAttributeSet inputAttributes = this.editorKit.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        inputAttributes.addAttributes(WBTextPane.getDefaultAttributes());
        this.textPane.setEditorKit(this.editorKit);
        this.document = this.editorKit.createDefaultDocument();
        this.textPane.setDocument((Document)((Object)this.document));
        this.document.setCharacterAttributes(0, 1, WBTextPane.getDefaultAttributes(), true);
        this.documentCopy = new CopyScaledFontStyledDocument();
        this.scroller = new JScrollPane(this.textPane, 20, 31){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor((Color)WBTextPane.this.editorTool.getFillColor().getColor());
                g2d.setComposite(AlphaComposite.getInstance(3, (float)WBTextPane.this.editorTool.getFillColor().getAlpha() / 255.0f));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
                g2d.dispose();
            }

            @Override
            public void repaint(int x, int y, int width, int height) {
                super.repaint(0, 0, this.getWidth(), this.getHeight());
            }
        };
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.getUI().add((Component)this.scroller, gbc);
        this.scroller.setBorder(new WBLineBorder((AbstractToolModel)this.editorTool));
        ComponentAdapter sbl = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ev) {
                WBTextPane.this.setBorderVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent ev) {
                WBTextPane.this.setBorderVisible(false);
            }
        };
        this.scroller.getVerticalScrollBar().addComponentListener(sbl);
        this.setBorderVisible(this.isScrollbarVisible());
        this.setPosition(tool.getBounds());
        this.updateDocument();
        CaretListener carLst = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (WBTextPane.this.editorTool.isUiComponentActive()) {
                    int xStart = e.getDot() < e.getMark() ? e.getDot() : e.getMark();
                    int xEnd = e.getDot() > e.getMark() ? e.getDot() : e.getMark();
                    WBTextPane.this.editorTool.setXStart(xStart);
                    WBTextPane.this.editorTool.setXEnd(xEnd);
                    WBTextPane.this.showAttributes(xStart, xEnd);
                }
            }
        };
        this.textPane.addCaretListener(carLst);
        this.textPane.addMouseListener(this.getWbMouseAdapter());
        this.textPane.addMouseMotionListener(this.getWbMouseAdapter());
        this.mListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!WBTextPane.this.editorTool.isUiComponentActive() && !WBTextPane.this.textPane.isEnabled()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WBTextPane.this.textPane.setEnabled(true);
                            ControllerPane controller = (ControllerPane)WBTextPane.this.editorTool.getContext().getController();
                            controller.repaint();
                        }
                    });
                }
            }
        };
        this.mMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!WBTextPane.this.editorTool.isUiComponentActive() && WBTextPane.this.textPane.isEnabled()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            WBTextPane.this.textPane.setEnabled(false);
                        }
                    });
                }
            }
        };
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                Component opposite = e.getOppositeComponent();
                if (opposite == null) {
                    return;
                }
                if (opposite.equals((ControllerPaneUIInterface)WBTextPane.this.editorTool.getContext().getController())) {
                    WBTextPane.this.editorTool.setUiComponentActive(false);
                }
            }
        };
        this.textPane.addFocusListener(fl);
        this.textPane.addMouseListener(this.mListener);
        this.textPane.addMouseMotionListener(this.mMotionListener);
        this.textPane.setRequestFocusEnabled(false);
        this.textPane.setOpaque(false);
        this.scroller.setOpaque(false);
        this.scroller.getViewport().setOpaque(false);
        this.scroller.getVerticalScrollBar().setOpaque(false);
        this.textPane.setEditable(false);
        ControllerPaneUIInterface controller = (ControllerPaneUIInterface)this.editorTool.getContext().getController();
        AbstractToolEditorUI fontEditor = ((ToolPropertiesPanel)controller.getPropertiesPanel()).getQuickEditor(this.editorTool.getToolFontList().getEditorUIName());
        AbstractToolEditorUI colorEditor = ((ToolPropertiesPanel)controller.getPropertiesPanel()).getQuickEditor(this.editorTool.getToolColorList().getEditorUIName());
        if (fontEditor != null) {
            this.addAttributeSetListener(fontEditor);
        }
        if (colorEditor != null) {
            this.addAttributeSetListener(colorEditor);
        }
        this.editorTool.addActivationListener((ToolActivationListener)this);
        this.editorTool.addActivationListener((ToolActivationListener)((ToolPropertiesPanel)controller.getPropertiesPanel()));
        this.textPane.addPropertyChangeListener(SCALE_FACTOR, this);
        JScrollBar vScroller = this.scroller.getVerticalScrollBar();
        vScroller.addMouseListener(this.getWbMouseAdapter());
        vScroller.addMouseMotionListener(this.getWbMouseAdapter());
        Component[] components = vScroller.getComponents();
        for (int i = 0; i < components.length; ++i) {
            List<MouseListener> compListeners = Arrays.asList(components[i].getMouseListeners());
            if (compListeners.contains(this.getWbMouseAdapter())) continue;
            components[i].addMouseListener(this.getWbMouseAdapter());
        }
    }

    private boolean isScrollbarVisible() {
        return this.scroller.getVerticalScrollBar().isVisible();
    }

    @Override
    public void endComposition() {
        if (this.textPane != null) {
            this.textPane.getInputContext().endComposition();
        }
    }

    private void updateDocument() {
        Object externalData = this.editorTool.getToolData();
        if (externalData != null) {
            this.getDocument().addDocumentListener(this);
            if (externalData instanceof Reader) {
                this.importData((Reader)externalData);
            } else if (externalData instanceof InputStream) {
                this.importData((InputStream)externalData);
            } else if (externalData instanceof String) {
                this.importData((String)externalData);
            } else {
                this.importData(externalData.toString());
            }
            this.getDocument().removeDocumentListener(this);
        } else {
            List attributes = this.editorTool.getAttributeList();
            for (AbstractAttribute att : attributes) {
                this.updateUIFromConference(att);
            }
        }
    }

    @Override
    public void render(Graphics g) {
        int newAdjValue;
        super.render(g);
        if (!this.editorTool.isSelected() && this.getAdjustment() != this.editorTool.getToolComponent().getScrollAdjustment() && (newAdjValue = this.editorTool.getToolComponent().getScrollAdjustment()) != this.curAdjValue) {
            this.setAdjustment(newAdjValue);
        }
        if (this.editorTool.isUiComponentActive() && !this.textPane.isEnabled()) {
            this.textPane.setEnabled(true);
        }
        WhiteboardContext context = this.editorTool.getContext();
        double zoomX = context.getScaleX();
        double zoomY = context.getScaleY();
        DPoint zoom = (DPoint)this.textPane.getDocument().getProperty(SCALE_FACTOR);
        if (zoom == null) {
            zoom = new DPoint(0.0, 0.0);
        }
        if (zoom.getX() != zoomX || zoom.getY() != zoomY) {
            zoom.setX(zoomX);
            zoom.setY(zoomY);
            this.textPane.getDocument().putProperty(SCALE_FACTOR, zoom);
            this.textPane.firePropertyChange(SCALE_FACTOR, false, true);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Point loc = this.getUI().getLocation();
        g2.translate(loc.x, loc.y);
        this.scroller.paint(g2);
        g2.dispose();
    }

    @Override
    public void onSelectTool(AbstractToolModel tool) {
        if (!tool.equals((Object)this.editorTool)) {
            return;
        }
        super.onSelectTool(tool);
        JScrollBar vScroller = this.scroller.getVerticalScrollBar();
        List<MouseListener> mouseScrollListeners = Arrays.asList(vScroller.getMouseListeners());
        List<MouseMotionListener> mouseScrollMotionListeners = Arrays.asList(vScroller.getMouseMotionListeners());
        if (mouseScrollListeners.contains(this.getWbMouseAdapter())) {
            vScroller.removeMouseListener(this.getWbMouseAdapter());
        }
        if (mouseScrollMotionListeners.contains(this.getWbMouseAdapter())) {
            vScroller.removeMouseMotionListener(this.getWbMouseAdapter());
        }
        Component[] components = vScroller.getComponents();
        for (int i = 0; i < components.length; ++i) {
            List<MouseListener> compListeners = Arrays.asList(components[i].getMouseListeners());
            if (!compListeners.contains(this.getWbMouseAdapter())) continue;
            components[i].removeMouseListener(this.getWbMouseAdapter());
        }
    }

    @Override
    public void onDeSelectTool(AbstractToolModel tool) {
        if (!tool.equals((Object)this.editorTool)) {
            return;
        }
        super.onDeSelectTool(tool);
        JScrollBar vScroller = this.scroller.getVerticalScrollBar();
        List<MouseListener> mouseScrollListeners = Arrays.asList(vScroller.getMouseListeners());
        List<MouseMotionListener> mouseScrollMotionListeners = Arrays.asList(vScroller.getMouseMotionListeners());
        if (!mouseScrollListeners.contains(this.getWbMouseAdapter())) {
            vScroller.addMouseListener(this.getWbMouseAdapter());
        }
        if (!mouseScrollMotionListeners.contains(this.getWbMouseAdapter())) {
            vScroller.addMouseMotionListener(this.getWbMouseAdapter());
        }
        Component[] components = vScroller.getComponents();
        for (int i = 0; i < components.length; ++i) {
            List<MouseListener> compListeners = Arrays.asList(components[i].getMouseListeners());
            if (compListeners.contains(this.getWbMouseAdapter())) continue;
            components[i].addMouseListener(this.getWbMouseAdapter());
        }
    }

    @Override
    public void onActivateTool(AbstractToolModel tool) {
        JScrollBar vScroller;
        List<AdjustmentListener> adjListeners;
        if (!tool.equals((Object)this.editorTool)) {
            return;
        }
        this.textPane.setEditable(true);
        this.textPane.getCaret().setVisible(true);
        super.onActivateTool(tool);
        List<MouseListener> mouseListeners = Arrays.asList(this.textPane.getMouseListeners());
        List<MouseMotionListener> mouseMotionListeners = Arrays.asList(this.textPane.getMouseMotionListeners());
        List docListenersList = this.getDocumentListeners();
        if (mouseListeners.contains(this.getWbMouseAdapter())) {
            this.textPane.removeMouseListener(this.getWbMouseAdapter());
        }
        if (mouseMotionListeners.contains(this.getWbMouseAdapter())) {
            this.textPane.removeMouseMotionListener(this.getWbMouseAdapter());
        }
        if (!docListenersList.contains(this)) {
            this.getDocument().addDocumentListener(this);
        }
        if (!(adjListeners = Arrays.asList((vScroller = this.scroller.getVerticalScrollBar()).getAdjustmentListeners())).contains(this)) {
            vScroller.addAdjustmentListener(this);
        }
        this.grabFocus();
        this.setCursor(this.editorTool.getMousePoint());
    }

    @Override
    public void onDeActivateTool(AbstractToolModel tool) {
        JScrollBar vScroller;
        List<AdjustmentListener> adjListeners;
        if (!tool.equals((Object)this.editorTool)) {
            return;
        }
        super.onDeActivateTool(tool);
        this.textPane.setEditable(false);
        this.textPane.getCaret().setVisible(false);
        List<MouseListener> mouseListeners = Arrays.asList(this.textPane.getMouseListeners());
        List<MouseMotionListener> mouseMotionListeners = Arrays.asList(this.textPane.getMouseMotionListeners());
        List docListenersList = this.getDocumentListeners();
        if (!mouseListeners.contains(this.getWbMouseAdapter())) {
            this.textPane.addMouseListener(this.getWbMouseAdapter());
        }
        if (!mouseMotionListeners.contains(this.getWbMouseAdapter())) {
            this.textPane.addMouseMotionListener(this.getWbMouseAdapter());
        }
        if (docListenersList.contains(this)) {
            this.getDocument().removeDocumentListener(this);
        }
        if ((adjListeners = Arrays.asList((vScroller = this.scroller.getVerticalScrollBar()).getAdjustmentListeners())).contains(this)) {
            vScroller.removeAdjustmentListener(this);
        }
        vScroller.setValue(this.editorTool.getToolComponent().getScrollAdjustment());
    }

    private void setCursor(Point p) {
        Point viewPos = this.scroller.getViewport().getViewPosition();
        p.setLocation(p.getX() + viewPos.getX(), p.getY() + viewPos.getY());
        int cursorPos = this.textPane.viewToModel(p);
        if (cursorPos > 0) {
            this.textPane.setCaretPosition(cursorPos);
            this.editorTool.setXStart(cursorPos);
            this.editorTool.setXEnd(cursorPos);
            this.showAttributes(cursorPos, cursorPos);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editorTool.removeActivationListener((ToolActivationListener)this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.editorTool.isUiComponentActive()) {
            this.editorTool.getToolComponent().setScrollAdjustment(e.getValue());
        }
    }

    @Override
    public void grabFocus() {
        this.textPane.grabFocus();
    }

    @Override
    public boolean hasFocus() {
        return this.textPane.hasFocus();
    }

    public void setAdjustment(int adjustmentValue) {
        this.scroller.getVerticalScrollBar().setValue(adjustmentValue);
        this.curAdjValue = adjustmentValue;
    }

    public int getAdjustment() {
        return this.scroller.getVerticalScrollBar().getValue();
    }

    public void addAttributeSetListener(AttributeSetListener listener) {
        if (!this.attributeSetListeners.contains(listener)) {
            this.attributeSetListeners.add(listener);
        }
    }

    public void removeAttributeSetListener(AttributeSetListener listener) {
        this.attributeSetListeners.remove(listener);
    }

    public LinkedList getAttributeSetListeners() {
        return this.attributeSetListeners;
    }

    public void fireAttributeSetEvent(AttributeSetEvent e) {
        if (this.editorTool.isUiComponentActive()) {
            Iterator iter = this.attributeSetListeners.iterator();
            while (iter.hasNext()) {
                ((AttributeSetListener)iter.next()).onAttributeSetChange(e);
            }
        }
    }

    public void importData(Reader r) {
        try {
            this.getEditorKit().read(r, (Document)this.getDocument(), 0);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"importData(Reader). IO problem.", (Throwable)ex, (boolean)true);
        }
    }

    public void importData(InputStream in) {
        try {
            this.getEditorKit().read(in, (Document)this.getDocument(), 0);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"importData(InputStream). IO problem.", (Throwable)ex, (boolean)true);
        }
    }

    public void importData(String str) {
        try {
            this.getDocument().insertString(0, str, WBTextPane.getDefaultAttributes());
        }
        catch (BadLocationException ex) {
            LogSupport.exception((Object)this, (String)"importData(String). IO problem.", (Throwable)ex, (boolean)true);
        }
    }

    public StyledDocument getDocument() {
        if (this.document == null) {
            this.document = new ScaledFontStyledDocument(false);
            this.document.setCharacterAttributes(0, 1, WBTextPane.getDefaultAttributes(), true);
        }
        return this.document;
    }

    @Override
    public boolean isLink(MouseEvent e) {
        if (e instanceof TranslatedMouseEvent) {
            TranslatedMouseEvent mouseEvent = (TranslatedMouseEvent)e;
            MouseEvent originalEvent = mouseEvent.getOriginalEvent();
            Point transPoint = SwingUtilities.convertPoint((Component)e.getSource(), originalEvent.getPoint(), this.textPane);
            boolean isLink = HyperlinkMouseHandler.isLink((JTextComponent)this.textPane, (Point)transPoint);
            return isLink;
        }
        Point transPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.textPane);
        boolean isLink = HyperlinkMouseHandler.isLink((JTextComponent)this.textPane, (Point)transPoint);
        return isLink;
    }

    @Override
    public void handleMouseRelease(MouseEvent e, int toolX, int toolY) {
        if (this.textPane != null) {
            if (e instanceof TranslatedMouseEvent) {
                TranslatedMouseEvent mouseEvent = (TranslatedMouseEvent)e;
                MouseEvent originalEvent = mouseEvent.getOriginalEvent();
                Point transPoint = SwingUtilities.convertPoint((Component)e.getSource(), originalEvent.getPoint(), this.textPane);
                HyperlinkMouseHandler.mouseReleased((Point)transPoint, (MouseEvent)originalEvent, (JTextComponent)this.textPane);
                if (originalEvent.isConsumed()) {
                    e.consume();
                }
            } else {
                Point transPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.textPane);
                HyperlinkMouseHandler.mouseReleased((Point)transPoint, (MouseEvent)e, (JTextComponent)this.textPane);
            }
        }
    }

    public StyledEditorKit getEditorKit() {
        if (this.editorKit == null) {
            this.editorKit = new ScaledFontEditorKit();
            this.document = this.editorKit.createDefaultDocument();
            MutableAttributeSet inputAttributes = this.editorKit.getInputAttributes();
            inputAttributes.removeAttributes(inputAttributes);
            inputAttributes.addAttributes(WBTextPane.getDefaultAttributes());
        }
        return this.editorKit;
    }

    public List getDocumentListeners() {
        DocumentListener[] listeners = ((AbstractDocument)((Object)this.document)).getDocumentListeners();
        return Arrays.asList(listeners);
    }

    public void showAttributes(int xStart, int xEnd) {
        this.editorTool.setIgnoreAttrChange(true);
        try {
            if (xStart == xEnd) {
                xStart = xStart > 0 ? xStart - 1 : 0;
            }
            xEnd = xEnd > 0 ? xEnd - 1 : 0;
            Color color = null;
            Color dColor = new Color(6, 8, 72);
            String name = null;
            String dName = "";
            Integer size = null;
            Integer dSize = new Integer(0);
            Boolean bold = null;
            Boolean dStyle = Boolean.FALSE;
            Boolean italic = null;
            Boolean underline = null;
            for (int i = xStart; i <= xEnd; ++i) {
                AttributeSet attr = this.document.getCharacterElement(i).getAttributes();
                color = (Color)WBTextPane.valueSelector(StyleConstants.getForeground(attr), color, dColor);
                name = (String)WBTextPane.valueSelector(StyleConstants.getFontFamily(attr), name, dName);
                size = (Integer)WBTextPane.valueSelector(new Integer(StyleConstants.getFontSize(attr)), size, dSize);
                bold = (Boolean)WBTextPane.valueSelector(new Boolean(StyleConstants.isBold(attr)), bold, dStyle);
                italic = (Boolean)WBTextPane.valueSelector(new Boolean(StyleConstants.isItalic(attr)), italic, dStyle);
                underline = (Boolean)WBTextPane.valueSelector(new Boolean(StyleConstants.isUnderline(attr)), underline, dStyle);
            }
            SimpleAttributeSet attr = new SimpleAttributeSet();
            StyleConstants.setForeground(attr, color);
            StyleConstants.setFontFamily(attr, name);
            StyleConstants.setFontSize(attr, size);
            StyleConstants.setBold(attr, bold);
            StyleConstants.setItalic(attr, italic);
            StyleConstants.setUnderline(attr, underline);
            this.editorTool.getToolColorList().setActiveColor(color);
            this.editorTool.getToolFontList().setFontName(name);
            this.editorTool.getToolFontList().setFontSize(size.intValue());
            int fontStyle = 0;
            if (bold.booleanValue()) {
                fontStyle |= 1;
            }
            if (italic.booleanValue()) {
                fontStyle |= 2;
            }
            this.editorTool.getToolFontList().setFontStyle(fontStyle);
            this.editorTool.getToolFontList().setUnderline(underline.booleanValue());
            AttributeSetEvent e = new AttributeSetEvent((AttributeSet)attr);
            this.fireAttributeSetEvent(e);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)("showAttributes() at (" + xStart + ", " + xEnd + ")"), (Throwable)ex, (boolean)true);
        }
        this.editorTool.setIgnoreAttrChange(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            StyledDocument doc = (StyledDocument)e.getDocument();
            this.editorTool.getToolText().setText(doc.getText(0, doc.getEndPosition().getOffset()));
            AttributeSet attr = doc.getCharacterElement(e.getOffset()).getAttributes();
            Font font = doc.getFont(attr);
            CompatibleFont eFont = null;
            eFont = new CompatibleFont(font.getFamily(), font.getStyle(), font.getSize(), StyleConstants.isUnderline(attr));
            this.editorTool.getToolFontList().setAttribute((Object)eFont);
            this.editorTool.getToolFontRuns().insertUpdate(e.getOffset(), e.getLength(), this.editorTool.getToolFontList().getAttribute((Object)eFont).getSaId(), doc.getLength());
            Color color = doc.getForeground(attr);
            this.editorTool.getToolColorList().setAttribute((Object)color);
            this.editorTool.getToolColorRuns().insertUpdate(e.getOffset(), e.getLength(), this.editorTool.getToolColorList().getAttribute((Object)color).getSaId(), doc.getLength());
            this.editorTool.notifyVisibleChange();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"insertUpdate()", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            StyledDocument doc = (StyledDocument)e.getDocument();
            this.editorTool.getToolText().setText(doc.getText(0, doc.getEndPosition().getOffset()));
            this.editorTool.getToolFontRuns().removeUpdate(e.getOffset(), e.getLength());
            this.editorTool.getToolColorRuns().removeUpdate(e.getOffset(), e.getLength());
            this.editorTool.notifyVisibleChange();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"removeUpdate)", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean applyAttributeChange(StyleSubAttribute sa, int xStart, int length) {
        StyleProxy sp = ProxyFactory.getProxy(sa);
        if (sp != null) {
            MutableAttributeSet attr = sp.getAttributeSet();
            if (length != 0) {
                this.getDocument().setCharacterAttributes(xStart, length, attr, false);
            }
            this.getEditorKit().getInputAttributes().addAttributes(attr);
            return true;
        }
        return false;
    }

    private void applyAttributes(ToolStyleRunList toolRuns, AbstractAttributeMap toolStyles) {
        List runs = toolRuns.getAttributeList();
        if (!runs.isEmpty()) {
            for (StyleRunSubAttribute styleChange : runs) {
                StyleSubAttribute sa = (StyleSubAttribute)toolStyles.getAttributeById(styleChange.getSaId());
                this.applyAttributeChange(sa, styleChange.getOffset(), styleChange.getLength());
            }
        }
    }

    private static MutableAttributeSet getDefaultAttributes() {
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributeSet, "Serif");
        StyleConstants.setFontSize(attributeSet, 14);
        StyleConstants.setBold(attributeSet, false);
        StyleConstants.setItalic(attributeSet, false);
        StyleConstants.setUnderline(attributeSet, false);
        StyleConstants.setForeground(attributeSet, new Color(-16777216));
        return attributeSet;
    }

    private static Object valueSelector(Object thisValue, Object value, Object defaultValue) {
        if (value == null) {
            value = thisValue;
        } else if (!value.equals(defaultValue) && !value.equals(thisValue)) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateUIFromConferenceDelayedActions(AbstractAttribute att) {
        if (!this.editorTool.isUiComponentActive()) {
            try {
                if (att instanceof ToolColor) {
                    Color background = (Color)this.editorTool.getFillColor().getColor();
                    this.textPane.setBackground(background);
                    this.scroller.setBackground(background);
                    this.getUI().setBackground(background);
                    return;
                }
                if (att instanceof ToolText) {
                    if (this.document.getText(0, this.getDocument().getLength()).equals(this.editorTool.getText())) return;
                    String editorText = this.editorTool.getText();
                    this.document.remove(0, this.getDocument().getLength());
                    this.document.insertString(0, editorText, WBTextPane.getDefaultAttributes());
                    this.documentCopy.queueUpdate(att, editorText);
                    return;
                }
                if (att instanceof ToolStyleRunList) {
                    ToolStyleRunList toolFontRuns = (ToolStyleRunList)this.editorTool.getToolFontRuns().clone();
                    ToolFontList toolFontList = (ToolFontList)this.editorTool.getToolFontList().clone();
                    ToolStyleRunList toolColorRuns = (ToolStyleRunList)this.editorTool.getToolColorRuns().clone();
                    ToolColorList toolColorList = (ToolColorList)this.editorTool.getToolColorList().clone();
                    this.applyAttributes(toolFontRuns, (AbstractAttributeMap)toolFontList);
                    this.applyAttributes(toolColorRuns, (AbstractAttributeMap)toolColorList);
                    this.documentCopy.queueUpdate(att, toolFontRuns, toolFontList);
                    this.documentCopy.queueUpdate(att, toolColorRuns, toolColorList);
                    this.document.parse();
                    return;
                }
                if (att instanceof ToolFontList) {
                    ToolStyleRunList toolFontRuns = (ToolStyleRunList)this.editorTool.getToolFontRuns().clone();
                    ToolFontList toolFontList = (ToolFontList)this.editorTool.getToolFontList().clone();
                    this.applyAttributes(toolFontRuns, (AbstractAttributeMap)toolFontList);
                    this.documentCopy.queueUpdate(att, toolFontRuns, toolFontList);
                    this.document.parse();
                    return;
                }
                if (att instanceof ToolColorList) {
                    ToolStyleRunList toolColorRuns = (ToolStyleRunList)this.editorTool.getToolColorRuns().clone();
                    ToolColorList toolColorList = (ToolColorList)this.editorTool.getToolColorList().clone();
                    this.applyAttributes(toolColorRuns, (AbstractAttributeMap)toolColorList);
                    this.documentCopy.queueUpdate(att, toolColorRuns, toolColorList);
                    this.document.parse();
                    return;
                }
                if (!(att instanceof ToolRectangle)) return;
                this.setPosition(this.editorTool.getBounds());
                this.document.parse();
                return;
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"render()", (Throwable)ex, (boolean)true);
            }
            return;
        }
        try {
            if (att instanceof ToolColor) return;
            if (att instanceof ToolText) {
                if (this.document.getText(0, this.getDocument().getLength()).equals(this.editorTool.getText())) return;
                String editorText = this.editorTool.getText();
                this.documentCopy.queueUpdate(att, editorText);
                return;
            }
            if (att instanceof ToolStyleRunList) {
                ToolStyleRunList toolFontRuns = (ToolStyleRunList)this.editorTool.getToolFontRuns().clone();
                ToolFontList toolFontList = (ToolFontList)this.editorTool.getToolFontList().clone();
                ToolStyleRunList toolColorRuns = (ToolStyleRunList)this.editorTool.getToolColorRuns().clone();
                ToolColorList toolColorList = (ToolColorList)this.editorTool.getToolColorList().clone();
                this.documentCopy.queueUpdate(att, toolFontRuns, toolFontList);
                this.documentCopy.queueUpdate(att, toolColorRuns, toolColorList);
                return;
            }
            if (att instanceof ToolFontList) {
                ToolStyleRunList toolFontRuns = (ToolStyleRunList)this.editorTool.getToolFontRuns().clone();
                ToolFontList toolFontList = (ToolFontList)this.editorTool.getToolFontList().clone();
                this.documentCopy.queueUpdate(att, toolFontRuns, toolFontList);
                return;
            }
            if (att instanceof ToolColorList) {
                ToolStyleRunList toolColorRuns = (ToolStyleRunList)this.editorTool.getToolColorRuns().clone();
                ToolColorList toolColorList = (ToolColorList)this.editorTool.getToolColorList().clone();
                this.documentCopy.queueUpdate(att, toolColorRuns, toolColorList);
                return;
            }
            if (!(att instanceof ToolRectangle)) return;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"render()", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public void updateUIFromConference(AbstractAttribute att) {
        if (!this.editorTool.isUiComponentActive()) {
            if (!this.documentCopy.isVisible()) {
                this.documentCopy.setVisible(true);
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WBTextPane.this.textPane.setDocument((Document)((Object)WBTextPane.this.documentCopy));
                    }
                });
            }
            this.updateUIFromConferenceDelayedActions(att);
            if (this.updateTimer != null) {
                try {
                    this.updateTimer.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.updateTimer = null;
            }
            this.updateTimer = new Timer(250, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WBTextPane.this.textPane.setDocument((Document)((Object)WBTextPane.this.document));
                    WBTextPane.this.documentCopy.setVisible(false);
                }
            });
            this.updateTimer.setRepeats(false);
            this.updateTimer.start();
        } else {
            this.updateUIFromConferenceDelayedActions(att);
            this.documentCopy.processBacklog();
        }
    }

    @Override
    public Image getImage() {
        try {
            SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    Rectangle rec = WBTextPane.this.editorTool.getVBounds();
                    WBTextPane.this.textImage = new BufferedImage(rec.width, rec.height, 2);
                    Graphics2D imageG = (Graphics2D)WBTextPane.this.textImage.getGraphics();
                    imageG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    imageG.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                    imageG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    DPoint zoom = (DPoint)WBTextPane.this.textPane.getDocument().getProperty(WBTextPane.SCALE_FACTOR);
                    if (zoom != null) {
                        double zoomX = 1.0 / zoom.getX();
                        double zoomY = 1.0 / zoom.getY();
                        imageG.scale(zoomX, zoomY);
                    }
                    WBTextPane.this.scroller.paint(imageG);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.textImage;
    }

    public void onScreenChange(ScreenChangeEvent sce) {
        if (sce.getObject() == this.editorTool || sce.getObject() instanceof Rectangle && ((Rectangle)sce.getObject()).intersects(this.editorTool.getBounds())) {
            this.setPosition(this.editorTool.getBounds());
        }
    }

    @Override
    public String toString() {
        return this.scroller.getName() + " Location: (" + this.scroller.getX() + ", " + this.scroller.getY() + "),  " + "Size: (" + this.scroller.getWidth() + ", " + this.scroller.getHeight() + ")";
    }

    @Override
    public void setBorder(Color color, int width) {
    }

    public void setBorderVisible(boolean vis) {
        WBLineBorder border = (WBLineBorder)this.scroller.getBorder();
        if (border.isBorderPainted() != vis) {
            border.setBorderPainted(vis);
            Container parent = this.getUI().getParent();
            if (parent != null) {
                parent.repaint();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setPosition(this.editorTool.getBounds());
        DPoint scaleFactor = (DPoint)this.textPane.getDocument().getProperty(SCALE_FACTOR);
        this.document.setScaleFactor(scaleFactor);
        this.documentCopy.setScaleFactor(scaleFactor);
        this.editorKit.getScaledFontViewFactory().updateViews();
    }

    @Override
    public void setPosition(Rectangle rec) {
        super.setPosition(rec);
        if (this.scroller != null) {
            this.scroller.setSize(this.getUI().getSize());
            if (!this.textPane.getSize().equals(this.scroller.getViewport().getSize())) {
                if (this.scroller.getVerticalScrollBarPolicy() != 22) {
                    this.scroller.setVerticalScrollBarPolicy(22);
                }
            } else if (this.scroller.getVerticalScrollBarPolicy() != 20) {
                this.scroller.setVerticalScrollBarPolicy(20);
            }
        }
    }

    public Cursor getCursor() {
        return this.editorTool.getCursor();
    }

    private class CopyScaledFontStyledDocument
    extends ScaledFontStyledDocument {
        private boolean isVisible;
        private ArrayList<InvisibleUpdate> backlog;
        private Object backlogLock;

        public CopyScaledFontStyledDocument() {
            super(false);
            this.isVisible = false;
            this.backlogLock = new Object();
            this.backlog = new ArrayList();
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean vis) {
            this.isVisible = vis;
            if (!vis) {
                this.processBacklog();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processBacklog() {
            if (!this.isVisible) {
                ArrayList<InvisibleUpdate> tempBacklog = null;
                Object object = this.backlogLock;
                synchronized (object) {
                    tempBacklog = this.backlog;
                    this.backlog = new ArrayList();
                }
                for (InvisibleUpdate u : tempBacklog) {
                    this.processUpdate(u);
                }
                tempBacklog.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueUpdate(AbstractAttribute att, String text) {
            Object object = this.backlogLock;
            synchronized (object) {
                this.backlog.add(new TextInvisibleUpdate(att, text));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueUpdate(AbstractAttribute att, ToolStyleRunList toolFontRuns, ToolFontList toolFontList) {
            Object object = this.backlogLock;
            synchronized (object) {
                this.backlog.add(new FontInvisibleUpdate(att, toolFontRuns, toolFontList));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueUpdate(AbstractAttribute att, ToolStyleRunList toolColorRuns, ToolColorList toolColorList) {
            Object object = this.backlogLock;
            synchronized (object) {
                this.backlog.add(new ColorInvisibleUpdate(att, toolColorRuns, toolColorList));
            }
        }

        public void processUpdate(InvisibleUpdate up) {
            try {
                if (up instanceof TextInvisibleUpdate) {
                    this.remove(0, this.getLength());
                    this.insertString(0, ((TextInvisibleUpdate)up).text, WBTextPane.getDefaultAttributes());
                } else if (up instanceof FontInvisibleUpdate) {
                    this.applyAttributes(((FontInvisibleUpdate)up).toolFontRuns, (AbstractAttributeMap)((FontInvisibleUpdate)up).toolFontList);
                    this.parse();
                } else if (up instanceof ColorInvisibleUpdate) {
                    this.applyAttributes(((ColorInvisibleUpdate)up).toolColorRuns, (AbstractAttributeMap)((ColorInvisibleUpdate)up).toolColorList);
                    this.parse();
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)((Object)this), (String)"render()", (Throwable)ex, (boolean)true);
            }
        }

        private void applyAttributes(ToolStyleRunList toolRuns, AbstractAttributeMap toolStyles) {
            List runs = toolRuns.getAttributeList();
            if (!runs.isEmpty()) {
                for (StyleRunSubAttribute styleChange : runs) {
                    StyleSubAttribute sa = (StyleSubAttribute)toolStyles.getAttributeById(styleChange.getSaId());
                    StyleProxy sp = ProxyFactory.getProxy(sa);
                    if (sp == null) continue;
                    MutableAttributeSet attr = sp.getAttributeSet();
                    if (styleChange.getLength() == 0) continue;
                    this.setCharacterAttributes(styleChange.getOffset(), styleChange.getLength(), attr, false);
                }
            }
        }

        private class ColorInvisibleUpdate
        extends InvisibleUpdate {
            private ToolStyleRunList toolColorRuns;
            private ToolColorList toolColorList;

            public ColorInvisibleUpdate(AbstractAttribute a, ToolStyleRunList r, ToolColorList l) {
                super(a);
                this.toolColorRuns = r;
                this.toolColorList = l;
            }
        }

        private class FontInvisibleUpdate
        extends InvisibleUpdate {
            private ToolStyleRunList toolFontRuns;
            private ToolFontList toolFontList;

            public FontInvisibleUpdate(AbstractAttribute a, ToolStyleRunList r, ToolFontList l) {
                super(a);
                this.toolFontRuns = r;
                this.toolFontList = l;
            }
        }

        private class InvisibleUpdate {
            public AbstractAttribute att;

            public InvisibleUpdate(AbstractAttribute a) {
                this.att = a;
            }
        }

        private class TextInvisibleUpdate
        extends InvisibleUpdate {
            public String text;

            public TextInvisibleUpdate(AbstractAttribute a, String t) {
                super(a);
                this.text = t;
            }
        }
    }
}

