/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.swingsupport;

import com.elluminate.groupware.whiteboard.module.ui.swingsupport.ParentChangedListener;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.ScaledFontLabelView;
import java.util.ArrayList;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ScaledFontViewFactory
implements ViewFactory {
    private ArrayList<ScaledFontLabelView> views = new ArrayList();
    private ParentChangedListener pcl = new ParentChangedListener(){

        @Override
        public void parentChanged(ScaledFontLabelView source, View oldValue, View newValue) {
            if (newValue == null) {
                ScaledFontViewFactory.this.views.remove(source);
                return;
            }
            if (oldValue == null) {
                ScaledFontViewFactory.this.views.add(source);
            }
        }
    };

    @Override
    public View create(Element elem) {
        String kind = elem.getName();
        if ("content".equals(kind)) {
            ScaledFontLabelView view = new ScaledFontLabelView(elem);
            view.setParentChangedListener(this.pcl);
            return view;
        }
        if ("paragraph".equals(kind)) {
            return new ParagraphView(elem);
        }
        if ("section".equals(kind)) {
            return new BoxView(elem, 1);
        }
        if ("component".equals(kind)) {
            return new ComponentView(elem);
        }
        if ("icon".equals(kind)) {
            return new IconView(elem);
        }
        return new LabelView(elem);
    }

    public void updateViews() {
        for (ScaledFontLabelView view : this.views) {
            try {
                view.setPropertiesFromAttributes();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }
}

