/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.gui.Mnemonic;
import com.elluminate.util.I18n;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public abstract class WBAbstractJMenu
extends JMenu {
    protected static I18n i18n = I18n.create((Object)new Object(){});
    ScreenModel screen;
    String propertiesName;
    WhiteboardContext context = null;

    public WBAbstractJMenu(WhiteboardContext context, Object housing, String properties) {
        super(Mnemonic.getText((String)WBAbstractJMenu.getMenuName(properties)));
        this.propertiesName = properties;
        this.setIcon(null);
        this.context = context;
        if (housing instanceof JMenu) {
            JMenu menu = (JMenu)housing;
            menu.add(this);
        } else if (housing instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)housing;
            popup.add(this);
        }
        Mnemonic.setMnemonic((AbstractButton)this, (String)WBAbstractJMenu.getMenuName(this.propertiesName));
        KeyStroke keyStroke = this.getAccelerator();
        if (keyStroke != null) {
            this.setAccelerator(keyStroke);
        }
    }

    public void setTextAndMnemonic(String text) {
        this.setText(Mnemonic.getText((String)text));
        Mnemonic.setMnemonic((AbstractButton)this, (String)text);
        KeyStroke keyStroke = this.getAccelerator();
        if (keyStroke != null) {
            this.setAccelerator(keyStroke);
        }
    }

    public JMenuItem menuItemFactory() {
        return WBAbstractJMenu.menuItemFactory(this);
    }

    public static JMenuItem menuItemFactory(WBAbstractJMenu menu) {
        JMenuItem item = new JMenuItem(WBAbstractJMenu.getMenuName(menu.getPropertiesName()), menu.getIcon());
        return item;
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public static String getMenuName(String propertiesName) {
        String menuName = propertiesName + ".item";
        try {
            menuName = i18n.getStringLegacy(menuName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menuName;
    }

    public String getToolTipText(String propertiesName) {
        try {
            return i18n.getStringLegacy(propertiesName + ".toolTip");
        }
        catch (Exception e) {
            return null;
        }
    }
}

