/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.ui.DisplayUtilities;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.ScreenCellRenderer;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PathSelectionDialog
extends EasyDialog
implements WindowListener {
    static I18n i18n = I18n.create((Object)new Object(){});
    public static final int CURRENT_GROUP = 1;
    public static final int CURRENT_SCREEN = 2;
    public static final int SELECTED_SCREENS = 4;
    public static final int USER_PANEL_TOP = 0;
    static final int SELECT_PANEL = 1;
    static final int EXTENT_PANEL = 2;
    public static final int USER_PANEL_MID = 3;
    static final int TREE_PANEL = 4;
    public static final int USER_PANEL_BOTTOM = 5;
    static final int BUTTON_PANEL = 6;
    JPanel dialogPanel = new JPanel();
    int depth = 1;
    TreePath[] paths = null;
    boolean cancelled = false;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JPanel selectPanel = new JPanel();
    JRadioButton currentRadioButton = new JRadioButton();
    JRadioButton currentScreenGroupButton = new JRadioButton();
    JRadioButton selectedRadioButton = new JRadioButton();
    JPanel extentPanel = new JPanel();
    JRadioButton allDeepRadiobutton = new JRadioButton();
    JRadioButton depthLimitRadio = new JRadioButton();
    JTextField depthTextField = new JTextField();
    ButtonGroup selectGroup = new ButtonGroup();
    ButtonGroup extentGroup = new ButtonGroup();
    JPanel userTopPanel = null;
    JPanel userMidPanel = null;
    JPanel userBottomPanel = null;
    boolean conversionError = false;
    WhiteboardContext context;
    DndTree navTree = null;
    JScrollPane navScrollPane = new JScrollPane();
    private ButtonModel lastSelectGroup;
    private ButtonModel lastExtentGroup;
    FocusListener depthFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PathSelectionDialog.this.processDepthField();
        }
    };
    boolean initTree = true;
    boolean needDepth = false;

    public PathSelectionDialog(WhiteboardContext context, int defaultButton, boolean enableCurrent, boolean enableCurrentScreenGroup, boolean enableSelected) {
        super((Component)context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_TITLE), true);
        this.context = context;
        try {
            this.jbInit(defaultButton, enableCurrent, enableCurrentScreenGroup, enableSelected);
            this.addWindowListener(this);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit(int defaultButton, boolean enableCurrent, boolean enableCurrentScreenGroup, boolean enableSelected) throws Exception {
        this.setResizable(true);
        this.dialogPanel.setLayout(new GridBagLayout());
        this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_OK));
        this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_CANCEL));
        TitledBorder border = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_SCREENBORDER));
        this.selectPanel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.selectPanel.setLayout(new GridBagLayout());
        this.currentRadioButton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_CURRENTSCREEN));
        this.currentScreenGroupButton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_CURRENTSCREENGROUP));
        this.selectedRadioButton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_SELECTEDSCREENS));
        this.depthTextField.setHorizontalAlignment(4);
        this.selectGroup.add(this.currentRadioButton);
        this.selectGroup.add(this.currentScreenGroupButton);
        this.selectGroup.add(this.selectedRadioButton);
        border = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_EXTENTBORDER));
        this.extentPanel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.extentPanel.setLayout(new GridBagLayout());
        this.allDeepRadiobutton.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_ALLBELOW));
        this.depthLimitRadio.setText(i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_TODEPTH));
        this.extentGroup.add(this.allDeepRadiobutton);
        this.extentGroup.add(this.depthLimitRadio);
        this.currentRadioButton.setSelected(true);
        this.depthLimitRadio.setSelected(true);
        this.depthTextField.setText(Integer.toString(this.depth));
        this.dialogPanel.add((Component)this.selectPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 0, 0, 0), 0, 0));
        if (enableCurrentScreenGroup) {
            this.selectPanel.add((Component)this.currentScreenGroupButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (enableCurrent) {
            this.selectPanel.add((Component)this.currentRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (enableSelected) {
            this.selectPanel.add((Component)this.selectedRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.selectPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.navScrollPane, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.dialogPanel.add((Component)this.extentPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.extentPanel.add((Component)this.allDeepRadiobutton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.extentPanel.add((Component)this.depthLimitRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.extentPanel.add((Component)this.depthTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.depthTextField.addFocusListener(this.depthFocusListener);
        this.currentRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.setEnables();
            }
        });
        this.currentScreenGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.setEnables();
            }
        });
        this.selectedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.setEnables();
            }
        });
        this.allDeepRadiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.setEnables();
            }
        });
        this.depthLimitRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.setEnables();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.okButtonAction(e);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathSelectionDialog.this.cancelButtonAction(e);
            }
        });
        this.navTree = new DndTree((TreeModel)this.context.getDataModel().getDisplayModel(), this.context);
        this.navTree.setRootVisible(false);
        this.navTree.setShowsRootHandles(true);
        this.navTree.setCellRenderer(new ScreenCellRenderer(this.context));
        this.navScrollPane.setVerticalScrollBarPolicy(22);
        this.navScrollPane.setHorizontalScrollBarPolicy(30);
        this.navScrollPane.setPreferredSize(new Dimension(200, 200));
        this.navScrollPane.setViewportView((Component)((Object)this.navTree));
        this.setDefaultCloseOperation(1);
        this.navScrollPane.setVisible(false);
        this.extentPanel.setVisible(false);
        this.selectButtonDefault(defaultButton);
        this.setContent(this.dialogPanel);
        this.addActionButton(this.okButton, true);
        this.addCancelButton(this.cancelButton);
    }

    public void addUserPanel(JPanel userPanel, int location) {
        AddPanelRunnable runnable = new AddPanelRunnable(userPanel, location);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)runnable);
        }
    }

    public void selectButtonDefault(int defaultButton) {
        if ((defaultButton & 1) != 0) {
            this.currentScreenGroupButton.setSelected(true);
        } else if ((defaultButton & 2) != 0) {
            this.currentRadioButton.setSelected(true);
        } else if ((defaultButton & 4) != 0) {
            this.selectedRadioButton.setSelected(true);
        }
    }

    public int getDepth() {
        if (this.allDeepRadiobutton.isSelected() || this.currentScreenGroupButton.isSelected()) {
            return Integer.MAX_VALUE;
        }
        return this.depth;
    }

    public TreePath[] getPaths() {
        if (this.currentRadioButton.isSelected()) {
            if (this.paths != null) {
                return this.paths;
            }
            TreePath[] treePaths = new TreePath[1];
            DisplayNode pathPeer = new DisplayNode();
            pathPeer.setUserObject((Object)this.context.getController().getScreen());
            treePaths[0] = new TreePath(pathPeer);
            return treePaths;
        }
        if (this.currentScreenGroupButton.isSelected()) {
            TreePath[] treePaths = new TreePath[1];
            DisplayNode pathPeer = new DisplayNode();
            pathPeer.setUserObject((Object)this.context.getController().getScreen().getRoot());
            treePaths[0] = new TreePath(pathPeer);
            return treePaths;
        }
        TreePath[] selectedPaths = this.navTree.getSelectionPaths();
        return selectedPaths;
    }

    public void setDepthNeeded(boolean needDepth) {
        this.needDepth = needDepth;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void okButtonAction(ActionEvent e) {
        super.setVisible(false);
    }

    private void cancelButtonAction(ActionEvent e) {
        this.cancelled = true;
        super.setVisible(false);
    }

    public void setVisible(TreePath[] paths, int depth) {
        this.paths = paths;
        this.depth = depth;
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.context.getDataModel().getDisplayModel() == null) {
                this.context.getDataModel().setDisplayModel(DisplayUtilities.createScreenTreeModel(this.context.getDataModel().getRoot(), this.context));
            }
            if (this.initTree) {
                this.navTree.setModel((TreeModel)this.context.getDataModel().getDisplayModel());
                this.initTree = false;
                ((WhiteboardBean)this.context.getBean()).addShowThumbnailsListener(new WhiteboardBean.ShowThumbnailsListener(){

                    @Override
                    public void showThumbnailsChanged(WhiteboardBean.ShowThumbnailsEvent e) {
                        PathSelectionDialog.this.navTree.setRowHeight(16);
                        PathSelectionDialog.this.navTree.setShowThumbnails(e.isShowingThumbnails());
                    }
                });
            }
            for (int i = 0; i < this.navTree.getRowCount(); ++i) {
                if (!this.navTree.isCollapsed(i)) continue;
                this.navTree.expandRow(i);
            }
            this.cancelled = false;
            this.depthTextField.setText(Integer.toString(Math.max(1, this.depth)));
            this.conversionError = false;
        }
        if (visible) {
            this.saveSettings();
            this.setEnables();
        }
        super.setVisible(visible);
    }

    private void processDepthField() {
        int localDepth = 0;
        this.conversionError = false;
        if (!this.depthTextField.isEnabled()) {
            return;
        }
        try {
            localDepth = Integer.parseInt(this.depthTextField.getText());
        }
        catch (NumberFormatException ex) {
            this.conversionError = true;
        }
        if (localDepth < 1) {
            this.conversionError = true;
        }
        if (this.conversionError) {
            this.depthTextField.removeFocusListener(this.depthFocusListener);
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_DEPTHERROR), (String)i18n.getString((PropertiesEnum)StringsProperties.PATHSELECTIONDIALOG_DEPTHERROR), (int)0);
            this.depthTextField.addFocusListener(this.depthFocusListener);
        }
        this.depth = localDepth;
    }

    private void setEnables() {
        this.setMinimumSize(new Dimension(180, 200));
        if (this.currentRadioButton.isSelected() || this.selectedRadioButton.isSelected()) {
            if (this.selectedRadioButton.isSelected()) {
                this.setMinimumSize(new Dimension(280, 420));
            }
            this.allDeepRadiobutton.setEnabled(true);
            this.depthLimitRadio.setEnabled(true);
            this.depthTextField.setEditable(this.depthLimitRadio.isSelected());
            if (this.navScrollPane.isVisible() != this.selectedRadioButton.isSelected()) {
                this.navScrollPane.setVisible(this.selectedRadioButton.isSelected());
                this.navScrollPane.getViewport().setExtentSize(this.navTree.getPreferredSize());
            }
        } else {
            this.allDeepRadiobutton.setEnabled(false);
            this.depthLimitRadio.setEnabled(false);
            this.depthTextField.setEditable(this.depthLimitRadio.isSelected());
            if (this.navScrollPane.isVisible()) {
                this.navScrollPane.setVisible(false);
            }
        }
        this.extentPanel.setVisible(!this.currentScreenGroupButton.isSelected() && this.needDepth);
        this.pack();
    }

    public void saveSettings() {
        this.lastExtentGroup = this.extentGroup.getSelection();
        this.lastSelectGroup = this.selectGroup.getSelection();
    }

    public void restoreSettings() {
        this.extentGroup.setSelected(this.lastExtentGroup, true);
        this.selectGroup.setSelected(this.lastSelectGroup, true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancelled = true;
        super.setVisible(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.cancelled = true;
        super.setVisible(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class AddPanelRunnable
    implements Runnable {
        JPanel panel;
        int location;

        public AddPanelRunnable(JPanel panel, int location) {
            this.panel = panel;
            this.location = location;
        }

        @Override
        public void run() {
            switch (this.location) {
                case 0: {
                    if (PathSelectionDialog.this.userTopPanel != null) {
                        PathSelectionDialog.this.dialogPanel.remove(PathSelectionDialog.this.userTopPanel);
                    }
                    PathSelectionDialog.this.userTopPanel = this.panel;
                    break;
                }
                case 3: {
                    if (PathSelectionDialog.this.userMidPanel != null) {
                        PathSelectionDialog.this.dialogPanel.remove(PathSelectionDialog.this.userMidPanel);
                    }
                    PathSelectionDialog.this.userMidPanel = this.panel;
                    break;
                }
                case 5: {
                    if (PathSelectionDialog.this.userBottomPanel != null) {
                        PathSelectionDialog.this.dialogPanel.remove(PathSelectionDialog.this.userBottomPanel);
                    }
                    PathSelectionDialog.this.userBottomPanel = this.panel;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.panel != null) {
                Insets ins = new Insets(0, 0, 0, 0);
                if (this.location > 0) {
                    ins.top = 6;
                }
                PathSelectionDialog.this.dialogPanel.add((Component)this.panel, new GridBagConstraints(0, this.location, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            }
            PathSelectionDialog.this.pack();
        }
    }
}

