/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.groupware.whiteboard.AbstractWBFileFilter;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.ImageSaveProcessor;
import com.elluminate.groupware.whiteboard.module.PDFSaveProcessor;
import com.elluminate.groupware.whiteboard.module.SaveProcessor;
import com.elluminate.groupware.whiteboard.module.WBDSaveProcessor;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardPDFFileFilter;
import com.elluminate.groupware.whiteboard.module.WhiteboardPNGFileFilter;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBDFileFilter;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBPFileFilter;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.FileChoice;
import com.elluminate.groupware.whiteboard.module.ui.menu.PathSelectionDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.tree.TreePath;

public class NavExportAction
extends WBAbstractAction {
    TreePath[] paths;
    TreePath[] pathsToProcess;
    int depth;
    int selectedDepth;
    File fileToSave;
    PathSelectionDialog selectionDialog = null;
    AbstractWBFileFilter wbFilter = new WhiteboardWBDFileFilter();
    AbstractWBFileFilter wpFilter = new WhiteboardWBPFileFilter();
    AbstractWBFileFilter pdfFilter = new WhiteboardPDFFileFilter();
    AbstractWBFileFilter imgFilter = new WhiteboardPNGFileFilter();
    AbstractWBFileFilter[] filters = new AbstractWBFileFilter[]{this.wbFilter, this.wpFilter, this.pdfFilter, this.imgFilter};

    public NavExportAction(WhiteboardContext context, Object housing, TreePath[] paths, int depth) {
        super(context, housing, "NavExportAction");
        this.depth = depth;
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    @Override
    public void actionPerformed(ActionFeatureEvent e) {
        this.performAction();
    }

    private void performAction() {
        SaveProcessor saveProcessor = null;
        if (this.context.getController().isProprietary()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.NAVEXPORTACTION_PROPRIETARYSAVE), (String)i18n.getString((PropertiesEnum)StringsProperties.NAVEXPORTACTION_PROPRIETARYSAVETITLE), (int)1);
            return;
        }
        FileChoice choice = null;
        boolean validated = false;
        do {
            int selectionMode = 1;
            this.pathsToProcess = this.paths;
            this.selectedDepth = this.depth;
            if (this.selectionDialog == null) {
                this.selectionDialog = new PathSelectionDialog(this.context, selectionMode, true, true, true);
            }
            if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
                this.selectionDialog.setDepthNeeded(false);
                this.selectionDialog.setVisible(this.pathsToProcess, this.depth);
                if (this.selectionDialog.isCancelled()) {
                    return;
                }
                this.pathsToProcess = this.selectionDialog.getPaths();
                this.selectedDepth = this.selectionDialog.getDepth();
                if (this.selectedDepth < Integer.MAX_VALUE) {
                    this.depth = this.selectedDepth;
                }
            }
            if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHS), (String)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHSTITLE), (int)0);
                return;
            }
            choice = FileUtils.getSaveFile(this.context, this.context.fileToSave, this.filters);
            if (choice == null || choice.getFile() == null) {
                return;
            }
            ScreenModel[] screens = ActionUtilities.nodesToScreens((WBNode[])FileUtils.createScreensFromPaths(this.pathsToProcess));
            int screenCount = this.screenCount(screens);
            if (choice.getFilter() instanceof WhiteboardPNGFileFilter && !validated && selectionMode != 2 && screenCount > 1) {
                int result = ModalDialog.showConfirmDialog((Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_MULTIIMAGE, new Object[]{screenCount}), (String)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_MULTIIMAGETITLE), (int)1, (int)2);
                if (result == 2) {
                    return;
                }
                if (result != 0) continue;
                validated = true;
                continue;
            }
            validated = true;
        } while (!validated);
        this.fileToSave = choice.getFile();
        if (this.fileToSave != null && !this.context.getController().isProprietary()) {
            this.pathsToProcess = ActionUtilities.orderPaths((TreePath[])this.pathsToProcess, (WhiteboardContext)this.context);
            if (choice.getFilter() == this.wbFilter) {
                saveProcessor = new WBDSaveProcessor(this.context);
            } else if (choice.getFilter() == this.wpFilter) {
                saveProcessor = new WBDSaveProcessor(this.context);
            }
            if (choice.getFilter() == this.pdfFilter) {
                saveProcessor = new PDFSaveProcessor(this.context);
            } else if (choice.getFilter() == this.imgFilter) {
                saveProcessor = new ImageSaveProcessor(this.context);
            }
            saveProcessor.setPathsToProcess(this.pathsToProcess);
            saveProcessor.setDepth(this.selectedDepth);
            saveProcessor.setFileToSave(this.fileToSave);
            if (!((ControllerPane)this.context.getController()).isProprietary()) {
                FileUtils.saveThisFile(this.context, this.fileToSave.getPath(), saveProcessor);
                if (!saveProcessor.getFileSaveError()) {
                    this.context.fileToSave = this.fileToSave;
                }
            }
            ((WhiteboardBean)this.context.getBean()).saveComplete();
        }
    }

    private int screenCount(ScreenModel[] screens) {
        int screenCount = 0;
        for (int i = 0; screens != null && i < screens.length; ++i) {
            ScreenModel[] screenArray;
            if (!(screens[i] instanceof ScreenModel)) continue;
            if (!(screens[i] instanceof ScreenRoot)) {
                ++screenCount;
            }
            if ((screenArray = new ScreenModel[screens[i].getChildCount()]).length <= 0) continue;
            for (int j = 0; j < screenArray.length; ++j) {
                WBNode wbnode = screens[i].getChildAt(j);
                screenArray[j] = wbnode instanceof ScreenModel ? (ScreenModel)wbnode : null;
            }
            screenCount += this.screenCount(screenArray);
        }
        return screenCount;
    }
}

