/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.ActionEvent;

public class DistributeHSpaceAction
extends WBAbstractAction {
    ScreenModel screen;

    public DistributeHSpaceAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "DistributeHSpaceAction");
        this.setScreen(screen);
    }

    public void setScreen(ScreenModel screen) {
        this.screen = screen;
        this.setEnabled(screen != null && screen.getSelectedToolList().size() > 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        int toolCount = this.screen.getSelectedToolList().size();
        AbstractToolModel[] tools = new AbstractToolModel[toolCount];
        double widths = 0.0;
        for (i = 0; i < toolCount; ++i) {
            tools[i] = (AbstractToolModel)this.screen.getSelectedToolList().get(i);
            widths += tools[i].getNormalSize().getWidth();
        }
        double totalWidth = tools[tools.length - 1].getNormalLocation().getX() + tools[tools.length - 1].getNormalSize().getWidth() - tools[0].getNormalLocation().getX();
        double space = (totalWidth - widths) / (double)(toolCount - 1);
        double leftEdge = tools[0].getNormalLocation().getX() + tools[0].getNormalSize().getWidth() + space;
        for (i = 1; i < toolCount - 1; ++i) {
            double leftCorrection = tools[i].getNormalLocation().getX() - leftEdge;
            tools[i].setLocation(tools[i].getLocation().getX() - leftCorrection, tools[i].getLocation().getY());
            leftEdge += tools[i].getNormalSize().getWidth() + space;
        }
    }
}

