/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenGroups;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.menu.CopyScreensToGroupsAction;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.util.I18n;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

class CopyScreensToMainGroupAction
extends WBAbstractAction {
    private I18n i18n = I18n.create(CopyScreensToGroupsAction.class);
    private ScreenModel[] selectedScreens;

    public CopyScreensToMainGroupAction(WhiteboardContext context, Object menu, TreePath[] selectedScreens) {
        super(context, menu, "CopyScreensToMainGroupAction");
        boolean onlyRoomsSelected = true;
        ArrayList<WBNode> scrs = new ArrayList<WBNode>();
        WBNode[] nodes = ActionUtilities.pathsToNodes((TreePath[])selectedScreens);
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof ScreenModel)) continue;
                scrs.add(nodes[i]);
                ScreenRoot root = (ScreenRoot)((ScreenModel)nodes[i]).getRoot();
                if (root.getGroupID() != 0) continue;
                onlyRoomsSelected = false;
            }
        }
        this.selectedScreens = scrs.toArray(new ScreenModel[0]);
        this.setEnabled(context.isChair() && onlyRoomsSelected && selectedScreens != null && selectedScreens.length > 0 && this.getCurrentGroups().length != 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionUtilities.duplicateScreensToMainGroup((WhiteboardContext)this.context, (ScreenModel[])this.selectedScreens);
    }

    private ScreenRoot[] getCurrentGroups() {
        ArrayList<ScreenRoot> groups = new ArrayList<ScreenRoot>();
        ScreenGroups roots = (ScreenGroups)this.context.getDataModel().getRoot();
        for (int i = 0; i < roots.getChildCount(); ++i) {
            ScreenRoot root = (ScreenRoot)roots.getChildAt(i);
            if (root.getGroupID() == 0) continue;
            groups.add(root);
        }
        return groups.toArray(new ScreenRoot[0]);
    }
}

