/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class AlignRightAction
extends WBAbstractAction {
    ScreenModel screen;

    public AlignRightAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "AlignRightAction");
        this.setScreen(screen);
    }

    public void setScreen(ScreenModel screen) {
        this.screen = screen;
        this.setEnabled(screen != null && screen.getSelectedToolList().size() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double anchorRight;
        Iterator iter = this.screen.getSelectedToolList().iterator();
        if (this.screen.getSelectedToolCount() == 1) {
            anchorRight = this.screen.getScreenSize().width;
        } else {
            AbstractToolModel anchor = (AbstractToolModel)iter.next();
            anchorRight = anchor.getVBounds().x + anchor.getVBounds().width;
        }
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            double toolRight = tool.getVBounds().x + tool.getVBounds().width;
            if (anchorRight == toolRight) continue;
            tool.setLocation(tool.getLocation().getX() + anchorRight - toolRight, tool.getLocation().getY());
        }
    }
}

