/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.ToolStroke;
import com.elluminate.groupware.whiteboard.module.ui.LineUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class ToolStrokeEditorUI
extends AbstractToolEditorUI {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static String NO_CHANGE = i18n.getString((PropertiesEnum)StringsProperties.EDITORS_NOCHANGE);
    public static final int WIDTH_VISIBLE = 1;
    public static final int CAP_VISIBLE = 2;
    public static final int DASH_VISIBLE = 4;
    private static float[] widths = new float[]{0.0f, 1.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 14.0f, 24.0f};
    private static int[] caps = new int[]{-1, 0, 1, 2};
    private static final float DASH_LENGTH = 5.0f;
    private DashItem[] dashItems = new DashItem[]{new DashItem(Float.NaN, new float[0]), new DashItem(0.0f, new float[0]), new DashItem(0.0f, new float[]{5.0f, 5.0f})};
    private HashSet attributes = new HashSet();
    private AbstractAttribute attribute = null;
    private WhiteboardContext context;
    private JComboBox widthCombo = new JComboBox();
    private JComboBox capCombo = new JComboBox();
    private JComboBox dashCombo = new JComboBox();
    private Border lineBorder = BorderFactory.createLineBorder(Color.black, 2);
    private Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private WidthComboRenderer widthComboRenderer;
    private CapComboRenderer capComboRenderer;
    private DashComboRenderer dashComboRenderer;
    private int selectedCap = 1;
    private int selectedJoin = 1;
    private float selectedMitre = 10.0f;
    private Object dashLineStorage = null;
    private HashMap strokeSources = new HashMap();
    private boolean evaluating = false;
    private boolean haveChanges = false;

    public ToolStrokeEditorUI() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        int i;
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.widthCombo);
        this.add(this.capCombo);
        this.add(this.dashCombo);
        this.widthCombo.setFocusable(false);
        this.capCombo.setFocusable(false);
        this.dashCombo.setFocusable(false);
        this.widthCombo.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.capCombo.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.dashCombo.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.widthComboRenderer = new WidthComboRenderer();
        this.widthCombo.setRenderer(this.widthComboRenderer);
        for (i = 0; i < widths.length; ++i) {
            this.widthCombo.addItem(new Float(widths[i]));
        }
        this.capComboRenderer = new CapComboRenderer();
        this.capCombo.setRenderer(this.capComboRenderer);
        for (i = 0; i < caps.length; ++i) {
            this.capCombo.addItem(new Integer(caps[i]));
        }
        this.capCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ToolStrokeEditorUI.this.capCombo.getSelectedItem() instanceof Integer && (Integer)ToolStrokeEditorUI.this.capCombo.getSelectedItem() >= 0) {
                    ToolStrokeEditorUI.this.selectedCap = (Integer)ToolStrokeEditorUI.this.capCombo.getSelectedItem();
                } else {
                    ToolStrokeEditorUI.this.selectedCap = 0;
                }
                ToolStrokeEditorUI.this.dashCombo.invalidate();
            }
        });
        this.dashComboRenderer = new DashComboRenderer();
        this.dashCombo.setRenderer(this.dashComboRenderer);
        for (i = 0; i < this.dashItems.length; ++i) {
            this.dashCombo.addItem(this.dashItems[i]);
        }
        this.dashCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolStrokeEditorUI.this.fireChanges();
            }
        });
        this.capCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolStrokeEditorUI.this.fireChanges();
            }
        });
        this.widthCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolStrokeEditorUI.this.fireChanges();
            }
        });
    }

    public void setVisible(boolean visible, int controls) {
        if ((controls & 1) != 0 && this.widthCombo.isVisible() != visible) {
            this.widthCombo.setVisible(visible);
        }
        if ((controls & 2) != 0 && this.capCombo.isVisible() != visible) {
            this.capCombo.setVisible(visible);
        }
        if ((controls & 4) != 0 && this.dashCombo.isVisible() != visible) {
            this.dashCombo.setVisible(visible);
        }
    }

    private void fireChanges() {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.fireTabPropertiesChange(this);
        }
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public AttributeEditorInterface newInstance() {
        ToolStrokeEditorUI ui = new ToolStrokeEditorUI();
        ui.setContext(this.context);
        return ui;
    }

    public void addAttribute(AbstractAttribute attribute) {
        if (this.attribute == null) {
            this.attribute = attribute;
        }
        this.attributes.add(attribute);
        this.evaluateAttributes();
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.attributes.remove(attribute);
        this.evaluateAttributes();
        return this.attributes.isEmpty();
    }

    public void applyChanges() {
        boolean widthDiffers = false;
        boolean capDiffers = false;
        boolean dashDiffers = false;
        if (!this.haveChanges) {
            return;
        }
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            float[] dashArray;
            float dashPhase;
            widthDiffers = false;
            capDiffers = false;
            dashDiffers = false;
            ToolStroke toolStroke = (ToolStroke)iter.next();
            float width = ((Float)this.widthCombo.getSelectedItem()).floatValue();
            if (width <= 0.0f) {
                width = toolStroke.getWidth();
            } else if (width != toolStroke.getWidth()) {
                widthDiffers = true;
            }
            int cap = (Integer)this.capCombo.getSelectedItem();
            if (cap < 0) {
                cap = toolStroke.getCap();
            } else if (cap != toolStroke.getCap()) {
                capDiffers = true;
            }
            DashItem dashItem = (DashItem)this.dashCombo.getSelectedItem();
            if (dashItem.isNoChange()) {
                dashPhase = toolStroke.getDashPhase();
                dashArray = toolStroke.getDashArray();
            } else {
                if (dashItem.hasDashes()) {
                    dashPhase = dashItem.getPhase();
                    dashArray = dashItem.getDashes(width);
                } else {
                    dashPhase = 0.0f;
                    dashArray = null;
                }
                if (dashPhase != toolStroke.getDashPhase() || dashArray != toolStroke.getDashArray()) {
                    dashDiffers = true;
                }
            }
            if (!widthDiffers && !capDiffers && !dashDiffers) continue;
            toolStroke.setStroke(width, cap, toolStroke.getLineJoin(), toolStroke.getMiterLimit(), dashArray, dashPhase);
        }
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return this.attribute != null ? this.attribute.getTabName() : null;
    }

    public String getDisplayName() {
        return this.attribute != null ? this.attribute.getDisplayName() : null;
    }

    public void evaluateAttributes() {
        boolean firstTime = true;
        boolean commonWidth = this.attributes.size() > 0;
        boolean commonCap = this.attributes.size() > 0;
        boolean commonDashing = this.attributes.size() > 0;
        float width = 0.0f;
        int cap = 0;
        boolean dashing = false;
        this.evaluating = true;
        for (ToolStroke toolStroke : this.attributes) {
            if (firstTime) {
                width = toolStroke.getWidth();
                cap = toolStroke.getCap();
                dashing = toolStroke.getDashArray() != null;
                firstTime = false;
                continue;
            }
            if (width != toolStroke.getWidth()) {
                commonWidth = false;
            }
            if (cap != toolStroke.getCap()) {
                commonCap = false;
            }
            if (dashing == (toolStroke.getDashArray() != null)) continue;
            commonDashing = false;
        }
        int widthIndex = 0;
        if (commonWidth) {
            for (widthIndex = 0; widthIndex < this.widthCombo.getItemCount() && !(((Float)this.widthCombo.getItemAt(widthIndex)).floatValue() >= width); ++widthIndex) {
            }
        }
        if (this.widthCombo.getSelectedIndex() != widthIndex) {
            this.widthCombo.setSelectedIndex(widthIndex);
        }
        int capIndex = 0;
        if (commonCap) {
            for (capIndex = 0; capIndex < this.capCombo.getItemCount() && (Integer)this.capCombo.getItemAt(capIndex) != cap; ++capIndex) {
            }
        }
        if (this.capCombo.getSelectedIndex() != capIndex) {
            this.capCombo.setSelectedIndex(capIndex);
        }
        int dashIndex = 0;
        if (commonDashing) {
            for (dashIndex = this.dashCombo.getItemCount() - 1; dashIndex >= 0 && dashing != ((DashItem)this.dashCombo.getItemAt(dashIndex)).hasDashes(); --dashIndex) {
            }
        }
        if (this.dashCombo.getSelectedIndex() != dashIndex) {
            this.dashCombo.setSelectedIndex(dashIndex);
        }
        if (this.widthCombo.isEnabled() == this.attributes.isEmpty()) {
            this.widthCombo.setEnabled(!this.attributes.isEmpty());
            this.capCombo.setEnabled(!this.attributes.isEmpty());
            this.dashCombo.setEnabled(!this.attributes.isEmpty());
        }
        this.evaluating = false;
    }

    class CapComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private CapIcon icon;

        CapComboRenderer() {
            this.icon = new CapIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Integer item = (Integer)value;
            this.icon.setCapStyle(item);
            if (this.getIcon() != this.icon) {
                this.setIcon(this.icon);
            }
            if (item instanceof Integer && item >= 0) {
                if (!this.getText().equals("")) {
                    this.setText("");
                }
            } else if (!NO_CHANGE.equals(this.getText())) {
                this.setText(NO_CHANGE);
            }
            if (isSelected) {
                if (this.getBorder() != ToolStrokeEditorUI.this.lineBorder) {
                    this.setBorder(ToolStrokeEditorUI.this.lineBorder);
                }
            } else if (this.getBorder() != ToolStrokeEditorUI.this.emptyBorder) {
                this.setBorder(ToolStrokeEditorUI.this.emptyBorder);
            }
            return this;
        }
    }

    class CapIcon
    implements Icon {
        private Integer capStyle;
        private int width;
        private int height;

        public CapIcon() {
            this(new Integer(-1), 35, 15);
        }

        public CapIcon(Integer capStyle, int width, int height) {
            this.capStyle = capStyle;
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.capStyle >= 0) {
                int insetY = 2;
                int thickness = this.height - 2 * insetY;
                int baseLine = this.width - thickness + 1;
                int insetX = thickness / 2;
                g.setColor(SystemColor.textText);
                g.fillRect(x + insetX, y + insetY, baseLine, thickness);
                switch (this.capStyle) {
                    case 1: {
                        g.fillOval(x, y + insetY, thickness, thickness);
                        g.fillOval(x + this.width - thickness, y + insetY, thickness, thickness);
                        break;
                    }
                    case 2: {
                        g.fillRect(x, y + insetY, thickness, thickness);
                        g.fillRect(x + this.width - thickness, y + insetY, thickness, thickness);
                        break;
                    }
                }
            }
        }

        public void setCapStyle(Integer capStyle) {
            this.capStyle = capStyle;
        }

        public Integer getCapStyle() {
            return this.capStyle;
        }

        @Override
        public int getIconWidth() {
            if (this.capStyle < 0) {
                return 0;
            }
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    class DashComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private DashIcon icon;

        DashComboRenderer() {
            this.icon = new DashIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DashItem item = (DashItem)value;
            this.icon.setDashItem(item);
            if (this.getIcon() != this.icon) {
                this.setIcon(this.icon);
            }
            if (!Float.isNaN(item.getPhase())) {
                if (!this.getText().equals("")) {
                    this.setText("");
                }
            } else if (!NO_CHANGE.equals(this.getText())) {
                this.setText(NO_CHANGE);
            }
            if (isSelected) {
                if (this.getBorder() != ToolStrokeEditorUI.this.lineBorder) {
                    this.setBorder(ToolStrokeEditorUI.this.lineBorder);
                }
            } else if (this.getBorder() != ToolStrokeEditorUI.this.emptyBorder) {
                this.setBorder(ToolStrokeEditorUI.this.emptyBorder);
            }
            return this;
        }
    }

    class DashIcon
    implements Icon {
        private DashItem dashItem;
        private int width;
        private int height;

        public DashIcon() {
            this(toolStrokeEditorUI.dashItems[0], 20, 15);
        }

        public DashIcon(DashItem dashItem, int width, int height) {
            this.dashItem = dashItem;
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!this.dashItem.isNoChange()) {
                int yPos = y + this.height / 2;
                BasicStroke stroke = this.dashItem.hasDashes() ? new BasicStroke(2.0f, ToolStrokeEditorUI.this.selectedCap, ToolStrokeEditorUI.this.selectedJoin, ToolStrokeEditorUI.this.selectedMitre, this.dashItem.getDashes(10.0f), this.dashItem.getPhase()) : new BasicStroke(2.0f, ToolStrokeEditorUI.this.selectedCap, ToolStrokeEditorUI.this.selectedJoin, ToolStrokeEditorUI.this.selectedMitre);
                ToolStrokeEditorUI.this.dashLineStorage = LineUI.drawLine(ToolStrokeEditorUI.this.dashLineStorage, stroke, g, SystemColor.textText, x, yPos, x + this.width, yPos);
            }
        }

        public void setDashItem(DashItem dashItem) {
            this.dashItem = dashItem;
        }

        public DashItem getDashItem() {
            return this.dashItem;
        }

        @Override
        public int getIconWidth() {
            if (this.dashItem.hasDashes()) {
                return this.width;
            }
            return 0;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    class DashItem {
        float phase;
        float[] dashes;
        float[] exteriorDashes;

        public DashItem(float phase, float[] dashes) {
            this.phase = phase;
            this.dashes = dashes;
            this.exteriorDashes = new float[dashes.length];
        }

        public float getPhase() {
            return this.phase;
        }

        public float[] getDashes(float lineWidth) {
            return this.dashes;
        }

        public boolean hasDashes() {
            return this.dashes.length > 0;
        }

        public boolean isNoChange() {
            return Float.isNaN(this.phase);
        }

        public void setNoChange() {
            this.phase = Float.NaN;
        }
    }

    class WidthComboRenderer
    extends JLabel
    implements ListCellRenderer {
        private WidthIcon icon;

        WidthComboRenderer() {
            this.icon = new WidthIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Float item = (Float)value;
            this.icon.setLineWidth(item);
            if (this.getIcon() != this.icon) {
                this.setIcon(this.icon);
            }
            if (item instanceof Float && item.intValue() > 0) {
                String text = Integer.toString(item.intValue());
                if (!this.getText().equals(text)) {
                    this.setText(text);
                }
            } else if (!this.getText().equals("")) {
                this.setText("");
            }
            if (isSelected) {
                if (this.getBorder() != ToolStrokeEditorUI.this.lineBorder) {
                    this.setBorder(ToolStrokeEditorUI.this.lineBorder);
                }
            } else if (this.getBorder() != ToolStrokeEditorUI.this.emptyBorder) {
                this.setBorder(ToolStrokeEditorUI.this.emptyBorder);
            }
            return this;
        }
    }

    class WidthIcon
    implements Icon {
        private Float lineWidth;
        private int width;
        private int height;

        public WidthIcon() {
            this(new Float(0.0f), 30, 15);
        }

        public WidthIcon(Float lineWidth, int width, int height) {
            this.lineWidth = lineWidth;
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.lineWidth.intValue() < this.width) {
                g.setColor(SystemColor.textText);
                if (this.lineWidth.intValue() > 0) {
                    int offset = (int)(((float)this.width - this.lineWidth.floatValue()) / 2.0f);
                    g.fillRect(x + offset, y, this.lineWidth.intValue(), this.height);
                }
            } else {
                g.setColor(SystemColor.textText);
                g.fillRect(x, y, this.width, this.height);
            }
        }

        public void setLineWidth(Float lineWidth) {
            this.lineWidth = lineWidth;
        }

        public Float getLineWidth() {
            return this.lineWidth;
        }

        @Override
        public int getIconWidth() {
            if (this.lineWidth instanceof Float && this.lineWidth.intValue() > 0) {
                return Math.max(this.width, this.lineWidth.intValue());
            }
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

