/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.ToolColorInterface;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AlphaPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ColorPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.border.TitledBorder;

public class ToolColorEditorUI
extends AbstractToolEditorUI {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private HashSet attributes = new HashSet();
    private ColorPicker colorCombo;
    private AlphaPicker alphaCombo;
    private AbstractAttribute attribute = null;
    private WhiteboardContext context;
    private boolean evaluating = false;
    private boolean haveChanges = false;

    public ToolColorEditorUI() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        TitledBorder panelBorder = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.TOOLCOLOREDITORUI_PANELBORDERTITLE));
        this.setBorder(panelBorder);
        this.colorCombo = new ColorPicker();
        this.alphaCombo = new AlphaPicker();
        this.add((Component)this.colorCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.alphaCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.colorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolColorEditorUI.this.fireChanges();
            }
        });
        this.alphaCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolColorEditorUI.this.fireChanges();
            }
        });
    }

    private void fireChanges() {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.fireTabPropertiesChange(this);
        }
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public AttributeEditorInterface newInstance() {
        ToolColorEditorUI ui = new ToolColorEditorUI();
        ui.setContext(this.context);
        return ui;
    }

    public void addAttribute(AbstractAttribute attribute) {
        if (this.attribute == null) {
            this.attribute = attribute;
        }
        if (attribute != null && ((ToolColorInterface)attribute).getColor() != null) {
            this.attributes.add(attribute);
            this.colorCombo.makeAndAdd((Color)((ToolColorInterface)attribute).getColor());
            this.evaluateAttributes();
        }
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.attributes.remove(attribute);
        this.evaluateAttributes();
        return this.attributes.isEmpty();
    }

    public void applyChanges() {
        boolean ignoreAlpha;
        boolean ignoreColor;
        int alpha = 0;
        int rgb = 0;
        if (!this.haveChanges) {
            return;
        }
        this.haveChanges = false;
        boolean bl = ignoreColor = !(this.colorCombo.getColor() instanceof Color);
        if (!ignoreColor) {
            rgb = this.colorCombo.getColor().getRGB() & 0xFFFFFF;
        }
        boolean bl2 = ignoreAlpha = this.alphaCombo.getAlpha() < 0;
        if (!ignoreAlpha) {
            alpha = this.alphaCombo.getAlpha();
        }
        for (ToolColorInterface toolColor : this.attributes) {
            if (ignoreColor) {
                rgb = ((Color)toolColor.getColor()).getRGB() & 0xFFFFFF;
            }
            if (ignoreAlpha) {
                alpha = toolColor.getAlpha();
            }
            if (ignoreColor && ignoreAlpha) continue;
            Color color = new Color(rgb);
            toolColor.setColor((Object)color, alpha);
        }
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return this.attribute.getTabName();
    }

    public String getDisplayName() {
        return this.attribute.getDisplayName();
    }

    public void evaluateAttributes() {
        boolean commonColor = this.attributes.size() > 0;
        boolean commonAlpha = this.attributes.size() > 0;
        boolean firstTime = true;
        int rgb = 0;
        int alpha = 0;
        int test = 0;
        this.evaluating = true;
        for (ToolColorInterface toolColor : this.attributes) {
            if (firstTime) {
                alpha = toolColor.getAlpha();
                rgb = 0xFFFFFF & ((Color)toolColor.getColor()).getRGB();
                firstTime = false;
                continue;
            }
            if (alpha != toolColor.getAlpha()) {
                commonAlpha = false;
            }
            if (rgb == (test = 0xFFFFFF & ((Color)toolColor.getColor()).getRGB())) continue;
            commonColor = false;
        }
        int itemIndex = 0;
        if (commonColor && !firstTime) {
            for (itemIndex = this.colorCombo.getItemCount() - 1; !(itemIndex <= 0 || this.colorCombo.getColorAt(itemIndex) instanceof Color && (test = 0xFFFFFF & this.colorCombo.getColorAt(itemIndex).getRGB()) == rgb); --itemIndex) {
            }
        }
        if (this.colorCombo.getSelectedIndex() != itemIndex) {
            this.colorCombo.setSelectedIndex(itemIndex);
        }
        int alphaIndex = 0;
        if (commonAlpha) {
            for (alphaIndex = this.alphaCombo.getItemCount() - 1; alphaIndex > 0 && (alpha < this.alphaCombo.getAlphaAt(alphaIndex) || this.alphaCombo.getAlphaAt(alphaIndex) < 0); --alphaIndex) {
            }
        }
        if (this.alphaCombo.getSelectedIndex() != alphaIndex) {
            this.alphaCombo.setSelectedIndex(alphaIndex);
        }
        if (this.alphaCombo.isEnabled() == this.attributes.isEmpty()) {
            this.alphaCombo.setEnabled(!this.attributes.isEmpty());
        }
        if (this.colorCombo.isEnabled() == this.attributes.isEmpty()) {
            this.colorCombo.setEnabled(!this.attributes.isEmpty());
        }
        this.evaluating = false;
    }
}

