/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.ToolStroke;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickEditorPanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickMenuPicker;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.QuickEditorInterface;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuickStrokePanel
extends QuickEditorPanel
implements QuickEditorInterface {
    private final I18n i18n = I18n.create((Object)this);
    private static float[] widths = new float[]{1.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 14.0f, 24.0f};
    private static final Dimension ICON_SIZE = new Dimension(80, 28);
    private HashSet<Object> sourceNodes = new HashSet();
    private HashSet<ToolStroke> attributes = new HashSet();
    private AbstractAttribute attribute = null;
    private WhiteboardContext context;
    private WidthPicker widthPicker;
    private HashMap<String, QuickEditorInterface.RefCount> strokeSources = new HashMap();
    private boolean evaluating = false;
    private boolean haveChanges = false;

    public QuickStrokePanel(WhiteboardContext context) {
        this.setContext(context);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 0));
        this.widthPicker = new WidthPicker(this.context);
        this.widthPicker.setFocusable(false);
        this.widthPicker.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.QUICKSTROKEPANEL_STROKETIP));
        this.widthPicker.setMinimumSize(new Dimension(85, 15));
        this.add(this.widthPicker);
        this.widthPicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QuickStrokePanel.this.fireChanges();
            }
        });
    }

    public void setVisible(boolean visible, int controls) {
        if (this.widthPicker.isVisible() != visible) {
            this.widthPicker.setVisible(visible);
        }
    }

    private void fireChanges() {
        if (!this.evaluating) {
            this.haveChanges = true;
            this.fireTabPropertiesChange(this);
        }
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public AttributeEditorInterface newInstance() {
        QuickStrokePanel ui = new QuickStrokePanel(this.context);
        return ui;
    }

    public void addAttribute(AbstractAttribute attribute) {
        if (this.attribute == null) {
            this.attribute = attribute;
        }
        this.attributes.add((ToolStroke)attribute);
        this.evaluateAttributes();
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.attributes.remove(attribute);
        this.evaluateAttributes();
        return this.attributes.isEmpty();
    }

    @Override
    public void addQuickAttribute(AbstractAttribute attribute, ToolPropertiesPanel panel) {
        if (attribute.getParent() != null) {
            this.sourceNodes.add(attribute.getParent());
        }
        if (attribute.isQuickAttribute() && attribute instanceof ToolStroke) {
            String attributeGroup = attribute.getTabName();
            QuickEditorInterface.RefCount refCount = this.strokeSources.get(attributeGroup);
            if (refCount == null) {
                refCount = new QuickEditorInterface.RefCount();
                this.strokeSources.put(attributeGroup, refCount);
            }
            refCount.addRef();
            this.addAttribute(attribute);
        }
        this.validateQuickVisibility();
    }

    @Override
    public void removeQuickAttribute(AbstractAttribute attribute) {
        this.sourceNodes.remove(attribute.getParent());
        if (attribute.isQuickAttribute() && attribute instanceof ToolStroke) {
            String attributeGroup = attribute.getTabName();
            QuickEditorInterface.RefCount refCount = this.strokeSources.get(attributeGroup);
            if (refCount == null) {
                return;
            }
            refCount.removeRef();
            if (refCount.isEmpty()) {
                this.strokeSources.remove(attributeGroup);
            }
            this.removeAttribute(attribute);
        }
        this.validateQuickVisibility();
    }

    @Override
    public void validateQuickVisibility() {
        boolean visible = this.attributes.size() > 0 && this.attributes.size() == this.sourceNodes.size();
        boolean enable = this.strokeSources.size() == 1;
        this.setVisible(visible);
        this.setEnabled(enable && visible);
    }

    public void applyChanges() {
        boolean widthDiffers = false;
        if (!this.haveChanges) {
            return;
        }
        Iterator<ToolStroke> iter = this.attributes.iterator();
        while (iter.hasNext()) {
            widthDiffers = false;
            ToolStroke toolStroke = iter.next();
            float width = this.widthPicker.getSelectedWidth();
            if (width <= 0.0f) {
                width = toolStroke.getWidth();
            } else if (width != toolStroke.getWidth()) {
                widthDiffers = true;
            }
            int cap = toolStroke.getCap();
            float dashPhase = toolStroke.getDashPhase();
            float[] dashArray = toolStroke.getDashArray();
            if (!widthDiffers) continue;
            toolStroke.setStroke(width, cap, toolStroke.getLineJoin(), toolStroke.getMiterLimit(), dashArray, dashPhase);
        }
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return this.attribute != null ? this.attribute.getTabName() : null;
    }

    public String getDisplayName() {
        return this.attribute != null ? this.attribute.getDisplayName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateAttributes() {
        boolean firstTime = true;
        boolean commonWidth = this.attributes.size() > 0;
        float width = -1.0f;
        try {
            this.evaluating = true;
            for (ToolStroke toolStroke : this.attributes) {
                if (firstTime) {
                    width = toolStroke.getWidth();
                    firstTime = false;
                    continue;
                }
                if (width == toolStroke.getWidth()) continue;
                commonWidth = false;
            }
            if (!commonWidth) {
                width = -1.0f;
            }
            this.widthPicker.setSelectedWidth(width);
            this.widthPicker.setEnabled(!this.attributes.isEmpty());
        }
        finally {
            this.evaluating = false;
        }
    }

    class DashItem {
        float phase;
        float[] dashes;
        float[] exteriorDashes;

        public DashItem(float phase, float[] dashes) {
            this.phase = phase;
            this.dashes = dashes;
            this.exteriorDashes = new float[dashes.length];
        }

        public float getPhase() {
            return this.phase;
        }

        public float[] getDashes(float lineWidth) {
            return this.dashes;
        }

        public boolean hasDashes() {
            return this.dashes.length > 0;
        }

        public boolean isNoChange() {
            return Float.isNaN(this.phase);
        }

        public void setNoChange() {
            this.phase = Float.NaN;
        }
    }

    static class WidthIcon
    implements Icon {
        private int iconHeight;
        private int iconWidth;
        private float strokeWidth;

        WidthIcon(float strokeWidth, int iconWidth, int iconHeight) {
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
            this.strokeWidth = strokeWidth;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int dy = Math.max(0, Math.round(((float)this.iconHeight - this.strokeWidth) / 2.0f));
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.iconWidth, this.iconHeight);
            g.setColor(c.getForeground());
            g.fillRect(x, y + dy, this.iconWidth, Math.round(this.strokeWidth));
        }
    }

    class WidthPicker
    extends QuickMenuPicker {
        private final Map<Float, JMenuItem> widthItems;
        private final Map<JMenuItem, Float> reverse;

        WidthPicker(WhiteboardContext context) {
            super(context.getThrowableListener());
            this.widthItems = new TreeMap<Float, JMenuItem>();
            this.reverse = new HashMap<JMenuItem, Float>();
            this.setFocusable(false);
            for (float w : widths) {
                WidthIcon icon = new WidthIcon(w, ICON_SIZE.width, ICON_SIZE.height);
                JMenuItem item = this.add((String)null, icon);
                this.widthItems.put(Float.valueOf(w), item);
                this.reverse.put(item, Float.valueOf(w));
            }
        }

        @Override
        protected String getItemText(JMenuItem item) {
            Float w = this.reverse.get(item);
            if (w != null) {
                return QuickStrokePanel.this.i18n.getString((PropertiesEnum)StringsProperties.QUICKSTROKEPANEL_STROKEITEMTEXT, new Object[]{w});
            }
            return null;
        }

        public float getSelectedWidth() {
            Float w = this.reverse.get(this.getSelectedItem());
            if (w != null) {
                return w.floatValue();
            }
            return -1.0f;
        }

        public void setSelectedWidth(float w) {
            this.setSelectedItem(this.widthItems.get(Float.valueOf(w)));
        }
    }
}

