/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.gui.swing.CButtonGroup;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CRadioButtonMenuItem;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class QuickMenuPicker
extends JPanel {
    private final I18n i18n = I18n.create((Object)this);
    private final JPopupMenu menu = new JPopupMenu();
    private final CButtonGroup group = new CButtonGroup();
    private volatile boolean useCheckBoxItems;
    private Dimension prefSize = null;
    private volatile JMenuItem selectedItem = null;
    private final MouseListener popupHandler;
    private final ActionListener itemActionListener;
    private final Image backgroundLeft;
    private final Image backgroundMid;
    private final Image backgroundRight;
    private final ListenerRegistry<ChangeListener> listeners;

    public QuickMenuPicker(ThrowableListener tl) {
        this(tl, true);
    }

    public QuickMenuPicker(ThrowableListener tl, boolean useCheckBoxItems) {
        this.useCheckBoxItems = useCheckBoxItems;
        this.backgroundLeft = this.i18n.getImage((PropertiesEnum)StringsProperties.QUICKMENIPICKER_BACKGROUNDLEFT);
        this.backgroundMid = this.i18n.getImage((PropertiesEnum)StringsProperties.QUICKMENIPICKER_BACKGROUNDMID);
        this.backgroundRight = this.i18n.getImage((PropertiesEnum)StringsProperties.QUICKMENIPICKER_BACKGROUNDRIGHT);
        this.listeners = new ListenerRegistry(tl);
        this.popupHandler = this.createPopupHandler();
        this.itemActionListener = this.createItemHandler();
        Font f = this.getFont();
        this.setFont(f.deriveFont((float)f.getSize() - 2.0f));
        this.addMouseListener(this.popupHandler);
    }

    public boolean getUseCheckBoxItems() {
        return this.useCheckBoxItems;
    }

    public void setUseCheckBoxItems(boolean b) {
        this.useCheckBoxItems = b;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add((Object)l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove((Object)l);
    }

    protected void fireChangeListeners() {
        FiringFunctor<ChangeListener> ff = new FiringFunctor<ChangeListener>(){
            ChangeEvent ev = null;

            public void fire(ChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ChangeEvent(QuickMenuPicker.this);
                }
                l.stateChanged(this.ev);
            }
        };
        this.listeners.fire((FiringFunctor)ff);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public JMenuItem add(String itemText, Icon itemIcon) {
        Object item = this.useCheckBoxItems ? new CCheckBoxMenuItem(itemText, itemIcon) : new CRadioButtonMenuItem(itemText, itemIcon);
        item.addActionListener(this.itemActionListener);
        this.menu.add((JMenuItem)item);
        this.group.add((AbstractButton)item);
        return item;
    }

    public void clearSelection() {
        this.setSelectedItem(null);
    }

    protected JMenuItem getSelectedItem() {
        return this.selectedItem;
    }

    protected void setSelectedItem(JMenuItem item) {
        if (item == this.selectedItem) {
            return;
        }
        if (item != null) {
            item.setSelected(true);
        } else {
            this.group.clearSelection();
        }
        this.selectedItem = item;
        this.fireChangeListeners();
        this.repaint();
    }

    protected String getItemText(JMenuItem item) {
        if (item != null) {
            return item.getText();
        }
        return null;
    }

    public String getText() {
        return this.getItemText(this.selectedItem);
    }

    public void showMenuPicker() {
        JMenuItem item;
        Insets ins = this.getInsets();
        Dimension menuDim = this.menu.getPreferredSize();
        int imgWidthLeft = this.backgroundLeft == null ? 0 : this.backgroundLeft.getWidth(this);
        int imgWidthRight = this.backgroundRight == null ? 0 : this.backgroundRight.getWidth(this);
        int x = ins.left + imgWidthLeft;
        int y = ins.top;
        if (menuDim != null) {
            x = this.getWidth() - ins.right - imgWidthRight - menuDim.width - 2;
        }
        if ((item = this.getSelectedItem()) != null) {
            Point p = SwingUtilities.convertPoint(item, 0, 0, this.menu);
            int h = item.getHeight();
            if (h < 1) {
                p.y = 1;
                for (Component cmp : this.menu.getComponents()) {
                    Dimension dim = cmp.getPreferredSize();
                    if (cmp == item) {
                        h = dim.height;
                        break;
                    }
                    if (!cmp.isVisible()) continue;
                    p.y += dim.height + 1;
                }
            }
            y += (this.getHeight() - ins.top - ins.bottom - h) / 2 - p.y;
        }
        this.menu.show(this, x, y);
    }

    @Override
    public void setPreferredSize(Dimension prefSize) {
        this.prefSize = prefSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        Insets ins = this.getInsets();
        Dimension min = this.getMinimumSize();
        Dimension max = this.getMaximumSize();
        int imgHeight = this.backgroundLeft == null ? 0 : this.backgroundLeft.getHeight(this);
        int imgWidthLeft = this.backgroundLeft == null ? 0 : this.backgroundLeft.getWidth(this);
        int imgWidthRight = this.backgroundRight == null ? 0 : this.backgroundRight.getWidth(this);
        int padWidth = imgWidthLeft + imgWidthRight + 4;
        int prefWidth = Math.max(padWidth, min == null ? 0 : min.width);
        int prefHeight = Math.max(imgHeight, min == null ? 0 : min.height);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int h = fm.getAscent() + fm.getDescent();
        if (h > prefHeight) {
            prefHeight = h;
        }
        for (Component cmp : this.menu.getComponents()) {
            int w;
            String text;
            if (!(cmp instanceof JMenuItem) || (text = this.getItemText((JMenuItem)cmp)) == null || (w = fm.stringWidth(text) + padWidth) <= prefWidth) continue;
            prefWidth = w;
        }
        if (max != null) {
            if (prefWidth > max.width) {
                prefWidth = max.width;
            }
            if (prefHeight > max.height) {
                prefHeight = max.height;
            }
        }
        return new Dimension(prefWidth, prefHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        String text = this.getText();
        Graphics g2 = null;
        try {
            g2 = g.create();
            if (this.isOpaque()) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g2.setClip(ins.left, ins.top, w, h);
            int imgWidthLeft = this.backgroundLeft == null ? 0 : this.backgroundLeft.getWidth(this);
            int imgWidthRight = this.backgroundRight == null ? 0 : this.backgroundRight.getWidth(this);
            int imgWidthMid = this.backgroundMid == null ? 0 : this.backgroundMid.getWidth(this);
            int imgHeight = this.backgroundLeft == null ? 0 : this.backgroundLeft.getHeight(this);
            int imgY = ins.top + Math.max(0, (h - imgHeight) / 2);
            if (imgWidthLeft > 0) {
                g2.drawImage(this.backgroundLeft, ins.left, imgY, this);
            }
            if (imgWidthMid > 0) {
                for (int x = ins.left + imgWidthLeft; x < ins.left + w - imgWidthRight; x += imgWidthMid) {
                    g2.drawImage(this.backgroundMid, x, imgY, this);
                }
            }
            if (imgWidthRight > 0) {
                g2.drawImage(this.backgroundRight, ins.left + w - imgWidthRight, imgY, this);
            }
            if (text != null) {
                Font f = this.getFont();
                FontMetrics fm = g2.getFontMetrics(f);
                int textHeight = fm.getAscent() + fm.getDescent();
                int x = ins.left + imgWidthLeft + 2;
                int y = ins.top + fm.getAscent() + Math.max(0, (h - textHeight + 1) / 2);
                g2.setClip(x, ins.top, w - imgWidthLeft - imgWidthRight - 4, h);
                g2.setColor(this.getForeground());
                g2.setFont(f);
                g2.drawString(text, x, y);
            }
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    protected MouseListener createPopupHandler() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                QuickMenuPicker.this.showMenuPicker();
            }
        };
    }

    protected ActionListener createItemHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JMenuItem item;
                if (ev.getSource() instanceof JMenuItem && (item = (JMenuItem)ev.getSource()).isSelected()) {
                    QuickMenuPicker.this.setSelectedItem(item);
                }
            }
        };
    }
}

