/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.SaveProcessor;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class WBDSaveDialog
extends CDialog
implements ProgressUpdate {
    private final I18n i18n = I18n.create((Object)((Object)this));
    private WhiteboardContext context;
    private int modalReturn = 64;
    private Point origin;
    private int delta = 0;
    JPanel panel = new JPanel();
    GridBagLayout progressLayout = new GridBagLayout();
    JLabel fileName = new JLabel();
    JButton cancelButton = new JButton();
    JLabel readLabel = new JLabel();
    JProgressBar writeProgress = new JProgressBar();
    JProgressBar progress = null;
    String progressName;
    int nameWidth = 0;
    int progressValue = 0;
    SaveProcessor saveProcessor;
    Thread saveThread = null;

    public WBDSaveDialog(WhiteboardContext context, Frame frame, String title, String file, boolean modal) {
        super(frame, title, modal);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.origin = frame.getLocationOnScreen();
        this.context = context;
        this.fileName.setText(file);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.progressLayout);
        this.readLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_FILEWRITING));
        this.writeProgress.setMinimumSize(new Dimension(300, 16));
        this.writeProgress.setPreferredSize(new Dimension(300, 16));
        this.writeProgress.setStringPainted(true);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.fileName, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.readLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.writeProgress, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.cancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.cancelButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_CANCEL));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WBDSaveDialog.this.saveProcessor != null) {
                    WBDSaveDialog.this.saveProcessor.endOperation();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (WBDSaveDialog.this.saveThread != null) {
                    WBDSaveDialog.this.saveThread.start();
                }
            }
        });
    }

    public void processFile(boolean b, final SaveProcessor saveProcessor) {
        Runnable saver = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WBDSaveDialog.this.progress = WBDSaveDialog.this.writeProgress;
                try {
                    saveProcessor.saveProcessor(WBDSaveDialog.this);
                }
                catch (Throwable e) {
                    WBDSaveDialog.this.setVisible(false);
                    System.gc();
                    StringBuffer details = new StringBuffer();
                    details.append(e.toString());
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        details.append("\n" + cause.toString());
                    }
                    File f = saveProcessor.getFileToSave();
                    String fn = f == null ? "" + null : f.getName();
                    String title = WBDSaveDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORWRITINGWBDTITLE);
                    String msg = WBDSaveDialog.this.i18n.getString((PropertiesEnum)StringsProperties.WBDDIALOG_ERRORWRITINGWBDMSG, new Object[]{fn, details});
                    ModalDialog.showMessageDialog((Component)WBDSaveDialog.this.context.getDialogParentFrame(), (Object)msg, (String)title, (int)0);
                    if (!(e instanceof OutOfMemoryError)) {
                        LogSupport.exception((Object)this, (String)"run", (Throwable)e, (boolean)true);
                    }
                    return;
                }
                finally {
                    WBDSaveDialog.this.setVisible(false);
                }
            }
        };
        this.saveProcessor = saveProcessor;
        this.saveThread = new WorkerThread(saver, "Whiteboard Saver");
        this.saveThread.setDaemon(true);
        Dimension paneSize = this.getSize();
        Frame appFrame = this.context.getDialogParentFrame();
        Point screenLocation = appFrame.getLocation();
        Dimension screenSize = appFrame.getSize();
        this.setLocation(screenLocation.x + (screenSize.width - paneSize.width) / 2, screenLocation.y + (screenSize.height - paneSize.height) / 2);
        if (b) {
            this.setVisible(b);
        } else {
            this.saveThread.start();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && this.saveProcessor != null) {
            this.saveProcessor.endOperation();
        }
        super.processWindowEvent(e);
    }

    public void setMaximum(final int value) {
        this.delta = value / 100;
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WBDSaveDialog.this.progress.setMaximum(value);
                }
            });
        }
    }

    public void incrementMaximum(final int increment) {
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WBDSaveDialog.this.progress.setMaximum(WBDSaveDialog.this.progress.getMaximum() + increment);
                }
            });
        }
    }

    public int getValue() {
        return this.progress != null ? this.progressValue : 0;
    }

    public void setValue(final int value) {
        if (this.progress != null && (value - this.delta >= this.progress.getValue() || value >= this.progress.getMaximum() || value < this.progress.getValue())) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WBDSaveDialog.this.progress.setValue(value);
                }
            });
        }
        this.progressValue = value;
    }

    public void setValue(WBElement element) {
        this.setValue(element.getInstanceCount());
    }

    public int getMaximum() {
        return this.progress != null ? this.progress.getMaximum() : 0;
    }

    public void setFilename(String name) {
        this.progressName = name;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WBDSaveDialog.this.fileName.setText(WBDSaveDialog.this.progressName);
            }
        });
    }
}

