/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.ImageWriterGraphics;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.flavors.InternalNodeListFlavor;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.TreePath;

public class TransferableTreePath
implements Transferable {
    public static final DataFlavor NODELIST_FLAVOR = new InternalNodeListFlavor();
    private WhiteboardContext context;
    private ArrayList<DataFlavor> flavors = new ArrayList();
    private boolean hasScreenModel = false;
    private InternalNodeListFlavor nodeListFlavor = null;
    private ArrayList<TreePath> treePaths;
    private ArrayList<WBNode> wbNodes;

    public TransferableTreePath(ArrayList<TreePath> treePaths, ArrayList<WBNode> wbNodes, WhiteboardContext context) {
        this.treePaths = treePaths;
        this.wbNodes = wbNodes;
        this.context = context;
        for (int i = 0; i < wbNodes.size(); ++i) {
            if (!(wbNodes.get(i) instanceof ScreenModel)) continue;
            this.hasScreenModel = true;
        }
        try {
            this.nodeListFlavor = new InternalNodeListFlavor(wbNodes, context);
            this.flavors.add((DataFlavor)this.nodeListFlavor);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot create an InternalNodeListFlavor", ex);
        }
        if (!this.hasScreenModel || wbNodes.size() == 1) {
            this.flavors.add(DataFlavor.imageFlavor);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[this.flavors.size()];
        flavors = this.flavors.toArray(flavors);
        return flavors;
    }

    public boolean hasScreenModel() {
        return this.hasScreenModel;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean result = false;
        for (int i = 0; i < this.flavors.size(); ++i) {
            if (!flavor.equals(this.flavors.get(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Rectangle bounds = null;
        if (flavor instanceof InternalNodeListFlavor) {
            for (int i = 0; i < this.flavors.size(); ++i) {
                InternalNodeListFlavor internalFlavor;
                if (!(this.flavors.get(i) instanceof InternalNodeListFlavor) || !InternalNodeListFlavor.isSameSession((InternalNodeListFlavor)(internalFlavor = (InternalNodeListFlavor)this.flavors.get(i)), (WhiteboardContext)this.context)) continue;
                return this.nodeListFlavor.getEncodedData();
            }
        }
        if (flavor.equals(DataFlavor.imageFlavor)) {
            WBNode wbNode = this.wbNodes.get(0);
            if (wbNode instanceof ScreenModel) {
                ScreenModel screen = (ScreenModel)wbNode;
                Dimension size = screen.getScreenSize();
                return screen.getScreenImage();
            }
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                for (AbstractToolModel abstractToolModel : this.wbNodes) {
                    if (bounds == null) {
                        bounds = abstractToolModel.getVBounds();
                        continue;
                    }
                    Rectangle.union(bounds, abstractToolModel.getVBounds(), bounds);
                }
                Iterator<WBNode> tools = this.wbNodes.iterator();
                BufferedImage image = ImageWriterGraphics.processToolToImage(null, tools, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, null, null);
                return image;
            }
        }
        return null;
    }
}

