/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.TopicElementListener;
import com.elluminate.gui.FontUtils;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;

class TopicElement
extends JLabel
implements MouseListener {
    I18n i18n = I18n.create((Object)this);
    ScreenModel screen = null;
    Font hotSpotFont = FontUtils.setFontStyleAndSize(null, (int)2, (int)14);
    Font minorHotSpotFont = FontUtils.setFontStyleAndSize(null, (int)2, (int)12);
    Font terminalFont = FontUtils.setFontStyleAndSize(null, (int)1, (int)14);
    Font minorFont = FontUtils.setFontStyleAndSize(null, (int)0, (int)10);
    boolean terminalElement = false;
    TopicElementListener elementListener;
    GridBagConstraints constraint;
    double normalWeight;

    public TopicElement(String text, Icon icon, boolean screenGroup, ScreenModel screen, boolean terminalElement, GridBagConstraints constraint, TopicElementListener elementListener) {
        super(icon, 2);
        if (!terminalElement) {
            this.setText(text + ">");
        } else {
            this.setText(text);
        }
        this.screen = screen;
        this.elementListener = elementListener;
        this.constraint = constraint;
        this.normalWeight = constraint.weightx;
        this.terminalElement = terminalElement;
        this.setFont(terminalElement ? this.terminalFont : this.minorFont);
        if (screenGroup) {
            this.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPICELEMENT_GROUPTIP));
        } else {
            this.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPICELEMENT_TOPICTIP));
        }
        this.addMouseListener(this);
        this.setOpaque(false);
    }

    public ScreenModel getScreen() {
        return this.screen != null && this.screen.isConferenceNode() ? this.screen : null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.elementListener.isNavigable()) {
            this.setForeground(Color.blue);
        }
        this.setFont(this.terminalElement ? this.hotSpotFont : this.minorHotSpotFont);
        this.constraint.weightx = 0.0;
        ((GridBagLayout)this.getParent().getLayout()).setConstraints(this, this.constraint);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setForeground(Color.black);
        this.setFont(this.terminalElement ? this.terminalFont : this.minorFont);
        this.constraint.weightx = this.normalWeight;
        ((GridBagLayout)this.getParent().getLayout()).setConstraints(this, this.constraint);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.elementListener.isNavigable()) {
            TopicElement element = (TopicElement)e.getSource();
            this.elementListener.onTopicElementSelection(element.getScreen(), this, e.getClickCount(), e.getX(), element.getLocation().y + element.getHeight());
        }
    }
}

