/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.util.SwingRunnerSupport;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JButton;

public class TimedButton
extends JButton {
    long startDelay = 1000L;
    long repeatDelay = 250L;
    Timer timer = null;

    public TimedButton() {
        this(null, null);
    }

    public TimedButton(Icon icon) {
        this(null, icon);
    }

    public TimedButton(String text) {
        this(text, null);
    }

    public TimedButton(String text, Icon icon) {
        super(text, icon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TimedButton.this.timer = new Timer(true);
                TimedButton.this.timer.scheduleAtFixedRate((TimerTask)new ButtonTimerTask(), TimedButton.this.startDelay, TimedButton.this.repeatDelay);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TimedButton.this.timer != null) {
                    TimedButton.this.timer.cancel();
                }
                TimedButton.this.timer = null;
            }
        });
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(long delay) {
        this.startDelay = delay;
    }

    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(long delay) {
        this.repeatDelay = delay;
    }

    public class ButtonTimerTask
    extends TimerTask {
        @Override
        public void run() {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TimedButton.this.getModel().isPressed()) {
                        TimedButton.this.fireActionPerformed(new ActionEvent(TimedButton.this, 1001, "Pressed"));
                    } else {
                        if (TimedButton.this.timer != null) {
                            TimedButton.this.timer.cancel();
                        }
                        TimedButton.this.timer = null;
                    }
                }
            });
        }
    }
}

