/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ScreenRelationPanel
extends JPanel {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static int[] buttonList = new int[]{1, 2, 4, ActionUtilities.SUBTOPIC};
    private TitledBorder screenCreationBorder;
    private ButtonGroup creationButtonGroup = new ButtonGroup();
    private JRadioButton createAfter = new JRadioButton();
    private JRadioButton createAtEnd = new JRadioButton();
    private JRadioButton createBefore = new JRadioButton();
    private JRadioButton createSubTopic = new JRadioButton();
    private ButtonModel savedButtonModel;
    private boolean twoLine = false;
    private LinkedList listeners = new LinkedList();

    public ScreenRelationPanel(String title, int buttonDefault, boolean twoLine) {
        try {
            this.twoLine = twoLine;
            this.jbInit();
            this.setTitle(title);
            this.setButtonSelected(buttonDefault);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void jbInit() throws Exception {
        if (this.twoLine) {
            this.setLayout(new GridLayout(2, 2, 6, 0));
        } else {
            this.setLayout(new GridLayout(1, 4, 6, 0));
        }
        this.screenCreationBorder = new TitledBorder("");
        this.setBorder(BorderFactory.createCompoundBorder(this.screenCreationBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.createAfter.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENRELATIONPANEL_AFTERCURRENT));
        this.createAtEnd.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENRELATIONPANEL_ATEND));
        this.createBefore.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENRELATIONPANEL_BEFORECURRENT));
        this.creationButtonGroup.add(this.createAfter);
        this.creationButtonGroup.add(this.createBefore);
        this.creationButtonGroup.add(this.createAtEnd);
        this.add(this.createAfter);
        this.add(this.createBefore);
        this.add(this.createAtEnd);
        this.savedButtonModel = this.creationButtonGroup.getSelection();
    }

    public int getSelectedRelation() {
        if (this.createAfter.isSelected()) {
            return 1;
        }
        if (this.createAtEnd.isSelected()) {
            return 2;
        }
        if (this.createBefore.isSelected()) {
            return 4;
        }
        return ActionUtilities.SUBTOPIC;
    }

    public void setButtonText(String text, int buttonIndex) {
        JRadioButton button;
        switch (buttonIndex) {
            case 1: {
                button = this.createAfter;
                break;
            }
            case 2: {
                button = this.createAtEnd;
                break;
            }
            case 4: {
                button = this.createBefore;
                break;
            }
            case 8: {
                button = this.createSubTopic;
                break;
            }
            default: {
                return;
            }
        }
        button.setText(text);
    }

    public int setButtonSelected(int buttonIndex) {
        int result = -1;
        block6: for (int i = 0; i < buttonList.length; ++i) {
            switch (buttonList[i]) {
                case 1: {
                    if (!this.createAfter.isEnabled()) continue block6;
                    if ((buttonIndex & buttonList[i]) != 0) {
                        this.createAfter.setSelected(true);
                        return -1;
                    }
                    if (result >= 0) continue block6;
                    result = i;
                    continue block6;
                }
                case 2: {
                    if ((buttonIndex & buttonList[i]) == 0) continue block6;
                    if (this.createAtEnd.isEnabled()) {
                        this.createAtEnd.setSelected(true);
                        return -1;
                    }
                    if (result >= 0) continue block6;
                    result = i;
                    continue block6;
                }
                case 4: {
                    if ((buttonIndex & buttonList[i]) == 0) continue block6;
                    if (this.createBefore.isEnabled()) {
                        this.createBefore.setSelected(true);
                        return -1;
                    }
                    if (result >= 0) continue block6;
                    result = i;
                    continue block6;
                }
                case 8: {
                    if ((buttonIndex & buttonList[i]) == 0) continue block6;
                    if (this.createSubTopic.isEnabled()) {
                        this.createSubTopic.setSelected(true);
                        return -1;
                    }
                    if (result >= 0) continue block6;
                    result = i;
                    continue block6;
                }
            }
        }
        return result;
    }

    public void enableButtons(boolean enable, int buttonMask) {
        if ((buttonMask & 1) != 0) {
            this.createAfter.setEnabled(enable);
        }
        if ((buttonMask & 2) != 0) {
            this.createAtEnd.setEnabled(enable);
        }
        if ((buttonMask & 4) != 0) {
            this.createBefore.setEnabled(enable);
        }
        if ((buttonMask & ActionUtilities.SUBTOPIC) != 0) {
            if (enable) {
                // empty if block
            }
            this.createSubTopic.setEnabled(false);
        }
    }

    public void addActionListener(ActionListener l) {
        this.createAfter.addActionListener(l);
        this.createAtEnd.addActionListener(l);
        this.createBefore.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.createAfter.removeActionListener(l);
        this.createAtEnd.removeActionListener(l);
        this.createBefore.removeActionListener(l);
    }

    public void setTitle(String title) {
        this.screenCreationBorder.setTitle(title);
    }

    public void saveSettings() {
        this.savedButtonModel = this.creationButtonGroup.getSelection();
    }

    public void restoreSettings() {
        this.creationButtonGroup.setSelected(this.savedButtonModel, true);
    }
}

