/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.PenToolModel;
import com.elluminate.groupware.whiteboard.tools.PenUIInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class PenUI
extends AbstractUI
implements PenUIInterface {
    private int lastX = 0;
    private int lastY = 0;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private Rectangle createRect = new Rectangle();

    public void draw(Graphics g, AbstractToolModel tool) {
        PenToolModel penTool = (PenToolModel)tool;
        GeneralPath path = (GeneralPath)tool.getUIData();
        if (path == null || penTool.isUIInvalid()) {
            path = this.makePath(penTool);
            tool.setUIData((Object)path);
            if (penTool.getUIData() == null) {
                return;
            }
            penTool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor((Color)penTool.getColor().getColor());
        try {
            g2.setStroke((BasicStroke)penTool.getStroke().getStroke());
            g2.draw(path);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    public GeneralPath makePath(PenToolModel pen) {
        short[] path = pen.getPath().getPath();
        if (path == null) {
            return null;
        }
        float x1 = (float)pen.getLocation().getX();
        float y1 = (float)pen.getLocation().getY();
        GeneralPath newPath = new GeneralPath(1, path.length);
        float scaleX = pen.getPath().getScaleX();
        float scaleY = pen.getPath().getScaleY();
        for (int i = 0; i < path.length; i += 2) {
            float x = (float)path[i] * scaleX + x1;
            float y = (float)path[i + 1] * scaleY + y1;
            if (i == 0) {
                newPath.moveTo(x, y);
                continue;
            }
            newPath.lineTo(x, y);
        }
        return newPath;
    }

    public Object makePath(Object path, int x, int y, float width, PenToolModel pen, ControllerPaneInterface pane) {
        GeneralPath newPath;
        int pad = (int)Math.ceil((double)width / 2.0) + 1;
        if (path == null) {
            newPath = new GeneralPath(1, 1024);
            newPath.moveTo(x, y);
            ((ControllerPane)pane).repaint(x - pad, y - pad, 2 * pad, 2 * pad);
        } else {
            newPath = (GeneralPath)path;
            newPath.lineTo(x, y);
            ((ControllerPane)pane).repaint(Math.min(x, this.lastX) - pad, Math.min(y, this.lastY) - pad, Math.abs(x - this.lastX) + 2 * pad, Math.abs(y - this.lastY) + 2 * pad);
        }
        this.lastX = x;
        this.lastY = y;
        this.minX = Math.min(this.minX, x);
        this.minY = Math.min(this.minY, y);
        this.maxX = Math.max(this.maxX, x);
        this.maxY = Math.max(this.maxY, y);
        this.createRect.setBounds(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
        pen.setBounds(this.createRect);
        return newPath;
    }
}

