/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroupSelectionDialog
extends EasyDialog {
    private static I18n i18n = I18n.create(GroupSelectionDialog.class);
    private MultilineLabel promptLabel;
    private JButton selectButton;
    private TreeMap checkBoxes = new TreeMap(new Comparator(){

        public int compare(Object obj1, Object obj2) {
            int com = ((JCheckBox)obj1).getText().compareToIgnoreCase(((JCheckBox)obj2).getText());
            if (com == 0) {
                com = ((JCheckBox)obj1).getText().compareTo(((JCheckBox)obj2).getText());
            }
            return com;
        }
    });

    public GroupSelectionDialog(Frame parent, String title, ScreenRoot[] groups) {
        super((Component)parent, title);
        this.setResizable(true);
        JPanel c = new JPanel(new BorderLayout(6, 6));
        this.promptLabel = new MultilineLabel();
        this.promptLabel.setVisible(false);
        c.add((Component)this.promptLabel, "North");
        ActionListener checkBoxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupSelectionDialog.this.updateCopyButtonEnabled();
            }
        };
        for (int i = 0; i < groups.length; ++i) {
            ScreenRoot grp = groups[i];
            JCheckBox cb = new JCheckBox(grp.getDisplayName());
            cb.addActionListener(checkBoxListener);
            cb.setSelected(true);
            cb.setOpaque(false);
            this.checkBoxes.put(cb, grp);
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(Color.WHITE);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        for (JCheckBox cb : this.checkBoxes.keySet()) {
            p.add((Component)cb, gbc);
        }
        gbc.weighty = 1.0;
        p.add(Box.createVerticalGlue(), gbc);
        JScrollPane sp = new JScrollPane(p, 22, 31);
        sp.setPreferredSize(new Dimension(200, 200));
        if (Platform.getLAF() == 502) {
            sp.setBackground(null);
            sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), sp.getBorder()));
        }
        c.add((Component)sp, "Center");
        p = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets.bottom = 6;
        JButton b = new JButton(i18n.getString((PropertiesEnum)StringsProperties.GROUPSELECTIONDIALOG_ALLBUTTON));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupSelectionDialog.this.setCheckBoxesSelected(true);
            }
        });
        p.add((Component)b, gbc);
        b = new JButton(i18n.getString((PropertiesEnum)StringsProperties.GROUPSELECTIONDIALOG_NONEBUTTON));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupSelectionDialog.this.setCheckBoxesSelected(false);
            }
        });
        p.add((Component)b, gbc);
        gbc.weighty = 1.0;
        p.add(Box.createVerticalGlue(), gbc);
        c.add((Component)p, "East");
        this.setContent(c);
        this.addCancelButton(this.makeButton(0));
        this.selectButton = this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.GROUPSELECTIONDIALOG_SELECTBUTTON));
        this.addActionButton(this.selectButton, true);
        this.updateCopyButtonEnabled();
    }

    public void setPrompt(String prompt) {
        this.promptLabel.setText(prompt);
        this.promptLabel.setSize(250, Integer.MAX_VALUE);
        this.promptLabel.setVisible(prompt != null && prompt.length() != 0);
    }

    public void setButtonText(String text) {
        this.selectButton.setText(text);
    }

    private void updateCopyButtonEnabled() {
        boolean en = false;
        for (JCheckBox cb : this.checkBoxes.keySet()) {
            if (!cb.isSelected()) continue;
            en = true;
            break;
        }
        this.selectButton.setEnabled(en);
    }

    private void setCheckBoxesSelected(boolean selected) {
        for (JCheckBox cb : this.checkBoxes.keySet()) {
            cb.setSelected(selected);
        }
        this.updateCopyButtonEnabled();
    }

    public ScreenRoot[] getSelectedGroups() {
        if (this.wasCanceled()) {
            return null;
        }
        ArrayList<ScreenRoot> grps = new ArrayList<ScreenRoot>();
        for (JCheckBox cb : this.checkBoxes.keySet()) {
            if (!cb.isSelected()) continue;
            grps.add((ScreenRoot)this.checkBoxes.get(cb));
        }
        return grps.toArray(new ScreenRoot[0]);
    }
}

