/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ToolSelectionEntry;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.listeners.SelectionListener;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPopup;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlipEvent;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlipListener;
import com.elluminate.groupware.whiteboard.module.ui.TranslatedMouseEvent;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public class ControllerPaneMouseAdapter
implements FocusListener,
InputMethodListener,
KeyListener,
MouseListener,
MouseMotionListener,
SelectionListener,
ToolSlipListener {
    private static final int MOUSE_BUTTONS_DOWN_MASK = 7168;
    private ControllerPane controllerPane;
    private Point mousePressed = new Point();
    private Point mouseLocation = new Point();
    private boolean mouseDragging = false;
    private int trackingMouseButtons = 0;
    private AbstractToolModel cursorTool = null;
    private int cursorHitType = -1;
    private AbstractToolModel hitTool = null;
    private int hitType = -1;
    private AbstractToolModel[] toolsUnderCursor = new AbstractToolModel[0];
    private AbstractToolModel topToolUnderCursor = null;
    private boolean mouseInTool = false;
    private boolean editing = false;
    private int[] moveSizeTable = null;
    private HashSet pendingSelectionSet = new HashSet();
    private ToolSlipEvent toolSlipEvent;
    private AbstractToolModel keyboardTool = null;
    private WhiteboardContext context;
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean metaDown = false;
    private boolean controlDown = false;
    private boolean whiteboardAccessible = true;
    private LinkedList motionListeners = new LinkedList();
    private boolean pendingSingleClick = false;
    private ControllerPopup popup = null;
    private boolean autoScale = false;
    private LinkedList mouseListeners = new LinkedList();
    private MouseEvent lastMouseMoveEvent = null;
    private boolean toolMoving = false;

    public ControllerPaneMouseAdapter(WhiteboardContext context, ControllerPane controllerPane) {
        this.context = context;
        this.controllerPane = controllerPane;
        context.addSelectionListener((SelectionListener)this);
    }

    public void setAutoScaleMode(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public void setWhiteboardAccessible(boolean whiteboardAccessible) {
        this.whiteboardAccessible = whiteboardAccessible;
    }

    public void onSelect(AbstractToolModel tool, boolean selected) {
        if (this.keyboardTool == tool && !selected) {
            this.keyboardTool = null;
        }
        if (this.cursorTool == tool && !selected || this.context.getController().getScreen().getSelectedToolCount() == 0) {
            this.controllerPane.setCanvasCursor(this.controllerPane.getDefaultCanvasCursor());
            this.cursorTool = null;
        }
        if (this.hitTool == tool && !selected) {
            this.endEditing(this.hitTool);
        }
    }

    public AbstractToolModel getCursorTool() {
        return this.cursorTool;
    }

    @Override
    public void mousePressed(MouseEvent oldMouseEvent) {
        if (oldMouseEvent.isConsumed()) {
            return;
        }
        int eventButtonMask = 0;
        switch (oldMouseEvent.getButton()) {
            case 1: {
                eventButtonMask = 1024;
                break;
            }
            case 2: {
                eventButtonMask = 2048;
                break;
            }
            case 3: {
                eventButtonMask = 4096;
            }
        }
        if (eventButtonMask == 0) {
            return;
        }
        this.trackingMouseButtons |= eventButtonMask;
        MouseEvent e = oldMouseEvent;
        if (e.getComponent() != this.controllerPane.getCanvas()) {
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.controllerPane.getCanvas());
        }
        if (this.autoScale) {
            e = ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY());
        }
        this.fireMouseListeners(e);
        if (!this.whiteboardAccessible || this.popup != null && this.popup.isVisible()) {
            return;
        }
        this.mousePressed.setLocation(e.getX(), e.getY());
        this.getFocus();
        if (this.toolSlipEvent != null && this.toolSlipEvent.getToolTemplate() != null) {
            this.toolSlipEvent.creationMouseEvent(e);
            return;
        }
        if (this.cursorTool != null && this.cursorHitType == 9 && this.cursorTool.wantsMouse(e)) {
            this.sendMouseEvent(this.cursorTool, e.getID(), e);
        }
        if (e.isConsumed() || this.cursorTool == this.topToolUnderCursor || this.topToolUnderCursor == null || this.topToolUnderCursor.wantsMouse(e)) {
            // empty if block
        }
        if (!e.isConsumed()) {
            if (this.controllerPane.isRightButton(false, e)) {
                this.controllerPane.consumeRightButton();
                this.managePopup(oldMouseEvent);
                e.consume();
                this.trackingMouseButtons &= ~eventButtonMask & 0x1C00;
                return;
            }
            this.endDragging();
            boolean processSelectBehaviour = false;
            if (this.cursorTool == null) {
                processSelectBehaviour = this.isToolSelection(e);
            } else if (!this.cursorTool.isSelected()) {
                processSelectBehaviour = this.cursorHitType != -1 && this.cursorHitType != 9 && this.cursorHitType != 8;
            } else if (this.cursorHitType == -1 || this.cursorHitType == 9 || this.cursorHitType == 8) {
                processSelectBehaviour = this.shiftDown;
            }
            if (processSelectBehaviour && this.topToolUnderCursor != null) {
                boolean topInSelected = false;
                if (this.cursorTool != null) {
                    for (int i = 0; i < this.toolsUnderCursor.length; ++i) {
                        if (this.toolsUnderCursor[i] != this.cursorTool) continue;
                        topInSelected = true;
                        break;
                    }
                }
                if (!topInSelected || this.cursorTool == this.topToolUnderCursor) {
                    this.processSingleClick(e);
                    e.consume();
                }
            }
            if (this.cursorTool != null) {
                this.startEditing(this.cursorTool, this.cursorHitType);
            }
        }
    }

    private boolean isToolSelection(MouseEvent e) {
        boolean isNotLink = this.topToolUnderCursor == null || !this.topToolUnderCursor.isLink(e);
        return (!this.shiftDown || this.topToolUnderCursor != null && !this.topToolUnderCursor.isSelected()) && isNotLink;
    }

    public void setKeyboardTool(AbstractToolModel keyboardTool) {
        this.keyboardTool = keyboardTool;
    }

    @Override
    public void mouseClicked(MouseEvent oldMouseEvent) {
    }

    private void getFocus() {
        if (!this.controllerPane.hasFocus()) {
            this.controllerPane.requestKeyboardFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent oldMouseEvent) {
        int eventButtonMask = 0;
        switch (oldMouseEvent.getButton()) {
            case 1: {
                eventButtonMask = 1024;
                break;
            }
            case 2: {
                eventButtonMask = 2048;
                break;
            }
            case 3: {
                eventButtonMask = 4096;
            }
        }
        boolean ignoreEvent = (eventButtonMask & this.trackingMouseButtons) == 0;
        this.trackingMouseButtons &= ~eventButtonMask & 0x1C00;
        if (ignoreEvent) {
            return;
        }
        if (oldMouseEvent.isConsumed()) {
            return;
        }
        MouseEvent e = oldMouseEvent;
        if (e.getComponent() != this.controllerPane.getCanvas()) {
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.controllerPane.getCanvas());
        }
        if (this.autoScale) {
            e = ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY());
        }
        this.fireMouseListeners(e);
        this.mouseLocation.x = e.getX();
        this.mouseLocation.y = e.getY();
        if (this.toolSlipEvent != null && this.toolSlipEvent.getTool() != null) {
            this.toolSlipEvent.creationMouseEvent(e);
            return;
        }
        if (this.whiteboardAccessible && this.cursorTool != null && (this.cursorHitType == 8 || this.cursorHitType == 9)) {
            if (this.cursorTool.wantsMouse(e)) {
                this.sendMouseEvent(this.cursorTool, e.getID(), e);
            } else {
                int toolX = this.cursorTool.getToolXOffset();
                int toolY = this.cursorTool.getToolYOffset();
                e.translatePoint(-toolX, -toolY);
                switch (this.cursorTool.receivedClick(e)) {
                    case 5: {
                        this.keyboardTool = this.cursorTool;
                        break;
                    }
                    case 4: {
                        this.keyboardTool = null;
                        break;
                    }
                }
                e.translatePoint(toolX, toolY);
            }
        }
        if (!e.isConsumed()) {
            if (this.controllerPane.isRightButton(false, e)) {
                this.controllerPane.consumeRightButton();
                this.managePopup(oldMouseEvent);
                e.consume();
                return;
            }
            if (this.mouseDragging) {
                this.endSelectionProcessing();
            } else {
                this.toolsUnderCursor = this.controllerPane.getScreen().findTools(this.mouseLocation);
                if (this.toolsUnderCursor != null && this.toolsUnderCursor.length > 0) {
                    this.setToolUnderCursor(this.toolsUnderCursor[this.toolsUnderCursor.length - 1], e);
                } else {
                    this.setToolUnderCursor(null, e);
                }
                if (this.cursorTool != this.topToolUnderCursor && this.topToolUnderCursor != null && this.topToolUnderCursor.wantsMouse(e)) {
                    this.sendMouseEvent(this.topToolUnderCursor, e.getID(), e);
                }
                AbstractToolModel[] tools = this.controllerPane.getScreen().findTools(this.mouseLocation);
                if (!(!this.whiteboardAccessible || e.isConsumed() || this.hitTool != null && tools.length == 0 || e.getClickCount() != 1 || this.shiftDown || this.toolMoving)) {
                    this.processSingleClick(e);
                }
                if (this.whiteboardAccessible && this.hitTool != null) {
                    Iterator iter = this.controllerPane.getScreen().getSelectedToolListIterator();
                    while (iter.hasNext()) {
                        this.endEditing((AbstractToolModel)iter.next());
                    }
                }
            }
        }
        this.mouseDragging = false;
        this.toolMoving = false;
    }

    @Override
    public void mouseEntered(MouseEvent oldMouseEvent) {
        this.mouseEnterExit(oldMouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent oldMouseEvent) {
        this.mouseEnterExit(oldMouseEvent);
        this.topToolUnderCursor = null;
    }

    private void mouseEnterExit(MouseEvent oldMouseEvent) {
        MouseEvent e = oldMouseEvent;
        if (e.getComponent() != this.controllerPane.getCanvas()) {
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.controllerPane.getCanvas());
        }
        if (this.autoScale) {
            e = ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY());
        }
        this.fireMouseListeners(e);
        if (!this.whiteboardAccessible || this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.toolSlipEvent != null && this.toolSlipEvent.getTool() != null) {
            this.toolSlipEvent.creationMouseEvent(e);
            return;
        }
        if (this.mouseInTool && this.cursorTool != null && this.cursorTool.wantsMouse(e)) {
            this.sendMouseEvent(this.cursorTool, e.getID(), e);
            this.mouseInTool = false;
        } else if (this.topToolUnderCursor != null) {
            this.sendMouseEvent(this.topToolUnderCursor, e.getID(), e);
        }
    }

    private void managePopup(MouseEvent e) {
        if (!this.context.isPlayback()) {
            this.popup = new ControllerPopup(this.controllerPane, this.context, "Controller", this.controllerPane.getScreen());
            this.popup.setMLocation(e.getPoint());
            this.popup.show(this.controllerPane, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseDragged(MouseEvent oldEventIn) {
        int buttonsDown = oldEventIn.getModifiersEx() & 0x1C00;
        if ((buttonsDown & this.trackingMouseButtons) == 0) {
            return;
        }
        if (oldEventIn.isConsumed()) {
            return;
        }
        if (oldEventIn.getComponent() != this.controllerPane.getCanvas()) {
            oldEventIn = SwingUtilities.convertMouseEvent(oldEventIn.getComponent(), oldEventIn, this.controllerPane.getCanvas());
        }
        MouseEvent e = oldEventIn.isShiftDown() == this.shiftDown ? oldEventIn : new MouseEvent(oldEventIn.getComponent(), oldEventIn.getID(), oldEventIn.getWhen(), oldEventIn.getModifiers() | 1, oldEventIn.getX(), oldEventIn.getY(), oldEventIn.getClickCount(), this.controllerPane.isRightButton(false, oldEventIn));
        MouseEvent translatedEvent = this.autoScale ? ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY()) : e;
        if (this.autoScale) {
            e = ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY());
        }
        this.fireMouseMotionListeners(e);
        if (!this.whiteboardAccessible || this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.toolSlipEvent != null && this.toolSlipEvent.getTool() != null) {
            this.toolSlipEvent.creationMouseEvent(translatedEvent);
            return;
        }
        if (this.cursorTool != null && this.cursorHitType == 9 && this.cursorTool.wantsMouse(e)) {
            this.sendMouseEvent(this.cursorTool, 506, translatedEvent);
        }
        if (!e.isConsumed()) {
            this.mouseLocation.x = translatedEvent.getX();
            this.mouseLocation.y = translatedEvent.getY();
            if (!this.editing || this.cursorTool == null) {
                if (!this.shiftDown & !this.mouseDragging) {
                    this.context.getController().getScreen().deSelectAllTools();
                }
                this.mouseDragging = true;
                this.toolMoving = false;
                this.controllerPane.showSelectionRectangle(this.mousePressed, this.mouseLocation);
                this.addSelection(this.mousePressed, this.mouseLocation, translatedEvent);
            } else {
                this.dragTool(this.cursorTool, this.mouseLocation);
                this.controllerPane.scrollToTool(this.cursorTool);
                this.mouseDragging = false;
                this.toolMoving = true;
            }
        }
        if (oldEventIn != e && translatedEvent.isConsumed()) {
            oldEventIn.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent oldMouseEvent) {
        if (oldMouseEvent.isConsumed()) {
            return;
        }
        MouseEvent e = oldMouseEvent;
        if (e.getComponent() != this.controllerPane.getCanvas()) {
            e = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.controllerPane.getCanvas());
        }
        if (this.autoScale) {
            e = ControllerPaneMouseAdapter.scaleMouse(e, this.context.getScaleX(), this.context.getScaleY());
        }
        this.fireMouseMotionListeners(e);
        if (!this.whiteboardAccessible || this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.toolSlipEvent != null && this.toolSlipEvent.getTool() != null) {
            this.toolSlipEvent.creationMouseEvent(e);
            return;
        }
        boolean toolIsUnderCursor = false;
        this.mouseLocation.x = e.getX();
        this.mouseLocation.y = e.getY();
        this.toolsUnderCursor = this.controllerPane.getScreen().findTools(this.mouseLocation);
        if (this.toolsUnderCursor != null && this.toolsUnderCursor.length > 0) {
            this.setToolUnderCursor(this.toolsUnderCursor[this.toolsUnderCursor.length - 1], e);
        } else {
            this.setToolUnderCursor(null, e);
        }
        this.cursorHitType = -1;
        Cursor proposedToolCursor = null;
        ScreenModel screen = this.controllerPane.getScreen();
        if (screen != null && !screen.selectedToolListIsEmpty()) {
            Iterator iter = screen.getSelectedToolListIterator();
            while (iter.hasNext() && this.cursorHitType == -1) {
                this.cursorTool = (AbstractToolModel)iter.next();
                this.cursorHitType = ToolSelectionEntry.getHitType((Point)this.mouseLocation, (AbstractToolModel)this.cursorTool);
                if (this.cursorTool.wantsMouse(e)) {
                    switch (this.cursorHitType) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            this.cursorHitType = 8;
                            break;
                        }
                    }
                }
                toolIsUnderCursor = this.cursorHitType != -1;
            }
            if (!toolIsUnderCursor) {
                this.cursorTool = null;
                this.cursorHitType = -1;
            }
            if (this.cursorTool != null && this.cursorHitType == 9 && this.cursorTool.wantsMouse(e)) {
                this.sendMouseEvent(this.cursorTool, 503, e);
                proposedToolCursor = this.cursorTool.getBehaviourCursor(e);
            }
            if (this.mouseInTool && this.cursorHitType != 9) {
                if (this.cursorTool != null && this.cursorTool.wantsMouse(e)) {
                    this.sendMouseEvent(this.cursorTool, 505, e);
                }
                this.mouseInTool = false;
                proposedToolCursor = null;
            }
            proposedToolCursor = !e.isConsumed() ? (this.cursorTool != null ? ToolSelectionEntry.getCursor((int)this.cursorHitType, (AbstractToolModel)this.cursorTool) : this.controllerPane.getDefaultCanvasCursor()) : this.controllerPane.getDefaultCanvasCursor();
        }
        this.lastMouseMoveEvent = e;
        if (this.toolSlipEvent == null) {
            this.manageCursor(e, proposedToolCursor);
        }
    }

    private void updateCursorKeys(KeyEvent e) {
        if (this.lastMouseMoveEvent != null) {
            MouseEvent me = new MouseEvent(this.lastMouseMoveEvent.getComponent(), this.lastMouseMoveEvent.getID(), this.lastMouseMoveEvent.getWhen(), e.getModifiers(), this.lastMouseMoveEvent.getX(), this.lastMouseMoveEvent.getY(), this.lastMouseMoveEvent.getClickCount(), this.controllerPane.isRightButton(false, this.lastMouseMoveEvent));
            this.manageCursor(me, null);
        }
    }

    private void manageCursor(MouseEvent e, Cursor proposedToolCursor) {
        if (this.toolSlipEvent == null && proposedToolCursor == null && this.cursorTool == null) {
            proposedToolCursor = this.controllerPane.getDefaultCanvasCursor();
        }
        if (this.topToolUnderCursor != null && this.topToolUnderCursor.wantsMouse(e)) {
            proposedToolCursor = this.topToolUnderCursor.getBehaviourCursor(e);
        }
        if (proposedToolCursor != null && proposedToolCursor != this.controllerPane.getCanvasCursor()) {
            this.controllerPane.setCanvasCursor(proposedToolCursor);
        }
    }

    private void setToolUnderCursor(AbstractToolModel tool, MouseEvent e) {
        if (this.topToolUnderCursor != tool) {
            if (this.topToolUnderCursor != null && !this.topToolUnderCursor.isDeleted()) {
                this.sendMouseEvent(this.topToolUnderCursor, 505, e);
            }
            if (tool != null) {
                this.sendMouseEvent(tool, 504, e);
            }
            this.topToolUnderCursor = tool;
        }
    }

    private void endDragging() {
        if (this.mouseDragging) {
            this.controllerPane.clearSelectionRectangle();
        }
        this.mouseDragging = false;
    }

    private void dragTool(AbstractToolModel cursorTool, Point mouseLocation) {
        if (this.hitType < 0 || this.hitType >= this.moveSizeTable.length || this.hitType == -1) {
            return;
        }
        double dx = mouseLocation.x - this.mousePressed.x;
        double dy = mouseLocation.y - this.mousePressed.y;
        if (this.hitType == 9 || this.hitType == 8) {
            this.translateTools(dx, dy);
            return;
        }
        if (!cursorTool.isEditing()) {
            cursorTool.setEditing(true);
        }
        double originX = cursorTool.getEditStartRect().getCentroid().getX();
        double originY = cursorTool.getEditStartRect().getCentroid().getY();
        double editStartWidth = Math.max(1.0E-6, cursorTool.getEditStartRect().getNormalSize().getWidth());
        double editStartHeight = Math.max(1.0E-6, cursorTool.getEditStartRect().getNormalSize().getHeight());
        switch (this.hitType) {
            case 0: {
                dy = -dy;
                dx = -dx;
                originX += editStartWidth / 2.0;
                originY += editStartHeight / 2.0;
                break;
            }
            case 1: 
            case 10: {
                dy = -dy;
                dx = 0.0;
                originY += editStartHeight / 2.0;
                break;
            }
            case 2: {
                dy = -dy;
                originX -= editStartWidth / 2.0;
                originY += editStartHeight / 2.0;
                break;
            }
            case 3: 
            case 11: {
                dx = -dx;
                dy = 0.0;
                originX += editStartWidth / 2.0;
                break;
            }
            case 4: 
            case 12: {
                dy = 0.0;
                originX -= editStartWidth / 2.0;
                break;
            }
            case 5: {
                dx = -dx;
                originX += editStartWidth / 2.0;
                originY -= editStartHeight / 2.0;
                break;
            }
            case 6: 
            case 13: {
                dx = 0.0;
                originY -= editStartHeight / 2.0;
                break;
            }
            case 7: {
                originX -= editStartWidth / 2.0;
                originY -= editStartHeight / 2.0;
                break;
            }
            default: {
                cursorTool = null;
                return;
            }
        }
        double scaleX = dx / editStartWidth + 1.0;
        double scaleY = dy / editStartHeight + 1.0;
        if (this.shiftDown) {
            switch (this.hitType) {
                case 1: 
                case 6: 
                case 10: 
                case 13: {
                    scaleX = scaleY;
                    break;
                }
                case 3: 
                case 4: 
                case 11: 
                case 12: {
                    scaleY = scaleX;
                    break;
                }
            }
            if (Math.abs(scaleX) > Math.abs(scaleY)) {
                scaleY = scaleY < 0.0 ? -Math.abs(scaleX) : Math.abs(scaleX);
            } else {
                scaleX = scaleX < 0.0 ? -Math.abs(scaleY) : Math.abs(scaleY);
            }
        }
        Iterator iter = this.controllerPane.getScreen().getSelectedToolListIterator();
        while (iter.hasNext()) {
            double newHeight;
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            if (!tool.isEditing()) {
                tool.setEditing(true);
            }
            double toolWidth = tool.getEditStartRect().getSize().getWidth();
            double toolHeight = tool.getEditStartRect().getSize().getHeight();
            double centroidX = tool.getEditStartRect().getCentroid().getX() - originX;
            double centroidY = tool.getEditStartRect().getCentroid().getY() - originY;
            double newWidth = toolWidth * scaleX;
            if (Math.abs(newWidth) < 1.0E-6) {
                double d = newWidth = scaleX < 0.0 ? -1.0E-6 : 1.0E-6;
            }
            if (Math.abs(newHeight = toolHeight * scaleY) < 1.0E-6) {
                newHeight = scaleX < 0.0 ? -1.0E-6 : 1.0E-6;
            }
            double newX = (centroidX - toolWidth / 2.0) * scaleX + originX;
            double newY = (centroidY - toolHeight / 2.0) * scaleY + originY;
            tool.setRect(newX, newY, newWidth, newHeight);
        }
    }

    private void translateTools(double dx, double dy) {
        Iterator iter = this.controllerPane.getScreen().getSelectedToolListIterator();
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            if (!tool.isEditing()) {
                tool.setEditing(true);
            }
            tool.setLocation(tool.getEditStartRect().getLocation().getX() + dx, tool.getEditStartRect().getLocation().getY() + dy);
        }
        this.controllerPane.enableOffscreenMove();
    }

    private void startEditing(AbstractToolModel tool, int hitType) {
        if (tool != null) {
            boolean flipVertical;
            this.hitTool = tool;
            this.hitType = hitType;
            this.editing = true;
            this.hitTool.setEditing(true);
            boolean flipHorizontal = tool.getEditStartRect().getSize().getWidth() < 0.0;
            boolean bl = flipVertical = tool.getEditStartRect().getSize().getHeight() < 0.0;
            this.moveSizeTable = flipHorizontal ? (flipVertical ? ToolSelectionEntry.BOTH_FLIP_TABLE : ToolSelectionEntry.HORZ_FLIP_TABLE) : (flipVertical ? ToolSelectionEntry.VERT_FLIP_TABLE : ToolSelectionEntry.NORMAL_TABLE);
        }
    }

    private void endEditing(AbstractToolModel tool) {
        tool.setEditing(false);
        this.editing = false;
        this.hitTool = null;
    }

    private void sendMouseEvent(AbstractToolModel tool, int type, MouseEvent e) {
        if (tool == null || tool.isDeleted()) {
            return;
        }
        int toolX = tool.getToolXOffset();
        int toolY = tool.getToolYOffset();
        e.translatePoint(-toolX, -toolY);
        if (!this.mouseInTool) {
            this.mouseInTool = true;
            this.sendMouseEvent(tool, 504, e);
        }
        if (e.getID() != type) {
            MouseEvent event = new MouseEvent(e.getComponent(), type, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), this.controllerPane.isRightButton(false, e));
            tool.mouseEvent(event, (Component)this.controllerPane);
            if (event.isConsumed()) {
                e.consume();
            }
        } else {
            tool.mouseEvent(e, (Component)this.controllerPane);
        }
        e.translatePoint(toolX, toolY);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.shiftDown = false;
        this.altDown = false;
        this.metaDown = false;
        this.controlDown = false;
    }

    private void sendInputMethodTextChanged(InputMethodEvent event) {
        if (!this.whiteboardAccessible) {
            return;
        }
        if (this.toolSlipEvent != null) {
            this.toolSlipEvent.creationInputMethodEvent(event);
            return;
        }
    }

    private void sendKeyEvent(AbstractToolModel tool, KeyEvent event) {
        if (!this.whiteboardAccessible) {
            return;
        }
        this.shiftDown = event.isShiftDown();
        this.altDown = event.isAltDown();
        this.metaDown = event.isMetaDown();
        boolean bl = this.controlDown = (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() & event.getModifiers()) != 0;
        if (this.toolSlipEvent != null) {
            this.toolSlipEvent.creationKeyEvent(event);
            return;
        }
        if (this.keyboardTool != null && this.keyboardTool.findScreenParent() != this.controllerPane.getScreen()) {
            this.keyboardTool = null;
        }
        if (this.keyboardTool != null) {
            switch (this.keyboardTool.keyEvent(event, (Component)this.controllerPane)) {
                case 4: {
                    this.keyboardTool = null;
                    break;
                }
            }
        } else if (tool != null && tool.wantsKeyboard() && tool.isSelected()) {
            tool.keyEvent(event, (Component)this.controllerPane);
        }
        if (!event.isConsumed()) {
            this.processAcceleratorKey(event, this.controlDown);
        }
    }

    public void processAcceleratorKey(KeyEvent event, boolean controlDown) {
        if (this.context.isAccessible(this.controllerPane.getScreen()) && event.getID() == 402) {
            if (event.getModifiers() == 0 && (event.getKeyCode() == 127 || event.getKeyCode() == 8)) {
                ActionUtilities.deleteSelectedTools((ScreenModel)this.controllerPane.getScreen(), (WhiteboardContext)this.context);
            } else if (controlDown || this.controlDown) {
                if (event.isAltDown()) {
                    return;
                }
                if (event.isShiftDown()) {
                    switch (event.getKeyCode()) {
                        case 83: {
                            break;
                        }
                        case 84: {
                            this.controllerPane.postNavigator(true);
                            break;
                        }
                    }
                    return;
                }
                switch (event.getKeyCode()) {
                    case 88: {
                        break;
                    }
                    case 67: {
                        break;
                    }
                    case 86: {
                        break;
                    }
                    case 69: {
                        ActionUtilities.emptyToolClipboard((WhiteboardContext)this.context);
                        break;
                    }
                    case 71: {
                        ActionUtilities.groupSelectedTools((ScreenModel)this.controllerPane.getScreen(), (WhiteboardContext)this.context);
                        break;
                    }
                    case 66: {
                        if (!this.controllerPane.getScreen().canEditBackground()) break;
                        ActionUtilities.groupSelectedToolsToBackground((ScreenModel)this.controllerPane.getScreen(), (WhiteboardContext)this.context);
                        break;
                    }
                    case 85: {
                        ActionUtilities.ungroupSelectedTools((ScreenModel)this.controllerPane.getScreen(), (WhiteboardContext)this.context);
                        break;
                    }
                    case 65: {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onToolSlipEvent(ToolSlipEvent toolSlipEvent) {
        if (toolSlipEvent == null) {
            this.toolSlipEvent = null;
            this.controllerPane.setToolCreche(null);
            return;
        }
        switch (toolSlipEvent.getType()) {
            case 0: {
                this.toolSlipEvent = toolSlipEvent;
                this.controllerPane.setToolCreche(toolSlipEvent.getTool());
                if (toolSlipEvent.getTool() != null) {
                    this.controllerPane.setCanvasCursor(toolSlipEvent.getTool().getDrawingCursor());
                    break;
                }
                if (toolSlipEvent.getToolTemplate() == null) break;
                this.controllerPane.setCanvasCursor(toolSlipEvent.getToolTemplate().getDrawingCursor());
                break;
            }
            case 2: {
                this.toolSlipEvent = null;
                this.controllerPane.setToolCreche(null);
                this.controllerPane.setSelectMode();
                break;
            }
            case 3: {
                if (toolSlipEvent.getTool() == null || !toolSlipEvent.getTool().isInitialized() || toolSlipEvent.getContainer().isDeleted()) break;
                toolSlipEvent.getContainer().add((WBNode)toolSlipEvent.getTool());
                break;
            }
            case 1: {
                if (toolSlipEvent.getTool() != null && toolSlipEvent.getTool().isInitialized() && !toolSlipEvent.getContainer().isDeleted()) {
                    toolSlipEvent.getContainer().add((WBNode)toolSlipEvent.getTool());
                }
                this.toolSlipEvent = null;
                this.controllerPane.setToolCreche(null);
                break;
            }
        }
    }

    private void processSingleClick(MouseEvent e) {
        this.pendingSingleClick = false;
        this.mouseLocation.x = e.getX();
        this.mouseLocation.y = e.getY();
        AbstractToolModel[] tools = this.controllerPane.getScreen().findTools(this.mouseLocation);
        if (tools.length == 0) {
            if (!this.shiftDown) {
                this.controllerPane.getScreen().deSelectAllTools();
            }
        } else {
            AbstractToolModel topTool = tools[tools.length - 1];
            if (topTool.wantsMouse(e) && !this.shiftDown) {
                topTool.mouseEvent(e, (Component)this.controllerPane);
            }
            if (!e.isConsumed()) {
                if (!this.shiftDown) {
                    this.controllerPane.getScreen().deSelectAllTools();
                }
                if (this.controllerPane.getScreen().isSelected(topTool)) {
                    this.controllerPane.getScreen().deSelectTool(topTool);
                } else if (topTool.isControllerPaneSelectable()) {
                    this.controllerPane.getScreen().selectTool(topTool);
                }
            }
        }
        this.mouseMoved(e);
    }

    private void addSelection(Point press, Point cursor, MouseEvent e) {
        if (Math.abs(press.x - cursor.x) < 4 && Math.abs(press.y - cursor.y) < 4) {
            this.pendingSingleClick = true;
            return;
        }
        this.pendingSingleClick = false;
        Rectangle selectionArea = new Rectangle(press.x, press.y, cursor.x - press.x, cursor.y - press.y);
        HashSet selecting = new HashSet(this.controllerPane.getScreen().findToolSet(selectionArea));
        HashSet adding = new HashSet(selecting);
        adding.removeAll(this.pendingSelectionSet);
        for (AbstractToolModel tool : adding) {
            if (!tool.isBackground() && tool.isControllerPaneSelectable()) {
                this.controllerPane.getScreen().selectTool(tool);
            }
            this.pendingSelectionSet.add(tool);
        }
        HashSet removing = new HashSet(this.pendingSelectionSet);
        removing.removeAll(selecting);
        for (AbstractToolModel tool : removing) {
            if (!tool.isBackground()) {
                this.controllerPane.getScreen().deSelectTool(tool);
            }
            this.pendingSelectionSet.remove(tool);
        }
    }

    private void endSelectionProcessing() {
        this.controllerPane.clearSelectionRectangle();
        this.pendingSelectionSet.clear();
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.sendInputMethodTextChanged(event);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.sendKeyEvent(this.cursorTool, e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.sendKeyEvent(this.cursorTool, e);
        this.updateCursorKeys(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.sendKeyEvent(this.cursorTool, e);
        this.updateCursorKeys(e);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        if (!this.motionListeners.contains(l)) {
            this.motionListeners.add(l);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.motionListeners.remove(l);
    }

    private void fireMouseMotionListeners(MouseEvent e) {
        for (MouseMotionListener l : this.motionListeners) {
            switch (e.getID()) {
                case 503: {
                    l.mouseMoved(e);
                    break;
                }
                case 506: {
                    l.mouseDragged(e);
                    break;
                }
            }
        }
    }

    public void addMouseListener(MouseListener l) {
        if (!this.mouseListeners.contains(l)) {
            this.mouseListeners.add(l);
        }
    }

    public void removeMouseListener(MouseMotionListener l) {
        this.mouseListeners.remove(l);
    }

    private void fireMouseListeners(MouseEvent e) {
        for (MouseListener l : this.mouseListeners) {
            switch (e.getID()) {
                case 500: {
                    l.mouseClicked(e);
                    break;
                }
                case 504: {
                    l.mouseEntered(e);
                    break;
                }
                case 505: {
                    l.mouseExited(e);
                    break;
                }
                case 501: {
                    l.mousePressed(e);
                    break;
                }
                case 502: {
                    l.mouseReleased(e);
                    break;
                }
            }
        }
    }

    private static MouseEvent scaleMouse(MouseEvent event, double scaleX, double scaleY) {
        if (scaleX != 1.0 && scaleY != 1.0 && !(event instanceof TranslatedMouseEvent)) {
            double newX = Math.abs(scaleX) > 1.0E-9 ? (double)event.getX() / scaleX : (double)event.getX();
            double newY = Math.abs(scaleY) > 1.0E-9 ? (double)event.getY() / scaleY : (double)event.getY();
            int xTranslate = (int)newX - event.getX();
            int yTranslate = (int)newY - event.getY();
            TranslatedMouseEvent newEvent = new TranslatedMouseEvent(event);
            newEvent.translatePoint(xTranslate, yTranslate);
            return newEvent;
        }
        return event;
    }
}

