/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations.macos;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointLoader;
import com.elluminate.groupware.whiteboard.module.presentations.macos.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.ProgressDialog;
import com.elluminate.platform.MacOSXPlatform;
import com.elluminate.platform.Platform;
import com.elluminate.platform.VersionSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public class MacPPTLoader
implements PowerPointLoader {
    private static final String[] EXPORT_IMAGE_TYPE;
    private static final String PPT_BUNDLE_ID = "com.microsoft.Powerpoint";
    private static final String PPT_CREATOR_CODE = "PPT3";
    private static final String SUPPORTED_VERSIONS = "11+";
    private static final String WFLOW_VERSION = "12+";
    private static final String IMPORT_SCRIPT = "PPTImporter.scpt";
    private static final String COMMON_WFLOW = "PPTImporterCommon.wflow";
    private static final String BKGRND_WFLOW = "PPTImporterBkg.wflow";
    private static final String SHAPE_DATA = "shapeData.txt";
    private static final String PNG_TYPE = "PNG";
    private static final String JPEG_TYPE = "JPEG";
    private static final long IMPORT_STALL_MILLIS = 120000L;
    private static final I18n i18n;
    private static boolean loadedOK;
    private static boolean hasPPT;
    private static boolean has2007Support;
    private static boolean useAutomator;
    private static File pptAppPath;
    private static String pptAppNative;
    private static String pptVersion;
    private static Icon pptIcon;
    private final NumberFormat intParser = NumberFormat.getIntegerInstance();
    private boolean canceled = false;
    private volatile ProgressDialog postProgress = null;
    private static final int SHAPE_SOURCE_UNKNOWN = 0;
    private static final int SHAPE_SOURCE_SLIDE = 1;
    private static final int SHAPE_SOURCE_MASTER = 2;
    private static final int SHAPE_SOURCE_DESIGN = 3;
    private static final int SHAPE_TYPE_INVALID = 0;
    private static final int SHAPE_TYPE_TEXT = 1;
    private static final int SHAPE_TYPE_PICTURE = 2;
    private static final int SHAPE_TYPE_LINE = 3;
    private static final int SHAPE_TYPE_OTHER = 4;

    private static String getAppVersion(File pptApp) {
        String path = pptApp.getAbsolutePath();
        String[] versCmd = new String[]{"osascript", "-e", "tell application \"Finder\" to get the version of file (POSIX file \"" + path + "\")"};
        try {
            StringBuffer outbuf = new StringBuffer(256);
            StringBuffer errbuf = null;
            if (WhiteboardDebug.POWERPOINT.show()) {
                errbuf = new StringBuffer(1024);
            }
            int status = -1;
            for (int retries = 0; retries < 3 && status != 0; ++retries) {
                if (retries > 0) {
                    try {
                        Thread.sleep(500 * retries);
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                status = ProcessUtils.exec((String[])versCmd, (StringBuffer)outbuf, (StringBuffer)errbuf, (long)2000L, (boolean)true);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message(MacPPTLoader.class, (String)"getAppVersion", (String)("attempt=" + retries + " status=" + status + " vers='" + outbuf + "'"));
                }
                if (!outbuf.toString().equals("\n")) continue;
                status = -1160048627;
            }
            if (status != 0) {
                StringBuilder cmdText = new StringBuilder();
                for (int ix = 0; ix < versCmd.length; ++ix) {
                    if (cmdText.length() > 0) {
                        cmdText.append(" ");
                    }
                    cmdText.append(versCmd[ix]);
                }
                LogSupport.message(MacPPTLoader.class, (String)"getAppVersion", (String)("Execution failed: " + cmdText + "\n" + "Exit status: " + status + "\n" + outbuf + (errbuf == null ? "" : "\n=====\n" + errbuf)));
                return null;
            }
            return outbuf.toString();
        }
        catch (Throwable t) {
            LogSupport.message(MacPPTLoader.class, (String)"getAppVersion", (String)("Exception getting version of " + path + ": " + Debug.getStackTrace((Throwable)t)));
            return null;
        }
    }

    private static String stripAppVersion(String version) {
        if (version == null) {
            return null;
        }
        String VERSION_CHARS = "0123456789._-";
        int pos1 = StringUtils.search((String)version, (String)"0123456789._-");
        if (pos1 < 0) {
            return null;
        }
        int pos2 = StringUtils.verify((String)version, (int)pos1, (String)"0123456789._-");
        if (pos2 < 0) {
            pos2 = version.length();
        }
        if (pos2 < pos1) {
            return null;
        }
        return version.substring(pos1, pos2);
    }

    private static boolean isVersionSupported() {
        if (pptVersion == null) {
            return false;
        }
        return VersionSupport.matchVersion((String)pptVersion, (String)SUPPORTED_VERSIONS);
    }

    @Override
    public boolean isAvailable() {
        if (!Platform.checkOSVersion((int)202, (String)"10.3+")) {
            return false;
        }
        return hasPPT;
    }

    @Override
    public boolean isXMLSupported() {
        return this.isAvailable() && has2007Support && this.isAvailable();
    }

    @Override
    public void load(File exportPath, File pptFile, File metaData, int slideType, int wbWidth, int wbHeight) {
        File shapeFile;
        File notesFile;
        File exportLog;
        boolean dumpLog;
        int err;
        long t0;
        block27: {
            this.canceled = false;
            if (!exportPath.exists()) {
                exportPath.mkdirs();
            }
            if (!exportPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid export directory: " + exportPath);
            }
            t0 = System.currentTimeMillis();
            err = -1;
            dumpLog = false;
            try {
                err = this.doExportPPT(exportPath, pptFile, metaData, slideType, "" + wbWidth, "" + wbHeight);
                if (err == 0) break block27;
                dumpLog = true;
            }
            catch (IOException iox) {
                try {
                    dumpLog = true;
                    throw new RuntimeException("Error processing presentation", iox);
                }
                catch (Throwable throwable) {
                    File exportLog2;
                    long dt = System.currentTimeMillis() - t0;
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"load", (String)("Exporter elapsed time: " + (double)dt / 1000.0 + " seconds"));
                        LogSupport.message((Object)this, (String)"load", (String)("Exporter exit code: " + err));
                        try {
                            String[] cmd = new String[]{"ls", "-l", exportPath.getAbsolutePath()};
                            StringBuffer buf = new StringBuffer();
                            int status = ProcessUtils.exec((String[])cmd, (StringBuffer)buf, (StringBuffer)buf, (long)5000L, (boolean)true);
                            LogSupport.message((Object)this, (String)"load", (String)(exportPath + ":\n" + buf));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        dumpLog = true;
                    }
                    if (dumpLog && (exportLog2 = new File(exportPath, "exportlog.txt")).exists()) {
                        MacPPTLoader.dumpFileToConsole(exportLog2);
                    }
                    throw throwable;
                }
            }
        }
        long dt = System.currentTimeMillis() - t0;
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"load", (String)("Exporter elapsed time: " + (double)dt / 1000.0 + " seconds"));
            LogSupport.message((Object)this, (String)"load", (String)("Exporter exit code: " + err));
            try {
                String[] cmd = new String[]{"ls", "-l", exportPath.getAbsolutePath()};
                StringBuffer buf = new StringBuffer();
                int status = ProcessUtils.exec((String[])cmd, (StringBuffer)buf, (StringBuffer)buf, (long)5000L, (boolean)true);
                LogSupport.message((Object)this, (String)"load", (String)(exportPath + ":\n" + buf));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            dumpLog = true;
        }
        if (dumpLog && (exportLog = new File(exportPath, "exportlog.txt")).exists()) {
            MacPPTLoader.dumpFileToConsole(exportLog);
        }
        if (err == Integer.MIN_VALUE) {
            String msg = i18n.getString((PropertiesEnum)StringsProperties.MACPPTLOADER_TIMEOUTWARNINGMSG);
            ModalDialog.showMessageDialog((Component)MacPPTLoader.findParent(), (Object)msg);
        } else if (err != 0) {
            throw new RuntimeException("Error calling AppleScript: " + err);
        }
        if (WhiteboardDebug.POWERPOINT.show() && (notesFile = new File(exportPath, "notesdat.tmp")).exists()) {
            MacPPTLoader.dumpFileToConsole(notesFile);
        }
        if ((shapeFile = new File(exportPath, SHAPE_DATA)).isFile()) {
            Runnable r;
            block28: {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    MacPPTLoader.dumpFileToConsole(shapeFile);
                }
                long t1 = System.currentTimeMillis();
                try {
                    r = new Runnable(){
                        private ActionListener cancelHandler = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                MacPPTLoader.this.canceled = true;
                            }
                        };

                        @Override
                        public void run() {
                            if (MacPPTLoader.this.postProgress != null) {
                                MacPPTLoader.this.postProgress.setVisible(false);
                            }
                            Component parent = MacPPTLoader.findParent();
                            MacPPTLoader.this.postProgress = new ProgressDialog(parent, (Object)i18n.getString((PropertiesEnum)StringsProperties.MACPPTLOADER_POSTPROGRESSMESSAGE), i18n.getString((PropertiesEnum)StringsProperties.MACPPTLOADER_POSTPROGRESSTITLE), i18n.getString((PropertiesEnum)StringsProperties.MACPPTLOADER_POSTPROGRESSINITNOTE));
                            MacPPTLoader.this.postProgress.setAutoHideEnabled(false);
                            MacPPTLoader.this.postProgress.addCancelListener(this.cancelHandler);
                            MacPPTLoader.this.postProgress.pack();
                            MacPPTLoader.this.postProgress.setVisible(true);
                        }
                    };
                    SwingRunnerSupport.invokeOnEventThread((Runnable)r);
                    this.postProcessShapes(exportPath, shapeFile, slideType, wbWidth, wbHeight);
                    if (!WhiteboardDebug.POWERPOINT.show()) break block28;
                    long dt2 = System.currentTimeMillis() - t1;
                    LogSupport.message((Object)this, (String)"load", (String)("Shape post-processing elapsed time: " + (double)dt2 / 1000.0 + " seconds"));
                    dt2 = System.currentTimeMillis() - t0;
                    LogSupport.message((Object)this, (String)"load", (String)("Total elapsed time: " + (double)dt2 / 1000.0 + " seconds"));
                }
                catch (IOException iox) {
                    try {
                        if (!dumpLog) {
                            dumpLog = true;
                            File exportLog3 = new File(exportPath, "exportlog.txt");
                            if (exportLog3.exists()) {
                                MacPPTLoader.dumpFileToConsole(exportLog3);
                            }
                        }
                        throw new RuntimeException("Error post-processing shape file", iox);
                    }
                    catch (Throwable throwable) {
                        Runnable r2 = new Runnable(){

                            @Override
                            public void run() {
                                if (MacPPTLoader.this.postProgress != null) {
                                    MacPPTLoader.this.postProgress.setVisible(false);
                                    MacPPTLoader.this.postProgress = null;
                                }
                            }
                        };
                        SwingRunnerSupport.invokeLater((Runnable)r2);
                        throw throwable;
                    }
                }
            }
            r = new /* invalid duplicate definition of identical inner class */;
            SwingRunnerSupport.invokeLater((Runnable)r);
        }
        if (this.canceled) {
            throw new PowerPointImport.CancelledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpFileToConsole(File f) {
        LogSupport.message((String)("******** Contents of " + f.getName()));
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            while (true) {
                String text = null;
                try {
                    text = br.readLine();
                }
                catch (EOFException eofx) {
                    break;
                }
                if (text == null) {
                    break;
                }
                LogSupport.message((String)text);
            }
        }
        catch (Throwable t) {
            LogSupport.message((String)("Error processing output: " + Debug.getStackTrace((Throwable)t)));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable t) {}
            }
        }
        LogSupport.message((String)("******** End of " + f.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void postProcessShapes(File exportPath, File shapeFile, int quality, int wbWidth, int wbHeight) throws IOException {
        fr = null;
        br = null;
        text = null;
        shapeList = new ArrayList<ShapeInfo>();
        slide = null;
        curSlideNo = 0;
        try {
            fr = new FileReader(shapeFile);
            br = new BufferedReader(fr);
            header = br.readLine();
            nSlides = this.parseCountFromHeader(header);
            setRange = false;
            while (true) {
                if (this.canceled) {
                    throw new PowerPointImport.CancelledException();
                }
                text = null;
                try {
                    text = br.readLine();
                }
                catch (EOFException eofx) {
                    break;
                }
                if (text == null) {
                    break;
                }
                if (text.trim().equals("") || !(parser = new StringTokenizer(text)).hasMoreTokens()) continue;
                cmd = parser.nextToken();
                if (cmd.equalsIgnoreCase("slide")) {
                    try {
                        slide = this.parseSlide(parser);
                        curSlideNo = slide.slideNo;
                    }
                    catch (Exception ex) {
                        LogSupport.message((Object)this, (String)"postProcessShapes", (String)("Error parsing slide " + (curSlideNo + 1)));
                        throw new RuntimeException("Error parsing slide", ex);
                    }
                    shapeList.clear();
                    dlg = this.postProgress;
                    if (dlg == null) continue;
                    if (!setRange && nSlides > 0) {
                        dlg.setRange(0, nSlides);
                        setRange = true;
                    }
                    note = MacPPTLoader.i18n.getString((PropertiesEnum)StringsProperties.MACPPTLOADER_POSTPROGRESSNOTE, new Object[]{slide.slideNo, nSlides});
                    dlg.setProgress(slide.slideNo, note);
                    continue;
                }
                if (cmd.equalsIgnoreCase("shape")) {
                    si = null;
                    try {
                        si = this.parseShape(parser, exportPath);
                    }
                    catch (Exception ex) {
                        curShapeNo = shapeList.size() + 1;
                        LogSupport.message((Object)this, (String)"postProcessShapes", (String)("Error parsing shape " + curShapeNo + " of slide " + (curSlideNo + 1)));
                        throw new RuntimeException("Error parsing shape", ex);
                    }
                    if (si == null) continue;
                    pos = shapeList.size();
                    for (ix = 0; ix < shapeList.size(); ++ix) {
                        s2 = shapeList.get(ix);
                        if (si.z >= s2.z) continue;
                        pos = ix;
                        break;
                    }
                    shapeList.add(pos, si);
                    continue;
                }
                if (cmd.equalsIgnoreCase("EndSlide")) {
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"postProcessShapes", (String)("Compositing shapes: " + shapeList));
                    }
                    slideImage = null;
                    try {
                        slideImage = this.compositeSlide(exportPath, slide, shapeList, quality, wbWidth, wbHeight);
                        switch (quality) {
                            case 2: 
                            case 3: {
                                f = new File(exportPath, "Slide" + slide.slideNo + ".png");
                                this.saveSlideImage((BufferedImage)slideImage, "PNG", f);
                                if (quality == 3) {
                                    ** break;
lbl73:
                                    // 1 sources

                                    break;
                                }
                            }
                            default: {
                                f = new File(exportPath, "Slide" + slide.slideNo + ".jpg");
                                this.saveSlideImage((BufferedImage)slideImage, "JPEG", f);
                                break;
                            }
                        }
                    }
                    finally {
                        if (slideImage != null) {
                            slideImage.flush();
                        }
                    }
                    shapeList.clear();
                    continue;
                }
                if (cmd.equalsIgnoreCase("end")) continue;
                LogSupport.message((Object)this, (String)"postProcessShapes", (String)("Invalid command '" + cmd + "' found in '" + text + "'"));
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable t) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private int parseCountFromHeader(String header) {
        int result = -1;
        int pos = StringUtils.verify((String)header, (String)"0123456789");
        if (pos > 0) {
            try {
                result = Integer.parseInt(header.substring(0, pos));
            }
            catch (Throwable t) {
                result = -1;
            }
        }
        return result;
    }

    private SlideInfo parseSlide(StringTokenizer parser) throws ParseException {
        SlideInfo info = new SlideInfo();
        info.slideNo = this.intParser.parse(parser.nextToken()).intValue();
        info.width = this.intParser.parse(parser.nextToken()).intValue();
        info.height = this.intParser.parse(parser.nextToken()).intValue();
        info.bg = this.parseSlideColor(parser.nextToken());
        return info;
    }

    private Color parseSlideColor(String s) throws ParseException {
        StringTokenizer parser = new StringTokenizer(s, ":");
        int r = this.intParser.parse(parser.nextToken()).intValue();
        int g = this.intParser.parse(parser.nextToken()).intValue();
        int b = this.intParser.parse(parser.nextToken()).intValue();
        return new Color(r, g, b);
    }

    private ShapeInfo parseShape(StringTokenizer parser, File exportPath) throws ParseException {
        ShapeInfo info = new ShapeInfo();
        info.slideNo = this.intParser.parse(parser.nextToken()).intValue();
        info.idx = this.intParser.parse(parser.nextToken()).intValue();
        String src = parser.nextToken();
        if (src.equalsIgnoreCase("master")) {
            info.src = 2;
            info.isBackground = true;
        } else if (src.equalsIgnoreCase("design")) {
            info.src = 3;
            info.isBackground = true;
        } else if (src.equalsIgnoreCase("slide")) {
            info.src = 1;
            info.isBackground = false;
        }
        String type = parser.nextToken();
        if (type.equalsIgnoreCase("text")) {
            info.type = 1;
        } else if (type.equalsIgnoreCase("picture")) {
            info.type = 2;
        }
        if (type.equalsIgnoreCase("line")) {
            info.type = 3;
        }
        if (type.equalsIgnoreCase("other")) {
            info.type = 4;
        }
        info.imgFile = new File(exportPath, parser.nextToken());
        info.z = this.intParser.parse(parser.nextToken()).intValue();
        double x = this.intParser.parse(parser.nextToken()).doubleValue();
        double y = this.intParser.parse(parser.nextToken()).doubleValue();
        double w = this.intParser.parse(parser.nextToken()).doubleValue();
        double h = this.intParser.parse(parser.nextToken()).doubleValue();
        int cropTop = this.intParser.parse(parser.nextToken()).intValue();
        int cropLeft = this.intParser.parse(parser.nextToken()).intValue();
        int cropBottom = this.intParser.parse(parser.nextToken()).intValue();
        int cropRight = this.intParser.parse(parser.nextToken()).intValue();
        info.rotation = this.intParser.parse(parser.nextToken()).doubleValue();
        if (parser.hasMoreTokens()) {
            info.name = parser.nextToken("");
        }
        if (!info.imgFile.isFile()) {
            return null;
        }
        if (Math.abs(info.rotation) > 1.0) {
            double rads = info.rotation * Math.PI / 180.0;
            double kSine = Math.sin(rads);
            double kCosine = Math.cos(rads);
            double xCentre = x + w / 2.0;
            double yCentre = y + h / 2.0;
            double[] x1 = new double[]{x - xCentre, x + w - xCentre, x + w - xCentre, x - xCentre};
            double[] y1 = new double[]{y - yCentre, y - yCentre, y + h - yCentre, y + h - yCentre};
            double[] x2 = new double[4];
            double[] y2 = new double[4];
            for (int ix = 0; ix < 4; ++ix) {
                x2[ix] = x1[ix] * kCosine + y1[ix] * kSine;
                y2[ix] = y1[ix] * kCosine - x1[ix] * kSine;
            }
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (int ix = 0; ix < 4; ++ix) {
                if (x2[ix] > maxX) {
                    maxX = x2[ix];
                }
                if (x2[ix] < minX) {
                    minX = x2[ix];
                }
                if (y2[ix] > maxY) {
                    maxY = y2[ix];
                }
                if (!(y2[ix] < minY)) continue;
                minY = y2[ix];
            }
            x = minX + xCentre;
            y = minY + yCentre;
            w = maxX + xCentre - x;
            h = maxY + yCentre - y;
        }
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int x1 = (int)Math.ceil(x + w);
        int y1 = (int)Math.ceil(y + h);
        info.bounds = new Rectangle(x0, y0, x1 - x0, y1 - y0);
        cropTop = Math.max(0, cropTop);
        cropLeft = Math.max(0, cropLeft);
        cropBottom = Math.max(0, cropBottom);
        cropRight = Math.max(0, cropRight);
        if (cropTop > 0 || cropLeft > 0 || cropBottom > 0 || cropRight > 0) {
            info.crop = new Insets(cropTop, cropLeft, cropBottom, cropRight);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage compositeSlide(File exportPath, SlideInfo slide, ArrayList<ShapeInfo> shapeList, int quality, int wbWidth, int wbHeight) {
        Image slideImage;
        block10: {
            Graphics g = null;
            slideImage = null;
            try {
                this.realizeShapes(shapeList, slide);
                slideImage = this.loadBackground(exportPath, slide, shapeList, wbWidth, wbHeight);
                if (quality != 1) {
                    File bkgFile = new File(exportPath, "SlideBG" + slide.slideNo + ".png");
                    try {
                        this.saveSlideImage((BufferedImage)slideImage, PNG_TYPE, bkgFile);
                    }
                    catch (Throwable t) {
                        LogSupport.message((Object)this, (String)"compositeSlide", (String)("Failed to save background image " + bkgFile.getName() + "\n" + Debug.getStackTrace((Throwable)t)));
                    }
                }
                g = ((BufferedImage)slideImage).createGraphics();
                double scaleX = (double)((BufferedImage)slideImage).getWidth() / (double)slide.width;
                double scaleY = (double)((BufferedImage)slideImage).getHeight() / (double)slide.height;
                AffineTransform scaler = AffineTransform.getScaleInstance(scaleX, scaleY);
                ((Graphics2D)g).transform(scaler);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                this.compositeShapes(shapeList, false, (Graphics2D)g);
                if (g == null) break block10;
            }
            catch (Throwable throwable) {
                if (g != null) {
                    g.dispose();
                }
                if (slideImage != null) {
                    slideImage.flush();
                }
                for (int ix = 0; ix < shapeList.size(); ++ix) {
                    ShapeInfo info = shapeList.get(ix);
                    if (info.img == null) continue;
                    info.img.flush();
                }
                throw throwable;
            }
            g.dispose();
        }
        if (slideImage != null) {
            slideImage.flush();
        }
        for (int ix = 0; ix < shapeList.size(); ++ix) {
            ShapeInfo info = shapeList.get(ix);
            if (info.img == null) continue;
            info.img.flush();
        }
        return slideImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadBackground(File exportPath, SlideInfo slide, ArrayList<ShapeInfo> shapeList, int wbWidth, int wbHeight) {
        double scale;
        Image img = null;
        int imgWidth = -1;
        int imgHeight = -1;
        File f = new File(exportPath, "Slide" + slide.slideNo + "_background.png");
        if (f.isFile()) {
            try {
                img = ImageSupport.loadImage((File)f);
                if (img != null) {
                    imgWidth = img.getWidth(null);
                    imgHeight = img.getHeight(null);
                }
            }
            catch (IOException iox) {
                LogSupport.message((Object)this, (String)"loadBackground", (String)Debug.getStackTrace((Throwable)iox));
                img = null;
            }
        }
        if ((scale = Math.min((double)wbWidth / (double)Math.max(1, slide.width), (double)wbHeight / (double)Math.max(1, slide.height))) > 1.0) {
            scale = 1.0;
        }
        int w = (int)Math.round((double)slide.width * scale);
        int h = (int)Math.round((double)slide.height * scale);
        BufferedImage bgImage = new BufferedImage(w, h, 1);
        Graphics2D g = null;
        try {
            g = bgImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setColor(slide.bg);
            g.fillRect(0, 0, w, h);
            if (img != null) {
                g.drawImage(img, 0, 0, w, h, null);
            }
            double scaleX = (double)w / (double)slide.width;
            double scaleY = (double)h / (double)slide.height;
            AffineTransform scaler = AffineTransform.getScaleInstance(scaleX, scaleY);
            g.transform(scaler);
            this.compositeShapes(shapeList, true, g);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return bgImage;
    }

    private void realizeShapes(ArrayList<ShapeInfo> shapeList, SlideInfo slide) {
        for (int ix = 0; ix < shapeList.size(); ++ix) {
            double bndAspect;
            ShapeInfo info = shapeList.get(ix);
            try {
                info.img = ImageSupport.loadImage((File)info.imgFile);
            }
            catch (ImageSupport.OversizeImageException osix) {
                LogSupport.message((Object)this, (String)"realizeShapes", (String)("Image shape too large: " + info));
                info.img = null;
                continue;
            }
            catch (IOException iox) {
                LogSupport.message((Object)this, (String)"realizeShapes", (String)("Error loading shape image: " + info + "\n" + Debug.getStackTrace((Throwable)iox)));
                info.img = null;
                continue;
            }
            if (info.img == null) {
                LogSupport.message((Object)this, (String)"realizeShapes", (String)("Could not load image for shape: " + info));
                continue;
            }
            int imgWidth = info.img.getWidth(null);
            int imgHeight = info.img.getHeight(null);
            if (imgWidth <= 0 || imgHeight <= 0) {
                LogSupport.message((Object)this, (String)"realizeShapes", (String)("Empty shape image: " + info));
                info.img = null;
                continue;
            }
            double imgAspect = (double)imgHeight / (double)imgWidth;
            if (info.type == 3) {
                if (info.bounds.width <= 0) {
                    info.bounds.width = (int)Math.round((double)info.bounds.height / imgAspect);
                }
                if (info.bounds.height <= 0) {
                    info.bounds.height = (int)Math.round((double)info.bounds.width * imgAspect);
                }
            }
            if (info.bounds.isEmpty() || !(Math.abs(imgAspect - (bndAspect = (double)info.bounds.height / (double)info.bounds.width)) > 0.001)) continue;
            int oldX = info.bounds.x;
            int oldY = info.bounds.y;
            int oldWidth = info.bounds.width;
            int oldHeight = info.bounds.height;
            boolean changed = false;
            if (imgAspect > bndAspect) {
                info.bounds.height = (int)Math.round((double)info.bounds.width * imgAspect);
                int dY = oldHeight - info.bounds.height;
                if (dY != 0) {
                    if (info.bounds.y < 0 && oldY >= 0) {
                        info.bounds.y = 0;
                    } else if (info.bounds.y + info.bounds.height > slide.height && oldY + oldHeight <= slide.height) {
                        info.bounds.y = slide.height - info.bounds.height;
                    }
                    changed = true;
                }
            } else {
                info.bounds.width = (int)Math.round((double)info.bounds.height / imgAspect);
                int dX = oldWidth - info.bounds.width;
                if (dX != 0) {
                    if (info.bounds.x < 0 && oldX >= 0) {
                        info.bounds.x = 0;
                    } else if (info.bounds.x + info.bounds.width > slide.width && oldX + oldWidth <= slide.width) {
                        info.bounds.y = slide.width - info.bounds.width;
                    }
                    changed = true;
                }
            }
            if (!WhiteboardDebug.POWERPOINT.show() || !changed) continue;
            LogSupport.message((Object)this, (String)"realizeShapes", (String)("Warning: aspect ratio mismatch, adjusting bounds of " + info.imgFile.getName() + " from " + oldX + "," + oldY + " " + oldWidth + "x" + oldHeight + " to " + info.bounds.x + "," + info.bounds.y + " " + info.bounds.width + "x" + info.bounds.height));
        }
    }

    private void compositeShapes(ArrayList<ShapeInfo> shapeList, boolean onlyBkg, Graphics2D g) {
        for (int ix = 0; ix < shapeList.size(); ++ix) {
            ShapeInfo info = shapeList.get(ix);
            if (info.isBackground != onlyBkg || info.img == null || info.bounds.isEmpty()) continue;
            g.drawImage(info.img, info.bounds.x, info.bounds.y, info.bounds.width, info.bounds.height, null);
        }
    }

    private void saveSlideImage(BufferedImage img, String outputType, File f) throws IOException {
        if (f.exists()) {
            LogSupport.message((Object)this, (String)"saveSlideImage", (String)("***** WARNING: " + f + " already exists, it will be overwritten."));
        }
        if (PNG_TYPE == outputType) {
            ImageSupport.saveAsPNG((Image)img, (int)9, (File)f);
        } else if (JPEG_TYPE == outputType) {
            ImageSupport.saveAsJPEG((Image)img, (int)85, (File)f);
        } else {
            throw new IllegalArgumentException("Invalid image type: " + outputType);
        }
    }

    private int doExportPPT(File exportPath, File pptFile, File metaDataFile, int slideType, String scaleWidth, String scaleHeight) throws IOException {
        boolean forceWflow = WhiteboardDebug.PPT_WRKFLOW.show();
        boolean forceAScpt = WhiteboardDebug.PPT_ASCRIPT.show();
        if (forceWflow || !forceAScpt && useAutomator) {
            return this.exportWFlow(exportPath, pptFile, metaDataFile, slideType);
        }
        return this.exportAScpt(exportPath, pptFile, metaDataFile, slideType, scaleWidth, scaleHeight);
    }

    private File extractResourceFile(String rsrcName, File exportPath, String fname) throws IOException {
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"extractResourceFile", (String)("Extracting " + rsrcName + " => " + fname));
        }
        Resource scriptRsrc = new Resource((Object)this, rsrcName);
        File scriptFile = new File(exportPath, fname);
        scriptRsrc.save(scriptFile.getPath());
        if (!scriptFile.exists()) {
            throw new RuntimeException("Failed to extract resource: " + rsrcName);
        }
        return scriptFile;
    }

    private int executeCommand(String[] cmd, int timeout) throws IOException {
        return this.executeCommand(cmd, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(String[] cmd, int timeout, Process[] proc) throws IOException {
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"executeCommand", (String)StringUtils.getStringValue((Object)cmd));
        }
        StringBuffer output = new StringBuffer();
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(cmd);
        if (proc != null && proc.length > 0) {
            proc[0] = p;
        }
        try {
            int status = ProcessUtils.getProcessOutput((Process)p, (StringBuffer)output, (StringBuffer)output, (long)timeout, (boolean)true);
            if (status != 0) {
                if (!WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"executeCommand", (String)StringUtils.getStringValue((Object)cmd));
                }
                if (status == Integer.MIN_VALUE) {
                    LogSupport.error((Object)this, (String)"executeCommand", (String)("Command failed to complete in " + timeout + " millisec"));
                } else if (status == -2147483647) {
                    LogSupport.error((Object)this, (String)"executeCommand", (String)"Command execution interrupted");
                } else {
                    LogSupport.error((Object)this, (String)"executeCommand", (String)("Command returned status=" + status));
                }
            }
            if (output.length() > 0 && (WhiteboardDebug.POWERPOINT.show() || status != 0)) {
                LogSupport.message((Object)this, (String)"executeCommand", (String)("Output: " + output.toString()));
            }
            int n = status;
            return n;
        }
        finally {
            if (proc != null && proc.length > 0) {
                proc[0] = null;
            }
        }
    }

    private void copyFile(File from, File to) throws IOException {
        String[] cmd = new String[]{"cp", "-pR", from.getAbsolutePath(), to.getAbsolutePath()};
        if (this.executeCommand(cmd, 15000) != 0) {
            throw new RuntimeException("Copy presentation failed");
        }
    }

    private void openPresentation(String pptPath) throws IOException {
        String[] openScript = new String[]{"tell application \"" + pptAppNative + "\" to launch", "tell application \"Finder\"", "  set isRunningFlag to false", "  repeat 10 times", "    delay 3", "    if (the name of every application process) contains \"Microsoft PowerPoint\" then", "      set isRunningFlag to true", "      exit repeat", "    end if", "  end repeat", "  if not isRunningFlag then error \"PowerPoint failed to start\"", "  set visible of (application process \"Microsoft PowerPoint\") to false", "end tell", "delay 1", "tell application \"Microsoft PowerPoint\" to open \"" + pptPath + "\""};
        if (this.executeOSAScript(openScript, 60000) != 0) {
            throw new RuntimeException("Opening presentation failed");
        }
    }

    private void shutdownPowerPoint(String presName) {
        String[] shutdownScript = new String[]{"tell application \"Microsoft PowerPoint\"", "  activate", "  try", "    close presentation \"" + presName + "\" saving no", "  end try", "  if the number of presentations is 0 then quit", "end tell"};
        try {
            this.executeOSAScript(shutdownScript, 10000);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int executeWorkflow(File wflow, String arg, Process[] proc) throws IOException {
        String[] cmd = WhiteboardDebug.POWERPOINT.show() ? new String[]{"automator", "-v", "-i", arg, wflow.getAbsolutePath()} : new String[]{"automator", "-i", arg, wflow.getAbsolutePath()};
        return this.executeCommand(cmd, 300000, proc);
    }

    private int executeOSAScript(String[] src, int timeout) throws IOException {
        String[] cmd = new String[src.length * 2 + 1];
        cmd[0] = "osascript";
        for (int ix = 0; ix < src.length; ++ix) {
            int ord = ix * 2 + 1;
            cmd[ord] = "-e";
            cmd[ord + 1] = src[ix];
        }
        return this.executeCommand(cmd, timeout);
    }

    private int countSlideImages(File dir) {
        FilenameFilter filter = new FilenameFilter(){
            Matcher matcher = Pattern.compile("Slide[0-9]+\\.png").matcher("");

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                this.matcher.reset(name);
                return this.matcher.matches();
            }
        };
        return dir.listFiles(filter).length;
    }

    private void stripSlideBorders(File dir, int nSlides, WorkflowProgressWatcher progressWatcher) throws IOException {
        String note = i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_STRIPIMAGESNOTE);
        progressWatcher.setNote(note);
        int progress = 0;
        for (int idx = 1; idx <= nSlides; ++idx) {
            if (progressWatcher.isCanceled()) {
                throw new PowerPointImport.CancelledException();
            }
            progressWatcher.setProgress(++progress);
            File f1 = new File(dir, "Slide" + idx + ".png");
            File f2 = new File(dir, "SlideBG" + idx + ".png");
            if (!f1.exists()) continue;
            Image img1 = ImageSupport.loadImage((File)f1);
            Image img2 = null;
            Rectangle crop = this.getCropRect(img1);
            Rectangle r = null;
            if (f2.exists()) {
                progressWatcher.setProgress(++progress);
                img2 = ImageSupport.loadImage((File)f2);
                r = this.getCropRect(img2);
                if (crop == null && r != null) {
                    crop = r;
                } else if (crop != null && r != null && !crop.equals(r)) {
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"stripSlideBorders", (String)("Slide " + idx + " foreground and background crops differ: " + crop + " bg=" + r));
                    }
                    crop = crop.intersection(r);
                }
            }
            if (crop != null && !crop.isEmpty()) {
                Image cropped;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"stripSlideBorders", (String)("Cropping to " + crop.x + "," + crop.y + " " + crop.width + "x" + crop.height + ": " + f1.getName()));
                }
                if ((cropped = this.cropImage(img1, crop)) != null) {
                    ImageSupport.saveAsPNG((Image)cropped, (int)9, (File)f1);
                    cropped.flush();
                }
                if (img2 != null && (cropped = this.cropImage(img2, crop)) != null) {
                    ImageSupport.saveAsPNG((Image)cropped, (int)9, (File)f2);
                    cropped.flush();
                }
            }
            img1.flush();
            if (img2 == null) continue;
            img2.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getCropRect(Image img) {
        BufferedImage bim = ImageSupport.toBufferedImage((Image)img);
        if (bim == null) {
            return null;
        }
        try {
            int alpha;
            int argb;
            int ix;
            if (bim.getTransparency() == 1) {
                Rectangle rectangle = null;
                return rectangle;
            }
            int w = bim.getWidth();
            int h = bim.getHeight();
            int l = 0;
            int t = 0;
            int r = 0;
            int b = 0;
            int x1 = w / 2;
            int y1 = h / 2;
            for (ix = 0; ix < w / 2; ++ix) {
                argb = bim.getRGB(ix, y1);
                alpha = argb >> 24 & 0xFF;
                if (alpha <= 127) continue;
                l = ix;
                break;
            }
            for (ix = 0; ix < h / 2; ++ix) {
                argb = bim.getRGB(x1, ix);
                alpha = argb >> 24 & 0xFF;
                if (alpha <= 127) continue;
                t = ix;
                break;
            }
            for (ix = 0; ix < w / 2; ++ix) {
                argb = bim.getRGB(w - ix - 1, y1);
                alpha = argb >> 24 & 0xFF;
                if (alpha <= 127) continue;
                r = ix;
                break;
            }
            for (ix = 0; ix < h / 2; ++ix) {
                argb = bim.getRGB(x1, h - ix - 1);
                alpha = argb >> 24 & 0xFF;
                if (alpha <= 127) continue;
                b = ix;
                break;
            }
            if (l == 0 && t == 0 && b == 0 && r == 0) {
                Rectangle rectangle = null;
                return rectangle;
            }
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)this, (String)"stripSlideBorders", (String)("Transparent inset: top=" + t + " left=" + l + " bottom=" + b + " right=" + r));
            }
            Rectangle rectangle = new Rectangle(l, t, w - l - r, h - t - b);
            return rectangle;
        }
        finally {
            bim.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image cropImage(Image img, Rectangle crop) {
        if (crop == null) {
            return img;
        }
        BufferedImage bim = ImageSupport.toBufferedImage((Image)img);
        if (bim == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = bim.getSubimage(crop.x, crop.y, crop.width, crop.height);
            return bufferedImage;
        }
        finally {
            bim.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportWFlow(File exportPath, File pptFile, File metaDataFile, int slideType) throws IOException {
        int status = 0;
        String ext = FileSysUtils.getExtension((File)pptFile).trim();
        if (ext == null || ext.length() == 0) {
            ext = "ppt";
        }
        File localPres = new File(exportPath, "pptPres." + ext);
        this.copyFile(pptFile, localPres);
        String nativePres = Platform.getNativePath((String)localPres.getAbsolutePath());
        final Process[] processHolder = new Process[]{null};
        ActionListener cancelHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Process p = processHolder[0];
                if (p != null) {
                    p.destroy();
                }
            }
        };
        WorkflowProgressWatcher progressWatcher = new WorkflowProgressWatcher(metaDataFile, slideType, cancelHandler);
        progressWatcher.start();
        try {
            this.openPresentation(nativePres);
            try {
                File wFlowFile = this.extractResourceFile(COMMON_WFLOW, exportPath, "importer.wflow");
                status = this.executeWorkflow(wFlowFile, nativePres, processHolder);
                if (progressWatcher.isCanceled()) {
                    throw new PowerPointImport.CancelledException();
                }
                if (status == 0 && slideType != 1) {
                    wFlowFile = this.extractResourceFile(BKGRND_WFLOW, exportPath, "importBkg.wflow");
                    status = this.executeWorkflow(wFlowFile, nativePres, processHolder);
                }
            }
            finally {
                this.shutdownPowerPoint(localPres.getName());
            }
            File errFile = new File(exportPath, "exporterr.tmp");
            if (errFile.length() > 0L) {
                MacPPTLoader.dumpFileToConsole(errFile);
            }
            this.stripSlideBorders(exportPath, this.countSlideImages(exportPath), progressWatcher);
        }
        finally {
            progressWatcher.terminate();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportAScpt(File exportPath, File pptFile, File metaDataFile, int slideType, String scaleWidth, String scaleHeight) throws IOException {
        String presName = pptFile.getName();
        String presPath = Platform.getNativePath((String)pptFile.getAbsolutePath());
        String outputDirPath = Platform.getNativePath((String)exportPath.getAbsolutePath());
        String metaNative = Platform.getNativePath((String)metaDataFile.getAbsolutePath());
        String encodingType = EXPORT_IMAGE_TYPE[slideType - 1];
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"load", (String)("PPT Import (PPTImporter.scpt): " + pptAppNative + "\n\t" + presPath + "\n\t" + outputDirPath + "\n\t" + metaNative + "\n\t" + encodingType + " " + scaleWidth + " " + scaleHeight));
        }
        File scriptFile = this.extractResourceFile(IMPORT_SCRIPT, exportPath, "pptexport.scpt");
        Runtime rt = Runtime.getRuntime();
        String[] osaCommand = new String[]{"osascript", scriptFile.getPath(), pptAppNative, presPath, outputDirPath, metaNative, encodingType, scaleWidth, scaleHeight};
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"exportAScpt", (String)("Exporting using command: " + StringUtils.getStringValue((Object)osaCommand)));
        }
        File progressFile = new File(exportPath, "progress.txt");
        final Process[] processHolder = new Process[]{null};
        ActionListener cancelHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Process p = processHolder[0];
                if (p != null) {
                    p.destroy();
                }
            }
        };
        ProgressWatcherThread progressWatcher = new ProgressWatcherThread(progressFile, cancelHandler);
        progressWatcher.start();
        int status = 0;
        try {
            processHolder[0] = rt.exec(osaCommand);
            StringBuffer out = new StringBuffer();
            StringBuffer err = new StringBuffer();
            status = ProcessUtils.getProcessOutput((Process)processHolder[0], (StringBuffer)out, (StringBuffer)err, (long)-1L);
            processHolder[0] = null;
            if (out.length() > 0 || err.length() > 0) {
                LogSupport.message((Object)this, (String)"exportAScpt", (String)("OSA output while processing " + scriptFile));
                if (out.length() > 0) {
                    LogSupport.message((String)("  stdout: " + out));
                }
                if (err.length() > 0) {
                    LogSupport.message((String)("\n==========\n  stderr: " + err));
                }
                LogSupport.message((Object)this, (String)"exportAScpt", (String)"========== end OSA output ==========");
            }
        }
        finally {
            progressWatcher.terminate();
            if (!WhiteboardDebug.POWERPOINT.show()) {
                try {
                    scriptFile.delete();
                }
                catch (Throwable ignored) {}
            }
        }
        if (progressWatcher.isCanceled() || status == Integer.MIN_VALUE) {
            this.shutdownPowerPoint(presName);
            throw new PowerPointImport.CancelledException();
        }
        return status;
    }

    private static Component findParent() {
        Frame[] frames = Frame.getFrames();
        if (frames == null) {
            return null;
        }
        for (int ix = 0; ix < frames.length; ++ix) {
            if (frames[ix] == null || !frames[ix].isVisible() || !frames[ix].getClass().getName().startsWith("com.elluminate")) continue;
            return frames[ix];
        }
        return null;
    }

    @Override
    public boolean isCancelDisabledDuringLoad() {
        return false;
    }

    static {
        File f;
        EXPORT_IMAGE_TYPE = new String[]{"faster", "better", "best"};
        i18n = I18n.create(MacPPTLoader.class);
        loadedOK = false;
        hasPPT = false;
        has2007Support = false;
        useAutomator = false;
        pptAppPath = null;
        pptAppNative = null;
        pptVersion = null;
        pptIcon = null;
        String appPath = System.getProperty("elive.pptPath");
        if (appPath != null && (f = new File(appPath)).exists()) {
            pptAppPath = f;
        }
        if (pptAppPath == null) {
            pptAppPath = MacOSXPlatform.findAppByBundle((String)PPT_BUNDLE_ID);
        }
        if (pptAppPath == null) {
            pptAppPath = MacOSXPlatform.findAppByCreator((String)PPT_CREATOR_CODE);
        }
        if (pptAppPath == null) {
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)"No installation of PowerPoint found.");
            }
        } else if (!pptAppPath.exists()) {
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)("PPT installation does not exist: " + pptAppPath));
            }
        } else {
            String rawVersion = MacPPTLoader.getAppVersion(pptAppPath);
            pptVersion = MacPPTLoader.stripAppVersion(rawVersion);
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)(pptAppPath + " '" + rawVersion + "' " + pptVersion));
            }
            if (!(hasPPT = MacPPTLoader.isVersionSupported())) {
                LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)("Unsupported version for " + pptAppPath + ": " + rawVersion));
            } else {
                pptAppNative = Platform.getNativePath((File)pptAppPath);
                if (pptAppNative == null) {
                    LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)("Cannot get native path to " + pptAppPath));
                    hasPPT = false;
                }
            }
            if (hasPPT) {
                pptIcon = GuiUtils.getFileIcon((File)pptAppPath);
                File ppt2008 = Platform.findAppByExtension((String)"pptx");
                has2007Support = pptAppPath.equals(ppt2008);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)("PPTX path (pptx): " + ppt2008));
                }
                useAutomator = VersionSupport.matchVersion((String)pptVersion, (String)WFLOW_VERSION);
            } else if (pptAppPath != null || WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message(MacPPTLoader.class, (String)"<clinit>", (String)("No PPT support: " + pptAppPath + " " + rawVersion));
            }
        }
    }

    private static class ProgressWatcherThread
    extends WorkerThread {
        private File progressFile = null;
        private long lastMod = 0L;
        private volatile boolean running = false;
        private String progressInfo = null;
        private ProgressDialog dlg = null;
        private ActionListener cancelHandler = null;

        ProgressWatcherThread(File f, ActionListener canceler) {
            super("PPT Export Progress Watcher");
            this.progressFile = f;
            this.cancelHandler = canceler;
        }

        public void start() {
            this.running = true;
            super.start();
        }

        public void terminate() {
            this.running = false;
            this.interrupt();
        }

        public boolean isCanceled() {
            if (this.dlg != null) {
                return this.dlg.isCanceled();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            try {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)("Progress watcher starting: " + this.progressFile));
                }
                Thread.sleep(1000L);
                this.createProgressDialog();
                while (this.running && !Thread.currentThread().isInterrupted()) {
                    if (this.checkUpdate()) {
                        this.updateProgress();
                    }
                    Thread.sleep(300L);
                }
                this.running = false;
            }
            catch (InterruptedException ignored) {
                this.running = false;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressWatcherThread.this.dlg != null) {
                            ProgressWatcherThread.this.dlg.setVisible(false);
                        }
                    }
                };
                SwingRunnerSupport.invokeLater((Runnable)r);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                }
            }
            catch (Throwable t) {
                LogSupport.message((Object)((Object)this), (String)"run", (String)Debug.getStackTrace((Throwable)t));
                this.running = false;
                {
                    catch (Throwable throwable) {
                        this.running = false;
                        Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                        SwingRunnerSupport.invokeLater((Runnable)r2);
                        if (WhiteboardDebug.POWERPOINT.show()) {
                            LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                        }
                        throw throwable;
                    }
                }
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                SwingRunnerSupport.invokeLater((Runnable)r);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                }
            }
            Runnable r = new /* invalid duplicate definition of identical inner class */;
            SwingRunnerSupport.invokeLater((Runnable)r);
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
            }
        }

        private void createProgressDialog() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (ProgressWatcherThread.this.dlg != null) {
                        return;
                    }
                    Component parent = MacPPTLoader.findParent();
                    ProgressWatcherThread.this.dlg = new ProgressDialog(parent, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_MESSAGE), i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_TITLE), i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_INITIALNOTE));
                    if (pptIcon != null) {
                        ProgressWatcherThread.this.dlg.setNoteIcon(pptIcon);
                    }
                    ProgressWatcherThread.this.dlg.setAutoHideEnabled(false);
                    ProgressWatcherThread.this.dlg.setCancelVisible(ProgressWatcherThread.this.cancelHandler != null);
                    ProgressWatcherThread.this.dlg.setCancelEnabled(ProgressWatcherThread.this.cancelHandler != null);
                    if (ProgressWatcherThread.this.cancelHandler != null) {
                        ProgressWatcherThread.this.dlg.addCancelListener(ProgressWatcherThread.this.cancelHandler);
                    }
                    ProgressWatcherThread.this.dlg.pack();
                    ProgressWatcherThread.this.dlg.setSize(new Dimension(600, ProgressWatcherThread.this.dlg.getHeight()));
                    ProgressWatcherThread.this.dlg.setVisible(true);
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        }

        private boolean checkUpdate() {
            if (this.lastMod <= 0L) {
                this.lastMod = System.currentTimeMillis();
            } else {
                long dT = System.currentTimeMillis() - this.lastMod;
                if (dT > 120000L) {
                    if (this.dlg != null) {
                        this.dlg.cancel();
                    }
                    LogSupport.message((Object)((Object)this), (String)"checkUpdate", (String)("PPT importer stalled, no activity in " + (double)dT / 1000.0 + " seconds."));
                    throw new RuntimeException("PPT importer stalled.");
                }
            }
            if (!this.progressFile.isFile()) {
                return false;
            }
            long mod = this.progressFile.lastModified();
            if (mod == this.lastMod) {
                return true;
            }
            if (System.currentTimeMillis() <= mod + 1L) {
                return false;
            }
            this.lastMod = mod;
            return true;
        }

        private void updateProgress() {
            String s = this.getProgress();
            if (s == null) {
                return;
            }
            if (this.progressInfo != null && this.progressInfo.equals(s)) {
                return;
            }
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)((Object)this), (String)"updateProgress", (String)s);
            }
            StringBuilder sb = new StringBuilder(s);
            int cur = this.stripNumber(sb);
            int max = this.stripNumber(sb);
            if (cur == Integer.MIN_VALUE || max == Integer.MIN_VALUE) {
                return;
            }
            this.progressInfo = s;
            String progressText = sb.toString().trim();
            String note = progressText.equals("Elluminate::ProcessingMetaData") ? i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_PROGRESSMETADATANOTE) : i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_PROGRESSNOTE, new Object[]{cur, max, progressText});
            if (max > 0 && max != this.dlg.getMaximum()) {
                this.dlg.setMaximum(max);
            }
            this.dlg.setProgress(cur, note);
        }

        private int stripNumber(StringBuilder sb) {
            int result = Integer.MIN_VALUE;
            int pos = sb.indexOf(" ");
            if (pos > 0) {
                try {
                    String s = sb.substring(0, pos);
                    result = Integer.parseInt(s);
                    sb.delete(0, pos + 1);
                }
                catch (NumberFormatException t) {
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)((Object)this), (String)"stripNumber", (String)("Parse error -- " + Debug.getStackTrace((Throwable)t)));
                    }
                    result = Integer.MIN_VALUE;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getProgress() {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(this.progressFile);
                br = new BufferedReader(fr);
                String string = br.readLine().trim();
                return string;
            }
            catch (InterruptedIOException ignored) {
                this.running = false;
            }
            catch (EOFException ignored) {
            }
            catch (IOException iox) {
                LogSupport.exception((Object)((Object)this), (String)"getProgress", (Throwable)iox, (boolean)true, (String)("I/O error reading progress: " + this.progressFile));
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable ignored) {}
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
            return null;
        }
    }

    private static class ShapeInfo {
        int slideNo = -1;
        int idx = -1;
        int z = -1;
        int src = 0;
        int type = 0;
        boolean isBackground = false;
        String name = "";
        File imgFile = null;
        Rectangle bounds = null;
        Insets crop = null;
        double rotation = 0.0;
        Image img = null;

        private ShapeInfo() {
        }

        public String toString() {
            return "shapeInfo " + this.slideNo + "#" + this.idx + " " + (this.isBackground ? "BG " : "") + this.src + "/" + this.type + " '" + this.name + "' z=" + this.z + " [" + (this.bounds == null ? "" : this.bounds.x + "," + this.bounds.y + " " + this.bounds.width + "x" + this.bounds.height) + "] rot=" + this.rotation + " ins=[" + (this.crop == null ? "" : this.crop.top + " " + this.crop.left + " " + this.crop.bottom + " " + this.crop.right) + "] " + this.imgFile.getName();
        }
    }

    private static class SlideInfo {
        int slideNo = -1;
        int width = -1;
        int height = -1;
        Color bg = null;
        int nShapes = -1;

        private SlideInfo() {
        }

        public String toString() {
            return "slideInfo " + this.slideNo + " " + this.width + "x" + this.height + " " + this.bg + " #shapes=" + this.nShapes;
        }
    }

    private static class WorkflowProgressWatcher
    extends WorkerThread {
        private File metadata;
        private File slideDir;
        private int multiplier;
        private int maxProgress;
        private volatile int borderProgress = 0;
        private volatile boolean running = false;
        private ProgressDialog dlg = null;
        private ActionListener cancelHandler = null;
        private FilenameFilter slideFilter = null;
        private volatile int filterCount;
        private final Object COUNTER_LOCK = new Object();

        WorkflowProgressWatcher(File f, int importType, ActionListener canceler) {
            this.metadata = f;
            this.slideDir = f.getParentFile();
            this.cancelHandler = canceler;
            switch (importType) {
                case 1: {
                    this.multiplier = 1;
                    break;
                }
                case 2: {
                    this.multiplier = 2;
                    break;
                }
                case 3: {
                    this.multiplier = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid import type: " + importType);
                }
            }
            this.slideFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isImage;
                    boolean bl = isImage = name.endsWith(".png") || name.endsWith(".jpg");
                    if (isImage && name.startsWith("Slide")) {
                        ++WorkflowProgressWatcher.this.filterCount;
                    }
                    return false;
                }
            };
        }

        public void start() {
            this.running = true;
            super.start();
        }

        public void terminate() {
            this.running = false;
            this.interrupt();
        }

        public boolean isCanceled() {
            if (this.dlg != null) {
                return this.dlg.isCanceled();
            }
            return false;
        }

        void setNote(String note) {
            if (this.dlg != null) {
                this.dlg.setNote(note);
            }
        }

        void setProgress(int cur) {
            this.borderProgress = cur;
        }

        int getProgress() {
            if (this.dlg != null) {
                return this.dlg.getProgress();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            try {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)"WorkflowProgressWatcher starting");
                }
                Thread.sleep(1000L);
                this.createProgressDialog();
                this.maxProgress = this.computeMaxFiles() * 2;
                String note = i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_GENIMAGESNOTE);
                this.dlg.setNote(note);
                while (this.running && !Thread.currentThread().isInterrupted()) {
                    this.updateProgress();
                    Thread.sleep(300L);
                }
                this.running = false;
            }
            catch (InterruptedException ignored) {
                this.running = false;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (WorkflowProgressWatcher.this.dlg != null) {
                            WorkflowProgressWatcher.this.dlg.setVisible(false);
                        }
                    }
                };
                SwingRunnerSupport.invokeLater((Runnable)r);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                }
            }
            catch (Throwable t) {
                LogSupport.message((Object)((Object)this), (String)"run", (String)Debug.getStackTrace((Throwable)t));
                this.running = false;
                {
                    catch (Throwable throwable) {
                        this.running = false;
                        Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                        SwingRunnerSupport.invokeLater((Runnable)r2);
                        if (WhiteboardDebug.POWERPOINT.show()) {
                            LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                        }
                        throw throwable;
                    }
                }
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                SwingRunnerSupport.invokeLater((Runnable)r);
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
                }
            }
            Runnable r = new /* invalid duplicate definition of identical inner class */;
            SwingRunnerSupport.invokeLater((Runnable)r);
            if (WhiteboardDebug.POWERPOINT.show()) {
                LogSupport.message((Object)((Object)this), (String)"run", (String)"Progress watcher exiting.");
            }
        }

        private void createProgressDialog() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (WorkflowProgressWatcher.this.dlg != null) {
                        return;
                    }
                    Component parent = MacPPTLoader.findParent();
                    WorkflowProgressWatcher.this.dlg = new ProgressDialog(parent, (Object)i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_MESSAGE), i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_TITLE), i18n.getString((PropertiesEnum)StringsProperties.PROGRESSWATCHER_INITIALNOTE));
                    if (pptIcon != null) {
                        WorkflowProgressWatcher.this.dlg.setNoteIcon(pptIcon);
                    }
                    WorkflowProgressWatcher.this.dlg.setAutoHideEnabled(false);
                    WorkflowProgressWatcher.this.dlg.setCancelVisible(WorkflowProgressWatcher.this.cancelHandler != null);
                    WorkflowProgressWatcher.this.dlg.setCancelEnabled(WorkflowProgressWatcher.this.cancelHandler != null);
                    if (WorkflowProgressWatcher.this.cancelHandler != null) {
                        WorkflowProgressWatcher.this.dlg.addCancelListener(WorkflowProgressWatcher.this.cancelHandler);
                    }
                    WorkflowProgressWatcher.this.dlg.pack();
                    WorkflowProgressWatcher.this.dlg.setSize(new Dimension(512, WorkflowProgressWatcher.this.dlg.getHeight()));
                    WorkflowProgressWatcher.this.dlg.setVisible(true);
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        }

        private int computeMaxFiles() throws InterruptedException, IOException {
            while (this.running) {
                int nSlides;
                if (this.metadata.length() > 2L && (nSlides = this.getSlideCount()) > 0) {
                    return nSlides * this.multiplier;
                }
                Thread.sleep(1000L);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSlideCount() throws IOException {
            FileInputStream fis = null;
            BufferedReader r = null;
            fis = new FileInputStream(this.metadata);
            r = new BufferedReader(new InputStreamReader(fis));
            String s = r.readLine();
            if (r.readLine() == null) {
                int n = -1;
                return n;
            }
            int n = Integer.parseInt(s);
            return n;
            finally {
                try {
                    r.close();
                }
                catch (Throwable ignored) {}
                try {
                    fis.close();
                }
                catch (Throwable ignored) {}
            }
        }

        private void updateProgress() {
            int curFiles = this.countSlideFiles();
            if (curFiles > 0) {
                this.dlg.setProgress(curFiles + this.borderProgress);
                if (this.maxProgress > 0) {
                    this.dlg.setMaximum(this.maxProgress);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int countSlideFiles() {
            Object object = this.COUNTER_LOCK;
            synchronized (object) {
                this.filterCount = 0;
                this.slideDir.list(this.slideFilter);
                return this.filterCount;
            }
        }
    }
}

