/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StarOfficeLoaderInterface;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationInterface;
import com.elluminate.groupware.whiteboard.module.presentations.StringsProperties;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileFilter;

public class StarOfficeImport
extends PresentationInterface
implements PropertyChangeListener,
ShutdownListener {
    static final int SOFTWARE_FAILURE = -1;
    static final int VERSION_FAILURE = -2;
    static final int IN_USE_FAILURE = -3;
    static final int NOT_INSTALLED_FAILURE = -4;
    static final int CANCELLED_FAILURE = -5;
    static final int CALL_FAILURE = -6;
    static final int CANNOT_START_FAILURE = -7;
    static final int CANCELLED_FAILURE2 = -9;
    private static final String TEMP_FILE_BASE = "vcStarOfficeTemp_";
    private static int tempSequence = 0;
    private static final String[] MIME_TYPES = new String[]{"application/x-ms-powerpoint", "application/vnd.sun.xml.impress"};
    public static final int FASTER_TYPE = 1;
    public static final int BETTER_TYPE = 2;
    private I18n i18n = I18n.create((Object)this);
    private static File oldStarOfficeFolder;
    private int countOfScreens;
    protected File starOfficeFile;
    private File tempPath;
    private StarOfficeLoaderInterface loader = null;
    private boolean loaded = false;
    private boolean presentationLoaded = false;
    private WhiteboardContext context;
    private Preferences preferences;
    private int desiredWidth = 1014;
    private int desiredHeight = 835;
    private static boolean available;
    private String failReason = "Unknown";

    public static boolean isSupported() {
        return true;
    }

    public static boolean isAvailable() {
        return StarOfficeInformation.instance().isValid();
    }

    public static void setAvailable(boolean isAvailable) {
        available = isAvailable;
    }

    public boolean accept(File f) {
        try {
            if (FileSysUtils.isTraversableDirectory((File)f)) {
                return true;
            }
            String type = Platform.getMimeType((File)f);
            if (!StarOfficeInformation.canReadPptxFormatFiles() && f.getName().toLowerCase(Locale.ENGLISH).endsWith(".pptx")) {
                return false;
            }
            for (int i = 0; i < MIME_TYPES.length; ++i) {
                if (!type.equalsIgnoreCase(MIME_TYPES[i])) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public PresentationInterface importFromFile(Component parent, WhiteboardContext context, int width, int height) {
        this.context = context;
        CFileChooser chooser = new CFileChooser(oldStarOfficeFolder);
        chooser.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_LOADDIALOGTITLE));
        FileFilter[] filters = chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            chooser.removeChoosableFileFilter(filters[i]);
            filters[i] = null;
        }
        chooser.addChoosableFileFilter((FileFilter)((Object)this));
        if (chooser.showOpenDialog(parent) == 0) {
            this.starOfficeFile = chooser.getSelectedFile();
            return this;
        }
        this.desiredWidth = width;
        this.desiredHeight = height;
        return this;
    }

    @Override
    public PresentationInterface importFromFile(String path, WhiteboardContext context, int width, int height) {
        return this.importFromFile(new File(path), context, width, height);
    }

    @Override
    public PresentationInterface importFromFile(File file, WhiteboardContext context, int width, int height) {
        this.context = context;
        if (!file.exists()) {
            return null;
        }
        this.starOfficeFile = file;
        if (!StarOfficeInformation.instance().isValid()) {
            this.countOfScreens = -4;
            this.failReason = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_NOTINSTALLED);
            return null;
        }
        this.desiredWidth = width;
        this.desiredHeight = height;
        return this;
    }

    public StarOfficeImport() {
        super(StarOfficeInformation.STAR_OFFICE_EXTENSIONS[0]);
        if (!StarOfficeInformation.canReadPptxFormatFiles()) {
            this.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_NOPPTXDESCRIPTION));
        }
        this.context = null;
        this.countOfScreens = 0;
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    @Override
    public JComponent getAccessory() {
        return null;
    }

    @Override
    public String getFailReason() {
        return this.failReason;
    }

    @Override
    public void addChoosableFileFilter(JFileChooser chooser) {
        if (!StarOfficeImport.isAvailable()) {
            return;
        }
        chooser.addChoosableFileFilter((FileFilter)((Object)this));
        chooser.addPropertyChangeListener("fileFilterChanged", this);
        chooser.setAccessory(this.getAccessory());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("fileFilterChanged")) {
            JFileChooser chooser = (JFileChooser)evt.getSource();
            if (this.getAccessory() != null) {
                if (evt.getNewValue() == this && chooser.getAccessory() != this.getAccessory()) {
                    if (chooser.getAccessory() != null) {
                        chooser.getAccessory().setVisible(false);
                    }
                    chooser.setAccessory(this.getAccessory());
                    if (chooser.getAccessory() != null) {
                        chooser.getAccessory().setVisible(true);
                    }
                    chooser.setMultiSelectionEnabled(false);
                    chooser.invalidate();
                } else if (evt.getOldValue() == this && chooser.getAccessory() == this.getAccessory()) {
                    chooser.getAccessory().setVisible(false);
                    chooser.setAccessory(null);
                }
            }
        }
    }

    @Override
    public int screenCount(int slideType) throws Exception {
        if (!this.presentationLoaded) {
            this.loadPresentation(slideType);
        }
        return this.countOfScreens;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public PresentationImage[] getScreenImages(int screenId, int slideType) throws Exception {
        if (!this.presentationLoaded) {
            this.loadPresentation(slideType);
        }
        if (screenId < 1 && screenId > this.countOfScreens) {
            throw new Exception("getScreen: screenId (" + screenId + ") not in range 1 <= screenid <= " + this.countOfScreens);
        }
        PresentationImage[] image = this.loader.getImages(screenId - 1);
        return image;
    }

    public void onShutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
        StarOfficeInformation.instance().disposeLoader();
        if (this.tempPath != null && this.tempPath.isDirectory()) {
            if (!WhiteboardDebug.POWERPOINT.show()) {
                FileSysUtils.deleteTree((File)this.tempPath);
            }
            this.tempPath = null;
        }
        this.presentationLoaded = false;
    }

    private void loadPresentation(int slideType) throws Exception {
        if (!this.presentationLoaded) {
            LoadPresentationRunnable loaderRunnable = new LoadPresentationRunnable(slideType, StarOfficeInformation.instance());
            StarOfficeLoadDialog dialog = new StarOfficeLoadDialog(this.context.getDialogParentFrame(), loaderRunnable, StarOfficeInformation.instance());
            dialog.setVisible(true);
            String reason = null;
            switch (this.countOfScreens) {
                case -1: {
                    reason = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_SOFTWAREERROR);
                    break;
                }
                case -7: {
                    reason = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CANNOTSTART);
                    break;
                }
                case -6: {
                    reason = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CALLFAILURE);
                    break;
                }
                case -9: 
                case -5: {
                    reason = this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_USERCANCELLEDMSG);
                    break;
                }
            }
            if (reason != null) {
                throw new Exception(reason);
            }
            if (this.countOfScreens < 0) {
                throw new Exception("Unknown importer error status: " + this.countOfScreens);
            }
            this.presentationLoaded = true;
        }
    }

    private void makeTempDir() {
        File tmpRoot = Platform.getTempDir();
        do {
            this.tempPath = new File(tmpRoot, TEMP_FILE_BASE + ++tempSequence);
        } while (this.tempPath.isFile() || this.tempPath.isDirectory() || this.tempPath.exists());
        this.tempPath.mkdir();
        if (!WhiteboardDebug.POWERPOINT.show()) {
            FileSysUtils.deleteTreeOnExit((File)this.tempPath);
        }
    }

    @Override
    public int getDesiredSlideType() {
        return 3;
    }

    @Override
    public boolean isNotesIncluded() {
        String name = this.getOwnerPrefix() + ".importQualityNotesImport";
        return this.getPreferences().getBooleanSetting(name, false);
    }

    @Override
    public String getSlideTitle(int index) {
        return this.loader.getTitle(index);
    }

    @Override
    public List<String> getSlideNotes(int index) {
        return this.loader.getSlideNotes(index);
    }

    @Override
    public String getSlideAltText(int index) {
        return this.loader.getSlideAltText(index);
    }

    public static void findStarOffice() {
        File execFile = StarOfficeImport.findStarOfficeApplication();
        if (execFile != null) {
            StarOfficeInformation.instance().setStarOfficeApplicationPath(execFile.getPath());
        }
    }

    public static File findStarOfficeApplication() {
        return StarOfficeInformation.getAppByExtensions();
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.context.getBean().getPreferences();
        }
        return this.preferences;
    }

    private String getOwnerPrefix() {
        return this.context.getBean().getOwnerPrefix();
    }

    static {
        available = true;
    }

    public static class CancelledException
    extends RuntimeException {
        public CancelledException() {
            super("Cancelled by user.");
        }
    }

    class LoadPresentationRunnable
    implements Runnable {
        int slideType;
        StarOfficeLoadDialog progress = null;
        StarOfficeInformation starOfficeInformation;

        public LoadPresentationRunnable(int slideType, StarOfficeInformation starOfficeInformation) {
            this.slideType = slideType;
            this.starOfficeInformation = starOfficeInformation;
        }

        public void setProgress(StarOfficeLoadDialog progress) {
            this.progress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StarOfficeImport.this.countOfScreens = 0;
            StarOfficeImport.this.makeTempDir();
            try {
                StarOfficeImport.this.onShutdown();
                if (StarOfficeInformation.instance().getLoader() == null) {
                    StarOfficeInformation.instance().createLoader(StarOfficeImport.this.i18n, "127.0.0.1", "8100");
                }
                StarOfficeImport.this.loader = StarOfficeInformation.instance().getLoader();
                this.starOfficeInformation.setRunning(true);
                if (StarOfficeImport.this.loader.connect(this.starOfficeInformation, this.progress.getProgressBar())) {
                    StarOfficeImport.this.loader.convertFile(this.starOfficeInformation, StarOfficeImport.this.starOfficeFile, StarOfficeImport.this.tempPath, this.progress.getProgressBar(), StarOfficeImport.this.desiredWidth, StarOfficeImport.this.desiredHeight, true, true, 0, 1, this.slideType);
                    StarOfficeImport.this.countOfScreens = StarOfficeImport.this.loader.getImageCount();
                    StarOfficeImport.this.loaded = true;
                } else {
                    StarOfficeImport.this.countOfScreens = -7;
                    StarOfficeImport.this.failReason = StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CANNOTSTART);
                }
            }
            catch (CancelledException cex) {
                StarOfficeImport.this.countOfScreens = -5;
                StarOfficeImport.this.failReason = StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_USERCANCELLEDMSG);
            }
            catch (RuntimeException rx) {
                StarOfficeImport.this.countOfScreens = -6;
                StarOfficeImport.this.failReason = StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CALLFAILURE);
                throw rx;
            }
            catch (Throwable ex) {
                StarOfficeImport.this.countOfScreens = -6;
                StarOfficeImport.this.failReason = StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CALLFAILURE);
                if (WhiteboardDebug.STAROFFICE.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)ex));
                }
            }
            finally {
                this.starOfficeInformation.setRunning(true);
                this.progress.setVisible(false);
            }
        }
    }

    class StarOfficeLoadDialog
    extends CDialog {
        Thread presentationLoader;
        LoadPresentationRunnable loader;
        Frame owner;
        volatile boolean cancelledFlag;
        JLabel statusMsg;
        JButton cancelBtn;
        JProgressBar progressBar;
        Cursor waitCursor;
        Cursor prevCursor;
        StarOfficeInformation starOfficeInformation;
        StarOfficeLoadDialog thisRef;

        public StarOfficeLoadDialog(Frame owner, LoadPresentationRunnable loader, StarOfficeInformation starOfficeInformation) {
            super(owner, StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_LOADERTITLE), true);
            this.presentationLoader = null;
            this.loader = null;
            this.cancelledFlag = false;
            this.statusMsg = new JLabel();
            this.cancelBtn = new JButton(StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CANCELBTN));
            this.progressBar = new JProgressBar();
            this.waitCursor = Cursor.getPredefinedCursor(3);
            this.prevCursor = null;
            this.thisRef = this;
            this.owner = owner;
            this.loader = loader;
            this.starOfficeInformation = starOfficeInformation;
            this.getRootPane().putClientProperty("Window.style", "small");
            this.statusMsg.setFont(new Font("sansserif", 1, 12));
            this.setString(StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CONVERTING));
            this.progressBar.setBorderPainted(true);
            this.progressBar.setStringPainted(true);
            Dimension barDim = new Dimension(owner.getSize());
            barDim.height = 21;
            barDim.width -= 128;
            if (barDim.width < 128) {
                barDim.width = 128;
            } else if (barDim.width > 512) {
                barDim.width = 512;
            }
            this.progressBar.setPreferredSize(barDim);
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    StarOfficeLoadDialog.this.cancelledFlag = true;
                    StarOfficeLoadDialog.this.thisRef.starOfficeInformation.setRunning(false);
                    StarOfficeLoadDialog.this.setString(StarOfficeImport.this.i18n.getString((PropertiesEnum)StringsProperties.STAROFFICEIMPORT_CANCELMSG));
                    StarOfficeLoadDialog.this.cancelBtn.setEnabled(false);
                    if (StarOfficeLoadDialog.this.presentationLoader != null && StarOfficeLoadDialog.this.presentationLoader.isAlive()) {
                        StarOfficeLoadDialog.this.presentationLoader.interrupt();
                    }
                }
            });
            Container content = this.getContentPane();
            content.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(16, 12, 4, 12);
            content.add((Component)this.statusMsg, gbc);
            gbc.insets = new Insets(4, 12, 4, 12);
            content.add((Component)this.progressBar, gbc);
            gbc.fill = 0;
            gbc.insets = new Insets(12, 0, 8, 0);
            content.add((Component)this.cancelBtn, gbc);
            this.setResizable(false);
            this.pack();
            loader.setProgress(this);
        }

        public void setMinimum(int min) {
            this.progressBar.setMinimum(min);
        }

        public void setMaximum(int max) {
            this.progressBar.setMaximum(max);
        }

        public void setValue(int val) {
            this.progressBar.setValue(val);
        }

        public void setString(String text) {
            this.statusMsg.setText(text);
        }

        public JProgressBar getProgressBar() {
            return this.progressBar;
        }

        public boolean isCancelled() {
            if (this.presentationLoader != null && this.presentationLoader.isInterrupted()) {
                this.cancelledFlag = true;
            }
            return this.cancelledFlag;
        }

        public void checkCancelled() {
            if (this.presentationLoader != null && this.presentationLoader.isInterrupted()) {
                this.cancelledFlag = true;
            }
            if (this.cancelledFlag) {
                throw new PowerPointImport.CancelledException();
            }
        }

        public void setVisible(boolean vis) {
            if (vis) {
                this.presentationLoader = new WorkerThread((Runnable)this.loader, "OpenOffice.org Loader");
                this.presentationLoader.setDaemon(true);
                this.presentationLoader.start();
                Rectangle ownerBounds = this.owner.getBounds();
                Dimension dim = this.getSize();
                this.setLocation(ownerBounds.x + (ownerBounds.width - dim.width) / 2, ownerBounds.y + (ownerBounds.height - dim.height) / 2);
                if (this.prevCursor == null) {
                    this.prevCursor = this.owner.getCursor();
                }
                this.owner.setCursor(this.waitCursor);
            } else {
                if (this.presentationLoader != null && this.presentationLoader != Thread.currentThread() && this.presentationLoader.isAlive()) {
                    this.presentationLoader.interrupt();
                    this.cancelledFlag = true;
                }
                this.presentationLoader = null;
                if (this.owner.getCursor() == this.waitCursor) {
                    if (this.prevCursor != null) {
                        this.owner.setCursor(this.prevCursor);
                    } else {
                        this.owner.setCursor(Cursor.getDefaultCursor());
                    }
                }
                this.prevCursor = null;
            }
            super.setVisible(vis);
        }
    }
}

