/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.navigation;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.module.navigation.NullParentACLList;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import javax.swing.SwingUtilities;

public class ExplorerEnabledClerk {
    private ACLTerm followLeaderACL = null;
    private ACLTerm followLeaderAccessACL = null;
    private ACLTerm roamAbleACL = null;
    private ACLTerm roamAbleAccessACL = null;
    private WhiteboardContext context;
    private boolean followEnabled;
    private boolean roamEnabled;
    private boolean roamAccessEnabled;
    private boolean followAccessEnabled;
    private boolean explorerSelected = false;
    private boolean followSelected = true;

    public ExplorerEnabledClerk(WhiteboardContext context) {
        this.context = context;
        this.establishACLs();
    }

    private void establishACLs() {
        this.followLeaderACL = new ACLTerm("FollowLeader", new NullParentACLList(), this.context, false){

            public void notifyACLChange(Boolean state) {
                ExplorerEnabledClerk.this.notifyFollowLeader(state);
            }
        };
        this.followLeaderAccessACL = new ACLTerm("FollowLeaderAccess", new NullParentACLList(), this.context, false){

            public void notifyACLChange(Boolean state) {
                ExplorerEnabledClerk.this.notifyFollowLeaderAccess(state);
            }
        };
        this.roamAbleACL = new ACLTerm("RoamAble", new NullParentACLList(), this.context, false){

            public void notifyACLChange(Boolean state) {
                ExplorerEnabledClerk.this.notifyRoamAble(state);
            }
        };
        this.roamAbleAccessACL = new ACLTerm("RoamAbleAccess", new NullParentACLList(), this.context, false){

            public void notifyACLChange(Boolean state) {
                ExplorerEnabledClerk.this.notifyRoamAbleAccess(state);
            }
        };
        this.followLeaderACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_OF_RECORD_ROLE));
        this.followLeaderACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_ROLE));
        this.roamAbleACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.CURRENT_GROUP, "", ACLEntry.CHAIR_OF_RECORD_ROLE));
        this.roamAbleACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_ROLE));
        this.followLeaderAccessACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_OF_RECORD_ROLE));
        this.followLeaderAccessACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_ROLE));
        this.roamAbleAccessACL.addDefiningEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_OF_RECORD_ROLE));
        this.roamAbleAccessACL.addAcceptEntry(new ACLEntry(this.context, ACLEntry.ALL_CLIENTS, ACLEntry.ALL_GROUPS, "", ACLEntry.CHAIR_ROLE));
    }

    public void notifyFollowLeader(Boolean state) {
        this.validateFollowLeader();
    }

    public void notifyFollowLeaderAccess(Boolean state) {
        this.validateFollowLeader();
    }

    public void notifyRoamAble(Boolean state) {
        this.validateRoam();
    }

    public void notifyRoamAbleAccess(Boolean state) {
        this.validateRoam();
    }

    private void validateFollowLeader() {
        if (SwingUtilities.isEventDispatchThread()) {
            new ValidateFollowLeaderRunnable().run();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new ValidateFollowLeaderRunnable());
        }
    }

    public boolean isFollowEnabled() {
        return this.followEnabled;
    }

    public boolean isFollowAccessEnabled() {
        return this.followAccessEnabled;
    }

    public boolean isFollowSelected() {
        return this.followSelected;
    }

    public void setFollowSelected(boolean newValue) {
        this.followSelected = newValue;
    }

    public void setExplorerSelected(boolean newValue) {
        this.explorerSelected = newValue;
    }

    public boolean isExplorerSelected() {
        return this.explorerSelected;
    }

    private void validateRoam() {
        SwingRunnerSupport.invokeLater((Runnable)new ValidateRoamRunnable());
    }

    class ValidateFollowLeaderRunnable
    implements Runnable {
        ValidateFollowLeaderRunnable() {
        }

        @Override
        public void run() {
            try {
                if (ExplorerEnabledClerk.this.followLeaderACL != null) {
                    ExplorerEnabledClerk.this.followEnabled = ExplorerEnabledClerk.this.followLeaderACL.allows();
                    if (ExplorerEnabledClerk.this.followLeaderAccessACL != null) {
                        ExplorerEnabledClerk.this.followAccessEnabled = ExplorerEnabledClerk.this.followLeaderAccessACL.allows() || ExplorerEnabledClerk.this.followLeaderACL.allows();
                    }
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)ex, (boolean)true);
            }
        }
    }

    class ValidateRoamRunnable
    implements Runnable {
        ValidateRoamRunnable() {
        }

        @Override
        public void run() {
            try {
                if (ExplorerEnabledClerk.this.roamAbleACL != null) {
                    ExplorerEnabledClerk.this.roamEnabled = ExplorerEnabledClerk.this.roamAbleACL.allows();
                    if (ExplorerEnabledClerk.this.roamAbleAccessACL != null) {
                        ExplorerEnabledClerk.this.roamAccessEnabled = ExplorerEnabledClerk.this.roamAbleAccessACL.allows() || ExplorerEnabledClerk.this.roamAbleACL.allows();
                    }
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)ex, (boolean)true);
            }
        }
    }
}

