/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements ImageObserver,
PropertyChangeListener,
Runnable {
    static I18n i18n = I18n.create((Object)new Object(){});
    static final String BOLD_STYLE = "bold";
    static final String ITALIC_STYLE = "italic";
    static final String PLAIN_STYLE = "plain";
    static final int TEXT_SIZE = Integer.parseInt(i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_TEXTSIZE));
    static final int TEXT_STYLE = ImagePreview.parseStyle(i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_TEXTSTYLE));
    static final String BIG_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_BIGMESSAGE);
    static final String ERROR_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_ERRORMESSAGE);
    static final String IO_ERROR_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_IOERRORMESSAGE);
    static final String NO_PREVIEW_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_NOPREVIEWMESSAGE);
    static final String PREPARE_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_PREPAREMESSAGE);
    static final String INTERRUPT_MESSAGE = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_INTERRUPTEDMESSAGE);
    static final int BORDER = 3;
    static final int TEXT_BORDER = 8;
    Image previewImage = null;
    File previewFile = null;
    String message = null;
    Thread previewThread = null;

    public static int parseStyle(String text) {
        int result = 0;
        StringTokenizer parser = new StringTokenizer(text);
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            if (token.equalsIgnoreCase(BOLD_STYLE)) {
                result |= 1;
                continue;
            }
            if (token.equalsIgnoreCase(ITALIC_STYLE)) {
                result |= 2;
                continue;
            }
            if (token.equalsIgnoreCase(PLAIN_STYLE)) {
                result = 0;
                continue;
            }
            LogSupport.message(ImagePreview.class, (String)"parseStyle", (String)("Invalid style token: " + token));
        }
        return result;
    }

    public ImagePreview(JFileChooser fc, int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        fc.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("fileViewChanged") || prop.equals("ChoosableFileFilterChangedProperty") || prop.equals("directoryChanged")) {
            this.dispose();
        }
        if (this.isShowing() && (prop.equals("SelectedFileChangedProperty") || prop.equals("SelectedFilesChangedProperty"))) {
            File[] files = null;
            if (prop.equals("SelectedFilesChangedProperty")) {
                files = (File[])e.getNewValue();
            } else {
                File f = (File)e.getNewValue();
                if (f != null) {
                    files = new File[]{f};
                }
            }
            if (files != null && files.length == 1 && files[0] != this.previewFile) {
                this.dispose();
                this.previewFile = files[0];
                ImagePreview imagePreview = this;
                synchronized (imagePreview) {
                    if (this.previewFile != null && this.previewFile.isFile()) {
                        this.message = PREPARE_MESSAGE;
                        this.previewThread = new WorkerThread((Runnable)this, "Image Loading Preview");
                        this.previewThread.setDaemon(true);
                        this.previewThread.start();
                    }
                }
            }
        }
        this.repaint();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ImagePreview imagePreview = this;
        synchronized (imagePreview) {
            if (this.previewThread != null) {
                this.previewThread.interrupt();
                this.previewThread = null;
            }
            if (this.previewImage != null) {
                this.previewImage.flush();
                this.previewImage = null;
            }
            this.previewFile = null;
        }
    }

    /*
     * Exception decompiling
     */
    private Object loadPreviewImage(File file, int width, int height) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 45[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            File f = null;
            ImagePreview imagePreview = this;
            synchronized (imagePreview) {
                if (Thread.currentThread() != this.previewThread) {
                    return;
                }
                f = this.previewFile;
            }
            Object result = this.loadPreviewImage(f, this.getSize().width - 6, this.getSize().height - 6);
            ImagePreview imagePreview2 = this;
            synchronized (imagePreview2) {
                if (Thread.currentThread() != this.previewThread) {
                    if (result instanceof Image) {
                        ((Image)result).flush();
                    }
                    return;
                }
                this.previewThread = null;
                if (this.previewImage != null) {
                    this.previewImage.flush();
                    this.previewImage = null;
                }
                if (result == null) {
                    this.message = null;
                } else if (result instanceof Image) {
                    this.previewImage = (Image)result;
                } else {
                    this.message = result.toString();
                }
            }
        }
        catch (Throwable t) {
            ImagePreview imagePreview = this;
            synchronized (imagePreview) {
                if (Thread.currentThread() != this.previewThread) {
                    return;
                }
                this.dispose();
                this.message = ERROR_MESSAGE;
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ImagePreview.this.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        ImagePreview imagePreview = this;
        synchronized (imagePreview) {
            Insets ins = this.getInsets();
            int componentWidth = this.getWidth() - ins.left - ins.right;
            int componentHeight = this.getHeight() - ins.top - ins.bottom;
            int imageWidth = -1;
            int imageHeight = -1;
            if (this.previewImage != null) {
                imageWidth = this.previewImage.getWidth(this);
                imageHeight = this.previewImage.getHeight(this);
            }
            if (imageWidth > 0 && imageHeight > 0) {
                boolean displayGood;
                int paintWidth = imageWidth;
                int paintHeight = imageHeight;
                int imageX = (componentWidth - imageWidth) / 2;
                int imageY = (componentHeight - imageHeight) / 2;
                if (imageX < 3 || imageY < 3) {
                    int targetWidth = componentWidth - 3 - 3;
                    double scaleWidth = (double)targetWidth / (double)imageWidth;
                    int targetHeight = componentHeight - 3 - 3;
                    double scaleHeight = (double)targetHeight / (double)imageHeight;
                    if (scaleWidth < scaleHeight) {
                        paintWidth = (int)(scaleWidth * (double)imageWidth);
                        paintHeight = (int)(scaleWidth * (double)imageHeight);
                    } else {
                        paintWidth = (int)(scaleHeight * (double)imageWidth);
                        paintHeight = (int)(scaleHeight * (double)imageHeight);
                    }
                    imageX = (componentWidth - paintWidth) / 2;
                    imageY = (componentHeight - paintHeight) / 2;
                    displayGood = g.drawImage(this.previewImage, ins.left + imageX, ins.top + imageY, paintWidth, paintHeight, this);
                    g.setColor(Color.black);
                    g.drawRect(ins.left, ins.top, componentWidth - 1, componentHeight - 1);
                } else {
                    displayGood = g.drawImage(this.previewImage, ins.left + imageX, ins.top + imageY, this);
                }
                if (displayGood) {
                    this.message = null;
                    String anno = i18n.getString((PropertiesEnum)StringsProperties.IMAGEPREVIEW_SIZEANNOTATION, new Object[]{new Integer(imageWidth), new Integer(imageHeight)});
                    if (!anno.equals(this.getToolTipText())) {
                        this.setToolTipText(anno);
                    }
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
                g.setColor(this.getBackground());
                g.fillRect(ins.left, ins.top, componentWidth, componentHeight);
                if (this.message != null) {
                    Font f = this.getFont().deriveFont(TEXT_STYLE, TEXT_SIZE);
                    this.paintMessage(g, f, this.message, ins.left, ins.top, componentWidth, componentHeight);
                }
            }
        }
    }

    private void paintMessage(Graphics g, Font f, String text, int x, int y, int w, int h) {
        FontMetrics fm = g.getFontMetrics(f);
        String[] lines = this.breakLines(text, fm, w - 16);
        g.setFont(f);
        g.setColor(Color.black);
        int vIndent = (h - lines.length * fm.getHeight()) / 2;
        if (vIndent < 0) {
            vIndent = 0;
        }
        int dY = fm.getAscent() + vIndent;
        for (int ix = 0; ix < lines.length && dY < h; dY += fm.getHeight(), ++ix) {
            int hIndent = (w - fm.stringWidth(lines[ix])) / 2;
            if (hIndent < 0) {
                hIndent = 0;
            }
            g.drawString(lines[ix], x + hIndent, y + dY);
        }
    }

    private String[] breakLines(String message, FontMetrics fm, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer parser = new StringTokenizer(message, "\n");
        while (parser.hasMoreTokens()) {
            String text = parser.nextToken().trim();
            int strWidth = fm.stringWidth(text);
            if (strWidth <= width) {
                lines.add(text);
                continue;
            }
            int breakPos = -1;
            int contPos = -1;
            int startPos = 0;
            char[] chars = text.toCharArray();
            for (int pos = 0; pos < chars.length; ++pos) {
                if (Character.isWhitespace(chars[pos]) && pos > 0) {
                    breakPos = pos++;
                    while (pos < chars.length && Character.isWhitespace(chars[pos])) {
                        ++pos;
                    }
                    contPos = pos;
                    continue;
                }
                int posWidth = fm.charsWidth(chars, startPos, pos - startPos + 1);
                if (posWidth <= width) continue;
                if (breakPos > 0) {
                    lines.add(new String(chars, startPos, breakPos - startPos));
                    startPos = contPos;
                    breakPos = -1;
                    contPos = -1;
                    continue;
                }
                lines.add(new String(chars, startPos, pos - startPos));
                startPos = pos;
            }
            if (startPos >= chars.length) continue;
            lines.add(new String(chars, startPos, chars.length - startPos));
        }
        return lines.toArray(new String[lines.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        ImagePreview imagePreview = this;
        synchronized (imagePreview) {
            if (this.previewImage != null && img != this.previewImage) {
                img.flush();
                return false;
            }
            if ((infoflags & 0x30) != 0 && this.previewImage != null) {
                this.repaint();
            }
        }
        return (infoflags & 0x20) == 0;
    }
}

