/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageInputDialog;
import com.elluminate.groupware.whiteboard.module.imageloading.SelectFrame;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.ProgressSteps;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ImageCapturePanel
extends JPanel {
    private static final Method getWindowsMethod;
    private I18n i18n = I18n.create((Object)this);
    private Dialog parentDialog;
    private Frame appFrame;
    private ImageInputDialog cancelListener;
    private static final boolean ENABLE_SCALE_UP = false;
    private int maxWidth;
    private int maxHeight;
    private Rectangle selectRectangle = null;
    private static Point lastSelectLocation;
    private static Dimension lastSelectSize;
    private SelectFrame selectFrame;
    private ByteArrayOutputStream imageOutputStream;
    private JPanel selectTypePanel = new JPanel();
    private TitledBorder selectTypeTitle;
    private ButtonGroup selectButtonGroup = new ButtonGroup();
    private JRadioButton encodeAsPNG = new JRadioButton();
    private JRadioButton encodeAsJPEG = new JRadioButton();
    private static final int ENCODE_AS_JPEG = 1;
    private static final int ENCODE_AS_PNG = 2;
    private static int selectButtonDefault;
    private JPanel ImageEncodePanel = new JPanel();
    private JPanel areaPanel = new JPanel();
    private ButtonGroup areaButtonGroup = new ButtonGroup();
    private JRadioButton selectedAreaButton = new JRadioButton();
    private JRadioButton entireButton = new JRadioButton();
    private JRadioButton entireDelayedButton = new JRadioButton();
    private static final int SELECT_AREA = 1;
    private static final int SELECT_ENTIRE = 2;
    private static final int SELECT_ENTIRE_DELAYED = 3;
    private static int areaButtonDefault;
    private JPanel jpegPanel = new JPanel();
    private TitledBorder jpegEncodeSettings;
    private ButtonGroup jpegButtonGroup = new ButtonGroup();
    private JRadioButton lowQualityButton = new JRadioButton();
    private JRadioButton mediumQualityButton = new JRadioButton();
    private JRadioButton highQualityButton = new JRadioButton();
    private static final int LOW_QUALITY_JPEG = 1;
    private static final int MEDIUM_QUALITY_JPEG = 2;
    private static final int HIGH_QUALITY_JPEG = 3;
    private static int jpegEncodeDefault;
    private JPanel pngPanel = new JPanel();
    private TitledBorder pngPanelTitle;
    private ButtonGroup pngButtonGroup = new ButtonGroup();
    private JRadioButton pngDefaultCompression = new JRadioButton();
    private JRadioButton pngNoCompression = new JRadioButton();
    private JRadioButton pngFastCompression = new JRadioButton();
    private JRadioButton pngMaxCompression = new JRadioButton();
    private static final int DEFAULT_COMP_PNG = 1;
    private static final int NO_COMP_PNG = 2;
    private static final int FAST_COMP_PNG = 3;
    private static final int MAX_COMP_PNG = 4;
    private static int pngEncodeDefault;
    private JPanel actuatePanel = new JPanel();
    private JButton captureButton = new JButton();
    private JCheckBox hideApplicationCheckbox = new JCheckBox();
    private JCheckBox scaleUpToFitCheckbox = new JCheckBox();
    private JCheckBox scaleDownToFitCheckbox = new JCheckBox();
    private static boolean hideDefault;
    private static boolean scaleUpDefault;
    private static boolean scaleDownDefault;
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private GridBagLayout gridBagLayout5 = new GridBagLayout();
    private String suffix = ".jpeg";
    private static int nextCaptureNumber;
    private static boolean isSupported;
    private static boolean enableHideApp;
    final double imageQualityHigh = 0.75;
    final double imageQualityMedium = 0.55;
    final double imageQualityLow = 0.35;
    private TitledBorder areaTitle;
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private boolean cancelled = true;
    private JButton cancelButton = new JButton();
    private ArrayList origWinState = new ArrayList(64);
    private LightweightTimer countdownTimer = null;

    public ImageCapturePanel(Dialog parentDialog, int maxWidth, int maxHeight) {
        this.parentDialog = parentDialog;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"<init>", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.pngPanelTitle = new TitledBorder("");
        this.jpegEncodeSettings = new TitledBorder("");
        this.selectTypeTitle = new TitledBorder("");
        this.areaTitle = new TitledBorder("");
        this.actuatePanel.setLayout(this.gridBagLayout1);
        this.setLayout(this.borderLayout2);
        this.hideApplicationCheckbox.setEnabled(enableHideApp || GUIDebug.APP_SNAP_HIDE.isEnabled());
        this.hideApplicationCheckbox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_HIDEAPPLICATIONCHECKBOX_TOOLTIPTEXT));
        this.hideApplicationCheckbox.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_HIDEAPPLICATIONCHECKBOX_TEXT));
        this.hideApplicationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                hideDefault = ImageCapturePanel.this.hideApplicationCheckbox.isSelected();
            }
        });
        this.scaleUpToFitCheckbox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SCALEUPTOFIT_TOOLTIPTEXT));
        this.scaleUpToFitCheckbox.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SCALEUPTOFIT_TEXT));
        this.scaleUpToFitCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaleUpDefault = ImageCapturePanel.this.scaleUpToFitCheckbox.isSelected();
            }
        });
        this.scaleUpToFitCheckbox.setVisible(false);
        this.scaleDownToFitCheckbox.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SCALEDOWNTOFIT_TOOLTIPTEXT));
        this.scaleDownToFitCheckbox.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SCALEDOWNTOFIT_TEXT));
        this.scaleDownToFitCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaleDownDefault = ImageCapturePanel.this.scaleDownToFitCheckbox.isSelected();
            }
        });
        this.captureButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SNAPIMAGE_TOOLTIPTEXT));
        this.captureButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SNAPIMAGE_TEXT));
        this.captureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageCapturePanel.this.snapImage();
            }
        });
        this.encodeAsPNG.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEASPNG_TEXT));
        this.encodeAsPNG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectButtonDefault = 2;
                ImageCapturePanel.this.enableEncodeButtons(false);
            }
        });
        this.ImageEncodePanel.setAlignmentX(0.0f);
        this.ImageEncodePanel.setAlignmentY(0.0f);
        this.ImageEncodePanel.setLayout(this.gridBagLayout2);
        this.encodeAsJPEG.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEASJPEG_TEXT));
        this.encodeAsJPEG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectButtonDefault = 1;
                ImageCapturePanel.this.enableEncodeButtons(true);
            }
        });
        this.pngPanel.setBorder(BorderFactory.createCompoundBorder(this.pngPanelTitle, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        this.pngPanel.setLayout(this.gridBagLayout3);
        this.jpegPanel.setBorder(BorderFactory.createCompoundBorder(this.jpegEncodeSettings, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        this.jpegPanel.setPreferredSize(new Dimension(131, 80));
        this.jpegPanel.setLayout(this.gridBagLayout4);
        this.selectTypePanel.setBorder(BorderFactory.createCompoundBorder(this.selectTypeTitle, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        this.selectTypePanel.setLayout(this.gridBagLayout5);
        this.pngFastCompression.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_PNGFASTCOMPRESSION_TEXT));
        this.pngFastCompression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pngEncodeDefault = 3;
            }
        });
        this.pngPanelTitle.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_PNGPANELTITLE_TITLE));
        if (Platform.getPlatform() != 2) {
            this.selectedAreaButton.setMnemonic('u');
        }
        this.selectedAreaButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SELECTEDAREABUTTON_TEXT));
        this.selectedAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                areaButtonDefault = 1;
            }
        });
        if (Platform.getPlatform() != 2) {
            this.highQualityButton.setMnemonic('h');
        }
        this.highQualityButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_HIGHQUALITYBUTTON_TEXT));
        this.highQualityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jpegEncodeDefault = 3;
            }
        });
        if (Platform.getPlatform() != 2) {
            this.mediumQualityButton.setMnemonic('m');
        }
        this.mediumQualityButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_MEDIUMQUALITYBUTTON_TEXT));
        this.mediumQualityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jpegEncodeDefault = 2;
            }
        });
        if (Platform.getPlatform() != 2) {
            this.lowQualityButton.setMnemonic('l');
        }
        this.lowQualityButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_LOWQUALITYBUTTON_TEXT));
        this.lowQualityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jpegEncodeDefault = 1;
            }
        });
        if (Platform.getPlatform() != 2) {
            this.entireButton.setMnemonic('e');
        }
        this.entireButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENTIREBUTTON_TEXT));
        this.entireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                areaButtonDefault = 2;
            }
        });
        if (Platform.getPlatform() != 2) {
            this.entireDelayedButton.setMnemonic('d');
        }
        this.entireDelayedButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENTIREDELAYEDBUTTON_TEXT));
        this.entireDelayedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                areaButtonDefault = 3;
            }
        });
        this.jpegEncodeSettings.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_JPEGENCODESETTINGS_TITLE));
        this.selectTypeTitle.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_SELECTTYPETITLE_TITLE));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.areaPanel.setBorder(BorderFactory.createCompoundBorder(this.areaTitle, BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        this.areaPanel.setLayout(this.gridBagLayout6);
        this.areaTitle.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_AREATITLE_TITLE));
        this.pngMaxCompression.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_PNGMAXCOMPRESSION_TEXT));
        this.pngMaxCompression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pngEncodeDefault = 4;
            }
        });
        this.pngNoCompression.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_PNGNOCOMPRESSION_TEXT));
        this.pngNoCompression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pngEncodeDefault = 2;
            }
        });
        this.pngDefaultCompression.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_PNGDEFAULTCOMPRESSION_TEXT));
        this.pngDefaultCompression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pngEncodeDefault = 1;
            }
        });
        this.cancelButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_CAPTURECANCEL_TEXT));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageCapturePanel.this.cancelled = true;
                if (ImageCapturePanel.this.cancelListener != null) {
                    ImageCapturePanel.this.cancelListener.cancelDialog();
                }
            }
        });
        this.actuatePanel.add((Component)this.hideApplicationCheckbox, new GridBagConstraints(0, 0, 1, 1, 50.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.actuatePanel.add((Component)this.scaleUpToFitCheckbox, new GridBagConstraints(1, 0, 1, 1, 50.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.actuatePanel.add((Component)this.scaleDownToFitCheckbox, new GridBagConstraints(2, 0, 1, 1, 50.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.actuatePanel.add((Component)this.captureButton, new GridBagConstraints(3, 0, 1, 1, 50.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.actuatePanel.add((Component)this.cancelButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 10), 0, 0));
        this.selectTypePanel.add((Component)this.encodeAsJPEG, new GridBagConstraints(0, 0, 1, 1, 50.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.selectTypePanel.add((Component)this.encodeAsPNG, new GridBagConstraints(1, 0, 1, 1, 50.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.pngPanel.add((Component)this.pngMaxCompression, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pngPanel.add((Component)this.pngFastCompression, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pngPanel.add((Component)this.pngNoCompression, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pngPanel.add((Component)this.pngDefaultCompression, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jpegPanel.add((Component)this.lowQualityButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jpegPanel.add((Component)this.mediumQualityButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jpegPanel.add((Component)this.highQualityButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ImageEncodePanel.add((Component)this.areaPanel, new GridBagConstraints(0, 0, 2, 1, 100.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.areaPanel.add((Component)this.entireButton, new GridBagConstraints(0, 0, 1, 1, 33.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.areaPanel.add((Component)this.entireDelayedButton, new GridBagConstraints(1, 0, 1, 1, 33.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.areaPanel.add((Component)this.selectedAreaButton, new GridBagConstraints(2, 0, 1, 1, 33.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.ImageEncodePanel.add((Component)this.pngPanel, new GridBagConstraints(1, 2, 1, 1, 50.0, 100.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ImageEncodePanel.add((Component)this.jpegPanel, new GridBagConstraints(0, 2, 1, 1, 50.0, 100.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ImageEncodePanel.add((Component)this.selectTypePanel, new GridBagConstraints(0, 1, 2, 1, 100.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.actuatePanel, "South");
        this.add((Component)this.ImageEncodePanel, "Center");
        this.appFrame = GuiUtils.getFrame((Component)this.parentDialog);
        this.selectButtonGroup.add(this.encodeAsJPEG);
        this.selectButtonGroup.add(this.encodeAsPNG);
        this.areaButtonGroup.add(this.selectedAreaButton);
        this.areaButtonGroup.add(this.entireButton);
        this.areaButtonGroup.add(this.entireDelayedButton);
        this.jpegButtonGroup.add(this.lowQualityButton);
        this.jpegButtonGroup.add(this.mediumQualityButton);
        this.jpegButtonGroup.add(this.highQualityButton);
        this.pngButtonGroup.add(this.pngDefaultCompression);
        this.pngButtonGroup.add(this.pngNoCompression);
        this.pngButtonGroup.add(this.pngFastCompression);
        this.pngButtonGroup.add(this.pngMaxCompression);
        this.setDefaults();
    }

    public static boolean canInstantiate() {
        return isSupported;
    }

    public void setButtonsVisible(boolean visible) {
        this.captureButton.setVisible(visible);
        this.cancelButton.setVisible(visible);
    }

    public void setCancelListener(ImageInputDialog myDialogParent) {
        this.cancelListener = myDialogParent;
    }

    private void checkPrevBounds(Rectangle screenBounds, Rectangle[] screens) {
        if (lastSelectSize == null || lastSelectLocation == null) {
            return;
        }
        if (ImageCapturePanel.lastSelectSize.width > screenBounds.width) {
            ImageCapturePanel.lastSelectSize.width = screenBounds.width;
        }
        if (ImageCapturePanel.lastSelectSize.height > screenBounds.height) {
            ImageCapturePanel.lastSelectSize.height = screenBounds.height;
        }
        if (ImageCapturePanel.lastSelectLocation.x < screenBounds.x) {
            ImageCapturePanel.lastSelectLocation.x = screenBounds.x;
        }
        if (ImageCapturePanel.lastSelectLocation.y < screenBounds.y) {
            ImageCapturePanel.lastSelectLocation.y = screenBounds.y;
        }
        int screenEndX = screenBounds.x + screenBounds.width;
        int screenEndY = screenBounds.y + screenBounds.height;
        if (ImageCapturePanel.lastSelectLocation.x + ImageCapturePanel.lastSelectSize.width > screenEndX) {
            ImageCapturePanel.lastSelectLocation.x = screenEndX - ImageCapturePanel.lastSelectSize.width;
        }
        if (ImageCapturePanel.lastSelectLocation.y + ImageCapturePanel.lastSelectSize.height > screenEndY) {
            ImageCapturePanel.lastSelectLocation.y = screenEndY - ImageCapturePanel.lastSelectSize.height;
        }
        if (GUIDebug.APP_SNAP.show()) {
            LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Vetting window location vs. screens: loc=" + lastSelectLocation + " dim= " + lastSelectSize));
        }
        Point topLeft = new Point(lastSelectLocation);
        Point topRight = new Point(ImageCapturePanel.lastSelectLocation.x + ImageCapturePanel.lastSelectSize.width - 1, ImageCapturePanel.lastSelectLocation.y);
        boolean hasTopLeft = false;
        boolean hasTopRight = false;
        for (int sno = 0; sno < screens.length; ++sno) {
            int ix;
            boolean extendY;
            boolean extendX;
            int dEdgeY;
            int dEdgeX;
            if (screens[sno].contains(topLeft)) {
                dEdgeX = screens[sno].x + screens[sno].width - 1 - topLeft.x;
                dEdgeY = screens[sno].y + screens[sno].height - topLeft.y;
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft found in " + screens[sno] + " dEdgeX=" + dEdgeX + " dEdgeY=" + dEdgeY));
                }
                extendX = false;
                extendY = false;
                for (ix = 0; ix < screens.length; ++ix) {
                    if (ix == sno) continue;
                    if (screens[ix].contains(screens[sno].x + screens[sno].width + 1, topLeft.y)) {
                        extendX = true;
                        if (GUIDebug.APP_SNAP.show()) {
                            LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft X extension by " + screens[ix]));
                        }
                    }
                    if (!screens[ix].contains(topLeft.x, screens[sno].y + screens[sno].height + 1)) continue;
                    extendY = true;
                    if (!GUIDebug.APP_SNAP.show()) continue;
                    LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft Y extension by " + screens[ix]));
                }
                boolean bl = hasTopLeft = !(dEdgeX <= 8 && !extendX || dEdgeY <= 3 && !extendY);
            }
            if (!screens[sno].contains(topRight)) continue;
            dEdgeX = screens[sno].x - topRight.x;
            dEdgeY = screens[sno].y + screens[sno].height - topRight.y;
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopLeft found in " + screens[sno] + " dEdgeX=" + dEdgeX + " dEdgeY=" + dEdgeY));
            }
            extendX = false;
            extendY = false;
            for (ix = 0; ix < screens.length; ++ix) {
                if (ix == sno) continue;
                if (screens[ix].contains(screens[sno].x - 2, topLeft.y)) {
                    extendX = true;
                    if (GUIDebug.APP_SNAP.show()) {
                        LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopRight X extension by " + screens[ix]));
                    }
                }
                if (!screens[ix].contains(topLeft.x, screens[sno].y + screens[sno].height + 1)) continue;
                extendY = true;
                if (!GUIDebug.APP_SNAP.show()) continue;
                LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("TopRight Y extension by " + screens[ix]));
            }
            hasTopRight = !(dEdgeX <= 8 && !extendX || dEdgeY <= 3 && !extendY);
        }
        if (GUIDebug.APP_SNAP.show()) {
            LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Top left: " + topLeft + " " + hasTopLeft));
            LogSupport.message((Object)this, (String)"checkPrevBounds", (String)("Top right: " + topRight + " " + hasTopRight));
        }
        if (!hasTopLeft && !hasTopRight) {
            lastSelectLocation = null;
            lastSelectSize = null;
        }
    }

    private void hideApplicationWindows() {
        Window[] windows = this.getWindowList();
        if (windows == null) {
            if (this.appFrame == null) {
                return;
            }
            windows = new Window[]{this.appFrame, this.parentDialog};
        }
        for (int ix = 0; ix < windows.length; ++ix) {
            Runnable undo;
            if (windows[ix] == null || !windows[ix].isShowing()) continue;
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message((Object)this, (String)"hideApplicationWindows", (String)("Hiding " + windows[ix]));
            }
            if ((undo = GuiUtils.hideWindow((Window)windows[ix])) == null) continue;
            if (windows[ix] == this.appFrame) {
                this.origWinState.add(undo);
                continue;
            }
            this.origWinState.add(0, undo);
        }
    }

    private void unhideApplicationWindows() {
        if (this.origWinState.isEmpty()) {
            return;
        }
        for (int ix = this.origWinState.size() - 1; ix >= 0; --ix) {
            try {
                Runnable undo = (Runnable)this.origWinState.get(ix);
                if (undo == null) continue;
                if (GUIDebug.APP_SNAP.show()) {
                    LogSupport.message((Object)this, (String)"unhideApplicationWindows", (String)("Restoring " + undo));
                }
                undo.run();
                continue;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"unhideApplicationWindows", (Throwable)t, (boolean)true);
            }
        }
        this.origWinState.clear();
    }

    private Window[] getWindowList() {
        if (getWindowsMethod != null) {
            try {
                return (Window[])getWindowsMethod.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"getWindowList", (Throwable)ex, (boolean)true);
            }
        }
        ArrayList<Window> windows = new ArrayList<Window>(64);
        Frame[] list = Frame.getFrames();
        if (list == null) {
            return null;
        }
        for (int ix = 0; ix < list.length; ++ix) {
            if (list[ix] == null || windows.contains(list[ix])) continue;
            windows.add(list[ix]);
            Window[] subWindows = list[ix].getOwnedWindows();
            if (subWindows == null) continue;
            for (int jx = 0; jx < subWindows.length; ++jx) {
                if (subWindows[jx] == null || windows.contains(subWindows[jx])) continue;
                windows.add(subWindows[jx]);
            }
        }
        if (windows.size() < 1) {
            return null;
        }
        return windows.toArray(new Window[windows.size()]);
    }

    public void snapImage() {
        Runnable action = null;
        Rectangle screenBounds = new Rectangle();
        Rectangle[] screens = GuiUtils.getScreenBounds((Rectangle)screenBounds);
        if (screens == null || screens.length < 1) {
            lastSelectLocation = null;
            lastSelectSize = null;
        }
        this.origWinState.clear();
        this.cancelled = false;
        try {
            this.selectFrame = new SelectFrame(this.appFrame);
            if (this.hideApplicationCheckbox.isSelected()) {
                this.hideApplicationWindows();
            } else {
                Runnable undo = GuiUtils.hideWindow((Window)this.parentDialog);
                if (undo != null) {
                    this.origWinState.add(undo);
                }
            }
            this.imageOutputStream = new ByteArrayOutputStream();
            try {
                block36: {
                    block33: {
                        int h;
                        int w;
                        int y;
                        int x;
                        block35: {
                            block34: {
                                if (!this.selectedAreaButton.isSelected()) break block33;
                                if (lastSelectSize != null && lastSelectLocation != null) {
                                    if (GUIDebug.APP_SNAP.show()) {
                                        LogSupport.message((Object)this, (String)"snapImage", (String)("Desktop bounds: " + screenBounds));
                                        LogSupport.message((Object)this, (String)"snapImage", (String)("Vetting window location vs. bounds: loc=" + lastSelectLocation + " dim=" + lastSelectSize));
                                    }
                                    this.checkPrevBounds(screenBounds, screens);
                                }
                                x = 0;
                                y = 0;
                                w = this.maxWidth;
                                h = this.maxHeight;
                                if (lastSelectSize != null && lastSelectLocation != null) break block34;
                                if (screens == null || screens.length <= 0) break block35;
                                x = screens[0].x;
                                y = screens[0].y;
                                break block35;
                            }
                            if (ImageCapturePanel.lastSelectSize.width > 0 && ImageCapturePanel.lastSelectSize.height > 0 && screens != null) {
                                Rectangle r = new Rectangle(lastSelectLocation, lastSelectSize);
                                for (int ix = 0; ix < screens.length; ++ix) {
                                    int area = -1;
                                    Rectangle isect = screens[ix].intersection(r);
                                    if (!isect.isEmpty()) {
                                        area = isect.width * isect.height;
                                    }
                                    if (isect.width <= 4 || isect.height <= 4 || area <= 256) continue;
                                    x = ImageCapturePanel.lastSelectLocation.x;
                                    y = ImageCapturePanel.lastSelectLocation.y;
                                    w = ImageCapturePanel.lastSelectSize.width;
                                    h = ImageCapturePanel.lastSelectSize.height;
                                    break;
                                }
                            }
                        }
                        if (GUIDebug.APP_SNAP.show()) {
                            LogSupport.message((Object)this, (String)"snapImage", (String)("Placing select frame: " + x + "," + y + " " + w + "x" + h));
                        }
                        this.selectFrame.setFrameLocation(x, y);
                        this.selectFrame.setFrameSize(w, h);
                        this.selectFrame.setWbBounds(this.maxWidth, this.maxHeight);
                        this.selectRectangle = this.selectFrame.showModal();
                        lastSelectSize = this.selectRectangle.getSize();
                        lastSelectLocation = this.selectRectangle.getLocation();
                        if (GUIDebug.APP_SNAP.show()) {
                            LogSupport.message((Object)this, (String)"snapImage", (String)("Saved position: " + lastSelectLocation + " " + lastSelectSize));
                        }
                        break block36;
                    }
                    if (this.entireDelayedButton.isSelected()) {
                        long dt;
                        CDialog countdownDialog;
                        int timeDelay = 10;
                        JLabel countdownLabel = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_DELAYCOUNTDOWN, new Object[]{new Integer(10)}));
                        Window win = SwingUtilities.windowForComponent(this);
                        if (win instanceof JFrame) {
                            countdownDialog = new CDialog((Frame)((JFrame)win), this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_DELAYTITLE), true);
                        } else if (win instanceof JDialog) {
                            countdownDialog = new CDialog((Dialog)((JDialog)win), this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_DELAYTITLE), true);
                        } else {
                            countdownDialog = new CDialog();
                            countdownDialog.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_DELAYTITLE));
                            countdownDialog.setModal(true);
                        }
                        countdownDialog.getRootPane().putClientProperty("Window.style", "small");
                        Runnable countdownAction = new Runnable((JDialog)countdownDialog, countdownLabel){
                            int snapCount = 10;
                            final /* synthetic */ JDialog val$countdownDialog;
                            final /* synthetic */ JLabel val$countdownLabel;
                            {
                                this.val$countdownDialog = jDialog;
                                this.val$countdownLabel = jLabel;
                            }

                            @Override
                            public void run() {
                                --this.snapCount;
                                if (this.snapCount <= 2) {
                                    LightweightTimer timer = ImageCapturePanel.this.countdownTimer;
                                    if (timer != null) {
                                        timer.cancel();
                                    }
                                    ImageCapturePanel.this.cancelled = false;
                                    if (this.val$countdownDialog.isVisible()) {
                                        this.val$countdownDialog.setVisible(false);
                                    }
                                } else {
                                    String msg = ImageCapturePanel.this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_DELAYCOUNTDOWN, new Object[]{new Integer(this.snapCount)});
                                    this.val$countdownLabel.setText(msg);
                                }
                            }
                        };
                        this.countdownTimer = new LightweightTimer(2, countdownAction);
                        this.countdownTimer.scheduleEvery(1000L);
                        JPanel countdownPanel = new JPanel(new BorderLayout());
                        countdownPanel.add(Box.createHorizontalStrut(24), "West");
                        countdownPanel.add(Box.createVerticalStrut(18), "North");
                        countdownPanel.add((Component)countdownLabel, "Center");
                        countdownPanel.add(Box.createVerticalStrut(18), "South");
                        countdownPanel.add(Box.createHorizontalStrut(24), "East");
                        JButton countdownCancelBtn = new JButton(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_CANCELCOUNTDOWNBUTTON));
                        ActionListener countdownCancelAction = new ActionListener((JDialog)countdownDialog){
                            final /* synthetic */ JDialog val$countdownDialog;
                            {
                                this.val$countdownDialog = jDialog;
                            }

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                ImageCapturePanel.this.cancelled = true;
                                LightweightTimer timer = ImageCapturePanel.this.countdownTimer;
                                ImageCapturePanel.this.countdownTimer = null;
                                if (timer != null) {
                                    timer.cancel();
                                }
                                this.val$countdownDialog.setVisible(false);
                            }
                        };
                        countdownCancelBtn.addActionListener(countdownCancelAction);
                        countdownCancelBtn.registerKeyboardAction(countdownCancelAction, "cancel", KeyStroke.getKeyStroke(27, 0, false), 2);
                        JPanel countdownButtonPanel = new JPanel(new FlowLayout());
                        countdownButtonPanel.add(countdownCancelBtn);
                        countdownDialog.getRootPane().setDefaultButton(countdownCancelBtn);
                        countdownDialog.getContentPane().setLayout(new BorderLayout());
                        countdownDialog.getContentPane().add((Component)countdownPanel, "Center");
                        countdownDialog.getContentPane().add((Component)countdownButtonPanel, "South");
                        this.cancelled = true;
                        countdownDialog.pack();
                        countdownDialog.setLocationRelativeTo(null);
                        long snapTime = System.currentTimeMillis() + 10000L;
                        countdownDialog.setVisible(true);
                        countdownDialog.dispose();
                        LightweightTimer timer = this.countdownTimer;
                        this.countdownTimer = null;
                        if (timer != null) {
                            timer.cancel();
                        }
                        if ((dt = snapTime - System.currentTimeMillis()) >= 50L) {
                            try {
                                Thread.sleep(dt);
                            }
                            catch (InterruptedException ignored) {
                                // empty catch block
                            }
                        }
                    }
                    if (!this.cancelled) {
                        this.selectFrame.setWbBounds(this.maxWidth, this.maxHeight);
                        this.selectRectangle = this.selectFrame.grabDesktop();
                    }
                }
                if (!this.cancelled) {
                    this.cancelled = this.selectFrame.isCancelled();
                }
                if (!this.cancelled && this.selectRectangle != null) {
                    action = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                try {
                                    ImageCapturePanel.this.imageOutputStream = ImageCapturePanel.this.encodeImage(((ImageCapturePanel)ImageCapturePanel.this).selectRectangle.width, ((ImageCapturePanel)ImageCapturePanel.this).selectRectangle.height, ImageCapturePanel.this.maxWidth, ImageCapturePanel.this.maxHeight);
                                }
                                catch (OutOfMemoryError oom) {
                                    ImageCapturePanel.this.cancelled = true;
                                    ImageCapturePanel.this.imageOutputStream = null;
                                    ModalDialog.showMessageDialog(null, (Object)ImageCapturePanel.this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_MEMORYERRORMSG), (String)ImageCapturePanel.this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ERRORTITLE), (int)0);
                                }
                                catch (Throwable t) {
                                    LogSupport.exception((Object)this, (String)"run (for ImageCapturePanel.snapImage)", (Throwable)t, (boolean)true);
                                }
                                if (ImageCapturePanel.this.selectFrame != null) {
                                    ImageCapturePanel.this.selectFrame.disposeImage();
                                    ImageCapturePanel.this.selectFrame.dispose();
                                }
                            }
                            finally {
                                ImageCapturePanel.this.unhideApplicationWindows();
                                ImageCapturePanel.this.parentDialog.setVisible(false);
                            }
                        }
                    };
                }
            }
            catch (Throwable t1) {
                LogSupport.exception((Object)this, (String)"snapImage", (Throwable)t1, (boolean)true);
                this.selectRectangle = null;
            }
        }
        catch (Throwable t2) {
            LogSupport.exception((Object)this, (String)"snapImage", (Throwable)t2, (boolean)true);
        }
        if (action != null) {
            WorkerThread doIt = new WorkerThread(action, "AppSnap Image Encoder");
            doIt.setDaemon(true);
            try {
                doIt.start();
            }
            catch (Throwable t) {
                action = null;
                LogSupport.exception((Object)this, (String)"snapImage", (Throwable)t, (boolean)true);
            }
        }
        if (action == null) {
            if (this.selectFrame != null) {
                this.selectFrame.disposeImage();
                this.selectFrame.dispose();
            }
            this.unhideApplicationWindows();
            this.parentDialog.setVisible(false);
        }
    }

    public String getCaptureName() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_CAPTURE) + nextCaptureNumber++ + this.suffix;
    }

    public String getCaptureSuffix() {
        return this.suffix;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream encodeImage(int encodeWidth, int encodeHeight, int maxWidth, int maxHeight) {
        double widthScale = 1.0;
        double heightScale = 1.0;
        double scale = 1.0;
        if (encodeWidth > maxWidth || encodeHeight > maxHeight) {
            if (scaleDownDefault) {
                widthScale = (double)maxWidth / (double)encodeWidth;
                heightScale = (double)maxHeight / (double)encodeHeight;
                scale = Math.min(widthScale, heightScale);
            }
        } else if (scaleUpDefault) {
            widthScale = (double)maxWidth / (double)encodeWidth;
            heightScale = (double)maxHeight / (double)encodeHeight;
            scale = Math.min(widthScale, heightScale);
        }
        this.imageOutputStream = new ByteArrayOutputStream();
        ProgressSteps prg = null;
        try {
            try {
                prg = new ProgressSteps(null, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEPROGRESS_TITLE), null, new String[]{this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEPROGRESS_IMAGING), this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEPROGRESS_SCALING), this.i18n.getString((PropertiesEnum)StringsProperties.IMAGECAPTUREPANEL_ENCODEPROGRESS_ENCODING)});
            }
            catch (Throwable ex) {
                LogSupport.exception((Object)this, (String)"encodeImage", (Throwable)ex, (boolean)true);
            }
            Image img = this.selectFrame.getSelectedImage();
            if (img == null) {
                ByteArrayOutputStream byteArrayOutputStream = this.imageOutputStream;
                return byteArrayOutputStream;
            }
            if (prg != null) {
                if (prg.isCanceled()) {
                    ByteArrayOutputStream byteArrayOutputStream = this.imageOutputStream;
                    return byteArrayOutputStream;
                }
                prg.nextStep();
            }
            if (scale != 1.0) {
                img = img.getScaledInstance((int)((double)encodeWidth * scale), (int)((double)encodeHeight * scale), 4);
            }
            if (prg != null) {
                if (prg.isCanceled()) {
                    ByteArrayOutputStream byteArrayOutputStream = this.imageOutputStream;
                    return byteArrayOutputStream;
                }
                prg.nextStep();
            }
            if (this.encodeAsJPEG.isSelected()) {
                this.encodeJPEG(img, this.imageOutputStream);
            } else if (this.encodeAsPNG.isSelected()) {
                this.encodePNG(img, this.imageOutputStream);
            }
            if (prg != null) {
                if (prg.isCanceled()) {
                    this.imageOutputStream.reset();
                    ByteArrayOutputStream byteArrayOutputStream = this.imageOutputStream;
                    return byteArrayOutputStream;
                }
                prg.nextStep();
            }
        }
        finally {
            if (prg != null) {
                prg.close();
            }
        }
        return this.imageOutputStream;
    }

    private void encodeJPEG(Image img, ByteArrayOutputStream imageOutputStream) {
        if (img == null) {
            return;
        }
        int quality = 55;
        if (this.highQualityButton.isSelected()) {
            quality = 75;
        } else if (this.lowQualityButton.isSelected()) {
            quality = 35;
        }
        try {
            ImageSupport.saveToStream((Image)img, (OutputStream)imageOutputStream, (String)"image/jpeg", (int)quality);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"encodeJPEG", (Throwable)ex, (boolean)true);
        }
    }

    private void encodePNG(Image img, ByteArrayOutputStream imageOutputStream) {
        this.suffix = ".png";
        int compressionLevel = 0;
        try {
            if (this.pngNoCompression.isSelected()) {
                compressionLevel = 0;
            } else if (this.pngFastCompression.isSelected()) {
                compressionLevel = 3;
            } else if (this.pngMaxCompression.isSelected()) {
                compressionLevel = 9;
            } else if (this.pngDefaultCompression.isSelected()) {
                compressionLevel = 5;
            }
            byte[] bytes = ImageSupport.encodeAsPNG((Image)img, (int)compressionLevel);
            if (bytes != null) {
                imageOutputStream.write(bytes, 0, bytes.length);
            }
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"encodePNG", (Throwable)e, (boolean)true);
        }
    }

    public Rectangle getSelectRectangle() {
        return this.selectRectangle;
    }

    public byte[] getImageBytes() {
        if (this.selectRectangle == null || this.selectFrame == null || this.imageOutputStream == null) {
            if (GUIDebug.APP_SNAP.show()) {
                LogSupport.message((Object)this, (String)"getImageBytes", (String)"No image bytes to get.");
            }
            return new byte[0];
        }
        byte[] imageBytes = this.imageOutputStream.toByteArray();
        this.imageOutputStream.reset();
        this.imageOutputStream = null;
        if (GUIDebug.APP_SNAP.show()) {
            LogSupport.message((Object)this, (String)"getImageBytes", (String)("Returning " + imageBytes.length + " bytes of " + this.suffix + " image data."));
        }
        return imageBytes;
    }

    private void setDefaults() {
        switch (selectButtonDefault) {
            case 1: {
                this.enableEncodeButtons(true);
                this.encodeAsJPEG.setSelected(true);
                break;
            }
            default: {
                this.enableEncodeButtons(false);
                this.encodeAsPNG.setSelected(true);
            }
        }
        switch (areaButtonDefault) {
            default: {
                this.selectedAreaButton.setSelected(true);
                break;
            }
            case 2: {
                this.entireButton.setSelected(true);
                break;
            }
            case 3: {
                this.entireDelayedButton.setSelected(true);
            }
        }
        switch (jpegEncodeDefault) {
            case 1: {
                this.lowQualityButton.setSelected(true);
                break;
            }
            default: {
                this.mediumQualityButton.setSelected(true);
                break;
            }
            case 3: {
                this.highQualityButton.setSelected(true);
            }
        }
        switch (pngEncodeDefault) {
            default: {
                this.pngDefaultCompression.setSelected(true);
                break;
            }
            case 2: {
                this.pngNoCompression.setSelected(true);
                break;
            }
            case 3: {
                this.pngFastCompression.setSelected(true);
                break;
            }
            case 4: {
                this.pngMaxCompression.setSelected(true);
            }
        }
        this.hideApplicationCheckbox.setSelected(hideDefault && enableHideApp);
        this.scaleUpToFitCheckbox.setSelected(scaleUpDefault);
        this.scaleDownToFitCheckbox.setSelected(scaleDownDefault);
    }

    private void enableEncodeButtons(boolean en) {
        this.lowQualityButton.setEnabled(en);
        this.mediumQualityButton.setEnabled(en);
        this.highQualityButton.setEnabled(en);
        this.pngDefaultCompression.setEnabled(!en);
        this.pngNoCompression.setEnabled(!en);
        this.pngFastCompression.setEnabled(!en);
        this.pngMaxCompression.setEnabled(!en);
    }

    static {
        Method m = null;
        try {
            if (Platform.checkJavaVersion((String)"1.6+")) {
                m = Window.class.getMethod("getWindows", new Class[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            m = null;
        }
        getWindowsMethod = m;
        lastSelectLocation = null;
        lastSelectSize = null;
        selectButtonDefault = 2;
        areaButtonDefault = 1;
        jpegEncodeDefault = 2;
        pngEncodeDefault = 4;
        hideDefault = true;
        scaleUpDefault = false;
        scaleDownDefault = true;
        nextCaptureNumber = 0;
        isSupported = false;
        enableHideApp = true;
        isSupported = SelectFrame.isAvailable();
        boolean bl = enableHideApp = Platform.getPlatform() != 3;
        if (!enableHideApp) {
            hideDefault = false;
        }
    }
}

