/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.module.ChangeWhiteboardScreenCmd;
import com.elluminate.groupware.whiteboard.module.CopyWhiteboardToBreakoutRoomsCmd;
import com.elluminate.groupware.whiteboard.module.CopyWhiteboardsToMainRoomCmd;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.GoToNextWhiteboardScreenCmd;
import com.elluminate.groupware.whiteboard.module.GoToPreviousWhiteboardScreenCmd;
import com.elluminate.groupware.whiteboard.module.LoadWhiteboardCmd;
import com.elluminate.groupware.whiteboard.module.ProtectWhiteboardCmd;
import com.elluminate.groupware.whiteboard.module.StarOfficePrefsPanel;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.UnprotectWhiteboardCmd;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardPublisher;
import com.elluminate.groupware.whiteboard.module.imageloading.AutoScaleSizeProvider;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteBuilderDialog;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteOrganizeDialog;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import com.elluminate.groupware.whiteboard.module.imageloading.PalettesFileListEntry;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.StarOfficeImport;
import com.elluminate.groupware.whiteboard.module.ui.ImageUI;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.image.SizeProvider;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

@Singleton
public class WhiteboardModule
extends AbstractClientModule
implements PreferencesPanelOwner,
ActionListener,
ModulePublisherInfo,
PlaybackTimeListener,
PropertyChangeListener {
    public static final String FEATURE_BASE_PATH = "/whiteboard";
    private static final String WHITEBOARD = "Whiteboard";
    private static final String prefix = WhiteboardModule.class.getName();
    private static I18n i18n = I18n.create((Object)new Object(){});
    private ArrayList paletteArgumentURLS = null;
    public static ArrayList addedPalettes = new ArrayList();
    private static volatile boolean palettesLoaded = false;
    private static volatile Thread paletteLoader = null;
    public static Palettes palettes = null;
    public static String addedPalettesKey = null;
    private PaletteOrganizeDialog paletteOrganizeDialog = null;
    boolean enablePalettes = true;
    boolean palettesMenuConfigured = false;
    String paletteResource = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTERESOURCE);
    private final MemoryFlagPropertyListener memoryFlagPropertyListener = new MemoryFlagPropertyListener();
    private WhiteboardBean whiteboardBean = null;
    private ConferencingEngine confEngine;
    private Provider<ChangeWhiteboardScreenCmd> changeWhiteboardScreenCmd;
    private Provider<CopyWhiteboardsToMainRoomCmd> copyWhiteboardsToMainRoomCmd;
    private Provider<CopyWhiteboardToBreakoutRoomsCmd> copyWhiteboardToBreakoutRoomsCmd;
    private Provider<GoToNextWhiteboardScreenCmd> goToNextWhiteboardScreenCmd;
    private Provider<GoToPreviousWhiteboardScreenCmd> goToPreviousWhiteboardScreenCmd;
    private Provider<LoadWhiteboardCmd> loadWhiteboardCmd;
    private Provider<ProtectWhiteboardCmd> protectWhiteboardCmd;
    private Provider<UnprotectWhiteboardCmd> unprotectWhiteboardCmd;
    private BooleanFeature explorerFeature;
    private DialogParentProvider parentProv;
    private Imps imps;
    private Provider<WhiteboardBean> beanProvider;
    private WhiteboardPublisher msgPublisher;
    private ClientProvider clientProvider;
    private Preferences preferences = null;
    private FeaturePathSupport pathSupport;
    private FeatureBroker broker;
    private ComponentFeature wbdPanelFeature = null;
    private ComponentFeature starOfficePrefsPanelFeature = null;
    private ComponentFeature mediaCacheMonitorFeature;
    private ActionFeature paletteEditorFeature;
    private ActionFeature paletteBuilderFeature;
    private Provider<StarOfficePrefsPanel> starOfficePrefsPanelProvider = null;
    private CRSession session;
    private PermissionFeatureFactory permissionFeatureFactory;
    private LoadFeature loadPowerPoint;
    private LoadFeature loadWhiteboard;
    private LoadFeature loadOpenOffice;
    private LoadFeature loadBackground;
    private LoadFeature loadImage;

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProv = dpp;
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        this.pathSupport = pathSupport;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initWhiteboardBeanProvider(Provider<WhiteboardBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initWhiteboardPublisher(WhiteboardPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initStarOfficePrefPanelProvider(Provider<StarOfficePrefsPanel> soppp) {
        this.starOfficePrefsPanelProvider = soppp;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
        session.addPermissionChangeListener("WhiteBoardPermission", new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                WhiteboardModule.this.updateFeatures();
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        });
        session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onParticipantAdded(CRParticipantEvent e) {
                CRParticipant p = e.getParticipant();
                if (p.isMe()) {
                    WhiteboardModule.this.updateFeatures();
                }
            }

            public void onParticipantRemoved(CRParticipantEvent e) {
                CRParticipant p = e.getParticipant();
                if (p.isMe()) {
                    WhiteboardModule.this.updateFeatures();
                }
            }
        });
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initChangeWhiteboardScreenCmd(Provider<ChangeWhiteboardScreenCmd> cp) {
        this.changeWhiteboardScreenCmd = cp;
    }

    @Inject
    public void initCopyWhiteboardsToMainRoomCmd(Provider<CopyWhiteboardsToMainRoomCmd> cp) {
        this.copyWhiteboardsToMainRoomCmd = cp;
    }

    @Inject
    public void initCopyWhiteboardToBreakoutRoomsCmd(Provider<CopyWhiteboardToBreakoutRoomsCmd> cp) {
        this.copyWhiteboardToBreakoutRoomsCmd = cp;
    }

    @Inject
    public void initGoToNextWhiteboardScreenCmd(Provider<GoToNextWhiteboardScreenCmd> cp) {
        this.goToNextWhiteboardScreenCmd = cp;
    }

    @Inject
    public void initGoToPreviousWhiteboardScreenCmd(Provider<GoToPreviousWhiteboardScreenCmd> cp) {
        this.goToPreviousWhiteboardScreenCmd = cp;
    }

    @Inject
    public void initLoadWhiteboardCmd(Provider<LoadWhiteboardCmd> cp) {
        this.loadWhiteboardCmd = cp;
    }

    @Inject
    public void initProtectWhiteboardCmd(Provider<ProtectWhiteboardCmd> cp) {
        this.protectWhiteboardCmd = cp;
    }

    @Inject
    public void initUnprotectWhiteboardCmd(Provider<UnprotectWhiteboardCmd> cp) {
        this.unprotectWhiteboardCmd = cp;
    }

    public String getPrefix() {
        return prefix;
    }

    public String getTitle() {
        return Mnemonic.getText((String)i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_COLUMNNAME));
    }

    public Icon getIcon() {
        return i18n.getIcon("WhiteboardModule.toolIcon");
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public WhiteboardBean getWhiteboardBean() {
        return this.whiteboardBean;
    }

    public String getNameOfModule() {
        return WHITEBOARD;
    }

    public String getDisplayNameOfModule() {
        return this.getTitle();
    }

    public Icon getModuleIcon() {
        return this.getIcon();
    }

    public void enablePalettes() {
        this.enablePalettes(this.enablePalettes);
    }

    private void showOrganizePalettesDialog() {
        if (this.paletteOrganizeDialog == null) {
            if (!WhiteboardModule.isPaletteLoadComplete()) {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTELOADINCOMPLETEMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTELOADINCOMPLETETITLE), (int)0);
                return;
            }
            String title = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTEORGANIZEDIALOGTITLE);
            this.paletteOrganizeDialog = new PaletteOrganizeDialog(this.parentProv.getDialogParent(), title, addedPalettes, palettes, addedPalettesKey);
        }
        this.paletteOrganizeDialog.setVisible(true);
    }

    private void showPaletteBuilderDialog() {
        String title = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTEBUILDERDIALOGTITLE);
        PaletteBuilderDialog paletteBuilderDialog = new PaletteBuilderDialog(this.parentProv.getDialogParent(), title, false);
        paletteBuilderDialog.setVisible(true);
    }

    public void resetSession() {
        if (this.whiteboardBean != null) {
            this.whiteboardBean.getContext().setConferenceUID(0L);
        }
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        if (this.whiteboardBean != null) {
            switch (linearity) {
                case REALTIME: {
                    this.whiteboardBean.getContext().setNonLinear(false);
                    this.whiteboardBean.getContext().setSeeking(false);
                    break;
                }
                case FAST_FORWARD: {
                    this.whiteboardBean.getContext().setNonLinear(true);
                    this.whiteboardBean.getContext().setSeeking(false);
                    break;
                }
                case SEEKING: {
                    this.whiteboardBean.getContext().setNonLinear(false);
                    this.whiteboardBean.getContext().setSeeking(true);
                }
            }
        }
    }

    protected void sendWhiteboardEnabledStatusUpdateMessage(Boolean oldValue, Boolean newValue) {
        if (oldValue != newValue && newValue != null) {
            if (newValue.booleanValue()) {
                this.msgPublisher.sendWhiteboardPrivilegeEnabledMessage();
            } else {
                this.msgPublisher.sendWhiteboardPrivilegeDisabledMessage();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean checkArgument(String arg, Iterator argIter) throws IllegalArgumentException {
        boolean accepted = false;
        String paletteArgument = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTEARGUMENT);
        if (arg.equals(paletteArgument)) {
            if (argIter.hasNext()) {
                String name = (String)argIter.next();
                if (name.startsWith("-")) {
                    throw new IllegalArgumentException("No arguments for " + paletteArgument);
                }
                if (!name.equals("")) {
                    PalettesFileListEntry entry = new PalettesFileListEntry(name, name);
                    this.addPalette(entry);
                }
                accepted = true;
            }
        } else if (arg.equals(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADARGUMENT))) {
            if (argIter.hasNext()) {
                accepted = true;
                String preloadFile = (String)argIter.next();
                if (!this.whiteboardBean.preload(preloadFile)) {
                    throw new RuntimeException(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_BADPRELOAD, new Object[]{preloadFile}));
                }
            }
        } else if (arg.equals(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_NOTFOLLOW))) {
            accepted = true;
            this.whiteboardBean.setFollowDefault(false);
        } else if (arg.equals(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_FOLLOW))) {
            accepted = true;
            this.whiteboardBean.setFollowDefault(true);
        } else if (arg.equals(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_SHOWSCREENCOUNTERARG)) && argIter.hasNext()) {
            accepted = true;
            String whoShouldSee = (String)argIter.next();
            try {
                this.whiteboardBean.setScreenCounterDefault(Byte.parseByte(whoShouldSee));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_BADSCREENCOUNTERDEFAULTARG, new Object[]{arg}));
            }
        }
        return accepted;
    }

    private void addPalette(PalettesFileListEntry entry) {
        if (!entry.getURL().equals("")) {
            if (this.paletteArgumentURLS == null) {
                this.paletteArgumentURLS = new ArrayList();
            }
            this.paletteArgumentURLS.add(entry);
        }
    }

    private void enablePalettes(boolean enablePalettes) {
        this.enablePalettes = enablePalettes;
        if (enablePalettes && !this.palettesMenuConfigured) {
            this.broker.setFeaturePublished((Feature)this.paletteEditorFeature, enablePalettes);
            this.broker.setFeaturePublished((Feature)this.paletteBuilderFeature, enablePalettes);
            this.palettesMenuConfigured = true;
        }
    }

    public static boolean isPaletteLoadComplete() {
        boolean result = palettesLoaded;
        return result;
    }

    private void loadPaletteResource() {
        try {
            Resource libRes = new Resource(this.paletteResource);
            if (libRes != null && libRes.exists()) {
                File tempDir = Platform.getTempDir();
                File palette = new File(tempDir.getAbsolutePath(), i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_BUILTINPALETTENAME) + ".jar");
                String pathName = palette.getAbsolutePath();
                palette.deleteOnExit();
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"loadPaletteResource", (String)("Saving " + libRes.find() + " to " + pathName));
                }
                libRes.save(pathName);
                URL fileURL = new URL("file", "", pathName);
                PalettesFileListEntry entry = new PalettesFileListEntry(pathName, libRes.getPath());
                this.addPalette(entry);
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"loadPaletteResource", (String)("WhiteboardModule, palettesFileListEntry: " + entry + "\n    fileURL: " + fileURL + "\n    protocol: " + fileURL.getProtocol() + "\n    file: " + fileURL.getFile()));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void showMemStatus(boolean show) {
        this.broker.setFeaturePublished((Feature)this.mediaCacheMonitorFeature, show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPalettes() {
        Object object;
        Debug.lockEnter((Object)this, (String)"paletteLoadThread", (String)"paletteLock", (Object)addedPalettes);
        try {
            object = addedPalettes;
            synchronized (object) {
                if (UtilDebug.PALETTE_LOAD.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("pkg=com.elluminate.util.imageLoading.palette,urls=" + this.paletteArgumentURLS + ",added=" + addedPalettes));
                }
                palettes = new Palettes("com.elluminate.util.imageLoading.palette", this.paletteArgumentURLS, false, null, addedPalettesKey, this.getPreferences());
                Iterator iter = addedPalettes.iterator();
                while (iter.hasNext() && this.enablePalettes) {
                    String path = (String)iter.next();
                    File file = new File(path);
                    if (file.isFile() && file.exists()) {
                        if (UtilDebug.PALETTE_LOAD.show()) {
                            LogSupport.message((Object)this, (String)"run", (String)("loading palette: " + file));
                        }
                        palettes.loadPaletteFile(file, true);
                        continue;
                    }
                    if (!UtilDebug.PALETTE_LOAD.show()) continue;
                    LogSupport.message((Object)this, (String)"run", (String)("skipping palette: " + file));
                }
                palettesLoaded = true;
            }
        }
        catch (Throwable t) {
            palettesLoaded = false;
            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)false, (String)"attempting palette load");
        }
        finally {
            Debug.lockLeave((Object)this, (String)"paletteLoadThread", (String)"paletteLock", (Object)addedPalettes);
            Debug.lockEnter((Object)this, (String)"paletteLoadThread", (String)"loaderThreadLock", (Object)this);
            try {
                object = this;
                synchronized (object) {
                    paletteLoader = null;
                    this.notifyAll();
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"paletteLoadThread", (String)"loaderThreadLock", (Object)this);
            }
            this.paletteEditorFeature.setEnabled(palettesLoaded);
        }
        if (UtilDebug.PALETTE_LOAD.show()) {
            LogSupport.message((Object)this, (String)"run", (String)"exiting...");
        }
    }

    public void start() {
        this.confEngine.registerCommand(this.changeWhiteboardScreenCmd);
        this.confEngine.registerCommand(this.copyWhiteboardsToMainRoomCmd);
        this.confEngine.registerCommand(this.copyWhiteboardToBreakoutRoomsCmd);
        this.confEngine.registerCommand(this.goToNextWhiteboardScreenCmd);
        this.confEngine.registerCommand(this.goToPreviousWhiteboardScreenCmd);
        this.confEngine.registerCommand(this.loadWhiteboardCmd);
        this.confEngine.registerCommand(this.protectWhiteboardCmd);
        this.confEngine.registerCommand(this.unprotectWhiteboardCmd);
    }

    public void attach() {
        ImageSupport.setAutoScaleSizeProvider((SizeProvider)new AutoScaleSizeProvider(this.preferences, this.getPrefix()));
        final Client client = this.clientProvider.get();
        client.getClientList().addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                if (e.isMe()) {
                    client.getClientList().getMyClient().addPropertyChangeListener("whiteboardFloor", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            WhiteboardModule.this.sendWhiteboardEnabledStatusUpdateMessage((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                        }
                    });
                }
            }
        });
        client.getClientList().addPropertyChangeListener("chair", (PropertyChangeListener)this);
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    public void setupUI() {
        this.setUpMainPanel();
        this.updateFeatures();
        palettesLoaded = false;
        paletteLoader = new WorkerThread(new Runnable(){

            @Override
            public void run() {
                WhiteboardModule.this.loadPalettes();
            }
        }, "Palette Loader");
        this.loadPaletteResource();
        paletteLoader.setDaemon(true);
        paletteLoader.start();
        this.createComponents();
        PresentationModeAPI presentMode = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (presentMode != null && presentMode.isAvailable()) {
            presentMode.setPresentable((Object)this, true);
        }
    }

    public void cleanupUI() {
        this.showMemStatus(false);
        PresentationModeAPI presentMode = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (presentMode != null && presentMode.isAvailable()) {
            presentMode.setPresentable((Object)this, false);
        }
        this.revokeFeatures();
        this.whiteboardBean.uninstallHook(this);
        this.enablePalettes(false);
    }

    public void detach() {
        this.clientProvider.get().getClientList().removePropertyChangeListener("chair", (PropertyChangeListener)this);
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    private void createComponents() {
        WhiteboardDebug.MEMORY.addPropertyChangeListener((PropertyChangeListener)this.memoryFlagPropertyListener);
        this.showMemStatus(WhiteboardDebug.MEMORY.show());
    }

    private void createFeatures() {
        String path = this.pathSupport.composePath(FEATURE_BASE_PATH, "canvas");
        String name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_COLUMNNAME);
        this.wbdPanelFeature = this.broker.createComponentFeature((Object)this, path, (ComponentProvider)this.whiteboardBean, name, null);
        if (StarOfficeImport.isSupported()) {
            this.starOfficePrefsPanelFeature = this.broker.createComponentFeature((Object)this, "/whiteboard/prefs", new ComponentProvider(){

                public Component get(ComponentFeature feature) {
                    return (Component)WhiteboardModule.this.starOfficePrefsPanelProvider.get();
                }
            }, i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_TITLE), i18n.getString((PropertiesEnum)StringsProperties.STAROFFICE_TITLE));
        }
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "mediaCacheMonitor");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDBEAN_MEDIAMONITORLABEL);
        ComponentProvider mediaCacheMonitorProvider = new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return WhiteboardModule.this.whiteboardBean.getMediaCacheMonitor();
            }
        };
        this.mediaCacheMonitorFeature = this.broker.createComponentFeature((Object)this, path, mediaCacheMonitorProvider, name, null);
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "palettesEditor");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTEEDITMENUTEXT);
        this.paletteEditorFeature = this.broker.createActionFeature((Object)this, path, name, null);
        this.paletteEditorFeature.setEnabled(false);
        this.paletteEditorFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                WhiteboardModule.this.showOrganizePalettesDialog();
            }
        });
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "paletteBuilder");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_PALETTEBUILDERMENUTEXT);
        this.paletteBuilderFeature = this.broker.createActionFeature((Object)this, path, name, null);
        this.paletteBuilderFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                WhiteboardModule.this.showPaletteBuilderDialog();
            }
        });
        ArrayList<String> typesWb = new ArrayList<String>();
        typesWb.add("wbd");
        typesWb.add("wbp");
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "loadWhiteboard");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADWHITEBOARD);
        this.loadWhiteboard = this.broker.createLoadFeature((Object)this, path, name, null);
        this.loadWhiteboard.setFileTypes(typesWb);
        this.loadWhiteboard.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADFEATUREICON));
        this.loadWhiteboard.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardContext context = ((WhiteboardBean)WhiteboardModule.this.beanProvider.get()).getContext();
                ScreenModel currentScreen = context.getController().getScreen();
                String ownerPrefix = context.getBean().getOwnerPrefix();
                Preferences preferences = context.getBean().getPreferences();
                int newScreenPosition = preferences.getIntegerSetting(ownerPrefix + ".importCreationLocation", 1);
                int screenWidth = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeWidth", 1014);
                int screenHeight = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeHeight", 835);
                int importQuality = 3;
                boolean includeNotes = WhiteboardModule.this.getPreferences().getBooleanSetting(ownerPrefix + ".importQualityNotesImport", false);
                ArrayList files = (ArrayList)event.getParameter("files");
                int nScreens = 0;
                for (File file : files) {
                    WhiteboardModel model = FileUtils.getWhiteboardLoadModel(context, file, screenWidth, screenHeight, 3, includeNotes);
                    nScreens += model == null ? 0 : model.getScreenCount();
                    FileUtils.loadWBD(context, newScreenPosition, currentScreen, WhiteboardModule.this.getTreePaths(currentScreen), model);
                }
                if (nScreens > 0) {
                    WhiteboardModule.this.broker.sendNotification((Object)WhiteboardModule.this, WhiteboardModule.this.pathSupport.composePath(WhiteboardModule.FEATURE_BASE_PATH, "contentLoadedNotification"));
                }
            }
        });
        ArrayList<String> typesPPT = new ArrayList<String>();
        typesPPT.add("ppt");
        typesPPT.add("pptx");
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "loadPowerPoint");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_IMPORTWITHPOWERPOINT);
        this.loadPowerPoint = this.broker.createLoadFeature((Object)this, path, name, null);
        this.loadPowerPoint.setFileTypes(typesPPT);
        this.loadPowerPoint.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADFEATUREICON));
        this.loadPowerPoint.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardContext context = ((WhiteboardBean)WhiteboardModule.this.beanProvider.get()).getContext();
                ScreenModel currentScreen = context.getController().getScreen();
                String ownerPrefix = context.getBean().getOwnerPrefix();
                Preferences preferences = context.getBean().getPreferences();
                int newScreenPosition = preferences.getIntegerSetting(ownerPrefix + ".importCreationLocation", 1);
                int screenWidth = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeWidth", 1014);
                int screenHeight = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeHeight", 835);
                int importQuality = 3;
                boolean includeNotes = WhiteboardModule.this.getPreferences().getBooleanSetting(ownerPrefix + ".importQualityNotesImport", false);
                ArrayList files = (ArrayList)event.getParameter("files");
                int nScreens = 0;
                for (File file : files) {
                    WhiteboardModel model = FileUtils.getPowerpointLoadModel(context, file, screenWidth, screenHeight, 3, includeNotes);
                    nScreens += model == null ? 0 : model.getScreenCount();
                    FileUtils.loadWBD(context, newScreenPosition, currentScreen, WhiteboardModule.this.getTreePaths(currentScreen), model);
                }
                if (nScreens > 0) {
                    WhiteboardModule.this.broker.sendNotification((Object)WhiteboardModule.this, WhiteboardModule.this.pathSupport.composePath(WhiteboardModule.FEATURE_BASE_PATH, "contentLoadedNotification"));
                }
            }
        });
        ArrayList<String> typesStarOffice = new ArrayList<String>();
        typesStarOffice.add("ppt");
        typesStarOffice.add("pptx");
        typesStarOffice.add("sxi");
        typesStarOffice.add("odp");
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "loadOpenOffice");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_IMPORTWITHOPENOFFICE);
        this.loadOpenOffice = this.broker.createLoadFeature((Object)this, path, name, null);
        this.loadOpenOffice.setFileTypes(typesStarOffice);
        this.loadOpenOffice.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADFEATUREICON));
        this.loadOpenOffice.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardContext context = ((WhiteboardBean)WhiteboardModule.this.beanProvider.get()).getContext();
                ScreenModel currentScreen = context.getController().getScreen();
                String ownerPrefix = context.getBean().getOwnerPrefix();
                Preferences preferences = context.getBean().getPreferences();
                int newScreenPosition = preferences.getIntegerSetting(ownerPrefix + ".importCreationLocation", 1);
                int screenWidth = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeWidth", 1014);
                int screenHeight = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeHeight", 835);
                boolean includeNotes = WhiteboardModule.this.getPreferences().getBooleanSetting(ownerPrefix + ".importQualityNotesImport", false);
                ArrayList files = (ArrayList)event.getParameter("files");
                int nScreens = 0;
                for (File file : files) {
                    WhiteboardModel model = FileUtils.getOpenOfficeLoadModel(context, file, screenWidth, screenHeight, includeNotes);
                    nScreens += model == null ? 0 : model.getScreenCount();
                    FileUtils.loadWBD(context, newScreenPosition, currentScreen, WhiteboardModule.this.getTreePaths(currentScreen), model);
                }
                if (nScreens > 0) {
                    WhiteboardModule.this.broker.sendNotification((Object)WhiteboardModule.this, WhiteboardModule.this.pathSupport.composePath(WhiteboardModule.FEATURE_BASE_PATH, "contentLoadedNotification"));
                }
            }
        });
        ArrayList<String> typesImages = new ArrayList<String>();
        typesImages.add("jpeg");
        typesImages.add("jpg");
        for (String mime : ImageSupport.getInputTypes()) {
            String ext = Platform.getSuffix((String)mime);
            if (ext == null || "".equals(ext) || typesImages.contains(ext)) continue;
            typesImages.add(ext);
        }
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "loadBackground");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_IMPORTBACKGROUNDS);
        this.loadBackground = this.broker.createLoadFeature((Object)this, path, name, null);
        this.loadBackground.setFileTypes(typesImages);
        this.loadBackground.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADFEATUREICON));
        this.loadBackground.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                WhiteboardContext context = ((WhiteboardBean)WhiteboardModule.this.beanProvider.get()).getContext();
                ScreenModel currentScreen = context.getController().getScreen();
                String ownerPrefix = context.getBean().getOwnerPrefix();
                Preferences preferences = context.getBean().getPreferences();
                int newScreenPosition = preferences.getIntegerSetting(ownerPrefix + ".importCreationLocation", 1);
                int screenWidth = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeWidth", 1014);
                int screenHeight = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeHeight", 835);
                int importQuality = 3;
                boolean includeNotes = WhiteboardModule.this.getPreferences().getBooleanSetting(ownerPrefix + ".importQualityNotesImport", false);
                int nScreens = 0;
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files != null) {
                    WhiteboardModel model = FileUtils.getImageLoadModel(context, files.toArray(new File[files.size()]), screenWidth, screenHeight, 3, includeNotes);
                    nScreens += model == null ? 0 : model.getScreenCount();
                    FileUtils.loadWBD(context, newScreenPosition, currentScreen, WhiteboardModule.this.getTreePaths(currentScreen), model);
                }
                if (nScreens > 0) {
                    WhiteboardModule.this.broker.sendNotification((Object)WhiteboardModule.this, WhiteboardModule.this.pathSupport.composePath(WhiteboardModule.FEATURE_BASE_PATH, "contentLoadedNotification"));
                }
            }
        });
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "loadImage");
        name = i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_IMPORTIMAGES);
        this.loadImage = this.broker.createLoadFeature((Object)this, path, name, null);
        this.loadImage.setFileTypes(typesImages);
        this.loadImage.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_LOADFEATUREICON));
        this.loadImage.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files == null) {
                    return;
                }
                WhiteboardContext context = ((WhiteboardBean)WhiteboardModule.this.beanProvider.get()).getContext();
                ScreenModel currentScreen = context.getController().getScreen();
                double x = 0.0;
                double y = 0.0;
                for (File f : files) {
                    try {
                        ExternalDataBean toolData = new ExternalDataBean();
                        if (!ImageMimeUtilities.isValidImageMimeFile((File)f)) continue;
                        toolData.setData((Object)f);
                        WBNode[] tool = new WBNode[]{context.getController().getToolByName("imagetool", currentScreen, toolData)};
                        ActionUtilities.pasteTools((ScreenModel)currentScreen, (WhiteboardContext)context, (DPoint)new DPoint(x += 20.0, y += 20.0), (WBNode[])tool);
                    }
                    catch (ImageSupport.InsufficientMemoryExcetpion ime) {
                        Dimension rs = ime.getReducedSize();
                        String msg = i18n.getString((PropertiesEnum)StringsProperties.INSUFFICIENT_MEMORY_FOR_IMAGE, new Object[]{rs.width, rs.height});
                        ImageUI.showLoadImageErrorDialog(context.getDialogParentFrame(), f.getName(), msg);
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)ex, (boolean)true);
                    }
                }
            }
        });
        BooleanFeature bf = this.permissionFeatureFactory.createPermissionFeature((Object)this, "WhiteBoardPermission", "/whiteboard/whiteboardPermission", i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_CONTEXTMENU), WHITEBOARD, i18n);
        bf.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDMODULE_CONTEXTMENU_ACCESSIBLENAME));
        this.session.registerAnnotation("WhiteboardActivityAnnotation", (Object)0);
        this.session.registerAnnotation("WhiteboardLagAnnotation", (Object)0);
    }

    private void updateFeatures() {
        CRParticipant me = this.session.getMe();
        boolean isChair = me != null ? me.isChair() : false;
        boolean isOffline = !this.clientProvider.get().getClientList().getConnection().isConnected() && !this.whiteboardBean.isPlayback();
        this.broker.setFeaturePublished((Feature)this.wbdPanelFeature, true);
        this.broker.setFeaturePublished((Feature)this.paletteEditorFeature, this.enablePalettes);
        this.broker.setFeaturePublished((Feature)this.paletteBuilderFeature, this.enablePalettes);
        if (this.starOfficePrefsPanelFeature != null) {
            this.broker.setFeaturePublished((Feature)this.starOfficePrefsPanelFeature, true);
        }
        this.broker.setFeaturePublished((Feature)this.loadOpenOffice, StarOfficeImport.isAvailable() && (isChair || isOffline));
        this.broker.setFeaturePublished((Feature)this.loadPowerPoint, PowerPointImport.isAvailable() && (isChair || isOffline));
        this.broker.setFeaturePublished((Feature)this.loadWhiteboard, isChair || isOffline);
        this.broker.setFeaturePublished((Feature)this.loadBackground, isChair || isOffline);
        this.broker.setFeaturePublished((Feature)this.loadImage, isChair || isOffline);
    }

    private void revokeFeatures() {
        this.broker.setFeaturePublished((Feature)this.wbdPanelFeature, false);
        this.broker.setFeaturePublished((Feature)this.paletteEditorFeature, false);
        this.broker.setFeaturePublished((Feature)this.paletteBuilderFeature, false);
        if (this.starOfficePrefsPanelFeature != null) {
            this.broker.setFeaturePublished((Feature)this.starOfficePrefsPanelFeature, false);
        }
        this.broker.setFeaturePublished((Feature)this.loadOpenOffice, false);
        this.broker.setFeaturePublished((Feature)this.loadPowerPoint, false);
        this.broker.setFeaturePublished((Feature)this.loadWhiteboard, false);
        this.broker.setFeaturePublished((Feature)this.loadBackground, false);
        this.broker.setFeaturePublished((Feature)this.loadImage, false);
    }

    private void setUpMainPanel() {
        this.whiteboardBean = (WhiteboardBean)this.beanProvider.get();
        this.whiteboardBean.setModule(this);
        this.whiteboardBean.createFeatures();
        this.createFeatures();
        this.whiteboardBean.setClient(this.clientProvider.get());
        this.whiteboardBean.setAppFrame(this.parentProv.getDialogParent());
        this.whiteboardBean.loadPreferences(prefix, this.preferences);
        this.whiteboardBean.start();
        this.whiteboardBean.installHook(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String nm = propertyChangeEvent.getPropertyName();
        if (nm.equals("chair")) {
            this.updateFeatures();
        }
    }

    public void stop() {
        this.whiteboardBean.stop();
        this.whiteboardBean.savePreferences(prefix, this.preferences);
        this.whiteboardBean.uninstall();
        WhiteboardDebug.MEMORY.removePropertyChangeListener((PropertyChangeListener)this.memoryFlagPropertyListener);
    }

    private TreePath[] getTreePaths(ScreenModel currentScreen) {
        TreePath[] treePaths = new TreePath[1];
        DisplayNode pathPeer = new DisplayNode();
        pathPeer.setUserObject((Object)currentScreen);
        treePaths[0] = new TreePath(pathPeer);
        return treePaths;
    }

    private class MemoryFlagPropertyListener
    implements PropertyChangeListener {
        private MemoryFlagPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof DebugFlag) {
                WhiteboardModule.this.showMemStatus(WhiteboardDebug.MEMORY.show());
            }
        }
    }
}

