/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.presentations.ImportQualityOptionsPanel;
import com.elluminate.groupware.whiteboard.module.presentations.StartOfficeAppInstallPanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenRelationPanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanel;
import com.elluminate.groupware.whiteboard.module.ui.ScreenSizePanelListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.ImportSelectionDialog;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

@Singleton
public class StarOfficePrefsPanel
extends AbstractPreferencesPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PREF_IMPORT_CREATION_LOCATION = ".importCreationLocation";
    public static final String PREF_IMPORT_SCREEN_SIZE_WIDTH = ".importScreenSizeWidth";
    public static final String PREF_IMPORT_SCREEN_SIZE_HEIGHT = ".importScreenSizeHeight";
    public static final String PREF_IMPORT_QUALITY_NOTES_IMPORT = ".importQualityNotesImport";
    private I18n i18n;
    private WhiteboardContext context;
    private ImportQualityOptionsPanel importQualityOptionsPanel;
    private ScreenSizePanel screenSizePanel;
    private ScreenRelationPanel creationLocation;
    private StartOfficeAppInstallPanel startOfficeAppInstallPanel;

    @Inject
    public StarOfficePrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDIMPORT_TITLE));
        this.i18n = i18n;
        WhiteboardModule module = (WhiteboardModule)owner;
        this.context = module.getWhiteboardBean().getContext();
    }

    protected void createContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcMain = new GridBagConstraints();
        gbcMain.gridx = 0;
        gbcMain.gridy = 0;
        gbcMain.insets.top = 0;
        gbcMain.insets.left = 0;
        gbcMain.anchor = 17;
        gbcMain.fill = 2;
        gbcMain.weightx = 1.0;
        this.creationLocation = new ScreenRelationPanel(ImportSelectionDialog.getScreenRelationTitle(), 1, false);
        this.creationLocation.setButtonText(ImportSelectionDialog.getImportActionReplaceText(), 2);
        this.creationLocation.addActionListener(this);
        gbcMain.insets.top = 6;
        ++gbcMain.gridy;
        this.add(this.creationLocation, gbcMain);
        int width = 0;
        int height = 0;
        ScreenModel scr = this.context.getController().getScreen();
        if (scr != null) {
            Dimension s = scr.getScreenSize();
            width = s.width;
            height = s.height;
        }
        ScreenSizePanelListener screenSizePanelListener = new ScreenSizePanelListener(){

            @Override
            public void onScreenSizePanelChange() {
                StarOfficePrefsPanel.this.setModified(true);
            }
        };
        this.screenSizePanel = new ScreenSizePanel(this.context, screenSizePanelListener, 2000, 2000);
        this.screenSizePanel.setDefaultSize(new Dimension(width, height));
        gbcMain.insets.top = 6;
        ++gbcMain.gridy;
        this.add(this.screenSizePanel, gbcMain);
        this.importQualityOptionsPanel = new ImportQualityOptionsPanel(this, this.i18n);
        gbcMain.insets.top = 6;
        ++gbcMain.gridy;
        this.add(this.importQualityOptionsPanel, gbcMain);
        this.startOfficeAppInstallPanel = new StartOfficeAppInstallPanel(this, this.i18n);
        gbcMain.insets.top = 6;
        ++gbcMain.gridy;
        this.add(this.startOfficeAppInstallPanel, gbcMain);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String path = preferences.getSetting(prefix + ".StarOfficeAppPath", "");
        if (!StarOfficeInformation.isValidApp(path)) {
            path = null;
        }
        String defaultPath = this.startOfficeAppInstallPanel.getDefaultPath();
        if (path == null || path.equals("") || defaultPath.equals(path)) {
            this.startOfficeAppInstallPanel.setUseDefaultSelected(true);
            this.startOfficeAppInstallPanel.setPath(defaultPath);
        } else {
            this.startOfficeAppInstallPanel.setUseDefaultSelected(false);
            this.startOfficeAppInstallPanel.setPath(path);
        }
        this.creationLocation.setButtonSelected(preferences.getIntegerSetting(prefix + PREF_IMPORT_CREATION_LOCATION, 1));
        int width = preferences.getIntegerSetting(prefix + PREF_IMPORT_SCREEN_SIZE_WIDTH, 1014);
        int height = preferences.getIntegerSetting(prefix + PREF_IMPORT_SCREEN_SIZE_HEIGHT, 835);
        this.screenSizePanel.setDefaultSize(new Dimension(width, height));
        this.importQualityOptionsPanel.setNotesImportSelected(preferences.getBooleanSetting(prefix + PREF_IMPORT_QUALITY_NOTES_IMPORT, false));
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        if (this.startOfficeAppInstallPanel.isUseDefaultSelected()) {
            preferences.clearSetting(prefix + ".StarOfficeAppPath");
        } else {
            String path = this.startOfficeAppInstallPanel.getPath();
            if (StarOfficeInformation.isValidApp(path)) {
                preferences.setSetting(prefix + ".StarOfficeAppPath", path);
            }
            this.startOfficeAppInstallPanel.installInstallation(path);
        }
        preferences.setSetting(prefix + PREF_IMPORT_CREATION_LOCATION, this.creationLocation.getSelectedRelation());
        Dimension screenSize = this.screenSizePanel.getSize(new Dimension(0, 0));
        preferences.setSetting(prefix + PREF_IMPORT_SCREEN_SIZE_WIDTH, screenSize.width);
        preferences.setSetting(prefix + PREF_IMPORT_SCREEN_SIZE_HEIGHT, screenSize.height);
        preferences.setSetting(prefix + PREF_IMPORT_QUALITY_NOTES_IMPORT, this.importQualityOptionsPanel.isNotesImportSelected());
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        preferences.setSetting(prefix + PREF_IMPORT_CREATION_LOCATION, 1);
        Dimension screenSize = WhiteboardContext.DEFAULT_SIZE;
        preferences.setSetting(prefix + PREF_IMPORT_SCREEN_SIZE_WIDTH, screenSize.width);
        preferences.setSetting(prefix + PREF_IMPORT_SCREEN_SIZE_HEIGHT, screenSize.height);
        preferences.setSetting(prefix + ".StarOfficeAppPath", "");
        preferences.setSetting(prefix + PREF_IMPORT_QUALITY_NOTES_IMPORT, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setModified(true);
    }
}

