/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.ChangeWhiteboardScreenCommand;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.AbstractWhiteboardCommand;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class ChangeWhiteboardScreenCmd
extends AbstractWhiteboardCommand
implements ChangeWhiteboardScreenCommand {
    protected String screen = null;
    protected boolean rootSearch = false;
    protected boolean searchChildren = false;
    @Inject
    private I18n i18n;

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public void setSearchFromScreenGroup(boolean rootSearch) {
        this.rootSearch = rootSearch;
    }

    public void setSearchSubTopics(boolean searchChildren) {
        this.searchChildren = searchChildren;
    }

    public void doexecute() throws CommandExecutionException {
        ScreenModel scr;
        if (this.screen == null || this.screen.length() == 0) {
            throw new CommandParameterException("Screen not set", this.i18n.getString((PropertiesEnum)StringsProperties.CHANGEWHITEBOARDSCREENCMD_BADPARAMSCREENNOTSET));
        }
        WhiteboardBean bean = this.getWhiteboardBean();
        if (this.isOnline() && bean.getContext().getController().isFollowInstructorSelected()) {
            this.validateIsChair();
        }
        if ((scr = this.findScreenInCurrentGroup(this.screen, this.rootSearch, this.searchChildren)) == null) {
            throw new CommandExecutionException("Could not find the requested ScreenModel", this.i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARDCMD_BADRESULTSCREENNOTFOUND, new Object[]{this.screen}));
        }
        bean.getContext().getController().gotoUIScreen(scr.getObjectID(), false);
    }
}

