/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder.module;

import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.moduleloading.LoadingStatusListener;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.recorder.RecorderProtocol;
import com.elluminate.groupware.recorder.module.RecorderModule;
import com.elluminate.groupware.recorder.module.RecorderPublisher;
import com.elluminate.groupware.recorder.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

@Singleton
public class RecorderBean
extends JPanel
implements ClientListener,
ChannelDataListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String PRERELEASE = "elluminate.prerelease";
    private static final String REC_START_NOTICE = "/recorder/notice/start";
    private static final String REC_STOP_NOTICE = "/recorder/notice/stop";
    private static final String REC_IN_PROGRESS_NOTICE = "/recorder/notice/inProgress";
    private I18n i18n;
    private RecorderModule rModule = null;
    private EasyDialog reminderDialog = null;
    private boolean recordReminded = false;
    private boolean reminderPreference = true;
    private boolean reminderPositioned = false;
    private JCheckBox dontAskAgainCheckBox = null;
    private RecorderPublisher msgPublisher;
    private JinxTerminal terminal;
    private ClientList clients;
    private DialogParentProvider parentProv;
    private FeatureBroker broker;
    private ChairProtocol chairProtocol;
    private boolean startRecordingFromReminder = false;
    private LoadingStatus loadingStatus;
    LoadingStatusListener readyStateListener = new LoadingStatusListener(){

        public void onStatusChange(LoadingStatus statusSource, String entityName) {
            RecorderBean.this.loadingStatus.removeListener(RecorderBean.this.readyStateListener);
            Timer t = new Timer(100, new ShowRecordReminderListener());
            t.setRepeats(false);
            t.start();
        }
    };

    @Inject
    public void initRecorderPublisher(RecorderPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initParentProvider(DialogParentProvider pp) {
        this.parentProv = pp;
    }

    @Inject
    public void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    @Inject
    public void initLoadingStatus(LoadingStatus loadingStatus) {
        this.loadingStatus = loadingStatus;
    }

    protected void setRecordReminderPreference(boolean setting) {
        if (this.reminderPreference != setting) {
            this.reminderPreference = setting;
            if (this.dontAskAgainCheckBox != null) {
                this.dontAskAgainCheckBox.setSelected(!setting);
            }
            if (this.reminderPreference) {
                Runnable reminderPeferenceChangeHandler = new Runnable(){

                    @Override
                    public void run() {
                        RecorderBean.this.recordReminded = false;
                        RecorderBean.this.manageRecordReminder();
                    }
                };
                SwingRunnerSupport.invokeOnEventThread((Runnable)reminderPeferenceChangeHandler);
            }
        }
    }

    protected boolean getRecordReminderPreference() {
        return this.reminderPreference;
    }

    @Inject
    public RecorderBean(RecorderModule mod, JinxTerminal terminal, I18n i18n, FeatureBroker aBroker) {
        this.rModule = mod;
        this.terminal = terminal;
        this.broker = aBroker;
        this.i18n = i18n;
        try {
            this.setUpAudioAlerts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clients = terminal.getClientList();
        this.clients.addClientListener((ClientListener)this);
        terminal.setProtocolAndListeners((JinxProtocol)new RecorderProtocol(), null, (ChannelDataListener)this, (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.session", (PropertyChangeListener)this);
    }

    public void dispose() {
        this.terminal.removeProtocolPropertyListeners((PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.session", (PropertyChangeListener)this);
        this.clients.removeClientListener((ClientListener)this);
        this.clients = null;
    }

    private void setUpAudioAlerts() {
        this.announceNotification(REC_START_NOTICE);
        this.announceNotification(REC_STOP_NOTICE);
        this.announceNotification(REC_IN_PROGRESS_NOTICE);
    }

    private void announceNotification(String path) {
        this.broker.announceNotification((Object)this, path);
    }

    private void sendNotification(String path, String msg) {
        long ts = this.terminal.getClient().getSessionTime();
        this.broker.sendNotification((Object)this, path, msg, ts);
    }

    public void clearRecording() {
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (!chair.isMe()) {
            return;
        }
        int answer = ModalDialog.showConfirmDialog((Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARCONFIRM), (String)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARCONFIRMTITLE), (int)2, (int)3);
        if (answer == 0) {
            ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)1);
            this.terminal.getChannel().onChannelData(msg);
        }
    }

    public void onChannelData(ChannelDataEvent e) {
        if (e.getSourceAddress() != 0) {
            return;
        }
        if (e.getCommand() != 2) {
            return;
        }
        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProv.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARFAILED), (String)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARFAILEDTITLE), (int)0);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent e) {
        Runnable changeHandler = new Runnable(){
            private String prop;
            private Object oldVal;
            private Object newVal;
            {
                this.prop = e.getPropertyName();
                this.oldVal = e.getOldValue();
                this.newVal = e.getNewValue();
            }

            @Override
            public void run() {
                if (this.prop.equals("chair")) {
                    Chair was = new Chair((Connection)RecorderBean.this.terminal.getClient(), this.oldVal);
                    Chair now = new Chair((Connection)RecorderBean.this.terminal.getClient(), this.newVal);
                    if (was.isMe() == now.isMe()) {
                        return;
                    }
                    RecorderBean.this.rModule.updateFeatures();
                } else if (this.prop.equals("recorder.enabled")) {
                    RecorderBean.this.rModule.updateFeatures();
                    if (!RecorderBean.this.isPlaying()) {
                        if (RecorderBean.this.isEnabled()) {
                            if (this.oldVal != null) {
                                RecorderBean.this.sendNotification(RecorderBean.REC_START_NOTICE, "Recording started");
                            } else {
                                RecorderBean.this.sendNotification(RecorderBean.REC_IN_PROGRESS_NOTICE, "Recording in progress");
                            }
                        } else if (this.oldVal != null && this.newVal != null) {
                            RecorderBean.this.sendNotification(RecorderBean.REC_STOP_NOTICE, "Recording stopped");
                        }
                        if (this.oldVal != null && this.newVal != null || RecorderBean.this.isEnabled()) {
                            RecorderBean.this.msgPublisher.sendRecorderStatusMessage(RecorderBean.this.isEnabled());
                        }
                    }
                } else if (this.prop.equals("recorder.forced")) {
                    RecorderBean.this.rModule.updateFeatures();
                } else if (this.prop.equals("Label.session")) {
                    RecorderBean.this.rModule.updateFeatures();
                }
                if (RecorderBean.this.loadingStatus.isReady()) {
                    RecorderBean.this.readyStateListener.onStatusChange(null, null);
                } else {
                    RecorderBean.this.loadingStatus.addListener(RecorderBean.this.readyStateListener);
                }
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)changeHandler);
    }

    private void manageRecordReminder() {
        if (this.reminderDialog == null && !this.reminderPreference) {
            return;
        }
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (chair.isMe() && (this.isRecording() || this.isPlaying())) {
            this.recordReminded = true;
        }
        if (!(!chair.isMe() || this.isPlaying() || this.isRecording() || this.isForced() || this.recordReminded || this.reminderDialog != null)) {
            this.reminderDialog = new EasyDialog((Component)this.parentProv.getDialogParent(), this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_DONTFORGETTOSTARTRECORDINGTITLE), false);
            this.reminderDialog.setDefaultCloseOperation(1);
            this.reminderDialog.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RecorderBean.this.recordReminded = true;
                    RecorderBean.this.reminderDialog.setVisible(false);
                }
            });
            BorderLayout layout = new BorderLayout();
            JPanel panel = new JPanel(layout);
            JLabel recordReminderIconLabel = new JLabel(this.i18n.getIcon("RecorderBean.disabledIcon"), 2);
            recordReminderIconLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            panel.add((Component)recordReminderIconLabel, "West");
            JLabel recordReminderLabel = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDINGNOTSTARTEDREMINDER), 4);
            recordReminderLabel.getAccessibleContext().setAccessibleName(null);
            recordReminderLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            panel.add((Component)recordReminderLabel, "East");
            this.dontAskAgainCheckBox = new JCheckBox(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_DONTASKMETHISAGAIN));
            this.dontAskAgainCheckBox.setSelected(!this.reminderPreference);
            this.dontAskAgainCheckBox.setHorizontalAlignment(0);
            this.dontAskAgainCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RecorderBean.this.reminderPreference = !RecorderBean.this.dontAskAgainCheckBox.isSelected();
                    if (RecorderBean.this.rModule != null) {
                        RecorderBean.this.rModule.reminderCheckBoxChanged(RecorderBean.this.reminderPreference);
                    }
                }
            });
            JPanel dontAskAgainPanel = new JPanel();
            dontAskAgainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), ""));
            dontAskAgainPanel.add(this.dontAskAgainCheckBox);
            panel.add((Component)dontAskAgainPanel, "South");
            this.reminderDialog.setContent((Component)panel);
            JButton startButton = this.reminderDialog.makeButton(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_STARTRECORDINGBUTTONLABEL));
            startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecorderBean.this.startRecordingFromReminder = true;
                    RecorderBean.this.setEnabledRecorder(true, true);
                    RecorderBean.this.recordReminded = true;
                    RecorderBean.this.reminderDialog.setVisible(false);
                }
            });
            this.reminderDialog.addActionButton(startButton, true);
            JButton closeButton = this.reminderDialog.makeButton(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLOSEBUTTONLABEL));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecorderBean.this.recordReminded = true;
                    RecorderBean.this.reminderDialog.setVisible(false);
                }
            });
            this.reminderDialog.addAlternateActionButton(closeButton, false);
        }
        if (this.reminderDialog != null) {
            if (!(!chair.isMe() || this.isPlaying() || this.isRecording() || this.isForced() || this.recordReminded)) {
                if (!this.reminderDialog.isVisible()) {
                    Frame frame;
                    this.reminderDialog.setVisible(true);
                    if (!this.reminderPositioned && (frame = this.parentProv.getDialogParent()).isShowing()) {
                        Dimension appFrameDimension = frame.getSize();
                        Dimension reminderDialogDimension = this.reminderDialog.getSize();
                        Point pt = frame.getLocationOnScreen();
                        pt.x += appFrameDimension.width - reminderDialogDimension.width - reminderDialogDimension.width / 8;
                        pt.y += reminderDialogDimension.height / 4 * 3;
                        this.reminderDialog.setLocation(pt);
                        this.reminderPositioned = true;
                    }
                }
            } else if (this.reminderDialog.isVisible()) {
                this.reminderDialog.setVisible(false);
            }
        }
    }

    public void addCustomIndexEntry() {
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        String text = null;
        if (!this.isRecording()) {
            return;
        }
        if (!chair.isMe()) {
            return;
        }
        String title = this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_ADDINDEXINPUTTITLE);
        String prompt = this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_ADDINDEXINPUTMSG);
        text = ModalDialog.showInputDialog((Component)this.parentProv.getDialogParent(), (Object)prompt, (String)title, (int)-1);
        if (text == null) {
            return;
        }
        this.sendAddIndexMessage(text);
    }

    public void onAddClient(ClientEvent e) {
        if (this.terminal.isPlayback()) {
            return;
        }
        if (e.getAddress() == 1) {
            if (this.rModule != null) {
                this.rModule.updateFeatures();
            }
            if (RecorderProtocol.DEBUG.show()) {
                System.out.println("Recording started.");
            }
        }
    }

    public void onRemoveClient(ClientEvent e) {
        if (this.terminal.isPlayback()) {
            return;
        }
        short addr = e.getAddress();
        if (addr == this.terminal.getClient().getAddress() || addr == 1) {
            this.rModule.updateFeatures();
            if (RecorderProtocol.DEBUG.show()) {
                System.out.println("Recording stopped.");
            }
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.clients == null) {
            return false;
        }
        return this.clients.getProperty("recorder.enabled", false);
    }

    public boolean isForced() {
        if (this.clients == null) {
            return true;
        }
        return this.clients.getProperty("recorder.forced", true);
    }

    public boolean isRecording() {
        if (this.clients == null) {
            return false;
        }
        if (this.terminal.isPlayback()) {
            return false;
        }
        return this.clients.get((short)1) != null;
    }

    public boolean isPlaying() {
        return this.terminal.isPlayback();
    }

    public void setEnabledRecorder(boolean value, boolean confirm) {
        int answer = 0;
        Frame frame = this.parentProv.getDialogParent();
        if (value) {
            if (confirm && !this.startRecordingFromReminder) {
                answer = ModalDialog.showConfirmDialog((Component)frame, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_STARTCONFIRM), (String)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_STARTCONFIRMTITLE), (int)2, (int)3);
            }
            if (answer == 0) {
                if (System.getProperty(PRERELEASE, "false").equals("true")) {
                    ModalDialog.showMessageDialog((Component)frame, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_PRERELEASEMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_PRERELEASETITLE), (int)2);
                }
                this.clients.setProperty("recorder.enabled", true);
                if (RecorderProtocol.DEBUG.show()) {
                    System.out.println("Request recording start");
                }
            }
            this.startRecordingFromReminder = false;
        } else {
            if (confirm) {
                answer = ModalDialog.showConfirmDialog((Component)frame, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_STOPCONFIRM), (String)this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_STOPCONFIRMTITLE), (int)2, (int)3);
            }
            if (answer == 0) {
                this.clients.setProperty("recorder.enabled", false);
                if (RecorderProtocol.DEBUG.show()) {
                    System.out.println("Request recording stop");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAddIndexMessage(String label) {
        ChannelDataEvent msg = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)3);
        DataOutputStream strm = null;
        try {
            strm = msg.write();
            strm.writeUTF(label);
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"addCustomIndexEntry", (Throwable)iox, (boolean)true);
            return;
        }
        finally {
            try {
                if (strm != null) {
                    strm.close();
                }
            }
            catch (Throwable ignored) {}
        }
        this.terminal.getChannel().onChannelData(msg);
        if (RecorderProtocol.DEBUG.show()) {
            System.out.println("Adding index mark - " + label);
        }
    }

    private class ShowRecordReminderListener
    implements ActionListener {
        private ShowRecordReminderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecorderBean.this.manageRecordReminder();
        }
    }
}

