/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.AddRecordingIndexEntryCommand;
import com.elluminate.groupware.recorder.module.RecorderBean;
import com.elluminate.groupware.recorder.module.RecorderModule;
import com.elluminate.groupware.recorder.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class AddRecordingIndexEntryCmd
extends AbstractCommand
implements AddRecordingIndexEntryCommand {
    private static final long serialVersionUID = 1L;
    @Inject
    private I18n i18n;
    @Inject
    private RecorderModule module;
    private String entryName = null;

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        RecorderBean bean = this.module.getRecorderBean();
        if (this.entryName == null || this.entryName.length() < 1) {
            throw new CommandParameterException("Index entry name must be set to a string of length > 0", this.i18n.getString((PropertiesEnum)StringsProperties.ADDRECORDINGINDEXENTRYCMD_BADPARAMENTRYNAMENOTSET));
        }
        if (!bean.isRecording()) {
            throw new CommandContextException("The recorder is not currently active", this.i18n.getString((PropertiesEnum)StringsProperties.RECORDINGCMD_BADCONTEXTNOTRECORDING));
        }
        bean.sendAddIndexMessage(this.entryName);
    }
}

