/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.moduleloading.Module;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.DisconnectQueryAPI;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.multimedia.MultimediaDebug;
import com.elluminate.groupware.multimedia.module.LoadMultimediaCmd;
import com.elluminate.groupware.multimedia.module.MultimediaBean;
import com.elluminate.groupware.multimedia.module.PlayMultimediaCmd;
import com.elluminate.groupware.multimedia.module.StopMultimediaCmd;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;

@Singleton
public class MultimediaModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
PlaybackTimeListener {
    public static final String MODULE_NAME = "Multimedia";
    public static final String SWF_FILETYPE = "swf";
    public static final String MPG_FILETYPE = "mpg";
    public static final String MPE_FILETYPE = "mpe";
    public static final String MPEG_FILETYPE = "mpeg";
    public static final String MPV_FILETYPE = "mpv";
    public static final String MP4_FILETYPE = "mp4";
    public static final String M4V_FILETYPE = "m4v";
    public static final String QT_FILETYPE = "qt";
    public static final String MOV_FILETYPE = "mov";
    public static final String AVI_FILETYPE = "avi";
    public static final String MP3_FILETYPE = "mp3";
    public static final String WMV_FILETYPE = "wmv";
    private I18n i18n = I18n.create((Object)this);
    private MultimediaBean mBean;
    private Client client = null;
    private ClientList clients = null;
    private DisconnectQueryAPI discQuery = null;
    private Provider<MultimediaBean> beanProvider;
    private ClientProvider clientProvider;
    private Imps imps;
    private FeatureBroker broker;
    private BooleanFeature showFeature;
    private ActionFeature loadUrlFeature;
    private ActionFeature stopFeature;
    private ActionFeature loadFileFeature;
    private ComponentFeature multimediaPanelFeature;
    private ComponentFeature multimediaLibraryFeature;
    private ConferencingEngine confEngine;
    private Provider<LoadMultimediaCmd> loadMultimediaCmd;
    private Provider<PlayMultimediaCmd> playMultimediaCmd;
    private Provider<StopMultimediaCmd> stopMultimediaCmd;
    private LoadFeature loadMultimedia;

    public MultimediaModule() {
        MultimediaDebug.UI.show();
        this.discQuery = new DisconnectQueryAPI(){

            public String getProvider() {
                return MultimediaModule.MODULE_NAME;
            }

            public byte getTier() {
                return 32;
            }

            public byte mayDisconnect() {
                if (MultimediaModule.this.mBean == null) {
                    return 0;
                }
                return MultimediaModule.this.mBean.disconnectQuery();
            }
        };
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initMultimediaBeanProvider(Provider<MultimediaBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initLoadMultimediaCmd(Provider<LoadMultimediaCmd> cp) {
        this.loadMultimediaCmd = cp;
    }

    @Inject
    public void initPlayMultimediaCmd(Provider<PlayMultimediaCmd> cp) {
        this.playMultimediaCmd = cp;
    }

    @Inject
    public void initStopMultimediaCmd(Provider<StopMultimediaCmd> cp) {
        this.stopMultimediaCmd = cp;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_EMPTYTITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("MultimediaModule.moduleIcon");
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    protected MultimediaBean getMultimediaBean() {
        return this.mBean;
    }

    private void changeState(boolean sel) {
        Module pm;
        PresentationModeAPI presentationAPI;
        boolean overriddenSel = sel;
        if (sel && (presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class)) != null && presentationAPI.isPresenting() && this.mBean != null && (pm = (Module)presentationAPI.getPresentedModule()) != null) {
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_NOMULTIMEDIAACCESSWHILEPRESENTINGMSG);
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_NOMULTIMEDIAACCESSWHILEPRESENTINGTITLE);
            ModalDialog.showMessageDialogAsync((int)15, (Component)this.mBean, (Object)msg, (String)title, (int)0);
            overriddenSel = false;
        }
        if (this.mBean != null) {
            if (overriddenSel != this.multimediaLibraryFeature.isPublished()) {
                this.mBean.getLibraryPanel().setUpdating(overriddenSel);
            }
            this.broker.setFeaturePublished((Feature)this.multimediaLibraryFeature, overriddenSel);
        }
    }

    public void setTitle(String title) {
    }

    public boolean requestClose() {
        return this.mBean.stopPlaying(this.mBean.getComponent(), false);
    }

    public Component getComponent() {
        return this.mBean.getComponent();
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        this.mBean.setNonLinear(linearity != PlaybackTimeListener.Linearity.REALTIME);
    }

    public void resetSession() {
        if (this.showFeature != null) {
            this.showFeature.setValue((Object)false);
        }
        if (this.mBean != null) {
            this.mBean.setModuleVisible(false);
        }
    }

    public boolean isContentVisible() {
        if (this.mBean == null) {
            return false;
        }
        return this.mBean.isPlaying();
    }

    public boolean prepareToPresent() {
        if (this.mBean == null) {
            return false;
        }
        if (this.mBean.isPlaying()) {
            Chair chair = ChairProtocol.getChair((ClientList)this.clients);
            boolean isChair = chair != null && chair.isMe();
            if (!this.mBean.stopPlaying(this.mBean.getComponent(), !isChair)) {
                return false;
            }
        }
        this.changeState(false);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String nm = e.getPropertyName();
        if (nm.equals("chair")) {
            Chair now = new Chair((Connection)this.client, e.getNewValue());
            Chair prev = new Chair((Connection)this.client, e.getOldValue());
            if (now.isMe() && !prev.isMe()) {
                this.broker.setFeaturePublished((Feature)this.showFeature, true);
                this.loadFileFeature.setEnabled(true);
                this.broker.setFeaturePublished((Feature)this.loadUrlFeature, true);
                this.broker.setFeaturePublished((Feature)this.stopFeature, true);
                this.broker.setFeaturePublished((Feature)this.loadMultimedia, true);
            } else if (prev.isMe() && !now.isMe()) {
                this.broker.setFeaturePublished((Feature)this.showFeature, false);
                this.loadFileFeature.setEnabled(false);
                this.broker.setFeaturePublished((Feature)this.loadUrlFeature, false);
                this.broker.setFeaturePublished((Feature)this.stopFeature, false);
                this.broker.setFeaturePublished((Feature)this.loadMultimedia, false);
                if (this.multimediaLibraryFeature.isPublished()) {
                    this.mBean.getLibraryPanel().setUpdating(false);
                    this.broker.removeFeature((Feature)this.multimediaLibraryFeature);
                }
            }
        } else if (nm.equals("moduleVisible")) {
            boolean visible = false;
            if (this.mBean != null) {
                visible = this.mBean.isModuleVisible();
            }
            if (visible && !this.multimediaPanelFeature.isPublished()) {
                this.broker.setFeaturePublished((Feature)this.multimediaPanelFeature, visible);
            }
            this.multimediaPanelFeature.setEnabled(visible);
        }
    }

    public void setupUI() {
        this.createFeature();
    }

    public void cleanupUI() {
    }

    public void start() {
        this.confEngine.registerCommand(this.loadMultimediaCmd);
        this.confEngine.registerCommand(this.playMultimediaCmd);
        this.confEngine.registerCommand(this.stopMultimediaCmd);
    }

    public void attach() {
        this.imps.provideAPI(DisconnectQueryAPI.class, (ImpsAPI)this.discQuery);
        this.mBean = (MultimediaBean)this.beanProvider.get();
        this.mBean.setClient();
        this.mBean.addPropertyChangeListener("moduleVisible", this);
        this.mBean.addPropertyChangeListener("libraryVisible", this);
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.mBean.removePropertyChangeListener(this);
        this.mBean.dispose();
        this.mBean = null;
        this.clients.removeClientPropertyChangeListener((PropertyChangeListener)this);
        this.clients = null;
        this.imps.revokeAPI(DisconnectQueryAPI.class, (ImpsAPI)this.discQuery);
    }

    public void stop() {
    }

    public void createFeature() {
        this.showFeature = this.broker.createBooleanFeature((Object)this, "/multimedia/show", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_MEDIALABEL), this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_SHOWLIBTIP));
        this.showFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_MEDIALABEL));
        this.showFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_MEDIALABEL));
        this.showFeature.setTrueIcon(this.i18n.getImage("MultimediaModule.mediaIcon"));
        this.showFeature.setFalseIcon(this.i18n.getImage("MultimediaModule.mediaIcon"));
        this.showFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean value = Boolean.parseBoolean(event.getNewValue().toString());
                MultimediaModule.this.changeState(value);
            }
        });
        this.loadFileFeature = this.broker.createActionFeature((Object)this, "/multimedia/loadFileMenu", this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_LOADFILELABEL), null);
        this.loadFileFeature.setEnabled(false);
        this.loadFileFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MultimediaModule.this.mBean.open();
                MultimediaModule.this.showFeature.setValue((Object)true);
            }
        });
        this.broker.setFeaturePublished((Feature)this.loadFileFeature, true);
        this.loadUrlFeature = this.broker.createActionFeature((Object)this, "/multimedia/loadURLMenu", this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_LOADURLLABEL), null);
        this.loadUrlFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MultimediaModule.this.mBean.load();
            }
        });
        this.multimediaPanelFeature = this.broker.createComponentFeature((Object)this, "/multimedia/multimediaPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return MultimediaModule.this.mBean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_EMPTYTITLE), this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_EMPTYTITLE));
        this.multimediaLibraryFeature = this.broker.createComponentFeature((Object)this, "/multimedia/libraryPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return MultimediaModule.this.mBean.getLibraryPanel();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_DEFAULTTITLE), "");
        this.stopFeature = this.broker.createActionFeature((Object)this, "/multimedia/stop", null, null);
        this.stopFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                MultimediaModule.this.mBean.stopPlaying(MultimediaModule.this.mBean, false);
            }
        });
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add(SWF_FILETYPE);
        fileTypes.add(MPG_FILETYPE);
        fileTypes.add(MPE_FILETYPE);
        fileTypes.add(MPEG_FILETYPE);
        fileTypes.add(MPV_FILETYPE);
        fileTypes.add(M4V_FILETYPE);
        fileTypes.add(MP4_FILETYPE);
        fileTypes.add(QT_FILETYPE);
        fileTypes.add(MOV_FILETYPE);
        fileTypes.add(AVI_FILETYPE);
        fileTypes.add(MP3_FILETYPE);
        fileTypes.add(WMV_FILETYPE);
        this.loadMultimedia = this.broker.createLoadFeature((Object)this, "/multimedia/loadMultimediaFiles", "Load Multimedia", null);
        this.loadMultimedia.setFileTypes(fileTypes);
        this.loadMultimedia.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.MULTIMEDIAMODULE_LOADFEATUREICON));
        this.loadMultimedia.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files != null) {
                    MultimediaModule.this.showFeature.setValue((Object)true);
                    for (File file : files) {
                        ((MultimediaBean)MultimediaModule.this.beanProvider.get()).addFileToPendingWithMediaId(file);
                    }
                }
            }
        });
    }
}

