/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.browser.BrowserPane;
import com.elluminate.browser.NavigationEvent;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.moduleloading.Module;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.MultimediaDebug;
import com.elluminate.groupware.multimedia.MultimediaProtocol;
import com.elluminate.groupware.multimedia.module.ClientMediaLibrary;
import com.elluminate.groupware.multimedia.module.Filter;
import com.elluminate.groupware.multimedia.module.IDClient;
import com.elluminate.groupware.multimedia.module.LibraryPanel;
import com.elluminate.groupware.multimedia.module.MediaIDEvent;
import com.elluminate.groupware.multimedia.module.MediaIDListener;
import com.elluminate.groupware.multimedia.module.MediaServer;
import com.elluminate.groupware.multimedia.module.MultimediaPublisher;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

@Singleton
public class MultimediaBean
extends JPanel
implements ChannelListener,
ChannelDataListener,
PropertyChangeListener,
MediaIDListener {
    public static final byte INIT_FAILED = -1;
    public static final byte INIT_UNKNOWN = 0;
    public static final byte INIT_OK = 1;
    public static final String MODULE_VISIBLE_PROP = "moduleVisible";
    public static final String LIBRARY_VISIBLE_PROP = "libraryVisible";
    public static final int UNKNOWN_PLAYER = 0;
    public static final int WINDOWS_MEDIA_PLAYER = 1;
    public static final int REAL_PLAYER = 2;
    public static final int QUICKTIME_PLAYER = 3;
    public static final int FLASH_PLAYER = 4;
    private static final String[] PLAYER_NAME = new String[]{"Unknown", "WindowsMedia", "Real", "QuickTime", "Flash"};
    private static final String WHITESPACE = "\n\t ";
    private static String SEPARATOR = "://";
    private static String[] PROTOCOLS = new String[]{"agenda", "http", "https"};
    private I18n i18n = I18n.create((Object)this);
    private ClientMediaLibrary lib;
    private IDClient idMgr;
    private MultimediaProtocol proto;
    private String lastDir = System.getProperty("user.home");
    private HashMap<Integer, File> pending = new HashMap();
    private boolean isModVisible = false;
    private BrowserPane browser;
    private MediaServer mServer;
    private boolean disposed = false;
    private boolean nonlinear = false;
    private int nowPlaying = -1;
    private int requested = -1;
    private LibraryPanel libraryPanel = null;
    private AbstractButton button = null;
    private int playingIds = -1;
    private URL lastURL;
    private MultimediaPublisher msgPublisher;
    private ImageIcon warnIcon = this.i18n.getIcon("MultimediaWarnDialog.warnIcon");
    private JinxTerminal terminal;
    private ClientList clients;
    private Imps imps;
    private DialogParentProvider parentProvider;
    private ContentCaptureProvider contentCaptureProvider;

    public MultimediaBean() {
        this.proto = new MultimediaProtocol();
        try {
            this.browser = new BrowserPane(true);
            this.browser.addUIListener(new UIListener(){

                public void setCurrentURL(String url) {
                }

                public void setPageTitle(String title) {
                }

                public void setBackEnabled(boolean enabled) {
                }

                public void setFwdEnabled(boolean enabled) {
                }
            });
            this.browser.addNavigationListener(new NavigationListener(){

                public void onNavigate(NavigationEvent e) {
                }

                public void onStop() {
                    if (MultimediaBean.this.libraryPanel != null) {
                        MultimediaBean.this.libraryPanel.onStop();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add(this.browser.getComponent(), "Center");
        }
        catch (InstantiationException ie) {
            this.browser = null;
        }
    }

    @Inject
    public void initMultimediaPublisher(MultimediaPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initJinxTerminal(JinxTerminal terminal) {
        this.terminal = terminal;
        this.clients = terminal.getClientList();
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    protected void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    public void setClient() {
        this.terminal.setProtocolAndListeners((JinxProtocol)this.proto, (ChannelListener)this, (ChannelDataListener)this, (PropertyChangeListener)this);
        Container parent = this.parentProvider.getDialogParent();
        if (parent == null) {
            parent = this;
        }
        this.lib = new ClientMediaLibrary(this.terminal.getChannel(), parent);
        this.idMgr = new IDClient(this.terminal.getChannel());
        this.idMgr.addMediaIDListener(this);
        this.mServer = new MediaServer(this.lib);
        if (this.browser != null) {
            this.mServer.setComponent(this.browser.getComponent());
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.idMgr != null) {
            this.idMgr.removeMediaIDListener(this);
        }
        if (this.browser != null) {
            this.browser.stop();
            this.browser.dispose();
        }
        this.mServer.stop();
        this.lib.dispose();
    }

    public boolean hasEmbeddedViewer() {
        return this.browser != null;
    }

    public boolean isPlaying() {
        if (this.libraryPanel == null) {
            return false;
        }
        return this.libraryPanel.isPlaying();
    }

    public Component getComponent() {
        return this.browser != null ? this : null;
    }

    public void setNonLinear(boolean nl) {
        this.nonlinear = nl;
        if (!this.nonlinear) {
            int req = this.requested;
            int now = this.nowPlaying;
            if (this.requested != this.nowPlaying) {
                if (now > 0) {
                    this.stopMedia();
                }
                if (req > 0) {
                    try {
                        this.playMedia(req);
                    }
                    catch (IOException ex) {
                        LogSupport.exception((Object)this, (String)"setNonLinear", (Throwable)ex, (boolean)true);
                        this.nowPlaying = -1;
                        this.requested = -1;
                    }
                }
            }
        }
    }

    public LibraryPanel getLibraryPanel() {
        this.setupLibraryDialog();
        this.libraryPanel.setVisible(true);
        return this.libraryPanel;
    }

    public void onChannelData(ChannelDataEvent e) {
        if (this.disposed || e.getSourceAddress() != 0) {
            return;
        }
        switch (e.getCommand() & 0xFFFFFFF0) {
            case 32: {
                this.handleEvent(e);
                break;
            }
            case 48: {
                this.idMgr.onChannelData(e);
                break;
            }
            case 16: {
                this.lib.onChannelData(e);
                break;
            }
            default: {
                LogSupport.error((Object)this, (String)"onChannelData", (String)("Unknown multimedia message - " + e.getCommand()));
            }
        }
    }

    private void setOsProperty(ClientInfo me) {
        byte osCode = 0;
        int os = Platform.getOS();
        switch (os) {
            case 202: {
                osCode = 1;
                break;
            }
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: {
                osCode = 2;
                break;
            }
            case 250: {
                osCode = 4;
                break;
            }
            case 300: {
                osCode = 3;
            }
        }
        me.setProperty("multimedia.os", Bytes.get((byte)osCode).byteValue());
    }

    public void channelStateChanged(ChannelEvent e) {
        if (this.disposed) {
            return;
        }
        switch (e.getState()) {
            case 1: {
                this.lib.addProxy((short)0);
                try {
                    this.mServer.start();
                }
                catch (IOException ex) {
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_MEDIASERVERMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_MEDIASERVERTITLE), (int)0);
                }
                this.setOsProperty(this.clients.getMyClient());
                break;
            }
            case 2: {
                this.stopMedia();
                this.lib.removeProxy((short)0);
                if (this.isModuleVisible()) {
                    this.setModuleVisible(false);
                }
                if (this.browser != null) {
                    this.browser.stop();
                }
                this.mServer.stop();
                if (this.button == null || !this.button.isSelected()) break;
                this.button.setSelected(false);
                break;
            }
        }
    }

    void setupLibraryDialog() {
        if (this.libraryPanel == null) {
            this.libraryPanel = new LibraryPanel(this.lib);
            this.libraryPanel.setBean(this);
            this.libraryPanel.setLoadFileAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultimediaBean.this.open();
                }
            });
            this.libraryPanel.setLoadURLAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultimediaBean.this.load();
                }
            });
            this.libraryPanel.setRemoveMediaAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Chair chair = ChairProtocol.getChair((ClientList)MultimediaBean.this.clients);
                    Component c = MultimediaBean.this.libraryPanel;
                    if (e.getSource() instanceof Component) {
                        c = (Component)e.getSource();
                    }
                    if (!chair.isMe()) {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)c, (Object)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRMSG, new Object[]{LabelProps.get((PropertyAccessAPI)MultimediaBean.this.clients, (String)"Label.moderator")}), (String)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRTITLE), (int)0);
                        return;
                    }
                    int[] ids = MultimediaBean.this.libraryPanel.getIDSelection();
                    int result = ids.length > 1 ? ModalDialog.showConfirmDialog((Component)c, (Object)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_VALIDATEDELETES), (String)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_VALIDATEDELETETITLE), (int)0) : ModalDialog.showConfirmDialog((Component)c, (Object)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_VALIDATEDELETE), (String)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_VALIDATEDELETETITLE), (int)0);
                    if (result == 0) {
                        for (int i = 0; i < ids.length; ++i) {
                            MultimediaBean.this.lib.remove(ids[i]);
                        }
                    }
                }
            });
            this.libraryPanel.setStopMediaAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof Component) {
                        MultimediaBean.this.stopPlaying((Component)e.getSource(), false);
                    } else {
                        MultimediaBean.this.stopPlaying(MultimediaBean.this.libraryPanel, false);
                    }
                }
            });
            this.libraryPanel.setPlayMediaAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultimediaBean.this.libraryPanel.requestPlay()) {
                        MultimediaBean.this.playSelectedMedia();
                    } else {
                        int[] ids = MultimediaBean.this.libraryPanel.getIDSelection();
                        Component c = e.getSource() instanceof Component ? (Component)e.getSource() : MultimediaBean.this.libraryPanel;
                        MultimediaBean.this.stopPlaying(c, ids.length == 1 && ids[0] == MultimediaBean.this.playingIds);
                    }
                }
            });
        }
    }

    protected byte disconnectQuery() {
        boolean aTransferIsNotComplete = false;
        StringBuffer uList = new StringBuffer();
        Iterator iter = this.lib.iterator();
        while (iter.hasNext()) {
            MediaLibraryEntry entry = (MediaLibraryEntry)iter.next();
            if (!entry.isLoading() || entry.getSource() == 0) continue;
            aTransferIsNotComplete = true;
            uList.append("    ");
            uList.append(entry.getName());
            uList.append("\n");
        }
        if (aTransferIsNotComplete) {
            String message = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_ULDISCONNECTQUERY, new Object[]{uList.toString()});
            int result = ModalDialog.showConfirmDialog((Component)this.parentProvider.getDialogParent(), (Object)message, (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_DISCONNECTTITLE), (int)0);
            if (result == 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    void playSelectedMedia() {
        Module pm;
        PresentationModeAPI presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (presentationAPI != null && presentationAPI.isPresenting() && (pm = (Module)presentationAPI.getPresentedModule()) != null) {
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTWHILEPRESENTINGMSG);
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTWHILEPRESENTINGTITLE);
            ModalDialog.showMessageDialogAsync((int)15, (Component)this.parentProvider.getDialogParent(), (Object)msg, (String)title, (int)0);
            return;
        }
        int[] ids = this.libraryPanel.getIDSelection();
        if (ids.length == 1 && !this.libraryPanel.isPlaying()) {
            int result;
            if (this.mediaNotComplete(ids) && (result = ModalDialog.showConfirmDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCOMPLETE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCOMPLETETITLE), (int)2, (int)2, (Icon)this.warnIcon)) == 2) {
                return;
            }
            this.fireEventToPlayMultimediaId(ids[0]);
        }
    }

    public void fireEventToPlayMultimediaId(int id) {
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)33);
        try {
            DataOutputStream ostr = cde.write();
            ostr.writeInt(id);
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"play", (Throwable)ex, (boolean)true);
            cde.dispose();
            return;
        }
        this.terminal.fireChannelData(cde);
        this.playingIds = id;
    }

    void addURL(String fileURL) throws MalformedURLException {
        this.lib.add(new URL(this.checkURL(fileURL)));
    }

    private boolean mediaNotComplete(int[] ids) {
        Iterator iter = this.lib.iterator();
        while (iter.hasNext()) {
            MediaLibraryEntry entry = (MediaLibraryEntry)iter.next();
            for (int i = 0; i < ids.length; ++i) {
                if (entry.getID() != ids[i]) continue;
                for (int j = 0; j < MultimediaProtocol.STATUS_PCT.length - 1; ++j) {
                    if (entry.getStatusCount(j) <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean stopPlaying(Component c, boolean silent) {
        if (this.libraryPanel != null && this.libraryPanel.isPlaying()) {
            Chair chair;
            if (c == null) {
                silent = true;
            }
            if (!(chair = ChairProtocol.getChair((ClientList)this.clients)).isMe()) {
                if (!silent) {
                    ModalDialog.showMessageDialog((Component)c, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRMSG, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRTITLE), (int)0);
                }
                return false;
            }
            if (silent || ModalDialog.showConfirmDialog((Component)c, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_QUERYSTOP), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_QUERYSTOPTITLE), (int)0) == 0) {
                if (this.browser != null) {
                    this.browser.stop();
                }
                this.libraryPanel.clearDeferredPlay();
                ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)34);
                this.terminal.fireChannelData(cde);
                return true;
            }
        }
        return false;
    }

    public void load() {
        String input;
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (!chair.isMe()) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRMSG, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRTITLE), (int)0);
            return;
        }
        String urlStr = null;
        if (this.lastURL != null) {
            urlStr = this.lastURL.toString();
        }
        if ((input = ModalDialog.showInputDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_ENTERURLMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_ENTERURLTITLE), (int)1, (String)urlStr)) == null) {
            return;
        }
        try {
            URL url = new URL(this.checkURL(input));
            boolean containsWMV = false;
            if (this.isUrlWMV(urlStr)) {
                containsWMV = true;
            }
            if (containsWMV && !this.areClientsAllWindows()) {
                ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_WMVFILETYPE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_WMVFILETITLE), (int)2);
            }
            this.lib.add(url);
            this.lastURL = url;
        }
        catch (MalformedURLException ex) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_BADURLMSG, new Object[]{input, ex.getMessage()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_BADURLTITLE), (int)0);
            return;
        }
    }

    public void open() {
        Chair chair = ChairProtocol.getChair((Connection)this.terminal.getClient());
        if (!chair.isMe()) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRMSG, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRTITLE), (int)0);
            return;
        }
        CFileChooser fc = new CFileChooser(this.lastDir);
        fc.removeChoosableFileFilter(fc.getAcceptAllFileFilter());
        Filter swfFilter = new Filter("FilterSWF");
        Filter mpgFilter = new Filter("FilterMPG");
        Filter qtFilter = new Filter("FilterQT");
        Filter mediaFilter = new Filter("FilterMedia");
        Filter m4vFilter = new Filter("FilterM4V");
        Filter wmvFilter = new Filter("FilterWMV");
        Filter audioFilter = new Filter("FilterAudio");
        fc.addChoosableFileFilter((FileFilter)mediaFilter);
        fc.addChoosableFileFilter((FileFilter)swfFilter);
        fc.addChoosableFileFilter((FileFilter)mpgFilter);
        fc.addChoosableFileFilter((FileFilter)qtFilter);
        fc.addChoosableFileFilter((FileFilter)m4vFilter);
        fc.addChoosableFileFilter((FileFilter)wmvFilter);
        fc.addChoosableFileFilter((FileFilter)audioFilter);
        fc.setFileFilter((FileFilter)mediaFilter);
        fc.setMultiSelectionEnabled(Platform.checkJavaVersion((String)"1.2+"));
        int answer = fc.showOpenDialog((Component)this.parentProvider.getDialogParent());
        if (answer != 0) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        boolean containsWMV = false;
        if (files == null || files.length <= 0) {
            File f = fc.getSelectedFile();
            if (f == null) {
                return;
            }
            files = new File[]{f};
        }
        for (int i = 0; i < files.length; ++i) {
            this.lastDir = files[i].getParent();
            if (!this.isFileValidMediaFile(files[i])) {
                ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_BADFILETYPE, new Object[]{files[i]}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_BADFILETITLE), (int)0);
                continue;
            }
            this.addFileToPendingWithMediaId(files[i]);
            if (!this.isFileWMV(files[i])) continue;
            containsWMV = true;
        }
        boolean areMobileDevicesPresent = this.areMobileDevicesPresent();
        if (containsWMV && !this.areClientsAllWindows() && !areMobileDevicesPresent) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_WMVFILETYPE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_WMVFILETITLE), (int)2);
        } else if (areMobileDevicesPresent) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_MOBILEVIDEOFILETYPE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_MOBILEVIDEOFILETITLE), (int)2);
        }
    }

    private boolean isFileWMV(File file) {
        String suffix = FileSysUtils.getExtension((File)file);
        return this.isStringWMV(suffix);
    }

    private boolean isStringWMV(String suffix) {
        if (suffix == null) {
            return false;
        }
        return (suffix = suffix.toLowerCase(Locale.ENGLISH)) != null && suffix.equals("wmv");
    }

    private boolean isUrlWMV(String file) {
        String suffix = FileSysUtils.getExtensionString((String)file);
        return this.isStringWMV(suffix);
    }

    private boolean areClientsAllWindows() {
        Iterator iter = this.clients.visibleIterator();
        while (iter.hasNext()) {
            ClientInfo client = (ClientInfo)iter.next();
            Byte os = (Byte)client.getProperty("multimedia.os");
            if (os == 2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileToPendingWithMediaId(File f) {
        HashMap<Integer, File> hashMap = this.pending;
        synchronized (hashMap) {
            int req = this.idMgr.requestMediaID();
            this.pending.put(new Integer(req), f);
        }
    }

    private boolean isFileValidMediaFile(File f) {
        Filter mediaFilter = new Filter("FilterMedia");
        return mediaFilter.accept(f);
    }

    private boolean areMobileDevicesPresent() {
        Iterator iter = this.clients.visibleIterator();
        while (iter.hasNext()) {
            ClientInfo client = (ClientInfo)iter.next();
            Byte devType = (Byte)client.getProperty("multimedia.os");
            if (devType == null || devType != 5 && devType != 6) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mediaIDAssigned(MediaIDEvent e) {
        File f;
        HashMap<Integer, File> hashMap = this.pending;
        synchronized (hashMap) {
            f = this.pending.get(new Integer(e.getRequestID()));
        }
        if (f == null) {
            return;
        }
        try {
            this.lib.add(f, e.getMediaID(), e.getAuthCode());
        }
        catch (Exception ex) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_ADDFAILEDMSG, new Object[]{f.toString(), ex.toString()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_ADDFAILEDTITLE), (int)0);
        }
    }

    public void delete() {
        Chair chair = ChairProtocol.getChair((Connection)this.terminal.getClient());
        if (!chair.isMe()) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRMSG, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_NOTCHAIRTITLE), (int)0);
            return;
        }
        this.libraryPanel.setVisible(true);
    }

    private void handleEvent(ChannelDataEvent e) {
        if (this.disposed) {
            return;
        }
        switch (e.getCommand()) {
            case 33: {
                try {
                    DataInputStream istr = e.read();
                    int id = istr.readInt();
                    istr.close();
                    this.playMedia(id);
                    break;
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"handleEvent", (Throwable)ex, (boolean)true);
                    return;
                }
            }
            case 34: {
                this.stopMedia();
            }
        }
    }

    private void playMedia(int id) throws IOException {
        if (!this.contentCaptureProvider.get().isEchoingData()) {
            return;
        }
        if (this.nonlinear) {
            this.requested = id;
        } else {
            String url = this.buildURL(id);
            if (MultimediaDebug.URL.show()) {
                LogSupport.message((Object)this, (String)"playMedia", (String)url);
            }
            new URLWorker(url).start();
            this.msgPublisher.sendMultimediaPlayingMessage(this.lib.get(id).getName(), false);
        }
    }

    private void stopMedia() {
        if (this.nonlinear) {
            this.requested = -1;
        } else {
            String mediaName = "";
            int previouslyPlaying = this.nowPlaying;
            try {
                mediaName = this.lib.get(this.nowPlaying).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lib.stopPlaying(this.nowPlaying);
            this.setModuleVisible(false);
            new StopWorker().start();
            this.nowPlaying = -1;
            this.requested = -1;
            if (this.libraryPanel != null) {
                this.libraryPanel.setPlaying(false, 0);
            }
            if (previouslyPlaying != -1) {
                this.msgPublisher.sendMultimediaStoppedMessage(mediaName, false);
            }
        }
    }

    private String buildURL(int id) throws IOException {
        MediaLibraryEntry ent = this.lib.get(id);
        if (ent == null) {
            throw new FileNotFoundException();
        }
        String mime = ent.getMimeType();
        int player = this.getPlayer(ent.getName(), mime);
        if (MultimediaDebug.PLAYER.show()) {
            String playerName = null;
            try {
                playerName = PLAYER_NAME[player];
            }
            catch (Throwable t) {
                playerName = "#" + player;
            }
            File app = null;
            try {
                app = Platform.findAppByMIME((String)mime);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            LogSupport.message((Object)this, (String)"buildURL", (String)("MIME=" + mime + " player=" + playerName + " app=" + app));
        }
        String host = "localhost";
        switch (player) {
            case 1: {
                return "http://" + host + ":" + this.mServer.getPort() + "/wmp_wrapper.html?id=" + id;
            }
            case 2: {
                return "http://" + host + ":" + this.mServer.getPort() + "/real_wrapper.html?id=" + id;
            }
            case 3: {
                return "http://" + host + ":" + this.mServer.getPort() + "/qt_wrapper.html?id=" + id;
            }
            case 4: {
                return "http://" + host + ":" + this.mServer.getPort() + "/swf_wrapper.html?id=" + id;
            }
        }
        return "http://" + host + ":" + this.mServer.getPort() + "/id" + id + "." + Platform.getSuffix((String)mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPlayer(String nm, String mime) {
        int platform = Platform.getPlatform();
        if (MultimediaDebug.WRAPPER_ASK.isEnabled()) {
            String[] options = new String[]{"Unknown", "Windows Media", "Realplayer", "QuickTime", "Flash"};
            JComboBox<String> cb = new JComboBox<String>(options);
            EasyDialog d = new EasyDialog((Component)this, "Wrapper Selector", true);
            cb.setEditable(false);
            d.addPassiveComponent((Component)new JLabel("Select the player to play " + nm + "(" + mime + ")?"));
            d.addPassiveComponent(cb);
            d.addActionButton(d.makeButton(1));
            d.setVisible(true);
            try {
                for (int i = 0; i < options.length; ++i) {
                    if (!options[i].equals(cb.getSelectedItem())) continue;
                    int n = i;
                    return n;
                }
            }
            finally {
                d.dispose();
            }
        }
        if (mime.equalsIgnoreCase("audio/mpeg") && platform == 2) {
            return 3;
        }
        if (mime.equalsIgnoreCase("video/mpeg") || mime.equalsIgnoreCase("audio/mpeg") || mime.equalsIgnoreCase("video/x-msvideo")) {
            File file = Platform.findAppByMIME((String)mime);
            if (file == null) {
                return 0;
            }
            String name = file.getName();
            if (name.equalsIgnoreCase("mplayer.exe") || name.equalsIgnoreCase("wmplayer.exe") || name.equalsIgnoreCase("Windows Media Player.app") || name.equalsIgnoreCase("Windows Media Player 7.app")) {
                return 1;
            }
            if ((name.equalsIgnoreCase("realplay.exe") || name.equalsIgnoreCase("realplayer") || name.equalsIgnoreCase("RealOne Player.app") || name.equalsIgnoreCase("RealPlayer.app")) && platform != 2) {
                return 2;
            }
            if (name.equalsIgnoreCase("QuickTimePlayer.exe") || name.equalsIgnoreCase("QuickTime Player.app")) {
                return 3;
            }
        } else if (mime.equalsIgnoreCase("application/vnd.ms-asf") || mime.equalsIgnoreCase("video/x-ms-asf") || mime.equalsIgnoreCase("video/x-ms-asf-plugin") || mime.equalsIgnoreCase("video/x-ms-wma") || mime.equalsIgnoreCase("video/x-ms-wmv")) {
            if (platform != 3) {
                return 1;
            }
        } else if (mime.equalsIgnoreCase("audio/x-realaudio") || mime.equalsIgnoreCase("audio/x-pn-realaudio") || mime.equalsIgnoreCase("audio/x-pn-realaudio") || mime.equalsIgnoreCase("audio/x-pn-realaudio-plugin") || mime.equalsIgnoreCase("application/vnd.rn-realmedia")) {
            if (platform != 2) {
                return 2;
            }
        } else if (mime.equalsIgnoreCase("video/quicktime") || mime.equalsIgnoreCase("video/x-m4v") || mime.equalsIgnoreCase("video/mp4")) {
            if (platform == 1) {
                if (Platform.getOS() == 407) {
                    return 4;
                }
                return 3;
            }
            if (platform != 3) {
                return 3;
            }
        } else if (mime.equalsIgnoreCase("application/x-shockwave-flash") && platform == 1) {
            return 4;
        }
        return 0;
    }

    public void setModuleVisible(boolean state) {
        if (this.isModVisible == state) {
            return;
        }
        boolean was = this.isModVisible;
        PlaybackTimeAPI timeAPI = null;
        timeAPI = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (timeAPI != null) {
            if (state) {
                timeAPI.suspendTimeCompression((Object)this);
            } else {
                timeAPI.resumeTimeCompression((Object)this);
            }
        }
        this.isModVisible = state;
        this.firePropertyChange(MODULE_VISIBLE_PROP, was, state);
    }

    public boolean isModuleVisible() {
        return this.isModVisible && this.getInitState() != -1;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public String checkURL(String str) throws MalformedURLException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (WHITESPACE.indexOf(str.charAt(i)) >= 0) continue;
            buf.append(str.charAt(i));
        }
        str = buf.toString();
        int sep = str.indexOf(SEPARATOR);
        if (sep < 0) {
            str = PROTOCOLS[0] + SEPARATOR + str;
        }
        URLString url = new URLString(str);
        String protocol = url.getProtocol();
        for (int i = 0; i < PROTOCOLS.length; ++i) {
            if (!protocol.equalsIgnoreCase(PROTOCOLS[i])) continue;
            return str;
        }
        throw new MalformedURLException(this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_INVALIDPROTOCOL, new Object[]{protocol}));
    }

    public byte getInitState() {
        if (this.browser == null) {
            return -1;
        }
        return this.browser.getInitState();
    }

    public void loadPreferences(String prefix, Preferences preferences) {
    }

    public void savePreferences(String prefix, Preferences preferences) {
    }

    class StopWorker
    extends WorkerThread {
        public StopWorker() {
            super("StopWorker");
        }

        public void run() {
            try {
                if (MultimediaBean.this.browser != null) {
                    MultimediaBean.this.browser.stop();
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)((Object)this), (String)"run", (Throwable)ex, (boolean)true);
            }
        }
    }

    class URLWorker
    extends WorkerThread {
        String url;

        public URLWorker(String url) {
            super("URLWorker");
            this.url = url;
        }

        public void run() {
            block8: {
                try {
                    long now;
                    long delay;
                    byte initState = MultimediaBean.this.getInitState();
                    if (MultimediaBean.this.browser != null && initState != -1) {
                        MultimediaBean.this.browser.openURL(this.url);
                    } else {
                        BrowserUtil.gotoURL((String)this.url);
                    }
                    MultimediaBean.this.getLibraryPanel().setPlaying(true, MultimediaBean.this.nowPlaying);
                    MultimediaBean.this.setModuleVisible(true);
                    if (initState != 0) break block8;
                    long limit = System.currentTimeMillis() + 10000L;
                    while ((delay = limit - (now = System.currentTimeMillis())) > 0L) {
                        try {
                            Thread.sleep(Math.min(1000L, delay));
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        if (MultimediaBean.this.getInitState() == 0) continue;
                    }
                    if (MultimediaBean.this.getInitState() == -1) {
                        MultimediaBean.this.setModuleVisible(false);
                        BrowserUtil.gotoURL((String)this.url);
                        MultimediaBean.this.setModuleVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ModalDialog.showMessageDialog((Component)MultimediaBean.this.parentProvider.getDialogParent(), (Object)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_CANTPUSHMSG, new Object[]{this.url, ex.getMessage()}), (String)MultimediaBean.this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIABEAN_CANTPUSHTITLE), (int)0);
                }
            }
        }
    }
}

