/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AnnouncementDisplayDialog
extends EasyDialog {
    public AnnouncementDisplayDialog(Component owner, Chat msg) {
        super(owner, null, false);
        I18n i18n = I18n.create(AnnouncementDisplayDialog.class);
        this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.ANNOUNCEMENT_DISPLAY_TITLE));
        JButton dismissButton = this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.ANNOUNCEMENT_DISPLAY_DISMISS_BUTTON));
        this.addActionButton(dismissButton);
        JPanel p = new JPanel(new BorderLayout(8, 0));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), BorderFactory.createEmptyBorder(0, 0, 6, 0)));
        JLabel fromLabel = new JLabel(msg.getOriginator().getName());
        p.add((Component)fromLabel, "West");
        String shortTimeStr = DateFormat.getTimeInstance(3).format(msg.getTimestamp());
        JLabel timeLabel = new JLabel(shortTimeStr);
        p.add((Component)timeLabel, "East");
        JPanel c = new JPanel(new BorderLayout(0, 6));
        c.add((Component)p, "North");
        MultilineLabel messageLabel = new MultilineLabel(msg.getText());
        messageLabel.setFocusable(true);
        messageLabel.setSize(300, Integer.MAX_VALUE);
        messageLabel.setWrapStyleWord(true);
        messageLabel.setMargin(new Insets(2, 4, 2, 4));
        final JScrollPane messagePane = new JScrollPane((Component)messageLabel);
        messagePane.setHorizontalScrollBarPolicy(31);
        messagePane.setBorder(BorderFactory.createEmptyBorder());
        messagePane.getViewport().setBackground(messageLabel.getBackground());
        messagePane.setSize(300, Integer.MAX_VALUE);
        messagePane.setPreferredSize(new Dimension(300, Math.min(messageLabel.getPreferredSize().height, 480)));
        c.add((Component)messagePane, "Center");
        this.setContent(c);
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                messagePane.getVerticalScrollBar().setValue(messagePane.getVerticalScrollBar().getMinimum());
            }
        });
    }
}

