/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web;

import com.elluminate.groupware.web.WebResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import java.io.DataInputStream;

public class WebProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "www";
    public static final byte PRIORITY = 2;
    public static final String ACCESS_PROPERTY = "webTourFloor";
    public static final String ACTIVE_PROPERTY = "webTourActive";
    public static final byte PUSH_URL = 1;
    public static final byte TOUR_MOVE = 2;
    public static final byte TOUR_CLOSE = 3;
    public static final byte TOUR_FRM_MOVE = 4;
    public static final byte TOUR_GUIDE = 5;

    public WebProtocol() {
        this(Boolean.FALSE);
    }

    public WebProtocol(boolean dftAccess) {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(ACCESS_PROPERTY, (byte)0, dftAccess);
        this.defineProperty(ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "PushURL";
            }
            case 2: {
                return "TourMove";
            }
            case 3: {
                return "TourClose";
            }
            case 4: {
                return "TourFrameMove";
            }
            case 5: {
                return "TourGuide";
            }
        }
        return "[ Invalid www protocol code - " + cmd + " ]";
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String msg = this.commandToString(cmd);
        if (cmd == 1 || cmd == 2) {
            try {
                msg = msg + " - " + str.readUTF();
            }
            catch (Exception ex) {
                msg = msg + " - Exception while reading message - " + ex;
            }
        } else if (cmd == 4) {
            try {
                msg = msg + " - [" + str.readUTF() + "] " + str.readUTF();
            }
            catch (Exception ex) {
                msg = msg + " - Exception while reading message - " + ex;
            }
        } else if (cmd == 5) {
            try {
                msg = msg + " - " + str.readShort();
            }
            catch (Exception ex) {
                msg = msg + " - Exception while reading message - " + ex;
            }
        }
        return msg;
    }

    public ProtocolResponder getResponder() {
        return new WebResponder(this);
    }
}

