/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.attributes.ToolColorList;
import com.elluminate.groupware.whiteboard.attributes.ToolComponent;
import com.elluminate.groupware.whiteboard.attributes.ToolFontList;
import com.elluminate.groupware.whiteboard.attributes.ToolSmileyMap;
import com.elluminate.groupware.whiteboard.attributes.ToolStyleRunList;
import com.elluminate.groupware.whiteboard.attributes.ToolText;
import com.elluminate.groupware.whiteboard.attributes.subattributes.ColorSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.FontSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.SmileySubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleRunSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.ToolActivationListener;
import com.elluminate.groupware.whiteboard.interfaces.WBClipboardInterface;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.tools.SwingSupport;
import com.elluminate.groupware.whiteboard.tools.TextEditorUIInterface;
import com.elluminate.groupware.whiteboard.tools.ToolDefinitions;
import com.elluminate.groupware.whiteboard.tools.ToolRenderer;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class TextEditorToolModel
extends AbstractToolModel
implements Cloneable,
ToolRenderer,
SwingSupport {
    static final String WBD_NAME = "TextEditorTool";
    static final String TEXT_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.TextEditorUI";
    private static Cursor handCursor = new Cursor(12);
    protected ToolText toolText = null;
    protected ToolComponent toolComp = null;
    protected ToolFontList toolFontList = null;
    protected ToolStyleRunList toolFontRuns = null;
    protected ToolColorList toolColorList = null;
    protected ToolStyleRunList toolColorRuns = null;
    protected ToolColor fillColor = null;
    protected ToolSmileyMap toolSmileyMap = null;
    protected ToolStyleRunList toolSmileyRuns = null;
    private ColorSubAttribute colorSub = null;
    private FontSubAttribute fontSub = null;
    private StyleRunSubAttribute styleRun = null;
    private SmileySubAttribute smileySub = null;
    private List toolActivationListeners = new LinkedList();
    private boolean ignoreAttrChange;
    private boolean isCreating = false;
    private boolean locationSet = false;
    private int stringIndx = 0;
    private int continuedResponse = 2;
    private Point mousePoint = new Point();
    protected Object toolData = null;
    private Cursor previousCursor;
    private static int originalWidth = 250;
    private static int originalHeight = 70;
    private int xStart;
    private int xEnd;
    private String exploreScreenName = null;

    public TextEditorToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public TextEditorToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.stroke.setStroke(1.0f, 2, 2, 0.0f, null, 0.0f);
        this.color.setAlternateName("BorderColor");
        this.color.setQuickAttribute(false);
        this.color.setColor(Color.LIGHT_GRAY);
        this.toolText = new ToolText(context, "Text");
        this.toolFontList = new ToolFontList(context);
        this.toolFontList.setAlternateName("ToolFontList");
        this.toolFontList.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FONT));
        this.toolFontList.setPanelKey("textProperties");
        this.toolFontList.setQuickAttribute(true);
        this.toolFontList.setDisplayEditorOnActivation(true);
        this.toolColorList = new ToolColorList(context);
        this.toolColorList.setAlternateName("ToolColorList");
        this.toolColorList.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_TEXTCOLOR));
        this.toolColorList.setPanelKey("textProperties");
        this.toolColorList.setQuickAttribute(true);
        this.toolColorList.setDisplayEditorOnActivation(true);
        this.toolComp = new ToolComponent(context);
        this.toolComp.setAlternateName("ToolComponent");
        this.toolComp.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FONT));
        this.toolComp.setPanelKey("textProperties");
        this.toolComp.setQuickAttribute(false);
        this.toolFontRuns = new ToolStyleRunList(context, "ToolFontRuns");
        this.toolFontRuns.setAlternateName("ToolFontRuns");
        this.toolFontRuns.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FONT));
        this.toolFontRuns.setPanelKey("textProperties");
        this.toolFontRuns.setQuickAttribute(false);
        this.toolColorRuns = new ToolStyleRunList(context, "ToolColorRuns");
        this.toolColorRuns.setAlternateName("ToolColorRuns");
        this.toolColorRuns.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_TEXTCOLOR));
        this.toolColorRuns.setPanelKey("textProperties");
        this.toolColorRuns.setQuickAttribute(false);
        this.fillColor = new ToolColor(context, "FillColor");
        this.fillColor.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FILLCOLOR));
        this.fillColor.setPanelKey("shapeProperties");
        this.fillColor.setColor(ToolDefinitions.BACKGROUND_COLOR_DEFAULT, 0);
        this.toolSmileyMap = new ToolSmileyMap(context);
        this.toolSmileyMap.setQuickAttribute(false);
        this.toolSmileyRuns = new ToolStyleRunList(context, "ToolSmileyRuns");
        this.toolSmileyRuns.setAlternateName("ToolSmileyRuns");
        this.toolSmileyRuns.setQuickAttribute(false);
        this.colorSub = new ColorSubAttribute(context);
        this.fontSub = new FontSubAttribute(context);
        this.styleRun = new StyleRunSubAttribute(context);
        this.smileySub = new SmileySubAttribute(context);
        this.setContentType("text/rtf");
        this.registerIfClass("TextEditorToolModel");
    }

    public TextEditorToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"JDOM constructor", (Throwable)ex, (boolean)true);
        }
    }

    public TextEditorToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"stream constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.addAttribute(this.toolText);
        this.addAttribute(this.toolComp);
        this.addAttribute(this.toolFontList);
        this.addAttribute(this.toolColorList);
        this.addAttribute(this.toolFontRuns);
        this.addAttribute(this.toolColorRuns);
        this.addAttribute(this.fillColor);
        this.addAttribute(this.toolSmileyMap);
        this.addAttribute(this.toolSmileyRuns);
        this.addAttribute(this.fontSub);
        this.addAttribute(this.colorSub);
        this.addAttribute(this.styleRun);
        this.addAttribute(this.smileySub);
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        TextEditorToolModel editorTool;
        try {
            editorTool = (TextEditorToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            editorTool = new TextEditorToolModel(this.context);
        }
        editorTool.initialized = false;
        editorTool.toolRect.setSize(originalWidth, originalHeight);
        return editorTool;
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        return null;
    }

    @Override
    public AbstractToolModel toolFactory(ExternalDataBean toolData, ScreenModel screen, WBNode container, boolean reciprocal) {
        TextEditorToolModel editorTool = (TextEditorToolModel)this.toolFactory(screen, container, null, reciprocal);
        editorTool.toolRect.setSize(originalWidth, originalHeight);
        editorTool.setContentType(toolData.getContentType());
        editorTool.initialized = true;
        editorTool.toolData = toolData.getData();
        if (editorTool.toolData != null) {
            if (editorTool.toolData instanceof String) {
                editorTool.setText((String)editorTool.toolData);
            } else if (editorTool.toolData instanceof StringReader) {
                editorTool.setContentType("text/rtf");
                StringReader reader = (StringReader)editorTool.toolData;
                StringBuffer str = new StringBuffer();
                int read = 0;
                char[] buf = new char[1024];
                try {
                    while (read >= 0) {
                        read = reader.read(buf);
                        if (read <= 0) continue;
                        str.append(buf, 0, read);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                editorTool.toolData = str.toString();
                editorTool.setText(str.toString());
            }
        }
        return editorTool;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TextEditorToolModel textEditorToolModel = (TextEditorToolModel)super.clone();
        textEditorToolModel.toolActivationListeners = new LinkedList();
        textEditorToolModel.toolComp = (ToolComponent)this.toolComp.clone();
        textEditorToolModel.toolText = (ToolText)this.toolText.clone();
        textEditorToolModel.toolFontList = (ToolFontList)this.toolFontList.clone();
        textEditorToolModel.toolColorList = (ToolColorList)this.toolColorList.clone();
        textEditorToolModel.toolFontRuns = (ToolStyleRunList)this.toolFontRuns.clone();
        textEditorToolModel.toolColorRuns = (ToolStyleRunList)this.toolColorRuns.clone();
        textEditorToolModel.fillColor = (ToolColor)this.fillColor.clone();
        textEditorToolModel.toolSmileyMap = (ToolSmileyMap)this.toolSmileyMap.clone();
        textEditorToolModel.toolSmileyRuns = (ToolStyleRunList)this.toolSmileyRuns.clone();
        textEditorToolModel.fontSub = (FontSubAttribute)this.fontSub.clone();
        textEditorToolModel.colorSub = (ColorSubAttribute)this.colorSub.clone();
        textEditorToolModel.smileySub = (SmileySubAttribute)this.smileySub.clone();
        textEditorToolModel.styleRun = (StyleRunSubAttribute)this.styleRun.clone();
        this.setContentType("text/rtf");
        textEditorToolModel.registerIfClass("TextEditorToolModel");
        return textEditorToolModel;
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.initialized = true;
                this.setLocation(e.getX(), e.getY());
                this.setCreating(true);
                this.setSize(0.0, 0.0);
                break;
            }
            case 506: {
                int x = e.getX() - this.getLocation().getIntLocation().x;
                int y = e.getY() - this.getLocation().getIntLocation().y;
                if (e.isShiftDown()) {
                    int max = Math.max(Math.abs(x), Math.abs(y));
                    x = x <= 0 ? -max : max;
                    y = y <= 0 ? -max : max;
                }
                this.setSize(x, y);
                break;
            }
            case 502: {
                response = 1;
                int width = this.toolRect.getBounds().width == 0 ? originalWidth : this.toolRect.getBounds().width;
                int height = this.toolRect.getBounds().height == 0 ? originalHeight : this.toolRect.getBounds().height;
                this.setSize(width, height);
                this.setCreating(false);
                break;
            }
            case 500: {
                break;
            }
        }
        return response;
    }

    public void repaintBounds() {
        this.setUIInvalid(true);
        this.context.getController().repaint(this.getVBounds().x - 3, this.getVBounds().y - 2, this.getVBounds().width + 8, this.getVBounds().height + 6);
    }

    @Override
    public void notifyVisibleChange() {
        super.notifyVisibleChange();
        if (this.isConferenceNode() && this.context.getController() != null && this.context.getController().getScreen() == this.getScreenParent()) {
            this.repaintBounds();
        }
    }

    public void startEditing() {
        super.setEditing(true);
        this.isCreating = true;
        this.wantKeyboard = true;
    }

    @Override
    public int receivedClick(MouseEvent e) {
        this.setMousePoint(new Point(e.getX(), e.getY()));
        if (e.getClickCount() >= 2) {
            this.setUiComponentActive(true);
            this.notifyVisibleChange();
        }
        return 0;
    }

    @Override
    public void setUiComponentActive(boolean uiComponentActive) {
        if (uiComponentActive != this.isUiComponentActive()) {
            this.fireToolActived(uiComponentActive);
        }
        super.setUiComponentActive(uiComponentActive);
    }

    @Override
    public void mouseEvent(MouseEvent e, Component component) {
        if (this.isCreating) {
            TextEditorUIInterface comp = this.getTextUI();
            if (comp != null && this.isSelected() && !comp.hasFocus(this)) {
                this.getTextUI().grabFocus(this);
            }
        } else if (e.getID() == 502) {
            TextEditorUIInterface editorUI = (TextEditorUIInterface)((Object)this.getUI());
            editorUI.handleMouseRelease(e, this);
        }
    }

    @Override
    public boolean wantsMouse(MouseEvent e) {
        if (this.isCreating) {
            return true;
        }
        if (e != null) {
            if (e.getID() == 503) {
                return true;
            }
            if (e.getID() == 502 && this.isLink(e)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLink(MouseEvent e) {
        TextEditorUIInterface editorUI = (TextEditorUIInterface)((Object)this.getUI());
        return editorUI.isLink(this, e);
    }

    @Override
    public Cursor getBehaviourCursor(MouseEvent e) {
        if (!this.isCreating) {
            TextEditorUIInterface editorUI = (TextEditorUIInterface)((Object)this.getUI());
            Cursor currentCursor = editorUI.getCurrentCursor(this);
            Cursor returnCursor = null;
            if (this.isLink(e)) {
                if (currentCursor != handCursor) {
                    this.previousCursor = currentCursor;
                }
                returnCursor = handCursor;
            } else if (currentCursor == handCursor) {
                returnCursor = this.previousCursor;
            }
            return returnCursor;
        }
        return null;
    }

    public void setMousePoint(Point mousePoint) {
        this.mousePoint = mousePoint;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.isCreating()) {
            this.endCreating();
            this.repaintBounds();
        }
    }

    @Override
    public int keyEvent(KeyEvent e, Component componeent) {
        if (this.getText() != null && this.stringIndx <= this.getText().length()) {
            Rectangle rect = this.getBounds();
            if (this.creationKeyEvent(e, true) == 0) {
                this.repaintBounds();
                return 0;
            }
        }
        this.endCreating();
        this.repaintBounds();
        return 4;
    }

    @Override
    public int creationKeyEvent(KeyEvent e) {
        return this.creationKeyEvent(e, false);
    }

    public int creationKeyEvent(KeyEvent e, boolean pasteSingleLine) {
        StringBuffer toolText = new StringBuffer(this.getText());
        int response = 0;
        this.repaintBounds();
        if (!this.locationSet) {
            return response;
        }
        WBClipboardInterface clipboard = this.context.getWBClipboard();
        this.setUIInvalid(true);
        switch (e.getID()) {
            case 400: {
                switch (e.getKeyChar()) {
                    case '\b': {
                        String localString = new String(toolText).substring(this.stringIndx, this.getText().length());
                        this.stringIndx = Math.max(this.stringIndx - 1, 0);
                        toolText.setLength(this.stringIndx);
                        toolText.append(localString);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        response = 2;
                        this.endCreating();
                        break;
                    }
                    case '\u007f': {
                        break;
                    }
                    default: {
                        if ((e.getModifiers() & 0xA) != 0) break;
                        if (this.stringIndx >= toolText.length()) {
                            toolText.append(e.getKeyChar());
                            this.stringIndx = toolText.length();
                            break;
                        }
                        toolText.insert(this.stringIndx, e.getKeyChar());
                        ++this.stringIndx;
                    }
                }
                e.consume();
                break;
            }
            case 401: {
                if ((e.getModifiers() & 8) != 0) break;
                switch (e.getKeyCode()) {
                    case 127: {
                        String localString = this.stringIndx < toolText.length() ? new String(toolText).substring(this.stringIndx + 1, toolText.length()) : "";
                        toolText.setLength(this.stringIndx);
                        toolText.append(localString);
                        break;
                    }
                    case 35: {
                        this.stringIndx = toolText.length();
                        break;
                    }
                    case 36: {
                        this.stringIndx = 0;
                        break;
                    }
                    case 39: {
                        this.stringIndx = Math.min(this.stringIndx + 1, toolText.length());
                        break;
                    }
                    case 37: {
                        this.stringIndx = Math.max(this.stringIndx - 1, 0);
                        break;
                    }
                    case 67: {
                        if (clipboard == null || (e.getModifiers() & 2) == 0) break;
                        clipboard.pasteTextToClipboard(toolText.toString());
                        break;
                    }
                    case 88: {
                        if (clipboard == null || (e.getModifiers() & 2) == 0) break;
                        clipboard.pasteTextToClipboard(toolText.toString());
                        toolText = new StringBuffer();
                        this.stringIndx = 0;
                        break;
                    }
                    case 86: {
                        if (clipboard == null || (e.getModifiers() & 2) == 0 || !clipboard.clipboardHasText()) break;
                        if (pasteSingleLine && clipboard.clipboardHasMultiLineText()) {
                            ModalDialog.showMessageDialog((Component)this.context.getDialogParentFrame(), (Object)I18N.getString((PropertiesEnum)StringsProperties.TEXTTOOLMODEL_CANNOTPASTE), (String)I18N.getString((PropertiesEnum)StringsProperties.TEXTTOOLMODEL_CANNOTPASTETITLE), (int)0);
                            response = 3;
                            break;
                        }
                        response = this.pasteResponse(clipboard.getTextFromClipboard(), toolText, this.stringIndx);
                        break;
                    }
                }
                this.setUIInvalid(true);
                break;
            }
        }
        this.setText(toolText.toString());
        this.repaintBounds();
        e.consume();
        return response;
    }

    private int pasteResponse(String textToPaste, StringBuffer toolText, int stringIndx) {
        int response;
        int pasteResponse = 2;
        boolean endOfPaste = false;
        String pasteRemainder = null;
        String suffix = "";
        if (textToPaste == null) {
            return 0;
        }
        if (stringIndx < 0 || stringIndx > toolText.length()) {
            stringIndx = toolText.length();
        }
        if (stringIndx < toolText.length() - 1 && toolText.length() > 0) {
            suffix = toolText.toString().substring(stringIndx);
            toolText.setLength(stringIndx);
            textToPaste = textToPaste + suffix;
        }
        if (textToPaste != null && textToPaste.length() > 0) {
            this.continuedResponse = 8;
            int newline = textToPaste.indexOf("\n");
            if (newline < 0) {
                toolText.append(textToPaste);
                pasteResponse = 0;
                this.stringIndx = toolText.length() - suffix.length();
            } else {
                toolText.append(textToPaste.substring(0, newline));
                if (newline < textToPaste.length() && "".equals(pasteRemainder = textToPaste.substring(newline + 1))) {
                    pasteRemainder = null;
                }
                this.stringIndx = toolText.length();
            }
        } else {
            this.continuedResponse = 2;
            this.stringIndx = toolText.length();
        }
        int n = response = pasteRemainder == null || pasteRemainder.length() == 0 ? pasteResponse : 8;
        if (pasteResponse != 0) {
            this.endCreating();
        }
        return response;
    }

    @Override
    public int continuedResponse() {
        return this.continuedResponse;
    }

    @Override
    public void quiesceTool() {
        if (this.getUI() instanceof TextEditorUIInterface) {
            this.getTextUI().endComposition(this);
        }
    }

    @Override
    public void endCreating() {
        super.endCreating();
        this.wantKeyboard = false;
        this.isCreating = false;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(TEXT_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public void delete() {
        this.removeRenderer();
        this.toolText = null;
        this.toolComp = null;
        this.toolFontList = null;
        this.toolColorList = null;
        this.toolFontRuns = null;
        this.toolColorRuns = null;
        this.fillColor = null;
        this.toolSmileyMap = null;
        this.toolSmileyRuns = null;
        super.delete();
    }

    @Override
    public String getDisplayName() {
        if (this.exploreScreenName == null) {
            this.exploreScreenName = I18N.getString((PropertiesEnum)StringsProperties.TEXTEDITORTOOL_EXPLORESCREENNAME);
        }
        if (this.getText() == null) {
            this.setDisplayName(this.exploreScreenName);
        } else {
            String str = this.exploreScreenName + ":" + this.getText();
            str = str.substring(0, Math.min(40, str.length()));
            this.setDisplayName(str);
        }
        return super.getDisplayName();
    }

    @Override
    public void toolComplete() {
        super.toolComplete();
        this.context.getController().getScreen().selectTool(this);
        this.setUiComponentActive(true);
        this.notifyVisibleChange();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        return super.streamToString(istr);
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        WBElement textElement = (WBElement)element.getChild("Text");
        if (textElement == null) {
            textElement = (WBElement)element.getChild("TEXT");
        }
        if (textElement != null) {
            if (textElement.getAttribute("X") != null) {
                try {
                    this.setLocation(textElement.getAttribute("X").getDoubleValue(), textElement.getAttribute("Y").getDoubleValue());
                }
                catch (Exception e) {
                    throw new Exception(this.getName() + " Invalid digits in X or Y: " + e.getMessage());
                }
            }
            this.evaluateBounds();
        } else {
            LogSupport.error((String)"Null Text in objectToElement.");
        }
        this.locationSet = true;
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    @Override
    public void render(Graphics g) {
        this.getTextUI().draw(g, this);
    }

    @Override
    public void render(Graphics g, Graphics unscaledG) {
        this.getTextUI().draw(g, unscaledG, this);
    }

    @Override
    public void onAttributeChange(AbstractAttribute attribute) {
        super.onAttributeChange(attribute);
        if (this.context.getController() != null) {
            this.getTextUI().updateUIFromConference(this, attribute);
        }
    }

    public void setText(String text) {
        if (this.toolText != null) {
            this.toolText.setText(text);
        }
    }

    public void setColor(Object rgbaObject, int alpha) {
        try {
            Color color = (Color)rgbaObject;
            StyleSubAttribute sa = (StyleSubAttribute)this.toolColorList.getAttribute(color);
            if (sa != null) {
                if (this.getXEnd() - this.getXStart() > 0) {
                    this.toolColorRuns.changeUpdate(this.getXStart(), this.getXEnd() - this.getXStart(), sa.getSaId());
                }
                this.getTextUI().applyAttributeChange(this, sa);
                this.notifyVisibleChange();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setColor()", (Throwable)ex, (boolean)true);
        }
        this.getTextUI().grabFocus(this);
    }

    public void setFont(CompatibleFont font) {
        try {
            StyleSubAttribute sa = (StyleSubAttribute)this.toolFontList.getAttribute(font);
            if (sa != null) {
                if (this.getXEnd() - this.getXStart() > 0) {
                    this.toolFontRuns.changeUpdate(this.getXStart(), this.getXEnd() - this.getXStart(), sa.getSaId());
                }
                this.getTextUI().applyAttributeChange(this, sa);
                this.notifyVisibleChange();
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"setFont()", (Throwable)ex, (boolean)true);
        }
        this.getTextUI().grabFocus(this);
    }

    public void setIgnoreAttrChange(boolean ignoreAttrChange) {
        this.ignoreAttrChange = ignoreAttrChange;
    }

    public void setXStart(int xStart) {
        this.xStart = xStart;
    }

    public void setXEnd(int xEnd) {
        this.xEnd = xEnd;
    }

    public String getText() {
        return this.toolText == null ? "" : this.toolText.getText();
    }

    public ToolText getToolText() {
        return this.toolText;
    }

    public ToolFontList getToolFontList() {
        return this.toolFontList;
    }

    public ToolColorList getToolColorList() {
        return this.toolColorList;
    }

    public ToolStyleRunList getToolFontRuns() {
        return this.toolFontRuns;
    }

    public ToolStyleRunList getToolColorRuns() {
        return this.toolColorRuns;
    }

    public ToolComponent getToolComponent() {
        return this.toolComp;
    }

    public Object getToolData() {
        return this.toolData;
    }

    public Point getMousePoint() {
        return this.mousePoint;
    }

    public boolean isIgnoreAttrChange() {
        return this.ignoreAttrChange;
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public ToolColor getFillColor() {
        return this.fillColor;
    }

    public ToolStyleRunList getToolSmileyRuns() {
        return this.toolSmileyRuns;
    }

    public ToolSmileyMap getToolSmileyMap() {
        return this.toolSmileyMap;
    }

    @Override
    public String getRendererClassName() {
        return "com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBTextPane";
    }

    public void addActivationListener(ToolActivationListener l) {
        if (!this.toolActivationListeners.contains(l)) {
            this.toolActivationListeners.add(l);
        }
    }

    public void removeActivationListener(ToolActivationListener l) {
        if (this.toolActivationListeners.contains(l)) {
            this.toolActivationListeners.remove(l);
        }
    }

    public List getActivationListeners() {
        return this.toolActivationListeners;
    }

    private void fireToolActived(boolean activated) {
        for (ToolActivationListener l : this.toolActivationListeners) {
            if (activated) {
                l.onActivateTool(this);
                continue;
            }
            l.onDeActivateTool(this);
        }
    }

    @Override
    public void drawUI(Graphics g) {
        this.getTextUI().drawImage(g, this);
    }

    @Override
    public void removeRenderer() {
        if (this.toolUI != null && this.toolUI instanceof TextEditorUIInterface) {
            ((TextEditorUIInterface)((Object)this.toolUI)).removeEditor(this);
        }
    }

    @Override
    protected void evaluateBounds() {
        this.visibleBounds.x = Math.min(this.getBounds().x, this.getBounds().x + this.getBounds().width);
        this.visibleBounds.y = Math.min(this.getBounds().y, this.getBounds().y + this.getBounds().height);
        this.visibleBounds.width = Math.abs(this.getBounds().width);
        this.visibleBounds.height = Math.abs(this.getBounds().height);
        if (this.visibleBorder()) {
            double delta = 1.0;
            this.visibleBounds.x = (int)((double)this.visibleBounds.x - delta);
            this.visibleBounds.y = (int)((double)this.visibleBounds.y - delta);
            this.visibleBounds.width = (int)((double)this.visibleBounds.width + 2.0 * delta);
            this.visibleBounds.height = (int)((double)this.visibleBounds.height + 2.0 * delta);
        }
    }

    private TextEditorUIInterface getTextUI() {
        return (TextEditorUIInterface)((Object)this.getUI());
    }
}

